/*	$Modname: vipxsnmp.h$  $version: 1.4$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 06/15/94 ross snmp variables.
1.1 06/15/94 ross added copyright.
1.2 08/08/94 ross finishing end station support.
1.3 11/23/94 ross Added remote access. Added auto-configuration.
1.4 06/27/95 ross mib and nlsp changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
enum TEST get_snmp_ipx_route_entry (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset_into_route_entry,
	ULONG address_of_get_set_function,ULONG filler,void *vptr_mib_value_obtained,USHORT *usptr_length_of_mib_obtained);

enum TEST get_snmp_ipx_SAP_entry (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset_into_SAP_entry,
	ULONG address_of_get_set_function,ULONG static_entry,void *vptr_mib_value_obtained,USHORT *usptr_length_of_mib_obtained);

enum TEST all_ipx_ports_statistic (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset_into_class,
	ULONG class_address,ULONG size_of_port_class,void *vptr_mib_value_obtained,USHORT *usptr_length_of_mib_obtained);

enum TEST snmp_get_or_set_boolean_plus_one (USHORT port_number,enum MIB_OPERATION mib_operation,ULONG offset_into_class,
	ULONG class_address,ULONG size_of_port_class,void *vptr_mib_value_obtained,USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 17, 1997. Added the prototype for the function to access
	ipxAdvSysMaxHops */
enum TEST snmp_get_or_set_sys_max_hops(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

enum TEST snmp_get_or_set_circ_max_packet_size(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

enum TEST snmp_get_or_set_circ_pace(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

enum TEST snmp_get_or_set_circ_age_multiplier(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

enum TEST snmp_get_or_set_circ_update_time(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 19, 1997. Added the following function prototype. */

enum TEST snmp_get_or_set_ipxExistState (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 19, 1997. Added the following function prototype. */

enum TEST snmp_get_or_set_ipxCircName_ipxCircDialName (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

/* Srikar, Mar 19, 1997. Added the following function prototype. */

enum TEST snmp_get_or_set_ipxOperState (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained);

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far	ipx_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS	ipx_snmp_table_parameters[] =
#endif
{
	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
			sizeof (ULONG),
			offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInstance),
			FALSE,
			NULL,
			FALSE,
			&ipx_class.number_of_basic_system_entries,
			TRUE
		}},
		MIB_TABLE_AS_AN_ARRAY,
		&ipx_class.ipxBasicSysEntry[0],
		sizeof (IPX_BASIC_SYS_ENTRY),
		0x01
		},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
			sizeof (ULONG),
			offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysInstance),
			FALSE,
			NULL,
			FALSE,
			&ipx_class.number_of_adv_system_entries,
			TRUE
		}},
		MIB_TABLE_AS_AN_ARRAY,
		&ipx_class.ipxAdvSysEntry[0],
		sizeof (IPX_ADV_SYS_ENTRY),
		0x01
		},

	{(ULONG) NULL,
	TRUE,
	0x02,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircSysInstance),*/
		offsetof (IPX_PORT_CLASS,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		TRUE
	},{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of the table index from size of byte to size of ushort */
		sizeof (USHORT),
/*		offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircIndex), */
		offsetof (IPX_PORT_CLASS,virtual_port_number),
		/* Srikar, Mar 19, 1997. Changed the need_to_increment from FALSE to TRUE, since the index saved in the table */
		/* is 0-relative and what needs to be sent to the SNMP manager is 1-relative. */
		TRUE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		TRUE
	}},
	MIB_TABLE_AS_AN_ARRAY,
	&ipx_class.port[0],
	sizeof (IPX_PORT_CLASS),
	NUMBER_OF_IPX_PORTS
	},

	{(ULONG) NULL,
	TRUE,
	0x02,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (ROUTE_LIST_ENTRY,ipxDestSysInstance),*/
		offsetof (ROUTE_LIST_ENTRY,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000004L,
/*		offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestNetNum),*/
		offsetof (ROUTE_LIST_ENTRY,route_entry.network),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	}},
	MIB_TABLE_AS_A_LINKED_LIST,
	&ipx_class.router_list.sptr_forward_link,
	},

	{(ULONG) NULL,
	TRUE,
	0x03,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (ROUTE_LIST_ENTRY,ipxStaticRouteSysInstance),*/
		offsetof (ROUTE_LIST_ENTRY,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		SNMP_SCALAR_TYPE,
		0x00000004L,
/*		offsetof (ROUTE_LIST_ENTRY,ipxStaticRouteCircIndex),*/  /* ### ??? */
		offsetof (ROUTE_LIST_ENTRY,port_number),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000004L,
/*		offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestNetNum),*/
		offsetof (ROUTE_LIST_ENTRY,route_entry.network),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	}},
	MIB_TABLE_AS_A_LINKED_LIST,
	&ipx_class.router_list.sptr_forward_link,
	},

	{(ULONG) NULL,
	TRUE,
	0x03,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (SAP_LIST_ENTRY,ipxServSysInstance),*/
		offsetof (SAP_LIST_ENTRY,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_FIXED_STRING_TYPE,
		0x00000002L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipxServType),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000008L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipxServName),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	}},
	MIB_TABLE_AS_A_LINKED_LIST,
	&ipx_class.SAP_list.sptr_forward_link,
	},

	{(ULONG) NULL,
	TRUE,
	0x06,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (SAP_LIST_ENTRY,ipxDestServSysInstance),*/
		offsetof (SAP_LIST_ENTRY,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000004L,
		offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.network),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_FIXED_STRING_TYPE,
		0x00000006L,
		offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.node_address),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_FIXED_STRING_TYPE,
		0x00000002L,
		offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.socket),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000008L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipxDestServName),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_FIXED_STRING_TYPE,
		0x00000002L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipxDestServType),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	}},
	MIB_TABLE_AS_A_LINKED_LIST,
	&ipx_class.SAP_list.sptr_forward_link,
	},

	{(ULONG) NULL,
	TRUE,
	0x04,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (SAP_LIST_ENTRY,ipxStaticServSysInstance),*/
		offsetof (SAP_LIST_ENTRY,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		SNMP_SCALAR_TYPE,
		0x00000002L,
/*		offsetof (SAP_LIST_ENTRY,ipxStaticServCircIndex),*/
		offsetof (SAP_LIST_ENTRY,port_number),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_STRING_TYPE,
		0x00000008L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipxStaticServName),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	},{
		/* Srikar, Mar 15 1997. Changed the index type from SNMP_SCALAR_TYPE */
		SNMP_FIXED_STRING_TYPE,
		0x00000002L,
/*		offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipxStaticServType),*/
		offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		FALSE,
		NULL,
		FALSE,
		NULL,
		FALSE
	}},
	MIB_TABLE_AS_A_LINKED_LIST,
	&ipx_class.SAP_list.sptr_forward_link,
	},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
			sizeof (ULONG),
			offsetof (IPX_RIP_SYS_ENTRY,ripSysInstance),
			FALSE,
			NULL,
			FALSE,
			&ipx_class.number_of_rip_sys_entries,
			TRUE
		}},
		MIB_TABLE_AS_AN_ARRAY,
		&ipx_class.ripSysEntry[0],
		sizeof (IPX_RIP_SYS_ENTRY),
		0x01
		},

	{(ULONG) NULL,
		TRUE,
		0x01,
		{{
			SNMP_SCALAR_TYPE,
			/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
			sizeof (ULONG),
			offsetof (IPX_SAP_SYS_ENTRY,sapSysInstance),
			FALSE,
			NULL,
			FALSE,
			&ipx_class.number_of_sap_sys_entries,
			TRUE
		}},
		MIB_TABLE_AS_AN_ARRAY,
		&ipx_class.sapSysEntry[0],
		sizeof (IPX_SAP_SYS_ENTRY),
		0x01
		},

	{(ULONG) NULL,
	TRUE,
	0x02,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (RIP_CIRCUIT_ENTRY,ripCircSysInstance),*/
		offsetof (IPX_PORT_CLASS,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		FALSE
	},{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of the table index from size of byte to size of ushort */
		sizeof (USHORT),
/*		offsetof (RIP_CIRCUIT_ENTRY,ripCircIndex),*/
		offsetof (IPX_PORT_CLASS,virtual_port_number),
		/* Srikar, Mar 17, 1997. Changed the need_to_increment to TRUE */
		TRUE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		TRUE
	}},
	MIB_TABLE_AS_AN_ARRAY,
	&ipx_class.port[0],
/*	sizeof (RIP_CIRCUIT_ENTRY), */
	sizeof(IPX_PORT_CLASS),
	NUMBER_OF_IPX_PORTS,
	},

	{(ULONG) NULL,
	TRUE,
	0x02,
	{{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of table index from size of a byte to size of ulong */
		sizeof (ULONG),
/*		offsetof (SAP_CIRCUIT_ENTRY,sapCircSysInstance),*/
		offsetof (IPX_PORT_CLASS,ipx_instance),
		FALSE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		FALSE
	},{
		SNMP_SCALAR_TYPE,
		/* Srikar, Apr 11, 1997. Changed the size of the table index from size of byte to size of ushort */
		sizeof (USHORT),
/*		offsetof (SAP_CIRCUIT_ENTRY,sapCircIndex),*/
		offsetof (IPX_PORT_CLASS,virtual_port_number),
		/* Srikar, Mar 17, 1997. Changed the need_to_increment to TRUE */
		TRUE,
		NULL,
		FALSE,
		&ipx_class.number_of_circuit_entries,
		TRUE
	}},
	MIB_TABLE_AS_AN_ARRAY,
	&ipx_class.port[0],
/*	sizeof (SAP_CIRCUIT_ENTRY), */
	sizeof(IPX_PORT_CLASS),
	NUMBER_OF_IPX_PORTS
	}
};

#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	ipx_snmp_table[] =
#else
	SNMP_TABLE_ENTRY	ipx_snmp_table[] =
#endif
{
	/* Basic System Information Table */

  {"ipxBasicSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInstance),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysExistState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysExistState),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxBasicSysNetNumber",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysNetNumber),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysNode",sizeof (ETHERNET_ADDRESS),snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysNode),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysName",sizeof (ipx_class.ipxBasicSysEntry[0].ipxBasicSysName),snmp_get_or_set_string,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysName),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInReceives",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInReceives),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInHdrErrors",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not actually update this variable -- no check for header errors */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInHdrErrors),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInUnknownSockets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable -- no IPX stack */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInUnknownSockets),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInDiscards),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInBadChecksums",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable -- no IPX stack */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInBadChecksums),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysInDelivers",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInDelivers),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysNoRoutes",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysNoRoutes),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysOutRequests",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysOutRequests),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysOutMalformedRequests",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysOutMalformedRequests),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysOutDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysOutDiscards),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysOutPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysOutPackets),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysConfigSockets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysConfigSockets),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxBasicSysOpenSocketFails",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysOpenSocketFails),
		&ipx_snmp_table_parameters[0],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Advanced System Information Table */

  {"ipxAdvSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysInstance),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysMaxPathSplits",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysMaxPathSplits),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Srikar, Mar 17, 1997. changed the mib access function from snmp_get_or_set_ulong */
  {"ipxAdvSysMaxHops",sizeof (ULONG),snmp_get_or_set_sys_max_hops,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysMaxHops),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysInTooManyHops",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysInTooManyHops),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysInFiltered",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysInFiltered),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysInCompressDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable */
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysInCompressDiscards),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysNETBIOSPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysNETBIOSPackets),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysForwPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysForwPackets),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysOutFiltered",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysOutFiltered),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysOutCompressDiscards",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		/* Code does not update this variable */
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysOutCompressDiscards),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysCircCount",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysCircCount),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysDestCount",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysDestCount),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxAdvSysServCount",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_ADV_SYS_ENTRY,ipxAdvSysServCount),
		&ipx_snmp_table_parameters[1],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Circuit (Port) Table */

  {"ipxCircSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_instance),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		TRUE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,virtual_port_number),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 19, 1997. Changed the access function from snmp_get_or_set_boolean_plus_one to snmp_get_or_set_ipxExistState. */
  {"ipxCircExistState",sizeof (ULONG),snmp_get_or_set_ipxExistState,
		FALSE,
		FALSE,
		/* Srikar, Apr 11, 1997. Changed the variable back to port_enabled */
		(ULONG) offsetof (IPX_PORT_CLASS,port_enabled),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* ### what is the diff between the one above and the one below? */

  /* Srikar, Mar 17, 1997. Changed the access function from snmp_get_or_set_boolean_plus_one */
  {"ipxCircOperState",sizeof (ULONG), snmp_get_or_set_ipxOperState,
		FALSE,
		FALSE,
		/* Srikar, Apr 11, 1997. Changed the access variable from port_enabled to ipxCircOperState */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.ipxCircOperState),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircIfIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		TRUE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,real_port_number),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 19, 1997. Changed the access function of ipxCircName from snmp_get_or_set_string to snmp_get_or_set_ipxCircName_ipxCircDialName. */
  {"ipxCircName",sizeof (ipx_class.port[0].lan_circuit_mib.ipxCircName),snmp_get_or_set_ipxCircName_ipxCircDialName,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircName), */
		/* Our circuits will have no name */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.circuit_name),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircType",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircType),*/
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.circuit_type),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 19, 1997. Changed the access function of ipxCircName from snmp_get_or_set_string to snmp_get_or_set_ipxCircName_ipxCircDialName. */
  {"ipxCircDialName",sizeof (ipx_class.port[0].wan.ipx_mib.ipxCircDialName),snmp_get_or_set_ipxCircName_ipxCircDialName,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircDialName),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircLocalMaxPacketSize",sizeof (ULONG),snmp_get_or_set_circ_max_packet_size,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircLocalMaxPacketSize), */
		(ULONG) offsetof (IPX_PORT_CLASS,maximum_packet_size_including_header),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressState),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressSlots",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressSlots),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircStaticStatus",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircStaticStatus), */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.circuit_status),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedSent",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedSent),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedInitSent",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedInitSent),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedRejectsSent",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedRejectsSent),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircUncompressedSent",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircUncompressedSent),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedReceived",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedReceived),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedInitReceived",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedInitReceived),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircCompressedRejectsReceived",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircCompressedRejectsReceived),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircUncompressedReceived",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircUncompressedReceived),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircMediaType",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircMediaType), */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.media_type),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxCircNetNumber",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircNetNumber),*/
		(ULONG) offsetof (IPX_PORT_CLASS,network),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircStateChanges",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircStateChanges), */
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.ipx_mib.number_of_state_changes),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircInitFails",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircInitFails), */
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.ipx_mib.number_of_initialization_failures),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircDelay",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircDelay), */
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.ipx_mib.number_of_milliseconds_to_send_1_byte),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircThroughput",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (IPX_PORT_CLASS,lan_circuit_mib.ipxCircThroughput), */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_mib.throughput_in_bits_per_second),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxCircNeighRouterName",sizeof (ipx_class.port[0].wan.ipx_mib.ipxCircNeighRouterName),snmp_get_or_set_string,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircNeighRouterName),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxCircNeighInternalNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_PORT_CLASS,wan.ipx_mib.ipxCircNeighInternalNetNum),
		&ipx_snmp_table_parameters[2],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Destination Table */

  {"ipxDestSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipx_instance),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxDestNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestNetNum), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.network),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestProtocol",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxDestProtocol), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,type),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxDestTicks",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestTicks), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.transport_time),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxDestHopCount",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestHopCount), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.hops),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestNextHopCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		/* Srikar, Apr 11, 1997. Changed the need_to_increment_flag_for_get_operation from FALSE to TRUE. */
		TRUE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxDestNextHopCircIndex), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,port_number),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestNextHopNICAddress",sizeof (ETHERNET_ADDRESS),snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxDestNextHopNICAddress), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,router_address),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxDestNextHopNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.route_entry.ipxDestNetNum), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,next_hop_network_number),
		&ipx_snmp_table_parameters[3],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Static Routes Table  -- This section is not checked as we do not
	** implement static routing for IPX 
	*/

  {"ipxStaticRouteSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxStaticRouteSysInstance), */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInstance),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticRouteCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxStaticRouteCircIndex), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,port_number),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxStaticRouteNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.static_route_entry.ipxStaticRouteNetNum), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.network),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticRouteExistState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,ipxStaticRouteExistState), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,do_not_age),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticRouteTicks",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.static_route_entry.ipxStaticRouteTicks), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.transport_time),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxStaticRouteHopCount",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (ROUTE_LIST_ENTRY,snmp_route_entry.static_route_entry.ipxStaticRouteHopCount), */
		(ULONG) offsetof (ROUTE_LIST_ENTRY,route_entry.hops),
		&ipx_snmp_table_parameters[4],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Services (SAP) Table */

  {"ipxServSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxServSysInstance), */
		(ULONG) offsetof (SAP_LIST_ENTRY,ipx_instance),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxServType",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipxServType), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxServName",sizeof (ipx_class.snmp_internal_SAP_id.ipxServName),snmp_get_or_set_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipxServName), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxServProtocol",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,type), */
		(ULONG) offsetof (SAP_LIST_ENTRY,type),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxServNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipx_address.network), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.network),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxServNode",sizeof (ETHERNET_ADDRESS),snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipx_address.node_address), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.node_address),
 		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxServSocket",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipx_address.socket), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.socket),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxServHopCount",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_ID.ipxServHopCount), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.intervening_networks),
		&ipx_snmp_table_parameters[5],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Destination Services (SAP) Table (variant of Services Table) */

  {"ipxDestServSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxDestServSysInstance), */
		(ULONG) offsetof (SAP_LIST_ENTRY,ipx_instance),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxDestServNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipx_address.network), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.network),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestServNode",sizeof (ETHERNET_ADDRESS),snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipx_address.node_address), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.node_address),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxDestServSocket",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipx_address.socket), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.socket),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestServName",sizeof (ipx_class.internal_SAP_id.SAP_name),snmp_get_or_set_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipxDestServName), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxDestServType",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipxDestServType), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxDestServProtocol",sizeof (ULONG),snmp_get_or_set_byte,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxDestServProtocol), */
		(ULONG) offsetof (SAP_LIST_ENTRY,type),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxDestServHopCount",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_dest_ID.ipxDestServHopCount), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.intervening_networks),
		&ipx_snmp_table_parameters[6],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* Static Services Table -- The entries in this section are not checked
	** for as we do not support static inclusion of services
	*/
  {"ipxStaticServSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxStaticServSysInstance), */
		(ULONG) offsetof (IPX_BASIC_SYS_ENTRY,ipxBasicSysInstance),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticServCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxStaticServCircIndex),*/
		(ULONG) offsetof (SAP_LIST_ENTRY,port_number),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticServName",sizeof (ipx_class.internal_SAP_id.SAP_name),snmp_get_or_set_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipxStaticServName), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_name),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxStaticServType",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipxStaticServType), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.SAP_type),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticServExistState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,ipxStaticServExistState), */
		(ULONG) offsetof (SAP_LIST_ENTRY,do_not_age),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 15, 1997. Changed mib access funciton pointer from */
  /* snmp_get_or_set_ulong to avoid sending reversed value */
  {"ipxStaticServNetNum",sizeof (ULONG),snmp_get_or_set_4_byte_object,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipx_address.network), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.network),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ipxStaticServNode",sizeof (ETHERNET_ADDRESS),snmp_get_or_set_mac_address,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipx_address.node_address), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.node_address),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer to snmp_get_or_set_2_byte_string and size to 2 */
  {"ipxStaticServSocket",2,snmp_get_or_set_2_byte_string,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipx_address.socket), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.ipx_address.socket),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  /* Srikar, Mar 17, 1997. Changed mib access funciton pointer from snmp_get_or_set_ushort */
  {"ipxStaticServHopCount",sizeof (ULONG),snmp_get_or_set_big_endian_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_LIST_ENTRY,snmp_sap_id.snmp_SAP_static_ID.ipxStaticServHopCount), */
		(ULONG) offsetof (SAP_LIST_ENTRY,SAP_ID.intervening_networks),
		&ipx_snmp_table_parameters[7],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* rip sap mib */

	/* RIP System Table */

  {"ripSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_RIP_SYS_ENTRY,ripSysInstance),
		&ipx_snmp_table_parameters[8],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripSysState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_RIP_SYS_ENTRY,ripSysState),
		&ipx_snmp_table_parameters[8],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripSysIncorrectPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_RIP_SYS_ENTRY,ripSysIncorrectPackets), 
		&ipx_snmp_table_parameters[8],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* SAP System Table */

  {"sapSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_SAP_SYS_ENTRY,sapSysInstance),
		&ipx_snmp_table_parameters[9],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapSysState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_SAP_SYS_ENTRY,sapSysState),
		&ipx_snmp_table_parameters[9],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapSysIncorrectPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (IPX_SAP_SYS_ENTRY,sapSysIncorrectPackets),
		&ipx_snmp_table_parameters[9],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* RIP Circuit Table */

  {"ripCircSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircSysInstance),*/
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_instance),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		TRUE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircIndex), */
		(ULONG) offsetof (IPX_PORT_CLASS,virtual_port_number),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircState),*/
		(ULONG) offsetof (IPX_PORT_CLASS,enable_RIP_broadcasts),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircPace",sizeof (ULONG),snmp_get_or_set_circ_pace,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircPace), */
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.rip_packets_per_second),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircUpdate",sizeof (ULONG),snmp_get_or_set_circ_update_time,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircUpdate), */
		(ULONG) offsetof (IPX_PORT_CLASS,periodic_RIP_tx_timer),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircAgeMultiplier",sizeof (ULONG),snmp_get_or_set_circ_age_multiplier,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircAgeMultiplier), */
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.rip_holding_timer),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircPacketSize",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircPacketSize), */
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.rip_packet_size),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircOutPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircOutPackets),*/
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.RIP_tx.number_of_packets),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"ripCircInPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (RIP_CIRCUIT_ENTRY,ripCircInPackets), */
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.RIP_rx.number_of_packets),
		&ipx_snmp_table_parameters[10],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

	/* SAP Circuit Table */
  {"sapCircSysInstance",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircSysInstance), */
		(ULONG) offsetof (IPX_PORT_CLASS,ipx_instance),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircIndex",sizeof (ULONG),snmp_get_or_set_ushort,
		TRUE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircIndex), */
		(ULONG) offsetof (IPX_PORT_CLASS,virtual_port_number),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircState",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircState),*/
		(ULONG) offsetof (IPX_PORT_CLASS,enable_SAP_broadcasts),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircPace",sizeof (ULONG),snmp_get_or_set_circ_pace,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircPace),*/
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.SAP_packets_per_second),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircUpdate",sizeof (ULONG),snmp_get_or_set_circ_update_time,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircUpdate),*/
		(ULONG) offsetof (IPX_PORT_CLASS,periodic_SAP_tx_timer),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircAgeMultiplier",sizeof (ULONG),snmp_get_or_set_circ_age_multiplier,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircAgeMultiplier),*/
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.SAP_holding_timer),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircPacketSize",sizeof (ULONG),snmp_get_or_set_ushort,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircPacketSize),*/
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.SAP_packet_size),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircGetNearestServerReply",sizeof (ULONG),snmp_get_or_set_boolean_plus_one,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircGetNearestServerReply),*/
		(ULONG) offsetof (IPX_PORT_CLASS,rip_sap_mib.respond_to_SAP_nearest_queries),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircOutPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircOutPackets),*/
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.SAP_tx.number_of_packets),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"sapCircInPackets",sizeof (ULONG),snmp_get_or_set_ulong,
		FALSE,
		FALSE,
/*		(ULONG) offsetof (SAP_CIRCUIT_ENTRY,sapCircInPackets),*/
		(ULONG) offsetof (IPX_PORT_CLASS,statistics.SAP_rx.number_of_packets),
		&ipx_snmp_table_parameters[11],
		/* Srikar, Mar 19, 1997. Added lexicographic ordering flag */
		TRUE
		},

  {"",0x0000,NULL,
			(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL}
};
