/************************************************************************/
/*	Copyright (C) 1993 - 1995 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#define IPX_PING_SIGNATURE BIG_ENDIAN_CONSTANT (0x50696E67) /* ASCII for "Ping" */
#define IPX_PING_SOCKET_NUMBER BIG_ENDIAN_CONSTANT (0x9086)
#define MINIMUM_SIZE_OF_IPX_PING_PACKET (sizeof (IPX_HEADER) + sizeof (IPX_PING_HEADER))
#define								VARIABLE_NUMBER_OF_BYTES 0x01;

enum PING_TYPE
{
	PING_REQUEST,
	PING_RESPONSE
};

enum PING_RESULT
{
	PING_DATA_NOT_PRESENT,
	PING_DATA_PRESENT
};

typedef	struct	IPX_PING_HEADER
{
	ULONG								signature; /* 'Ping' */
	BYTE								version;
	BYTE_ENUM (PING_TYPE)		type;
	USHORT							id;
	BYTE_ENUM (PING_RESULT)		result;
	BYTE								reserved;
} IPX_PING_HEADER;

typedef	struct	IPX_PING_PACKET
{
	UNION_MAC_HEADER				mac_header;
	IPX_HEADER						ipx_header;
	IPX_PING_HEADER				ping_header;
	BYTE								data[VARIABLE_NUMBER_OF_BYTES];
} IPX_PING_PACKET;
