/*	$Modname: kmacbr.h$  $version: 1.20$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross change RX_PACKET_STATE to handle packet recognized but not forwarded (filtering case).
1.2 07/30/92 ross
1.3 07/30/92 ross
1.4 07/30/92 ross
1.5 08/05/92 ross
1.6 08/21/92 ross
1.7 08/22/92 ross Added support for multiple instances of stp_class
1.8 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.9 01/15/93 ross changed timer constants, since they were off by 256.  Path cost should have been 100 - a typo.
1.10 01/15/93 ross
1.11 01/20/93 ross
1.12 01/29/93 ross changed constants in macbrrx.c and macbrdb.c to better match snmp, fixed frame relay bug.
1.13 02/12/93 ross added NUMBER_OF_USER_DEFINED_STP_PORTS.
1.14 03/29/93 ross added more snmp stuff
1.15 07/16/93 ross added some mib statistics
1.16 10/28/93 ross deleted an unnecessary comment.
1.17 12/29/93 ross big endian fix.  Courtesy of Rick.
1.18 12/30/93 ross moved SORT_RETURN enum to kstart.h
1.19 06/15/94 ross cosmetic changes and snmp access routines.
1.20 03/31/95 ross Changes for new rwutils library.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

#define	BROADCAST_FRAME_RELAY_DLCI 0xffff

#if 0							/* will be included by another (global) header */
#ifdef BIG_ENDIAN
	#define	BIG_ENDIAN_CONSTANT(ushort) ushort
	#define	swap(a) a
	#define	swap_long(a) a
#else
	#define	BIG_ENDIAN_CONSTANT(ushort) (((0x00ff & ushort) << 8) | (ushort >> 8))
#endif
#endif

#ifdef SMALL_ENTRY

	#define NULL_USHORT_ENTRY 0xffff

#endif

#define	ROOT_PORT_NUMBER 0
#define	NO_PORT	0
#define	HIGHEST_PORT_PRIORITY 0x00
#define	HIGHEST_BRIDGE_PRIORITY 0x0000

#define	PORT_PRIORITY	0x80	 
#define	BRIDGE_PRIORITY	0x8000 

#define	MAXIMUM_BRIDGE_DIAMETER 7
#define	MAXIMUM_BRIDGE_TRANSIT_DELAY	4
#define	MAXIMUM_BPDU_TRANSMISSION_DELAY	4
#define	MAXIMUM_MESSAGE_AGE_INCREMENT_OVERESTIMATE	4

#define	ETHERNET_PATH_COST	1000/10 /* 1000/x MB/s */

#define	TIMER_GRANULARITY 0x100 /* used for timer values */

/* maximum age of rxed protocol information before it is discarded */

#define	MAXIMUM_AGE				20	* TIMER_GRANULARITY

/* time between hello configuration BPDU's */

#define	HELLO_TIME				2 * TIMER_GRANULARITY

/* time spent between states, also used for aging dynamic entries in the filtering database when the topology change flag is TRUE in protocol messages received from the root*/

#define	FORWARD_DELAY_TIME	15	* TIMER_GRANULARITY

#define	MESSAGE_AGE_INCREMENT	1 * TIMER_GRANULARITY

#define	AGEING_TIME_FOR_FILTERING_DATABASE	 300

#define NUMBER_OF_ENTRIES_PER_TIMER_CHECK	NUMBER_OF_FILTERING_DATABASE_ENTRIES/CLOCK_TICKS_PER_SECOND /* clocks per second */

#define	VERSION_ID			0x00

enum	BPDU_TYPE
{
	CONFIGURATION
	/* TOPOLOGY_CHANGE = 0x80 */
};

#define TOPOLOGY_CHANGE 0x80 /* stuck here because of compiler error, needs to be 1 byte wide */

#define	FORWARDING_STATION_TIME_LIMIT	60 * 2 

#ifndef RX_PACKET_STATE_DEFINED

	#define RX_PACKET_STATE_DEFINED

	enum	RX_PACKET_STATE
	{
		PACKET_NOT_RECOGNIZED,
		PACKET_RECOGNIZED_BUT_NOT_FORWARDED,
		PACKET_RECOGNIZED_AND_FORWARDED
	};

#endif

enum FD_TABLE_ENTRY_TYPE
{
/* SNMP types */

	OTHER_TABLE_ENTRY = 0x0000,
	INVALID_TABLE_ENTRY,
	DELETE_ENTRY_ON_RESET,
	PERMANENT_TABLE_ENTRY,
	DELETE_ENTRY_ON_TIMEOUT,
	FILTER_ADDRESS,

/* LEARNED is the same as DELETE_ENTRY_ON_TIMEOUT */
/* SELF is the same as PERMANENT_ENTRY */
/* MANAGEMENT is the same as DELETE_ENTRY_ON_RESET */

/* return types */

	OUT_OF_DATABASE_ENTRIES,
	NOT_IN_DATABASE,
	IN_DATABASE_SAME_PORT,
	IN_DATABASE_DIFFERENT_PORT,
#ifdef NEW_FILTERING
	FILTER_ON_DESTINATION_ADDRESS = 0x01FF,
	FILTER_ON_SOURCE_ADDRESS= 0x02FF,
	FORWARD_ON_SOURCE_ADDRESS = 0x03FF,
	FORWARD_ON_DESTINATION_ADDRESS = 0x04FF,
	FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS = 0x05FF,
	FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS = 0x06FF
#endif
};

enum	TIMER_COMMAND	
{ 
	STOP_TIMER = 0,
	START_TIMER = 1 
};

/* Srikar, Mar 18, 1997. Changed the constants to match the SNMP specification requirements. */
enum	PORT_STATE
{
	DISABLED = 1,
	LISTENING,
	LEARNING,
	FORWARDING,
	BLOCKING
};

enum FILTER_ACTION
{
	FORWARD_PACKET,
	FILTER_PACKET
} ;


enum	ESTIMATE_TIMER_BOUNDS
{
	LOWER_TIMER_BOUND  = 18/2, TIMER_BOUND_DEFAULT = 18, UPPER_TIMER_BOUND = 36
};

enum	PORT_TYPE
{
	_8023,_8025
};

#ifdef BIG_ENDIAN							/* sridhar 30-9-1995 */
	#define	MULTICAST_BROADCAST_MASK_BIT	0x01000000
#else
	#define	MULTICAST_BROADCAST_MASK_BIT	0x00000001
#endif

#define	NO_MULTICAST_OR_BROADCAST	0x00000000

#ifdef	__MSDOS__
	#define	print_string_to_AT_port printf
	#define  SIZE_OF_HASH_KEY BYTE
	#define	NUMBER_OF_FILTERING_DATABASE_ENTRIES 0x000100 /* 256 */
	#define	NUMBER_OF_ENTRIES_IN_HASH_TABLE 0x000000100 /*  */
#else 
	#define  SIZE_OF_HASH_KEY USHORT
	#define	NUMBER_OF_FILTERING_DATABASE_ENTRIES 0x00004000 /* 16k */
	#define	NUMBER_OF_ENTRIES_IN_HASH_TABLE 0x00010000 /* 64k */
#endif

enum STP_PRINTF_GROUPS
{
	STP_ALGORITHM_PRINTF,
	STP_MEMORY_PRINTF,
	STP_ALARM_PRINTF,
	STP_SNMP_PRINTF,
	STP_DATA_PRINTF	 
};

/* Srikar, Mar 23, 1997. Changed the following bridge type constants to match SNMP specification. */
#if 0
enum STP_BASE_TYPE
{
	UNKNOWN,
	TRANSPARENT,
	SOURCE_ROUTING_,
	SRT
};
#endif

enum STP_BASE_TYPE
{
	BRIDGE_TYPE_UNKNOWN = 1,
	BRIDGE_TYPE_TRANSPARENT,
	BRIDGE_TYPE_SOURCE_ROUTING,
	BRIDGE_TYPE_SRT
};

enum STP_TYPE
{
	STP_DEC_LAN_BRIDGE_100 = 2,
	IEEE_8021D = 3
};					  
