#include	"defs.h"
/*	$Modname: macbrini.c$  $version: 1.20$      $date: 02/09/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross
1.2 04/22/92 ross
1.3 07/30/92 ross
1.4 07/30/92 ross
1.5 08/05/92 ross
1.6 08/21/92 ross
1.7 08/22/92 ross Added support for multiple instances of stp_class
1.8 10/16/92 ross changed handling of big_e/little_e of BPDUs (for frame relay).
1.9 11/23/92 ross added comments.
1.10 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.11 01/15/93 ross
1.12 07/16/93 ross added some mib statistics
1.13 07/23/93 ross added check for enable/disable.
1.14 08/09/93 ross added STAND_ALONE ifdef.
1.15 10/28/93 ross remove C++ comment.
1.16 10/28/93 ross delete nvram header
1.17 12/03/93 ross changes for lsl version 3.0
1.18 03/07/94 ross removed external references to mac_address, function used instead.
1.19 06/15/94 ross cosmetic changes and snmp access routines.
1.20 02/09/95 ross modified root path cast to swap_long instead of swap.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include	<lslproto.h>
/****************************************************************************/
extern enum TEST mac_bridge_control (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1); /* macbrcfg.c */
/****************************************************************************/
enum TEST initialize_bridge (ULONG clock_ticks_per_second)
{
	BYTE hash_key_bit;
	USHORT port_number;
	ULONG number_of_hash_table_entries;

	stp_class.clock_ticks_per_second = clock_ticks_per_second;

	/* Keep the below section of code before the check for STP enabled. The
	** following init is for the purpose of proper SNMP support when STP is
	** disabled.
	*/
	for (port_number = 0x01; port_number <= stp_class.number_of_spanning_tree_ports ; port_number += (BYTE) 1)
	{
		if (stp_class.port[port_number].state != DISABLED)
			stp_class.port[port_number].state = BLOCKING;
		stp_class.port[port_number].dot1dStpPortEnable = FALSE;
		stp_class.port[port_number].port_id.number = (BYTE) port_number;
	}
	/* Upto here to be kept before check for STP enable. */

	if (stp_class.enabled == FALSE)
		{
		return (PASS);
		}

	/* Srikar, Mar 23, 1997. Changed the bridge type to match SNMP specification. */
	stp_class.dot1dBaseType = BRIDGE_TYPE_SRT;
	stp_class.dot1dStpProtocolSpecification = IEEE_8021D;

#ifdef __LSL__
	if (lsl_control (REGISTER_PROTOCOL_STACK,"Spanning Tree",
		(enum RX_PACKET_STATE (*) (USHORT port_number,void *vptr_buffer,USHORT number_of_bytes))mac_bridge_rx,mac_bridge_timer,
		mac_bridge_control,&stp_class.stack_id) == FAIL)
		{
#ifdef FRAME_RELAY /* KVSP */
		printf ("SPANTREE: Error while initializing. Disabled.\r\n") ;
		stp_class.enabled = FALSE ;
		return PASS ;
#else
		return (FAIL);
#endif
		}
#endif

	for (number_of_hash_table_entries = stp_class.number_of_hash_table_entries,hash_key_bit = 0x00;
		hash_key_bit < 31; hash_key_bit += (BYTE) 1)
		{
		number_of_hash_table_entries >>= 1; /* number_of_hash_table_entries MUST BE A POWER OF 2!!!!!!! */

		if (number_of_hash_table_entries & 0x0001)
			{
			stp_class.size_of_hash_key = hash_key_bit;
			break;
			}
		}

	++stp_class.size_of_hash_key;

	stp_class.hash_mask = (USHORT) (0xffffffffL >> (32 - stp_class.size_of_hash_key));

	stp_class.mac_bridge_enabled = TRUE;
	stp_class.timer_enabled = FALSE;

	initialize_hashing_table ();

	initialize_bridge_spanning_tree ();

	stp_class.timer_enabled = TRUE;
	return (PASS);
}
/****************************************************************************/
enum SORT_RETURN compare_identifiers (BRIDGE_IDENTIFIER *sptr_address_1,BRIDGE_IDENTIFIER *sptr_address_2)
{
	enum SORT_RETURN sort_return_value;

	if (sptr_address_1->priority > sptr_address_2->priority)
		return (GREATER_THAN);
	else if (sptr_address_1->priority < sptr_address_2->priority)
		return (LESS_THAN);
	else 
		{
		sort_return_value = compare_addresses (&sptr_address_1->address,&sptr_address_2->address);
		return (sort_return_value);
		}
}
/****************************************************************************/
enum SORT_RETURN compare_port_identifiers (PORT_IDENTIFIER *sptr_address_1,PORT_IDENTIFIER *sptr_address_2)
{
	if (sptr_address_1->priority > sptr_address_2->priority)
		return (GREATER_THAN);
	else if (sptr_address_1->priority < sptr_address_2->priority)
		return (LESS_THAN);
	else 
		{
		if (sptr_address_1->number > sptr_address_2->number)
			return (GREATER_THAN);
		else if (sptr_address_1->number < sptr_address_2->number)
			return (LESS_THAN);
		else 
			return (EQUAL_TO);
		}
}
/****************************************************************************/
/* Srikar, Mar 23, 1997. The function modified to work independent of the byte ordering. */

enum SORT_RETURN compare_addresses (MAC_ADDRESS *sptr_address_1,MAC_ADDRESS *sptr_address_2)
{
	BYTE	address_size = sizeof (MAC_ADDRESS);
	BYTE	*wptr_address_1 = (BYTE *) sptr_address_1;
	BYTE	*wptr_address_2 = (BYTE *) sptr_address_2;

	while (address_size--)
		{
		if (*wptr_address_1 > *wptr_address_2)
			return (GREATER_THAN);
		if (*wptr_address_1 < *wptr_address_2)
			return (LESS_THAN);

		++wptr_address_1;
		++wptr_address_2;
		}

	return (EQUAL_TO);
}
/****************************************************************************/
void big_endianize_packet (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
	sptr_bridge_configuration_BPDU->root_id.priority = swap (sptr_bridge_configuration_BPDU->root_id.priority);
	sptr_bridge_configuration_BPDU->root_path_cost = swap_long (sptr_bridge_configuration_BPDU->root_path_cost);
	sptr_bridge_configuration_BPDU->bridge_id.priority = swap (sptr_bridge_configuration_BPDU->bridge_id.priority);
	sptr_bridge_configuration_BPDU->message_age = swap (sptr_bridge_configuration_BPDU->message_age); 		
	sptr_bridge_configuration_BPDU->max_age = swap (sptr_bridge_configuration_BPDU->max_age);					
	sptr_bridge_configuration_BPDU->hello_time = swap (sptr_bridge_configuration_BPDU->hello_time);			
	sptr_bridge_configuration_BPDU->forward_delay = swap (sptr_bridge_configuration_BPDU->forward_delay);	
}
/****************************************************************************/
void little_endianize_packet (BRIDGE_CONFIGURATION_BPDU *sptr_bridge_configuration_BPDU)
{
/*	sptr_bridge_configuration_BPDU->mac_header.length = swap (sptr_bridge_configuration_BPDU->mac_header.length); */

	sptr_bridge_configuration_BPDU->root_id.priority = swap (sptr_bridge_configuration_BPDU->root_id.priority);
	sptr_bridge_configuration_BPDU->root_path_cost = swap_long (sptr_bridge_configuration_BPDU->root_path_cost);
	sptr_bridge_configuration_BPDU->bridge_id.priority = swap (sptr_bridge_configuration_BPDU->bridge_id.priority);
	sptr_bridge_configuration_BPDU->message_age = swap (sptr_bridge_configuration_BPDU->message_age);		
	sptr_bridge_configuration_BPDU->max_age = swap (sptr_bridge_configuration_BPDU->max_age);					
	sptr_bridge_configuration_BPDU->hello_time = swap (sptr_bridge_configuration_BPDU->hello_time);			
	sptr_bridge_configuration_BPDU->forward_delay = swap (sptr_bridge_configuration_BPDU->forward_delay);	
}
#ifdef STAND_ALONE
/****************************************************************************/
USHORT swap (USHORT ushort_to_swap_bytes_with)
{
	return (two_bytes_to_ushort (low_byte_of_ushort (ushort_to_swap_bytes_with),high_byte_of_ushort (ushort_to_swap_bytes_with)));
}
/****************************************************************************/
ULONG swap_long (ULONG ulong_to_swap_bytes_with)
{
	ULONG return_value;
	BYTE *bptr_return_value;
	BYTE *bptr_ulong;

	bptr_return_value = (BYTE *) &return_value + 3;

	bptr_ulong = (BYTE *) &ulong_to_swap_bytes_with;

	*bptr_return_value-- = *bptr_ulong++;
	*bptr_return_value-- = *bptr_ulong++;
	*bptr_return_value-- = *bptr_ulong++;
	*bptr_return_value = *bptr_ulong;

	return (return_value);
}
#endif
int IsBridgingEnabled()
{
	return (stp_class.enabled);
}
