/****************************************************************************
 * File	: MACBRNFLT.C
 *
 * Date	: 13.12.1995
 * By		: Sachin S Desai
 * Rev.	: 
 ***************************************************************************/

#include	"defs.h"
#ifdef NEW_FILTERING

#include	<string.h>
#include	<stdlib.h>
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include	<lslproto.h>

void display_span_tree () ;

extern USHORT get_port_number_and_string (char *cptr_port_number_and_value,char *return_string) ;

enum FILTER_ACTION stp_filter_default_action = FORWARD_PACKET ;
FILTERING_DATABASE_ENTRY *filtering_database_chain ;
USHORT stp_number_of_filters = 0 ;

void stp_src_filter_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
   int i ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3 ;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
		sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
			(int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
			(int *)(mac_address_ptr + 5));

		new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
		if (new_entry == NULL)
			return ;

		new_entry->source_address._ulong = mac_address._ulong ;
		new_entry->source_address._ushort = mac_address._ushort ;
		new_entry->port_number = port_number ;
		new_entry->type = FILTER_ON_SOURCE_ADDRESS ;
		new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
		new_entry->links.sptr_backward_link = NULL ;
		filtering_database_chain = new_entry ;

#if 0
		printf ("\nFilter source address, port : %d, address : %08lX%04X",
   				       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr += 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;
      ethernet_address_string_ptr++ ;
   }

	return ;
}

void stp_src_and_dest_filter_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   int i ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
	   sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
		   (int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
		   (int *)(mac_address_ptr + 5));

	   new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
	   if (new_entry == NULL)
		   return ;

	   new_entry->source_address._ulong = mac_address._ulong ;
	   new_entry->source_address._ushort = mac_address._ushort ;
	   new_entry->port_number = port_number ;
	   new_entry->type = FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS ;
	   new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
	   new_entry->links.sptr_backward_link = NULL ;
	   filtering_database_chain = new_entry ;

#if 0
	   printf ("\nFilter on source or destination address, port : %d, address : %08lX%X",
 			       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr += 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;
      ethernet_address_string_ptr++ ;
   }

   return ;
}

void stp_src_and_dest_forward_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
   int i ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3 ;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;   

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
		sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
			(int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
			(int *)(mac_address_ptr + 5));

		new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
		if (new_entry == NULL)
			return ;

		new_entry->source_address._ulong = mac_address._ulong ;
		new_entry->source_address._ushort = mac_address._ushort ;
		new_entry->port_number = port_number ;
		new_entry->type = FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS ;
		new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
		new_entry->links.sptr_backward_link = NULL ;
		filtering_database_chain = new_entry ;

#if 0
		printf ("\nForward on source or destination address, port : %d, address : %08lX%X",
 			       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr+= 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;
      ethernet_address_string_ptr++ ;
   }
	return ;
}


void stp_dest_filter_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
   int i ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3 ;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
	   sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
		   (int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
		   (int *)(mac_address_ptr + 5));

	   new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
	   if (new_entry == NULL)
		   return ;
	   new_entry->source_address._ulong = mac_address._ulong ;
	   new_entry->source_address._ushort = mac_address._ushort ;
	   new_entry->port_number = port_number ;
	   new_entry->type = FILTER_ON_DESTINATION_ADDRESS ;
	   new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
	   new_entry->links.sptr_backward_link = NULL ;
	   filtering_database_chain = new_entry ;

#if 0
		printf ("\nFilter destination address, port : %d, address : %08lX%X",
 			       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr += 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;

      ethernet_address_string_ptr++ ;
   }

	return ;
}


void stp_src_forward_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
   int i ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3 ;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
	   sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
		   (int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
		   (int *)(mac_address_ptr + 5));

	   new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
	   if (new_entry == NULL)
		   return ;
	   new_entry->source_address._ulong = mac_address._ulong ;
	   new_entry->source_address._ushort = mac_address._ushort ;
	   new_entry->port_number = port_number ;
	   new_entry->type = FORWARD_ON_SOURCE_ADDRESS ;
	   new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
	   new_entry->links.sptr_backward_link = NULL ;
	   filtering_database_chain = new_entry ;

#if 0
		printf ("\nForward source address, port : %d, address : %08lX%X",
 			       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr += 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;
      ethernet_address_string_ptr++ ;
   }

	return ;
}


void stp_dest_forward_cfg_string (char *filter_cfg_string)
{
	FILTERING_DATABASE_ENTRY *new_entry ;
   int i ;
	unsigned short port_number ;
	MAC_ADDRESS mac_address ;
   unsigned char *ethernet_address_string_ptr = filter_cfg_string+3 ;
	unsigned char *mac_address_ptr = (unsigned char *)&mac_address ;

   sscanf (filter_cfg_string, "%02u", (int *)&i) ;
   port_number = i ;

   while (1)
   {
	   sscanf (ethernet_address_string_ptr,"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(mac_address_ptr + 0),(int *)(mac_address_ptr + 1),
		   (int *)(mac_address_ptr + 2),(int *)(mac_address_ptr + 3),(int *)(mac_address_ptr + 4),
		   (int *)(mac_address_ptr + 5));

	   new_entry = (FILTERING_DATABASE_ENTRY *) malloc (sizeof (FILTERING_DATABASE_ENTRY)) ;
	   if (new_entry == NULL)
		   return ;
	   new_entry->source_address._ulong = mac_address._ulong ;
	   new_entry->source_address._ushort = mac_address._ushort ;
	   new_entry->port_number = port_number ;
	   new_entry->type = FORWARD_ON_DESTINATION_ADDRESS ;
	   new_entry->links.sptr_forward_link = (LINK *)filtering_database_chain ;
	   new_entry->links.sptr_backward_link = NULL ;
	   filtering_database_chain = new_entry ;

#if 0
		printf ("\nForward destination address, port : %d, address : %08lX%X",
 			       port_number, mac_address._ulong, mac_address._ushort) ;
#endif

      ethernet_address_string_ptr += 12 ;
      if (*ethernet_address_string_ptr == 0)
         break ;
      ethernet_address_string_ptr++ ;
   }

	return ;
}


void stp_default_action_cfg_string (char *filter_cfg_string)
{
	if (strstr (filter_cfg_string, "filter"))
		stp_filter_default_action = FILTER_PACKET ;
	else
		stp_filter_default_action = FORWARD_PACKET ;

#if 0
	printf ("\nSpanning Tree default action : %s", (stp_filter_default_action == FILTER_PACKET) ? "Filter" : "Forward") ;
#endif
}


void add_other_filters_to_static_forwarding_table ()
{
	FILTERING_DATABASE_ENTRY *next_entry, *previous_entry ;
#if 0
	char *temp_ptr ;
#endif

	next_entry = filtering_database_chain ;
   stp_number_of_filters++ ;

	while (next_entry != NULL)
	{
		add_entry_to_filtering_database (next_entry->source_address._ushort,
		                                 next_entry->source_address._ulong,
		                                 next_entry->port_number,
		                                 next_entry->type) ;
#if 0
		temp_ptr = (char *)&next_entry->source_address._ulong ;
		printf ("\nAddress added : %02X%02X%02X%02X%02X%02X",
		(char)(*(temp_ptr+0)), (char)(*(temp_ptr+1)), (char)(*(temp_ptr+2)),
		(char)(*(temp_ptr+3)), (char)(*(temp_ptr+4)), (char)(*(temp_ptr+5))) ;
#endif
		previous_entry = next_entry ;
		next_entry = (FILTERING_DATABASE_ENTRY *)next_entry->links.sptr_forward_link ;
		free (previous_entry) ;
      stp_number_of_filters++ ;
	}

	return ;
}

#ifdef PRINTF

extern STP_CLASS stp_class ;

void display_span_tree ()
{
	FILTERING_DATABASE_ENTRY *next_entry ;
	int i ;
	char *temp_ptr ;

	printf ("\nDisplaying Filter Table.....") ;
   printf ("\nNumber of filters : %d", stp_number_of_filters) ;

	for (i = 0 ; i < 256 ; i++)
	{
		next_entry = &stp_class.sptr_first_entry_in_fd_table[i] ;
		if ((next_entry->source_address._ulong == 0L) &&
		    (next_entry->source_address._ushort == 0))
			continue ;
		temp_ptr = (char *)&next_entry->source_address._ulong ;
		printf ("\nEthernet address : %02X%02X%02X%02X%02X%02X, port : %d",
		(char)(*(temp_ptr+0)), (char)(*(temp_ptr+1)), (char)(*(temp_ptr+2)),
		(char)(*(temp_ptr+3)), (char)(*(temp_ptr+4)), (char)(*(temp_ptr+5)),
		next_entry->port_number) ;
		switch (next_entry->type)
		{
			case (FILTER_ON_DESTINATION_ADDRESS) :
				printf (", type : Filter on destination") ;
				break ;
			case (FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS) :
				printf (", type : Filter on source or dest.") ;
				break ;
			case (FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS) :
				printf (", type : Forward on source or dest.") ;
				break ;
			case (FILTER_ON_SOURCE_ADDRESS) :
				printf (", type : Filter on source") ;
				break ;
			case (FORWARD_ON_DESTINATION_ADDRESS) :
				printf (", type : Forward on destination") ;
				break ;
			case (FORWARD_ON_SOURCE_ADDRESS) :
				printf (", type : Forward on Source") ;
				break ;
			case (DELETE_ENTRY_ON_TIMEOUT) :
				printf (", type : Learned") ;
				break ;
			case (PERMANENT_TABLE_ENTRY) :
				printf (", type : Permanent table entry") ;
				break ;
			default :
				break ;
		}
	}
	return ;
}

#endif


#endif
