#include	"defs.h"
#define DEBUG
/*	$Modname: macbrrx.c$  $version: 1.38$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/25/92 ross changed return (PACKET_HAS_NOT_BEEN_TXED) to HAS in unicast and multicast cases (first 2).  This is  to cover the case where a packet is not wanted by anybody (filtering case)
1.2 01/25/92 ross
1.3 01/26/92 ross
1.4 01/26/92 ross made frames_discarded and frames_forwarded an array of port_numbers
1.5 04/22/92 ross
1.6 07/30/92 ross checking in for adding broadcast packet support.
1.7 07/30/92 ross added send_broadcast_packet routine.
1.8 07/30/92 ross
1.9 07/30/92 ross
1.10 07/30/92 ross
1.11 07/31/92 ross checking in
1.12 08/05/92 ross
1.13 08/21/92 ross
1.14 08/21/92 ross
1.15 08/22/92 ross Added support for multiple instances of stp_class
1.16 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.17 01/10/93 ross adding dlci parameters for frame relay.
1.18 01/10/93 ross added frame relay function to store dlci's in the transmitted frame.
1.19 01/18/93 ross added SPANNING_TREE_FILTERING #ifdef.
1.20 01/20/93 ross
1.21 01/23/93 ross changed store_dlci to use port_number.
1.22 01/24/93 ross
1.23 01/25/93 ross moved stp_filter routine.
1.24 01/29/93 ross delete reference to store_dlci and moved it into vmacbstr.h
1.25 01/29/93 ross changed constants in macbrrx.c and macbrdb.c to better match snmp, fixed frame relay bug.
1.26 01/30/93 ross delete references to stp dlci
1.27 07/16/93 ross added some mib statistics
1.28 07/23/93 ross added mtu check and statistic.  Courtesy of Teresa.
1.29 10/07/93 ross accidently removed frame relay header stuff.
1.30 10/28/93 ross added parameter to convert tr to ethernet header.
1.31 11/29/93 ross delete line that have number_of_packets forwarded incremented twice.
1.32 01/28/94 ross had frame relay header subtractions in for test, that should have been removed.
1.33 02/02/94 ross took out frame relay header and fixed big endian problems.  Courtesy of Rick.
1.34 02/25/94 ross added multi port broadcast support for wans.
1.35 05/09/94 ross added changes for configuring forwarding state for SRT
1.36 06/15/94 ross cosmetic changes and snmp access routines.
1.37 03/31/95 ross Changes for new rwutils library.
1.38 06/27/95 ross fixed allocation problem.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>
#include	<kstart.h>
#include "macbridg.h"
#include "vmacbr.h"
#include	<lslproto.h>
/****************************************************************************/
/*static enum RX_PACKET_STATE send_broadcast_packet (USHORT rx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer);*/
enum RX_PACKET_STATE send_broadcast_packet (USHORT rx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer);
static enum RX_PACKET_STATE  send_mac_bridge_packet (USHORT rx_port_number,USHORT tx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,
	USHORT size_of_packet,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_packet));
static void send_mac_bridge_completion_routine (USHORT port_number,void *sptr_ethernet_packet);

MAC_ADDRESS	broadcast_address = {0xffffffffL,0xffff};

#ifdef NEW_FILTERING
extern enum FILTER_ACTION stp_filter_default_action ;
#endif

/****************************************************************************/
#if 0
enum RX_PACKET_STATE mac_bridge_rx (USHORT port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer)
{
	STP_PORT_CLASS				*sptr_port;
	enum	FD_TABLE_ENTRY_TYPE	forwarding_status;
	USHORT destination_mac_address_ushort;
	ULONG destination_mac_address_ulong;
	FILTERING_DATABASE_ENTRY	*sptr_database_entry;
	enum RX_PACKET_STATE return_rx_state;

	++port_number;

	sptr_port = &stp_class.port[port_number];

	if (sptr_port->state == DISABLED)
		{
		return (PACKET_NOT_RECOGNIZED);
		}

#ifdef DEBUG
	stp_printf(STP_DATA_PRINTF, "STP: Pkt Rx ");
	display_spanning_tree_packet (port_number,sptr_rx_buffer,size_of_buffer);
#endif

	if (sptr_port->token_ring == TRUE)
		{
		convert_token_ring_header_to_ethernet (sptr_rx_buffer,size_of_buffer);
		}

	destination_mac_address_ushort = sptr_rx_buffer->mac_header.destination_address._ushort;
	destination_mac_address_ulong = sptr_rx_buffer->mac_header.destination_address._ulong;

#ifdef NOTNOW
printf(" <Source=%x%x>",
sptr_rx_buffer->mac_header.source_address._ulong,
sptr_rx_buffer->mac_header.source_address._ushort);
#endif

#ifdef SIMPLE_BRIDGE
	sptr_port->state = FORWARDING; /* uncomment to bypass spanning tree */
	--port_number;
	send_packet (stp_class.stack_id,port_number ^ 0x01,sptr_rx_buffer,size_of_buffer,TRUE,TRUE,NULL); /* set port number back to zero based */

	return (PACKET_NOT_RECOGNIZED);
#endif

	if ((stp_class.port[port_number].token_ring == FALSE) &&
		(destination_mac_address_ushort == bridge_group_address._ushort &&
		destination_mac_address_ulong == bridge_group_address._ulong))
		{
		if (stp_class.stp_algorithm_enabled == TRUE)
			{
			little_endianize_packet ((BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

			bridge_protocol_message_received (port_number,(BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);
			}
#ifdef DEBUG
		stp_printf (STP_DATA_PRINTF,"STP: PACKET_RECOGNIZED_BUT_NOT_FORWARDED\n\r");
#endif
		++stp_class.port[port_number].dot1dTpPortInFrames;
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
	else if ((stp_class.port[port_number].token_ring == TRUE) &&
		(destination_mac_address_ushort == token_ring_bridge_group_address._ushort &&
		destination_mac_address_ulong == token_ring_bridge_group_address._ulong))
		{
		little_endianize_packet ((BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

		bridge_protocol_message_received (port_number,(BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

#ifdef DEBUG
		stp_printf (STP_DATA_PRINTF,"STP: PACKET_RECOGNIZED_BUT_NOT_FORWARDED\n\r");
#endif
		++stp_class.port[port_number].dot1dTpPortInFrames;
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
	else if (stp_class.mac_bridge_enabled == TRUE &&
		(sptr_port->state == LEARNING || sptr_port->state == FORWARDING))
		{
		if ((sptr_rx_buffer->mac_header.source_address._ulong & MULTICAST_BROADCAST_MASK_BIT) == NO_MULTICAST_OR_BROADCAST)
			{
			forwarding_status = add_entry_to_filtering_database (sptr_rx_buffer->mac_header.source_address._ushort,
				sptr_rx_buffer->mac_header.source_address._ulong,port_number,DELETE_ENTRY_ON_TIMEOUT);
			}
		else {
			forwarding_status = NOT_IN_DATABASE;
		}

#ifdef SPANNING_TREE_FILTERING
	if (stp_filter (port_number,sptr_rx_buffer) == TRUE)
		{
		++stp_class.port[port_number].number_of_rx_frames_filtered;
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
#endif
		++stp_class.port[port_number].dot1dTpPortInFrames;

		return_rx_state = PACKET_NOT_RECOGNIZED;

		if (sptr_port->state == FORWARDING)
			{
			if (forwarding_status != PERMANENT_TABLE_ENTRY)
				{
				if (destination_mac_address_ushort == 0xffff && destination_mac_address_ulong == 0xffffffffL) /* broadcast */
					{
					send_broadcast_packet (port_number,sptr_rx_buffer,size_of_buffer);
			 		return_rx_state = PACKET_RECOGNIZED_AND_FORWARDED;
					}
				else																		
					{
					sptr_database_entry = get_destination_address_database_entry (destination_mac_address_ushort,
						destination_mac_address_ulong);

					if (sptr_database_entry	== NULL) 
						{
						return_rx_state = send_broadcast_packet (port_number,sptr_rx_buffer,size_of_buffer);
						}
					else /* entry found in table, send it to known port */
						{
						if (sptr_database_entry->port_number != port_number &&
							stp_class.port[sptr_database_entry->port_number].state == FORWARDING)
							{
							/* set port number back to zero based */

							return_rx_state = send_mac_bridge_packet (port_number,sptr_database_entry->port_number,sptr_rx_buffer,
								size_of_buffer,NULL);
							}
						}
					}

				return (return_rx_state);
				}
			else
				{
				++stp_class.port[port_number].number_of_frames_discarded;
				}
			}
		}

#ifdef DEBUG
		stp_printf (STP_DATA_PRINTF,"STP: PACKET_NOT_RECOGNIZED\n\r");
#endif
	return (PACKET_NOT_RECOGNIZED);
}
#endif

#ifdef NEW_FILTERING
enum RX_PACKET_STATE mac_bridge_rx (USHORT port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer)
{
	STP_PORT_CLASS *sptr_port;
	enum FD_TABLE_ENTRY_TYPE forwarding_status;
	USHORT destination_mac_address_ushort;
	ULONG destination_mac_address_ulong;
	FILTERING_DATABASE_ENTRY *sptr_database_entry;
	enum RX_PACKET_STATE return_rx_state;
	enum FILTER_ACTION filter_action ;

	++port_number;

	sptr_port = &stp_class.port[port_number];

	/* if receive-port is disabled, return */
	if (sptr_port->state == DISABLED)
	{
#if 0
		printf ("\nPacket from %08lX%04X, Rx port disabled",
		        sptr_rx_buffer->mac_header.source_address._ulong, sptr_rx_buffer->mac_header.source_address._ushort) ;
#endif
		return (PACKET_NOT_RECOGNIZED);
	}

	if (sptr_port->token_ring == TRUE)
	{
		convert_token_ring_header_to_ethernet (sptr_rx_buffer,size_of_buffer);
	}

	destination_mac_address_ushort = sptr_rx_buffer->mac_header.destination_address._ushort;
	destination_mac_address_ulong = sptr_rx_buffer->mac_header.destination_address._ulong;

	if ((stp_class.port[port_number].token_ring == FALSE) &&
		(destination_mac_address_ushort == bridge_group_address._ushort &&
		destination_mac_address_ulong == bridge_group_address._ulong))
	{
		if (stp_class.stp_algorithm_enabled == TRUE)
		{
			little_endianize_packet ((BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

			bridge_protocol_message_received (port_number,(BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);
		}
		++stp_class.port[port_number].dot1dTpPortInFrames;
#if 0
		printf ("\nPacket from %08lX%04X, recognized but not forwarded",
              sptr_rx_buffer->mac_header.source_address._ulong, sptr_rx_buffer->mac_header.source_address._ushort) ;
#endif
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
	}
	else 
	{
		if ((stp_class.port[port_number].token_ring == TRUE) &&
		    (destination_mac_address_ushort == token_ring_bridge_group_address._ushort &&
		destination_mac_address_ulong == token_ring_bridge_group_address._ulong))
		{
			little_endianize_packet ((BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

			bridge_protocol_message_received (port_number,(BRIDGE_CONFIGURATION_BPDU *) sptr_rx_buffer);

			++stp_class.port[port_number].dot1dTpPortInFrames;
#if 0
			printf ("\nPacket from %08lX%04X, recognized but not forwarded",
			        sptr_rx_buffer->mac_header.source_address._ulong, sptr_rx_buffer->mac_header.source_address._ushort) ;
#endif
			return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
		else
		{
			if (stp_class.mac_bridge_enabled == TRUE &&
			   (sptr_port->state == LEARNING || sptr_port->state == FORWARDING))
			{
				if ((sptr_rx_buffer->mac_header.source_address._ulong & MULTICAST_BROADCAST_MASK_BIT) == NO_MULTICAST_OR_BROADCAST)
				{
					forwarding_status = add_entry_to_filtering_database (sptr_rx_buffer->mac_header.source_address._ushort,
				        sptr_rx_buffer->mac_header.source_address._ulong,port_number,DELETE_ENTRY_ON_TIMEOUT);
				}
				else
				{
					forwarding_status = NOT_IN_DATABASE;
				}
				++stp_class.port[port_number].dot1dTpPortInFrames;
				return_rx_state = PACKET_NOT_RECOGNIZED;
				if (sptr_port->state == FORWARDING)
				{
					sptr_database_entry = get_destination_address_database_entry (destination_mac_address_ushort,
					                      destination_mac_address_ulong) ;
				}
				else
				{
#if 0
					printf ("\nPacket from %08lX%04X, Rx port not in forwarding state",
			             sptr_rx_buffer->mac_header.source_address._ulong, sptr_rx_buffer->mac_header.source_address._ushort) ;
#endif
					return (PACKET_NOT_RECOGNIZED) ;
				}
				if (((forwarding_status == FILTER_ON_SOURCE_ADDRESS) || (forwarding_status == FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS)) ||
				    ((sptr_database_entry != NULL) && ((sptr_database_entry->type == FILTER_ON_DESTINATION_ADDRESS) ||
					   (sptr_database_entry->type == FILTER_ON_SOURCE_AND_DESTINATION_ADDRESS))))
				    	filter_action = FILTER_PACKET ;
				else
					if (((forwarding_status == FORWARD_ON_SOURCE_ADDRESS) || ((forwarding_status == FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS))) ||
					    ((sptr_database_entry == NULL) ||
						  (sptr_database_entry->type == FORWARD_ON_DESTINATION_ADDRESS) ||
						  (sptr_database_entry->type == FORWARD_ON_SOURCE_AND_DESTINATION_ADDRESS)))
					     	filter_action = FORWARD_PACKET ;
					else
						filter_action = stp_filter_default_action ;

				if (filter_action == FILTER_PACKET)
				{
#if 0
					printf ("\nSTP : Packet filtered off") ;
#endif
					++stp_class.port[port_number].number_of_frames_discarded ;
					return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED) ;
				}

				if (((destination_mac_address_ushort == 0xFFFF) && (destination_mac_address_ulong == 0xFFFFFFFFL)) ||
				    (sptr_database_entry == NULL))
				{
					/* node's port is not known or it is a b/c packet, flood it */
#if 0
					if ((destination_mac_address_ushort != 0xFFFF) && (destination_mac_address_ulong != 0xFFFFFFFFL))
						printf ("\nPacket from %08lX%04X to %08lX%04X, Port not known, flooding to all ports",
						         sptr_rx_buffer->mac_header.source_address._ulong, sptr_rx_buffer->mac_header.source_address._ushort,
						         destination_mac_address_ulong, destination_mac_address_ushort) ;
#endif
					send_broadcast_packet (port_number, sptr_rx_buffer, size_of_buffer) ;
					return (PACKET_RECOGNIZED_AND_FORWARDED) ;
				}
				else
				{
#if 0
					printf ("\nPacket bridged from port %d to %d", port_number, sptr_database_entry->port_number) ;
#endif
					if (sptr_database_entry->port_number != port_number &&
						stp_class.port[sptr_database_entry->port_number].state == FORWARDING)
							return_rx_state = send_mac_bridge_packet (port_number, sptr_database_entry->port_number,
					                  sptr_rx_buffer, size_of_buffer, NULL) ;
					return (return_rx_state) ;
				}
			}
#if 0
			else
					printf("Port state=%d\n",sptr_port->state);
#endif
		}
	}
	return (PACKET_NOT_RECOGNIZED);
}
#endif


#ifndef FRAME_RELAY		/* KVSP - 17 Feb 97 */
/****************************************************************************/
/*static enum RX_PACKET_STATE send_broadcast_packet (USHORT rx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer)*/
enum RX_PACKET_STATE send_broadcast_packet (USHORT rx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer)
{
	USHORT broadcast_port_number;
	enum BOOLEAN first_packet_sent;
	ETHERNET_BUFFER *sptr_calloced_tx_buffer;
	enum RX_PACKET_STATE return_code;


	first_packet_sent = FALSE;

	/* send to all ports */
	
	for (broadcast_port_number = 0x0001; broadcast_port_number < stp_class.number_of_spanning_tree_ports + 1;
		++broadcast_port_number)	
		{
		if (broadcast_port_number != rx_port_number && stp_class.port[broadcast_port_number].state == FORWARDING)
			{
			if (first_packet_sent == FALSE)
				{
				first_packet_sent = TRUE;

				return_code = send_mac_bridge_packet (rx_port_number,broadcast_port_number,sptr_rx_buffer,size_of_buffer,NULL);
				/* set port number back to zero based */
				}
			else
				{
				sptr_calloced_tx_buffer = buffer_malloc (size_of_buffer);
				if (sptr_calloced_tx_buffer != NULL)
					{
					memcpy (sptr_calloced_tx_buffer,sptr_rx_buffer,size_of_buffer);

					send_mac_bridge_packet (rx_port_number,broadcast_port_number,sptr_calloced_tx_buffer,size_of_buffer,
						send_mac_bridge_completion_routine);
					}
				}
			}
#if 0
			else
				printf("%d is disabled\n", broadcast_port_number);
#endif
		}

	if (first_packet_sent == FALSE)
		{
		return (PACKET_NOT_RECOGNIZED);
		}
	else
		{
		return (return_code);
		}
}
/****************************************************************************/
static void send_mac_bridge_completion_routine (USHORT port_number,void *sptr_txed_packet)
{
/*	PARAMETER_NOT_USED (port_number);*/

	buffer_free (sptr_txed_packet);
}
#else		/* KVSP - 17 Feb 97 */
/****************************************************************************/
/****************************************************************************/

/* If the number of ports are greater than 1, we need the received buffer */
/* not to be freed till we submit for the last time. So, if the number of */
/* ports are greater than 1, we fool send_mac_bridge_pkt function by      */
/* passing a valid completion function ptr making it think this is not a  */
/* device driver buffer till we submit for the last time.                 */

/****************************************************************************/
enum RX_PACKET_STATE send_broadcast_packet (USHORT rx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,USHORT size_of_buffer)
{
	USHORT broadcast_port_number;
	enum BOOLEAN first_packet_sent;
	enum RX_PACKET_STATE return_code;
	USHORT number_of_transmits = 0;
	USHORT current_transmit = 0;

	/* count the number of times we are going to submit the packet */
	
	for (broadcast_port_number = 0x0001; broadcast_port_number < stp_class.number_of_spanning_tree_ports + 1;
		++broadcast_port_number)	
	{
		if ((broadcast_port_number != rx_port_number) && (stp_class.port[broadcast_port_number].state == FORWARDING))
		{
			number_of_transmits ++;
		}
	}

	if (number_of_transmits == 0)
		return (PACKET_NOT_RECOGNIZED);

	first_packet_sent = FALSE;

	/* send to all ports */
	
	for (broadcast_port_number = 0x0001; broadcast_port_number < stp_class.number_of_spanning_tree_ports + 1;
		++broadcast_port_number)	
	{
		if ((broadcast_port_number != rx_port_number) && (stp_class.port[broadcast_port_number].state == FORWARDING))
		{
			if (first_packet_sent == FALSE)
			{
				first_packet_sent = TRUE;

				return_code = send_mac_bridge_packet (rx_port_number,
										broadcast_port_number,
										sptr_rx_buffer,
										size_of_buffer,
										((current_transmit+1) == number_of_transmits)
										? NULL : send_mac_bridge_completion_routine);
				current_transmit++;
			}
			else
			{
				send_mac_bridge_packet (rx_port_number,
										broadcast_port_number,
										sptr_rx_buffer,
										size_of_buffer,
										((current_transmit+1) == number_of_transmits)
										? NULL : send_mac_bridge_completion_routine);
				current_transmit++;
			}
		}
	}

	if (first_packet_sent == FALSE)
	{
		return (PACKET_NOT_RECOGNIZED);
	}
	else
	{
		return (return_code);
	}
}

/****************************************************************************/
static void send_mac_bridge_completion_routine (USHORT port_number,void *sptr_txed_packet)
{
	/* don't do anything */
}

#endif


/****************************************************************************/
static enum RX_PACKET_STATE send_mac_bridge_packet (USHORT rx_port_number,USHORT tx_port_number,ETHERNET_BUFFER *sptr_rx_buffer,
	USHORT size_of_packet,void (*fptr_tx_completion) (USHORT port_number,void *sptr_ethernet_packet))
{
	enum TEST return_value;


	if (stp_class.port[tx_port_number].token_ring == TRUE)
		{
		convert_ethernet_header_to_token_ring ((ETHERNET_HEADER *) sptr_rx_buffer);
		}
	else if (stp_class.port[tx_port_number].wan_port == TRUE && stp_class.port[rx_port_number].token_ring == TRUE)
		{
		convert_ethernet_header_to_token_ring ((ETHERNET_HEADER *) sptr_rx_buffer);
		}

#ifdef DEBUG
/*	display_spanning_tree_packet (tx_port_number,sptr_rx_buffer,size_of_packet); */
#endif

	if (size_of_packet > stp_class.port[tx_port_number].maximum_packet_size)
		{
	 	++stp_class.port[tx_port_number].dot1dBasePortMtuExceededDiscards;

#ifdef DEBUG
		stp_printf (STP_DATA_PRINTF,"STP:  PACKET_NOT_RECOGNIZED; sizeof(pakit)=%d\n\r", size_of_packet);
#endif
		return (PACKET_NOT_RECOGNIZED);
		}
	else
		{
		/* Srikar, Mar 23, 1997. The following line commented to avoid incrementing the counter for */
		/* the number of packets forwarded without checking whether the packet actually got forwarded or not. */
		/* The code that follows incorporates the necessary check. */
/*	 	++stp_class.port[tx_port_number].number_of_frames_forwarded; */
		}

	if (fptr_tx_completion == NULL)
		{
		return_value = send_packet (stp_class.stack_id,(USHORT) (tx_port_number - 1),sptr_rx_buffer,
			(USHORT) (size_of_packet),TRUE,TRUE,fptr_tx_completion);
#ifdef DEBUG
	stp_printf (STP_DATA_PRINTF,"STP: PACKET_RECOGNIZED_AND_FORWARDED RxPort=%d, TxPort = %d\n\r",rx_port_number,tx_port_number);
	if (return_value == PASS)
		stp_printf (STP_DATA_PRINTF,"STP: Above forwarding was successful\n\r");
	else
		stp_printf (STP_DATA_PRINTF,"STP: Above forwarding FAILED!!!\n\r");
#endif
/*		return_value = send_packet (stp_class.stack_id,(USHORT) (tx_port_number - 1),sptr_rx_buffer,
			(USHORT) (size_of_packet + sizeof (CRC)),TRUE,TRUE,fptr_tx_completion);
*/
		}
	else
		{
		return_value = send_packet (stp_class.stack_id,(USHORT) (tx_port_number - 1),sptr_rx_buffer,
			(USHORT) (size_of_packet),TRUE,FALSE,fptr_tx_completion);
#ifdef DEBUG
	stp_printf (STP_DATA_PRINTF,"STP: PACKET_RECOGNIZED_AND_FORWARDED Rx Port=%d, Tx Port = %d\n\r",rx_port_number,tx_port_number);
	if (return_value == PASS)
		stp_printf (STP_DATA_PRINTF,"STP: Above forwarding was successful\n\r");
	else
		stp_printf (STP_DATA_PRINTF,"STP: Above forwarding FAILED!!!\n\r");
#endif
/*		return_value = send_packet (stp_class.stack_id,(USHORT) (tx_port_number - 1),sptr_rx_buffer,
			(USHORT) (size_of_packet + sizeof (CRC)),TRUE,FALSE,fptr_tx_completion);
*/
		}

	/* Srikar, Mar 23, 1997. The following line commented and new code added for this reason : Do not blindly */
	/* return a status of packet forwarded. Only if the packet is actually forwarded the return value indicates that */
	/* the packet is 'recognized and forwarded'; otherwise the return value is 'recognized and not forwarded'. */
	/* The packet forwarded counter is incremented only if the packet is sent thru the link. */

	if (return_value == PASS)
		{
	 	++stp_class.port[tx_port_number].number_of_frames_forwarded;
		return (PACKET_RECOGNIZED_AND_FORWARDED);
		}
	else
		{
		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
}
