/*	$Modname: vmacmstr.h$  $version: 1.10$      $date: 04/17/95$   */
/*
* 	$lgb$
1.0 01/05/92 ross
1.1 01/26/92 ross
1.2 04/22/92 ross
1.3 08/05/92 ross
1.4 11/23/92 ross changed ETHERNET_ADDRESS to MAC_ADDRESS to appear more generic (cosmetic)
1.5 01/15/93 ross
1.6 03/29/93 ross added more snmp stuff
1.7 07/16/93 ross added some mib statistics
1.8 06/15/94 ross cosmetic changes and snmp access routines.
1.9 08/25/94 ross added support for BYTE_ENUM and USHORT_ENUM
1.10 04/17/95 ross removed pragmas.  Courtesy of Hung.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	BRIDGE_PARAMETERS
{
	USHORT					root_path_cost;	

	USHORT					max_age;
	USHORT					configuration_time;
	USHORT					forward_delay;

	USHORT					bridge_max_age;
	USHORT					bridge_configuration_time;
	USHORT					bridge_forward_delay;

	enum	BOOLEAN			topology_change_detected;
	enum	BOOLEAN			topology_change;
	USHORT					topology_change_time;
	USHORT					hold_time;
} BRIDGE_PARAMETERS;


typedef	struct	READ_PORT_ADDRESS
{
	BYTE					port_number;
	MAC_ADDRESS	bridge_entity_address;

} READ_PORT_ADDRESS;

typedef	struct	READ_BRIDGE_STATUS
{
	MAC_ADDRESS	mac_address_from_bridge_id;
	char					name[32];
	USHORT				number_of_ports;
	ULONG					uptime;
	READ_PORT_ADDRESS	port_address[8];
} READ_BRIDGE_STATUS;


typedef	struct	ERROR_DETAILS
{
	MAC_ADDRESS						source_mac_address;
	enum REASON_PACKET_WAS_DISCARDED	reason;
}ERROR_DETAILS;

typedef	struct	PORT_COUNTERS
{
	ULONG				number_of_frames_received;
	ULONG				number_of_frames_discarded;
	ULONG				number_of_frames_forwarded;
	ULONG				number_of_frames_discarded_due_no_buffers;
	ULONG				number_of_frames_discarded_due_transmit_delay_exceeded;
	ULONG				number_of_frames_discarded_due_large_tx_size;
	ERROR_DETAILS	error_details[16];
}PORT_COUNTERS;

typedef	struct	PERMANENT_DATABASE_STATUS
{
	USHORT	maximum_number_of_entries;
	USHORT	current_number_of_entries;
}PERMANENT_DATABASE_STATUS;

typedef	struct	PORT_MAP
{
	BYTE				inbound_port_number;
	enum	BOOLEAN	outbound_port_filter_enable[8];
} PORT_MAP;

typedef	union	UNION_FILTERING_STP_PORT_CLASS
{
	PORT_MAP	static_port_map;
	BYTE		dynamic_port_number;
} UNION_FILTERING_STP_PORT_CLASS;

typedef	struct	FILTERING_ENTRY_STATUS
{
	MAC_ADDRESS								filtering_mac_address;
	enum	FILTERING_ENTRY_TYPE			filtering_entry_type;
	UNION_FILTERING_STP_PORT_CLASS	union_filtering_port;
} FILTERING_ENTRY_STATUS;

/* 802.1 Bridge Management Entity Operations */

enum TEST discover_bridge (READ_BRIDGE_STATUS *sptr_read_bridge_status,MAC_ADDRESS **sptr_low_address,MAC_ADDRESS **sptr_high_address,MAC_ADDRESS **sptr_address_exclusion_list);
void  set_bridge_name (const char *bptr_bridge_name);
void reset_bridge (void);
void	read_port (USHORT port_number,char *bptr_port_name,enum PORT_TYPE *type_of_port);
void	set_port_name (USHORT port_number,const char *bptr_port_name);

/* 802.1 Bridge Mapping of Forwarding Process Operations */

void	read_forwarding_port_counters (USHORT port_number,PORT_COUNTERS *sptr_port_counters);
BYTE	read_transmissions_priority (USHORT port_number);
void	set_transmission_priority (USHORT port_number,BYTE priority);

/* 802.1 Bridge Mapping of Filtering Database Operations */

void	*read_filtering_database (void);
void set_filtering_database_aging_time (ULONG time);
void	read_permanent_database (PERMANENT_DATABASE_STATUS *sptr_permanent_database_status);
void	create_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,MAC_ADDRESS *sptr_mac_address_to_add,
	PORT_MAP *sptr_port_map);
void	delete_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,MAC_ADDRESS *sptr_mac_address_to_delete);
void read_filtering_entry (enum FILTERING_DATABASE_TYPE filtering_database_type,
	MAC_ADDRESS *sptr_mac_address_to_read,FILTERING_ENTRY_STATUS *sptr_filtering_entry_status);
void read_filtering_entry_range (enum FILTERING_DATABASE_TYPE filtering_database_type,
	USHORT database_start_index,USHORT database_stop_index,FILTERING_ENTRY_STATUS *sptr_filtering_entry_status);

/* 802.1 Bridge Protocol Entity */

BRIDGE_PARAMETERS	*read_bridge_parameters (void);
void	set_bridge_parameters (USHORT bridge_max_age,USHORT hello_time,USHORT forward_delay,USHORT bridge_priority);
UNION_FILTERING_STP_PORT_CLASS	*read_port_parameters (USHORT port_number);
void	force_port_state (USHORT port_number,enum PORT_STATE state);
void	set_port_parameters (USHORT port_number,USHORT path_cost,BYTE port_priority);


