#include "defs.h"
/*	$Modname: spxcfg.c$  $version: 1.4$      $date: 11/21/94$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 08/08/94 ross Initial release
1.3 08/08/94 ross Added copyright
1.4 11/21/94 ross changed to compile under C++.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include <stdio.h>
#include "spx.h"
#include	<vnvrmstr.h>
#include	"vnvspx.h"
/****************************************************************************/
static enum TEST spx_initialize_socket_transport_interface (TRANSPORT_INTERFACE *sptr_transport_interface);
/****************************************************************************/
enum TEST spx_configuration (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	TRANSPORT_INTERFACE *sptr_transport_interface;

	PARAMETER_NOT_USED (parameter_0);

	switch (command)
		{
		case IS_TRANSPORT_ENABLED:
			*((BYTE_ENUM (BOOLEAN) *) parameter_1) = spx.enabled;

			break;

		case INITIALIZE_SOCKET_TRANSPORT_INTERFACE:
			sptr_transport_interface = (TRANSPORT_INTERFACE *) parameter_1;

			spx_initialize_socket_transport_interface (sptr_transport_interface);

			break;

		case INITIALIZE_TRANSPORT_FUNCTION_POINTERS:
			if ((enum TEST) lsl_control (INITIALIZE_SOCKET_FUNCTION_POINTERS, SOCKETS_INTERFACE, INITIALIZE_FUNCTION_POINTERS,
				TRANSPORT_LAYER_TYPE, &spx.socket_fptrs) == FAIL)
				{
				spx_printf (SPX_ALARM_PRINTF, "SPX: failed to initialize function pointers to the socket library\n");

				return (FAIL);
				}

			break;

		default:

			return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST spx_initialize_socket_transport_interface (TRANSPORT_INTERFACE *sptr_transport_interface)
{
	sptr_transport_interface->socket = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket, USHORT protocol)) socket_spx;

	sptr_transport_interface->listen = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket, USHORT mode))
														socket_spx_listen;

	sptr_transport_interface->connect = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_spx_connect;

	sptr_transport_interface->receive = (USHORT (*) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
														SOCKADDR	*sptr_sockaddr, USHORT *usptr_address_length, enum TEST *eptr_error))
														socket_spx_receive;

	sptr_transport_interface->send = (USHORT (*) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
													SOCKADDR *sptr_sockaddr, enum TEST *eptr_error)) socket_spx_send;

/*
	sptr_transport_interface->queue_length = (USHORT (*) (struct USER_SOCKET *sptr_user_socket, USHORT queue_type,
																enum TEST *eptr_error)) socket_spx_queue_length;

	sptr_transport_interface->kick = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_spx_kick;

	sptr_transport_interface->shut = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket, USHORT channel)) socket_spx_shut;
*/

	sptr_transport_interface->close = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_spx_close;

/*
	sptr_transport_interface->check_if_window_open = (BYTE_ENUM (BOOLEAN) (*) (struct USER_SOCKET *sptr_user_socket))
		check_if_spx_window_open;

	sptr_transport_interface->state = (char *(*) (struct USER_SOCKET *sptr_user_socket)) socket_spx_get_state_string;

	sptr_transport_interface->status = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_spx_status;
*/

	sptr_transport_interface->check = (BYTE_ENUM (TEST) (*) (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length))
		spx_check_ipx_address;

	return (PASS);
}
/****************************************************************************/
enum SPX_RETURN_CODE spx_get_configuration (USHORT *usptr_maximum_number_of_connections,
	USHORT *usptr_number_of_available_connections)
{
	*usptr_maximum_number_of_connections = spx.maximum_number_of_connections;
	*usptr_number_of_available_connections = spx.maximum_number_of_available_connections;

	return (SPX_SUCCESSFUL);
}
/****************************************************************************/
enum SPX_RETURN_CODE spx_get_version (BYTE *bptr_major_version,BYTE *bptr_minor_version,BYTE	*bptr_revision_level)
{
	*bptr_major_version = spx.major_revision;
	*bptr_minor_version = spx.minor_revision;
	*bptr_revision_level = spx.revision_level;

	return (SPX_SUCCESSFUL);
}
#if 0
/****************************************************************************/
static BYTE value[12];
static void _set_ulong_swapped_hex_value (char *cptr_value_string);
static void _set_mac_address (char *cptr_mac_string);
static ULONG _get_ulong_hex_value (char *cptr_port_number_and_value);
static enum TEST parse_spx_parameters (char *cptr_string_from_ini_file,char *cptr_value_string);
/****************************************************************************/
enum TEST get_spx_ini_file (char *cptr_name_of_ini_file)
{
	FILE *filptr_ini_file;
	char *cptr_value_string;
	char string_from_ini_file[80];

	if ((filptr_ini_file = fopen (cptr_name_of_ini_file, "rt")) == NULL)
		{
		return (FAIL);
		}

	while (fgets (string_from_ini_file,sizeof (string_from_ini_file),filptr_ini_file) != NULL)
		{
		if (string_from_ini_file[0] == '/' && string_from_ini_file[1] == '/')
			continue;
		else if ((cptr_value_string = strchr (string_from_ini_file,'=')) == NULL)
			continue;

		cptr_value_string += 2;

		if (parse_spx_parameters (string_from_ini_file,cptr_value_string) == FAIL)
			{
		   fclose (filptr_ini_file);

			return (FAIL);
			}
		}

   fclose (filptr_ini_file);

	return (PASS);
}
/****************************************************************************/
static enum TEST parse_spx_parameters (char *cptr_string_from_ini_file,char *cptr_value_string)
{
	if (strstr (cptr_string_from_ini_file,"Destination Node Address") != NULL)
		{
		_set_mac_address (cptr_value_string);
		}
	else if (strstr (cptr_string_from_ini_file,"Destination Network Number") != NULL)
		{
		_set_ulong_swapped_hex_value (cptr_value_string);
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static void _set_mac_address (char *cptr_mac_address_string)
{
	char scanf_string[20];
	char *cptr_ethernet_address;

	cptr_ethernet_address = &scanf_string[0];

	sscanf (cptr_mac_address_string,"%02x%02x%02x%02x%02x%02x",(int *)(cptr_ethernet_address + 0),
		(int *)(cptr_ethernet_address + 1),
		(int *)(cptr_ethernet_address + 2),(int *)(cptr_ethernet_address + 3),(int *)(cptr_ethernet_address + 4),
		(int *)(cptr_ethernet_address + 5));
}
/****************************************************************************/
void _set_ulong_swapped_hex_value (char *cptr_value_string)
{
	PARAMETER_NOT_USED (cptr_value_string);
}
#endif
