#include "defs.h"
/*	$Modname: spxconn.c$  $version: 1.6$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
1.5 11/21/94 ross changed to compile under C++.
1.6 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "spx.h"
/*************************************************************************/
static void	reset_session_members_to_initial_values (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb);
static void	free_ecb_list_for_session (EVENT_CONTROL_BLOCK_LINK *sptr_ecb_list);
static void spx_cleanup_session(SPX_SESSION_CLASS *sptr_session, enum SPX_RETURN_CODE connection_state);
static void call_esrs_for_ecbs(EVENT_CONTROL_BLOCK_LINK *sptr_ecb_list, enum SPX_RETURN_CODE connection_state);
/*************************************************************************/
enum SPX_RETURN_CODE spx_connect (USHORT socket, BYTE number_of_connection_retries, enum BOOLEAN watchdog,
	ULONG *ulptr_session_handle, EVENT_CONTROL_BLOCK *sptr_connect_ecb, EVENT_CONTROL_BLOCK *sptr_listen_ecb)
{
	enum SPX_RETURN_CODE return_code;
	SPX_SESSION_CLASS *sptr_session;

	return_code = spx_open_socket (&socket);

/*
	if (return_code == SPX_IPX_SOCKET_IN_USE)
		{
		spx_close_socket (socket);

		return (SPX_SOCKET_NOT_FOUND);
		}
*/

	if (return_code == SPX_SOCKET_TABLE_FULL)
		{
		return (SPX_SOCKET_NOT_FOUND);
		}

	if ((sptr_listen_ecb->session_handle == (ULONG) NULL) || (sptr_connect_ecb->session_handle == (ULONG) NULL))
		{
		sptr_session = (SPX_SESSION_CLASS *) table_malloc (1, sizeof (SPX_SESSION_CLASS));

		if (sptr_session == NULL)
			{
		 	spx_printf (SPX_ALARM_PRINTF, "SPX: table_malloc failed\r\n");

			return (SPX_OUT_OF_RESOURCES);
			}

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated SESSION %p\n", sptr_session);

		if (set_connection_number (sptr_session) == FAIL)
			{
		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SESSION %p\n", sptr_session);

			table_free (sptr_session);

			return (SPX_CONNECT_TABLE_FULL);
			}

		sptr_session->sptr_connect_ecb = sptr_connect_ecb;

		if (number_of_connection_retries > 0x00)
			{
			sptr_session->number_of_connection_retries = number_of_connection_retries;
			sptr_session->number_of_disconnection_retries = number_of_connection_retries;
			sptr_session->number_of_data_retries = number_of_connection_retries;
			}
		else
			{
			sptr_session->number_of_connection_retries = spx.number_of_connection_retries;
			sptr_session->number_of_disconnection_retries = spx.number_of_disconnection_retries;
			sptr_session->number_of_data_retries = spx.number_of_data_retries;
			}
			
		sptr_session->current_number_of_connection_retries = 0x0000;
		sptr_session->watchdog = watchdog;
		sptr_session->watchdog_timeout = spx.watchdog_timeout;
		sptr_session->socket = socket;
		sptr_session->ack_timeout = spx.ack_timeout;
		sptr_session->destination_ipx_address =
			sptr_session->sptr_connect_ecb->fragment_descriptor[0].type.sptr_spx_packet->ipx_header.destination;

		add_entry_to_list ((LINK *) &spx.session_list, (LINK *) &sptr_session->links);
		}
	else if (sptr_connect_ecb->session_handle != (ULONG) NULL)
		{
		sptr_session = (SPX_SESSION_CLASS *) sptr_connect_ecb->session_handle;
		}
	else
		{
		sptr_session = (SPX_SESSION_CLASS *) sptr_listen_ecb->session_handle;
		}

	execute_spx_state_machine (SPX_START_CONNECTION, sptr_session, sptr_connect_ecb);

	*ulptr_session_handle = (ULONG) sptr_session;

	++spx.number_of_active_connections;

	return (SPX_SUCCESSFUL);
}
/*************************************************************************/
void spx_transmit_connection_request (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb)
{
 	spx_printf (SPX_DATA_PRINTF, "SPX: Sending CONNECT REQUEST packet\r\n");

	send_spx_packet (sptr_session,sptr_ecb,SPX_CONNECT_REQUEST_PACKET);
}
/*************************************************************************/
void spx_transmit_connection_ack (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb)
{
	if (check_if_connection_to_destination_already_exists ((ECB_WITH_BACKWARD_REFERENCE *) sptr_ecb) == FALSE)
		{
		sptr_session->destination_ipx_address = sptr_ecb->destination_ipx_address;

		sptr_ecb->completion_code = SPX_CONNECTION_STARTED;

		call_ecb_esr (sptr_ecb);

		sptr_ecb->fragment_descriptor[0].type.sptr_spx_packet->ipx_header.destination = sptr_ecb->destination_ipx_address;

		sptr_ecb->fragment_descriptor[0].size_of_buffer = (USHORT) (sptr_ecb->fragment_descriptor[0].size_of_buffer +
			(sizeof (UNION_MAC_HEADER) + sizeof (IPX_HEADER) + sizeof (SPX_HEADER)));

	 	spx_printf (SPX_DATA_PRINTF, "SPX: Sending CONNECT ACK packet\r\n");

		send_spx_packet (sptr_session, sptr_ecb, SPX_CONNECT_ACK_PACKET);

		--spx.number_of_listen_connections;

		++spx.number_of_active_connections;
		}
	else
		{
		reset_session_members_to_initial_values (sptr_session, sptr_ecb);

	 	spx_printf (SPX_DATA_PRINTF, "\n@@@@@SPX: ABORTED sending a CONNECT ACK because connection already exists\n\n");
		}
}
/*************************************************************************/
static void	reset_session_members_to_initial_values (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb)
{
	sptr_session->remote_connection_id = ILLEGAL_CONNECTION_ID;
	sptr_session->ack_number = 0x0000;
	sptr_session->remote_allocation_number = 0x0000;
	sptr_session->old_state = SPX_DISCONNECTED;
	sptr_session->state = SPX_LISTENING;

	memset (&sptr_ecb->destination_ipx_address, 0x00, sizeof (IPX_ADDRESS));

	sptr_ecb->fragment_descriptor[0].size_of_buffer = sizeof (SPX_PACKET_HEADER);
}
/*************************************************************************/
void spx_transmit_disconnect (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb, enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);

 	spx_printf (SPX_DATA_PRINTF, "SPX: Sending DISCONNECT packet\r\n");

	send_spx_packet (sptr_session, sptr_ecb, SPX_DISCONNECT_PACKET);
}
/*************************************************************************/
void spx_transmit_disconnect_ack (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);

 	spx_printf (SPX_DATA_PRINTF, "SPX: Sending DISCONNECT ACK packet\r\n");

	/* Patch as below was easier */
	++sptr_session->remote_ack_number;

	spx_send_internal_packet (sptr_session, SPX_DISCONNECT_ACK_PACKET);
}
/*************************************************************************/
void spx_transmit_connection_established (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_connect_ecb)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_connect_ecb->completion_code = SPX_CONNECTION_COMPLETED;

	call_ecb_esr (sptr_connect_ecb);
}
/*************************************************************************/
enum TEST set_connection_number (SPX_SESSION_CLASS *sptr_new_session)
{
	USHORT connection_id;
	SPX_SESSION_CLASS *sptr_session;

	for (connection_id = 0x0000; connection_id < spx.maximum_number_of_connections; ++connection_id)
		{
		for (sptr_session = (SPX_SESSION_CLASS *) spx.session_list.sptr_forward_link; sptr_session != NULL;
			sptr_session = (SPX_SESSION_CLASS *) sptr_session->links.sptr_forward_link)
			{
			if (sptr_session->connection_id == connection_id)
				{
				break;
				}
			}

		if (sptr_session == NULL)
			{
			break;
			}
		}

	if (connection_id == spx.maximum_number_of_connections)
		{
		return (FAIL);
		}
	else
		{
		sptr_new_session->connection_id = connection_id;
		sptr_new_session->remote_connection_id = ILLEGAL_CONNECTION_ID;
		}

	return (PASS);
}
/*************************************************************************/
SPX_SESSION_CLASS *get_session_using_connection_id (USHORT connection_id)
{
	SPX_SESSION_CLASS *sptr_session;

	for (sptr_session = (SPX_SESSION_CLASS *) spx.session_list.sptr_forward_link; sptr_session != NULL;
		sptr_session = (SPX_SESSION_CLASS *) sptr_session->links.sptr_forward_link)
		{
		if (sptr_session->connection_id == connection_id &&
			sptr_session->remote_connection_id != ILLEGAL_CONNECTION_ID)
			{
			break;
			}
		}

	return (sptr_session);
}
/*************************************************************************/
SPX_SESSION_CLASS *find_session_class_corresponding_to_received_packet (SPX_PACKET *sptr_spx_rx_packet)
{
	SPX_SESSION_CLASS *sptr_session;

	for (sptr_session = (SPX_SESSION_CLASS *) spx.session_list.sptr_forward_link; sptr_session != NULL;
		sptr_session = (SPX_SESSION_CLASS *) sptr_session->links.sptr_forward_link)
		{
		if (sptr_session->socket == sptr_spx_rx_packet->ipx_header.destination.socket)
			{
			if ((sptr_session->sptr_listen_connect_ecb != NULL) && (sptr_session->state == SPX_LISTENING))
				{
				break;
				}
			}
		}

	return (sptr_session);
}
/*************************************************************************/
void spx_connection_status (ULONG connection_handle,SPX_SESSION_CLASS *sptr_return_session)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_session = (SPX_SESSION_CLASS *) connection_handle;

	*sptr_return_session = *sptr_session;
}
/*************************************************************************/
void spx_terminate_connection (ULONG connection_handle, EVENT_CONTROL_BLOCK *sptr_terminate_ecb)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_session = (SPX_SESSION_CLASS *) connection_handle;

	sptr_session->sptr_disconnect_ecb = sptr_terminate_ecb;

	sptr_terminate_ecb->completion_code = SPX_SUCCESSFUL;

	sptr_terminate_ecb->fragment_descriptor[0].size_of_buffer = sizeof (SPX_ACK_PACKET);

	execute_spx_state_machine (SPX_STOP_CONNECTION, sptr_session, sptr_terminate_ecb);
}
/*************************************************************************/
void spx_delete_session	(SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);


	sptr_ecb->completion_code = SPX_CONNECT_TERMINATED;

	sptr_session->connection_id = 0xFFFF;

	call_ecb_esr (sptr_ecb);

	spx_cleanup_session(sptr_session, SPX_CONNECT_TERMINATED);

#if 0 /* Sanjay 24, July, 1996, Removed original code */

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all unacked send ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->unacked_send_ecb_list);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all unsent send ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->unsent_send_ecb_list);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all listen ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->listen_ecb_list);

	delete_entry_from_list ((LINK *) &spx.session_list, (LINK *) &sptr_session->links);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SESSION %p\r\n", sptr_session);

	table_free (sptr_session);

	--spx.number_of_active_connections;
#endif
}
/*************************************************************************/
static void	free_ecb_list_for_session (EVENT_CONTROL_BLOCK_LINK *sptr_ecb_list)
{
	EVENT_CONTROL_BLOCK *sptr_ecb;
	EVENT_CONTROL_BLOCK *sptr_ecb_next;
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb = (EVENT_CONTROL_BLOCK *) get_pointer_to_first_entry_in_list ((LINK *) sptr_ecb_list);

	while (sptr_ecb != NULL)
		{
		sptr_ecb_next = (EVENT_CONTROL_BLOCK *) get_pointer_to_next_entry_in_list ((LINK *) sptr_ecb);

		delete_entry_from_list ((LINK *) sptr_ecb_list, (LINK *) sptr_ecb);

		sptr_ecb_with_packet = (ECB_WITH_PACKET *) ((ULONG) sptr_ecb - sizeof (ECB_WITH_PACKET_LINKS));

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB with packet %p\r\n", sptr_ecb_with_packet);

		buffer_free ((void *) sptr_ecb_with_packet);

		sptr_ecb = sptr_ecb_next;
		}
}
/*************************************************************************/
void spx_abort_session	(SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_ecb);

/* Naveen 05/02/1997 */

	if (sptr_session->sptr_disconnect_ecb != NULL)
	{
		call_ecb_esr (sptr_session->sptr_disconnect_ecb) ;
	}

/* Naveen 05/02/1997 */

	spx_cleanup_session(sptr_session, SPX_CONNECT_ABORTED);

#if 0 /* Sanjay 26, July, 1996, Removed original code */

	sptr_ecb->completion_code = SPX_CONNECT_ABORTED;

	sptr_session->connection_id = 0xFFFF;

	call_ecb_esr (sptr_ecb);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all unacked send ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->unacked_send_ecb_list);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all unsent send ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->unsent_send_ecb_list);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing all listen ECBs\r\n");

	free_ecb_list_for_session (&sptr_session->listen_ecb_list);

	delete_entry_from_list ((LINK *) &spx.session_list, (LINK *) &sptr_session->links);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SESSION %p\r\n",	sptr_session);

	table_free (sptr_session);

	--spx.number_of_active_connections;
#endif
}
/*************************************************************************/
static void spx_cleanup_session(SPX_SESSION_CLASS *sptr_session, enum SPX_RETURN_CODE completion_code)
{
 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Posting all queued ECBs\r\n");

	/* Call the ECB's of unacked and pending sends and all pending receives */

	call_esrs_for_ecbs(&sptr_session->unacked_send_ecb_list, completion_code);
	call_esrs_for_ecbs(&sptr_session->unsent_send_ecb_list, completion_code);
	call_esrs_for_ecbs(&sptr_session->listen_ecb_list, completion_code);

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SESSION %p\r\n", sptr_session);

	delete_entry_from_list ((LINK *) &spx.session_list, (LINK *) &sptr_session->links);
	table_free (sptr_session);

	--spx.number_of_active_connections;
}

static void call_esrs_for_ecbs(EVENT_CONTROL_BLOCK_LINK *sptr_ecb_list, enum SPX_CONNECTION_STATE completion_code)
{
	EVENT_CONTROL_BLOCK *sptr_ecb;
	EVENT_CONTROL_BLOCK *sptr_ecb_next;

	sptr_ecb = (EVENT_CONTROL_BLOCK *) get_pointer_to_first_entry_in_list ((LINK *) sptr_ecb_list);
	while (sptr_ecb != NULL)
	{
		sptr_ecb_next = (EVENT_CONTROL_BLOCK *) get_pointer_to_next_entry_in_list ((LINK *) sptr_ecb);
		delete_entry_from_list ((LINK *) sptr_ecb_list, (LINK *) sptr_ecb);

		sptr_ecb->completion_code = completion_code;
		call_ecb_esr(sptr_ecb);

		sptr_ecb = sptr_ecb_next;
	}
}
