#include "defs.h"
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "spx.h"
/****************************************************************************/
static SPX_ECB_SOCKET_LIST_ENTRY *build_listen_connect_ecb (IPX_ADDRESS local_address);
static void listen_connect_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
static enum TEST processing_to_listen_for_multiple_connections (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET **ptr_to_sptr_user_socket);
static void	set_local_ipx_port_number_for_new_connection (USHORT new_ipx_port,
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, USER_SOCKET *sptr_user_socket);
static USHORT allocate_local_ipx_port (void);
static USER_SOCKET *clone_user_socket (USER_SOCKET *sptr_user_socket_old);
static void processing_to_listen_for_single_connection (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET **ptr_to_sptr_user_socket);
static void	processing_for_listen_connect_completion (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET *sptr_user_socket, ECB_WITH_BACKWARD_REFERENCE *sptr_ecb);
static EVENT_CONTROL_BLOCK *spx_build_send_packet (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, void *vptr_data,
	USHORT length);
static void spx_transmit_completion_routine (EVENT_CONTROL_BLOCK *sptr_ecb_sent);
/****************************************************************************/
SPX_ECB_SOCKET_LIST_ENTRY *spx_listen_connect (USER_SOCKET *sptr_user_socket, IPX_ADDRESS local_address, USHORT mode)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;

	sptr_ecb_socket_entry = build_listen_connect_ecb (local_address);

	if (sptr_ecb_socket_entry != NULL)
		{
		sptr_ecb_socket_entry->sptr_user_socket = sptr_user_socket;

		sptr_ecb_socket_entry->listen_mode = mode;

		sptr_ecb_socket_entry->application_id = sptr_user_socket->application_id;

		spx_listen_for_connection (0x00, TRUE, (ULONG *) &sptr_ecb_socket_entry->session_handle,
			&sptr_ecb_socket_entry->listen_connect_ecb.ecb, NULL);

		add_entry_to_list ((LINK *) &spx.ecb_socket_list, (LINK *) sptr_ecb_socket_entry);

		++spx.number_of_ecb_socket_entries;
		}

	return (sptr_ecb_socket_entry);
}
/****************************************************************************/
static SPX_ECB_SOCKET_LIST_ENTRY *build_listen_connect_ecb (IPX_ADDRESS local_address)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	void *vptr_buffer;

	sptr_ecb_socket_entry = table_malloc (1, sizeof (SPX_ECB_SOCKET_LIST_ENTRY));


	if (sptr_ecb_socket_entry == NULL)
		{
		return (NULL);
		}
   /* Naveen 20/06/1997 moved this from above if statement*/
 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated ECB SOCKET ENTRY %p\r\n", sptr_ecb_socket_entry);
   /* Naveen 20/06/1997 */
	sptr_ecb_socket_entry->listen_connect_ecb.ecb.in_use = 0x00;
	sptr_ecb_socket_entry->listen_connect_ecb.ecb.completion_code = 0x00;
	sptr_ecb_socket_entry->listen_connect_ecb.ecb.socket_number = local_address.socket;
	sptr_ecb_socket_entry->listen_connect_ecb.ecb.fragment_count = 1;

	vptr_buffer	= buffer_malloc (sizeof (SPX_PACKET_HEADER) + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

/* Naveen 20/06/1997 */
   if (vptr_buffer == NULL)
   {
      table_free(sptr_ecb_socket_entry);
      return NULL;
   }
/* Naveen 20/06/1997 */

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated listen connect ecb buffer %p\r\n", vptr_buffer);

	sptr_ecb_socket_entry->listen_connect_ecb.ecb.fragment_descriptor[0].type.vptr_buffer =
		(void *) ((ULONG)	vptr_buffer + MINIMAL_EXTRA_FRAME_HEADER_BYTES);

	sptr_ecb_socket_entry->listen_connect_ecb.ecb.fragment_descriptor[0].size_of_buffer = sizeof (SPX_PACKET_HEADER);
	sptr_ecb_socket_entry->listen_connect_ecb.ecb.fptr_event_service_routine =
		(void (*) (EVENT_CONTROL_BLOCK *)) listen_connect_completion_routine;

	memcpy (&sptr_ecb_socket_entry->listen_connect_ecb.ecb.immediate_address, &local_address.node_address,
		sizeof (MAC_ADDRESS));

	memcpy (&sptr_ecb_socket_entry->local_address, &local_address, sizeof (IPX_ADDRESS));

	sptr_ecb_socket_entry->listen_connect_ecb.sptr_ecb_socket_entry = sptr_ecb_socket_entry;

 	spx_printf (SPX_DATA_PRINTF, "SPX: Build listen connect ECB\r\n");

	return (sptr_ecb_socket_entry);
}
/****************************************************************************/
static void listen_connect_completion_routine (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;
	LSL_MESSAGE *sptr_lsl_message;
	USER_SOCKET *sptr_user_socket;

	sptr_ecb_socket_entry = sptr_ecb->sptr_ecb_socket_entry;

	if (sptr_ecb_socket_entry == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: pointer to ecb socket entry is NULL\n");

		return;
		}
			
	if (sptr_ecb->ecb.completion_code == SPX_CONNECTION_STARTED)
		{
		spx_printf (SPX_DATA_PRINTF, "SPX: VALID call to listen_connection_completion_routine\n");

		if (sptr_ecb_socket_entry->listen_mode == SOCKET_OPEN_MODE_WAIT_FOR_MULTIPLE_CONNECTION)
			{
			if (processing_to_listen_for_multiple_connections (sptr_ecb_socket_entry, &sptr_user_socket) == FAIL)
				{
				spx_printf (SPX_ALARM_PRINTF, "SPX: @@@@@listen connect FAILED for multiple connections\n");

				return;
				}
			}
		else
			{
			processing_to_listen_for_single_connection (sptr_ecb_socket_entry, &sptr_user_socket);
			}

		processing_for_listen_connect_completion (sptr_ecb_socket_entry, sptr_ecb_socket_entry->sptr_user_socket, sptr_ecb);

		sptr_lsl_message = spx_generate_message (sptr_user_socket, sptr_ecb_socket_entry, CONNECTION_REQUEST_RECEIVED);

		lsl_control (RESOLVE_SOCKET_API, LINK_SERVICES_LAYER_TYPE, (ULONG) ADD_MESSAGE_TO_QUEUE, (ULONG) sptr_lsl_message,
			(ULONG) NULL);

		spx_printf (SPX_MESSAGE_PRINTF, "SPX: CONNECTION REQUEST RECEIVED message placed in mailbox: %d\n",
			sptr_lsl_message->destination_id);

		spx_listen_for_data (sptr_ecb_socket_entry);

		build_disconnect_ecb (sptr_ecb_socket_entry);

		((SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle)->sptr_disconnect_ecb =
			(EVENT_CONTROL_BLOCK *) &sptr_ecb_socket_entry->disconnect_ecb;
		}
	else if (sptr_ecb->ecb.completion_code == SPX_OUT_OF_RESOURCES)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: OUT OF RESOURCES call to listen_connection_completion_routine\n");

		spx_listen_for_data (sptr_ecb_socket_entry);
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: UNRECOGNIZED call to listen_connection_completion_routine\n");
		}
}
/*****************************************************************************************/
enum BOOLEAN check_if_connection_to_destination_already_exists (ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_session = (SPX_SESSION_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &spx.session_list);

	while (sptr_session != NULL)
		{
		if (memcmp (&sptr_session->destination_ipx_address, &sptr_ecb->ecb.destination_ipx_address, sizeof (IPX_ADDRESS))
			== 0x0L)
			{
			return (TRUE);
			}

		sptr_session = (SPX_SESSION_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_session);
		}

	return (FALSE);
}
/*****************************************************************************************/
static enum TEST processing_to_listen_for_multiple_connections (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET **ptr_to_sptr_user_socket)
{
	USER_SOCKET *sptr_user_socket_old;
	USER_SOCKET *sptr_user_socket_new;
	USHORT allocated_local_ipx_port;
	enum SPX_RETURN_CODE return_code;

	sptr_user_socket_old = sptr_ecb_socket_entry->sptr_user_socket;

	sptr_ecb_socket_entry->listening_for_connection = FALSE;

	sptr_user_socket_new = clone_user_socket (sptr_user_socket_old);

	if ((sptr_user_socket_new != NULL) && (sptr_user_socket_new != (USER_SOCKET *) INVALID_SOCKET_DESCRIPTOR))
		{
		sptr_user_socket_old->vptr_protocol_control_block = spx_listen_connect (sptr_user_socket_old,
			sptr_ecb_socket_entry->local_address, sptr_ecb_socket_entry->listen_mode);

		if (sptr_user_socket_old->vptr_protocol_control_block == NULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: failed to do another listen connect (for multiple connections)\n");

			return (FAIL);
			}
			
		allocated_local_ipx_port = allocate_local_ipx_port ();

		return_code = spx_open_socket (&allocated_local_ipx_port);

		if (return_code == SPX_SOCKET_TABLE_FULL)
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: failed open ipx socket\n");

			return (FAIL);
			}

		sptr_user_socket_new->vptr_protocol_control_block = (void *) sptr_ecb_socket_entry;

		sptr_ecb_socket_entry->sptr_user_socket = (void *) sptr_user_socket_new;

		set_local_ipx_port_number_for_new_connection (allocated_local_ipx_port, sptr_ecb_socket_entry, sptr_user_socket_new);

		/* Store the new socket # in the old one */

		sptr_user_socket_old->ready_socket = (ULONG) sptr_user_socket_new;

		sptr_user_socket_old->valid_ready_socket = TRUE;

		*ptr_to_sptr_user_socket = sptr_user_socket_old;
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: Failed to clone socket descriptor\n");
		}

	return (PASS);
}
/*****************************************************************************************/
static void	set_local_ipx_port_number_for_new_connection (USHORT allocated_local_ipx_port,
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, USER_SOCKET *sptr_user_socket)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_ecb_socket_entry->local_address.socket = allocated_local_ipx_port;

	sptr_ecb_socket_entry->listen_connect_ecb.ecb.socket_number = allocated_local_ipx_port;

	sptr_session = (SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle;

	sptr_session->socket = allocated_local_ipx_port;

	((SOCKADDR_IPX *) sptr_user_socket->vptr_address)->port = allocated_local_ipx_port;
}
/*****************************************************************************************/
static USHORT allocate_local_ipx_port (void)
{
	USHORT ipx_port;

	ipx_port = (*spx.socket_fptrs.fptr_get_number_of_already_allocated_ports_in_socket_class) ();

	++ipx_port;

	return (ipx_port);
}
/*****************************************************************************************/
static USER_SOCKET *clone_user_socket (USER_SOCKET *sptr_user_socket_old)
{
	USER_SOCKET *sptr_user_socket_new;
	ULONG socket_descriptor_new;

	/* Clone the socket */

	socket_descriptor_new = (ULONG) (*spx.socket_fptrs.fptr_socket) (AF_NETWARE, SOCK_STREAM, (int) 0);

	if (socket_descriptor_new == FAILED)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: call to create clone socket failed\n");

		return ((USER_SOCKET *) NULL);
		}

	sptr_user_socket_new = (USER_SOCKET *) socket_descriptor_new;

	sptr_user_socket_new->socket_descriptor = socket_descriptor_new;
	sptr_user_socket_new->application_id = sptr_user_socket_old->application_id;
	sptr_user_socket_new->socket_type_of_service = sptr_user_socket_old->socket_type_of_service;
	sptr_user_socket_new->internet_type_of_service = sptr_user_socket_old->internet_type_of_service;
	sptr_user_socket_new->flag = sptr_user_socket_old->flag;
	sptr_user_socket_new->do_not_block = sptr_user_socket_old->do_not_block;
	sptr_user_socket_new->sptr_transport_interface = sptr_user_socket_old->sptr_transport_interface;

	/* Allocate new memory for the address areas */

	sptr_user_socket_new->vptr_address = (void *) table_malloc (1, sizeof (SOCKADDR_IPX));

	if (sptr_user_socket_new->vptr_address == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: table_malloc failed\n");

		return ((USER_SOCKET *) NULL);
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated vptr address %p\n", sptr_user_socket_new->vptr_address);

	sptr_user_socket_new->address_length = sizeof (SOCKADDR_IPX);

	memcpy (sptr_user_socket_new->vptr_address, sptr_user_socket_old->vptr_address, sizeof (SOCKADDR_IPX));

	sptr_user_socket_new->vptr_peer_address = (void *) table_malloc (1, sizeof (SOCKADDR_IPX));

	if (sptr_user_socket_new->vptr_peer_address == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: table_malloc failed\n");

		return ((USER_SOCKET *) NULL);
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated vptr peer address %p\n", sptr_user_socket_new->vptr_peer_address);

	sptr_user_socket_new->peer_address_length = sizeof (SOCKADDR_IPX);

	return (sptr_user_socket_new);
}
/*****************************************************************************************/
static void processing_to_listen_for_single_connection (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET **ptr_to_sptr_user_socket)
{
	sptr_ecb_socket_entry->listening_for_connection = FALSE;

	*ptr_to_sptr_user_socket = sptr_ecb_socket_entry->sptr_user_socket;

	(*ptr_to_sptr_user_socket)->vptr_peer_address = (void *) table_malloc (1, sizeof (SOCKADDR_IPX));

	if ((*ptr_to_sptr_user_socket)->vptr_peer_address == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: table_malloc failed\n");

		return;
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated vptr peer address %p\n", (*ptr_to_sptr_user_socket)->vptr_peer_address);

	(*ptr_to_sptr_user_socket)->peer_address_length = sizeof (SOCKADDR_IPX);

	(*ptr_to_sptr_user_socket)->ready_socket = (ULONG) *ptr_to_sptr_user_socket;

	(*ptr_to_sptr_user_socket)->valid_ready_socket = TRUE;
}
/*****************************************************************************************/
static void	processing_for_listen_connect_completion (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	USER_SOCKET *sptr_user_socket, ECB_WITH_BACKWARD_REFERENCE *sptr_ecb)
{
	SOCKADDR_IPX *sptr_sockaddr_ipx;

	sptr_ecb_socket_entry->connection_is_up = TRUE;

	memcpy (&sptr_ecb_socket_entry->remote_address, &sptr_ecb->ecb.destination_ipx_address, sizeof (IPX_ADDRESS));

	sptr_sockaddr_ipx = (SOCKADDR_IPX *) sptr_user_socket->vptr_peer_address;

	sptr_sockaddr_ipx->family = AF_NETWARE;

	memcpy (&sptr_sockaddr_ipx->ipx_address, &sptr_ecb->ecb.destination_ipx_address,	sizeof (sptr_sockaddr_ipx->ipx_address));

	sptr_sockaddr_ipx->port = sptr_ecb->ecb.destination_ipx_address.socket;

	sptr_user_socket->peer_address_length = sizeof (SOCKADDR_IPX);
}
/*****************************************************************************************/
LSL_MESSAGE *spx_generate_message (USER_SOCKET *sptr_user_socket, SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry,
	enum APPLICATION_CONTROL_OPERATION command)
{
	LSL_MESSAGE *sptr_lsl_message;

	sptr_lsl_message = (LSL_MESSAGE *) table_malloc (1, sizeof (LSL_MESSAGE));

	if (sptr_lsl_message == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: spx_generate_message : table_malloc failed\n");

		return (sptr_lsl_message);
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated lsl message %p\n", sptr_lsl_message);

	sptr_lsl_message->command = (ULONG) command;

	sptr_lsl_message->socket_descriptor = (ULONG) sptr_user_socket;

	sptr_lsl_message->vptr_context = (void *) sptr_ecb_socket_entry;

	sptr_lsl_message->destination_id = sptr_ecb_socket_entry->application_id;

	sptr_lsl_message->destination_iso_layer_type = APPLICATION_LAYER_TYPE;

	sptr_lsl_message->source_id = spx.transport_id;

	sptr_lsl_message->source_iso_layer_type = TRANSPORT_LAYER_TYPE;

	return (sptr_lsl_message);
}
/*************************************************************************/
USHORT spx_send_data (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, void *vptr_data, USHORT length)
{
	EVENT_CONTROL_BLOCK *sptr_ecb_to_send;

	sptr_ecb_to_send = spx_build_send_packet (sptr_ecb_socket_entry, vptr_data, length);

	if (sptr_ecb_to_send == NULL)
		{
		return (0x0000);
		}
	
	spx_send_sequenced_packet (sptr_ecb_socket_entry->session_handle, sptr_ecb_to_send);

 	spx_printf (SPX_DATA_PRINTF, "SPX SOCKET: sent packet\r\n");

	return (length);
}
/*************************************************************************/
static EVENT_CONTROL_BLOCK *spx_build_send_packet (SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry, void *vptr_data,
	USHORT length)
{
	ECB_WITH_PACKET *sptr_ecb_with_packet;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) buffer_malloc (sizeof (ECB_WITH_PACKET));

	if (sptr_ecb_with_packet == NULL)
		{
		spx_printf (SPX_MEMORY_PRINTF, "SPX: buffer_malloc failed\n");

		return (NULL);
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated ECB with packet %p\n", sptr_ecb_with_packet);

	memcpy (&sptr_ecb_with_packet->data[0], vptr_data, length);

	sptr_ecb_with_packet->sptr_ecb_socket_entry = sptr_ecb_socket_entry;
	sptr_ecb_with_packet->ecb.links.sptr_forward_link = NULL;
	sptr_ecb_with_packet->ecb.links.sptr_backward_link = NULL;
	sptr_ecb_with_packet->ecb.in_use = TRUE;
	sptr_ecb_with_packet->ecb.completion_code = 0x00;
	sptr_ecb_with_packet->ecb.socket_number = sptr_ecb_socket_entry->local_address.socket;

	memcpy ((void *) &sptr_ecb_with_packet->ecb.destination_ipx_address, &sptr_ecb_socket_entry->remote_address,
		sizeof (ULONG) + sizeof (MAC_ADDRESS));

	sptr_ecb_with_packet->ecb.fragment_count = 1;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].type.vptr_buffer = &sptr_ecb_with_packet->mac_header;
	sptr_ecb_with_packet->ecb.fragment_descriptor[0].size_of_buffer =
		(USHORT) (length + sizeof (SPX_HEADER) + sizeof (IPX_HEADER) + sizeof (UNION_MAC_HEADER));

	sptr_ecb_with_packet->ecb.fptr_event_service_routine = (void (*) (EVENT_CONTROL_BLOCK *)) spx_transmit_completion_routine;

	memcpy (&sptr_ecb_with_packet->ipx_header.source, &sptr_ecb_socket_entry->local_address, sizeof (IPX_ADDRESS));

	memcpy (&sptr_ecb_with_packet->ipx_header.destination, &sptr_ecb_socket_entry->remote_address, sizeof (IPX_ADDRESS));

	return (&sptr_ecb_with_packet->ecb);
}
/*****************************************************************************************/
static void spx_transmit_completion_routine (EVENT_CONTROL_BLOCK *sptr_ecb_sent)
{
	/* shouldn't the ecb be first removed from some send list before freeing it */

	ECB_WITH_PACKET *sptr_ecb_with_packet;
	SPX_SESSION_CLASS *sptr_session;
	EVENT_CONTROL_BLOCK *sptr_ecb;
	EVENT_CONTROL_BLOCK *sptr_ecb_next;
	SPX_ECB_SOCKET_LIST_ENTRY *sptr_ecb_socket_entry;

	sptr_ecb_with_packet = (ECB_WITH_PACKET *) ((ULONG) sptr_ecb_sent - sizeof (ECB_WITH_PACKET_LINKS));

	sptr_ecb_socket_entry = sptr_ecb_with_packet->sptr_ecb_socket_entry;

	sptr_session = (SPX_SESSION_CLASS *) sptr_ecb_socket_entry->session_handle;

	sptr_ecb = (EVENT_CONTROL_BLOCK *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_session->unacked_send_ecb_list);

	while (sptr_ecb != NULL)
		{
		sptr_ecb_next = (EVENT_CONTROL_BLOCK *) get_pointer_to_next_entry_in_list ((LINK *) sptr_ecb);

		if (sptr_ecb == sptr_ecb_sent)
			{
			delete_entry_from_list ((LINK *) &sptr_session->unacked_send_ecb_list, (LINK *) sptr_ecb);

			break;
			}
		else
			{
			sptr_ecb = sptr_ecb_next;
			}
		}

 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing ECB with packet (on transmit completion) %p\r\n",	sptr_ecb_with_packet);

	buffer_free ((void *) sptr_ecb_with_packet);
}
