#include "defs.h"
/*	$Modname: spxtx.c$  $version: 1.6$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 07/23/94 ross watchdog across router timed correctly.
1.3 08/08/94 ross Initial release
1.4 08/08/94 ross Added copyright
1.5 11/21/94 ross changed to compile under C++.
1.6 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include "spx.h"
/****************************************************************************/
static void build_data_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static void build_data_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static void build_connect_request_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static void build_connect_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static void build_disconnect_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static void build_disconnect_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet);
static USHORT build_ipx_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet,EVENT_CONTROL_BLOCK *sptr_ecb,
	USHORT number_of_bytes_to_tx);
static void free_transmit_ecb (EVENT_CONTROL_BLOCK *sptr_transmit_ecb);
/****************************************************************************/
enum TEST send_spx_packet (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb, enum SPX_PACKET_TYPE packet_type)
{
	SPX_PACKET *sptr_spx_packet;
	USHORT virtual_port_number;
	void (*fptr_spx_send_completion) (USHORT port_number, SPX_PACKET *sptr_txed_packet);

	sptr_spx_packet = sptr_ecb->fragment_descriptor[0].type.sptr_spx_packet;

	sptr_spx_packet->spx_header.connection_control._byte = 0x00;

	fptr_spx_send_completion = NULL;

	switch (packet_type)
		{
		case SPX_DATA_PACKET:
			build_data_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_WATCHDOG_PACKET:
		case SPX_DATA_ACK_PACKET:
			build_data_ack_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_WATCHDOG_RETRY_PACKET:
			build_connect_request_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_CONNECT_REQUEST_PACKET:
			build_connect_request_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_CONNECT_ACK_PACKET:
			build_connect_ack_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_DISCONNECT_PACKET:
		case SPX_INTERNAL_DISCONNECT_PACKET:
			build_disconnect_packet_header (sptr_session, sptr_spx_packet);
			break;
		case SPX_DISCONNECT_ACK_PACKET:
			build_disconnect_ack_packet_header (sptr_session, sptr_spx_packet);
			break;
		default:
			spx_printf (SPX_ALARM_PRINTF,"SPX: Illegal packet type \r\n");
			return (FAIL);
		}

	if ((packet_type == SPX_DATA_ACK_PACKET) || (packet_type == SPX_WATCHDOG_PACKET) || (packet_type == SPX_WATCHDOG_RETRY_PACKET) ||
		(packet_type == SPX_INTERNAL_DISCONNECT_PACKET) || (packet_type == SPX_DISCONNECT_ACK_PACKET))
		{
		fptr_spx_send_completion = spx_send_completion;
		}

	sptr_spx_packet->spx_header.source_connection_id = swap (sptr_session->connection_id);
	sptr_spx_packet->spx_header.destination_connection_id = sptr_session->remote_connection_id;

	sptr_spx_packet->spx_header.ack_number = swap (sptr_session->remote_ack_number);
	sptr_spx_packet->spx_header.allocation_number = swap (sptr_session->allocation_number);

	virtual_port_number = build_ipx_header (sptr_session, sptr_spx_packet, sptr_ecb,
		(USHORT) (sptr_ecb->fragment_descriptor[0].size_of_buffer - sizeof (MAC_HEADER)));

	if (virtual_port_number == ILLEGAL_VIRTUAL_PORT_NUMBER)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: Illegal virtual port number\r\n");

		return (FAIL);
		}

	if (send_ipx_packet (virtual_port_number, (IPX_PACKET *) sptr_spx_packet, swap (sptr_spx_packet->ipx_header.length), FALSE,
		(void (*) (USHORT port_number, IPX_PACKET *sptr_tx_packet)) fptr_spx_send_completion) ==
		DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED)
		{
		return (PASS);
		}

	spx_printf (SPX_ALARM_PRINTF, "SPX: Failed to send SPX packet\r\n");

	return (FAIL);
}
/****************************************************************************/
static void build_data_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = TRUE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = FALSE;

	sptr_spx_packet->spx_header.datastream_type = (BYTE_ENUM (SPX_DATASTREAM_TYPE)) USER_DEFINED_DATASTREAM;

	sptr_spx_packet->spx_header.source_connection_id = swap (sptr_session->connection_id);

	sptr_spx_packet->spx_header.sequence_number = swap (sptr_session->sequence_number);

	++sptr_session->sequence_number;
}
/****************************************************************************/
static void build_data_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = TRUE;
	sptr_spx_packet->spx_header.sequence_number = swap (sptr_session->sequence_number);

	sptr_spx_packet->spx_header.datastream_type = (BYTE_ENUM (SPX_DATASTREAM_TYPE))USER_DEFINED_DATASTREAM;
}
/****************************************************************************/
static void build_connect_request_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = TRUE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = TRUE;

	sptr_spx_packet->spx_header.datastream_type = (BYTE_ENUM (SPX_DATASTREAM_TYPE))USER_DEFINED_DATASTREAM;
}
/****************************************************************************/
static void build_connect_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = TRUE;

	sptr_spx_packet->spx_header.datastream_type = (BYTE_ENUM (SPX_DATASTREAM_TYPE))USER_DEFINED_DATASTREAM;
}
/****************************************************************************/
static void build_disconnect_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = TRUE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = FALSE;

	sptr_spx_packet->ipx_header.destination = sptr_session->destination_ipx_address;

	sptr_spx_packet->spx_header.datastream_type = END_OF_CONNECTION;
}
/****************************************************************************/
static void build_disconnect_ack_packet_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet)
{
	PARAMETER_NOT_USED (sptr_session);

	sptr_spx_packet->spx_header.connection_control._bit.end_of_message = TRUE;
	sptr_spx_packet->spx_header.connection_control._bit.attention = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.ack_required = FALSE;
	sptr_spx_packet->spx_header.connection_control._bit.system_packet = FALSE;

	sptr_spx_packet->spx_header.sequence_number = 0;

	sptr_spx_packet->ipx_header.destination = sptr_session->destination_ipx_address;

	sptr_spx_packet->spx_header.datastream_type = END_OF_CONNECTION_ACKNOWLEDGEMENT;
}
/****************************************************************************/
static USHORT build_ipx_header (SPX_SESSION_CLASS *sptr_session,SPX_PACKET *sptr_spx_packet,EVENT_CONTROL_BLOCK *sptr_ecb,
	USHORT number_of_bytes_to_tx)
{
	USHORT virtual_port_number;
	MAC_ADDRESS *sptr_destination_mac_address;
	SAP_ID *sptr_internal_sap_id;

	sptr_destination_mac_address = (MAC_ADDRESS *) get_next_hop_router_address (sptr_spx_packet->ipx_header.destination.network,
		&virtual_port_number);

	if (sptr_destination_mac_address == (MAC_ADDRESS *) ON_OTHER_PORTS_NETWORK)
		{
		sptr_spx_packet->mac_header.destination_address = *((MAC_ADDRESS *) &sptr_spx_packet->ipx_header.destination.node_address);
		}
	else
		{
		if (sptr_destination_mac_address == NULL)
			{
			return (ILLEGAL_VIRTUAL_PORT_NUMBER);
			}
		else
			{
			sptr_spx_packet->mac_header.destination_address = *sptr_destination_mac_address;
			}
		}

	sptr_session->router_or_destination_mac_address = sptr_spx_packet->mac_header.destination_address;

	get_ipx_mac_address_for_port (virtual_port_number, &sptr_spx_packet->mac_header.source_address);

	sptr_spx_packet->mac_header.length = RAW_8023_IPX;

	sptr_spx_packet->ipx_header.checksum = 0xffff;
	sptr_spx_packet->ipx_header.length = swap (number_of_bytes_to_tx);

	sptr_spx_packet->ipx_header.packet_type = SEQUENCED_PACKET_PROTOCOL;

	sptr_spx_packet->ipx_header.transport_control_hop_count = 0x00;

	sptr_internal_sap_id = get_ipx_internal_SAP_id ();

	sptr_spx_packet->ipx_header.source.network = sptr_internal_sap_id->ipx_address.network;
	sptr_spx_packet->ipx_header.source.node_address = *((ETHERNET_ADDRESS *) &sptr_spx_packet->mac_header.source_address);
	sptr_spx_packet->ipx_header.source.socket = sptr_ecb->socket_number;

	return (virtual_port_number);
}
/****************************************************************************/
void spx_send_data_ack_packet (SPX_SESSION_CLASS *sptr_session)
{
	if (sptr_session->watchdog == TRUE)
		{
		sptr_session->current_number_of_watchdog_retries = 0x0000;
		sptr_session->time_since_last_watchdog_packet_rxed = 0x00000000L;
		}

	spx_send_internal_packet (sptr_session, SPX_DATA_ACK_PACKET);
}
/****************************************************************************/
void spx_send_internal_packet (SPX_SESSION_CLASS *sptr_session, enum SPX_PACKET_TYPE packet_type)
{
	EVENT_CONTROL_BLOCK *sptr_send_ecb;
	SPX_PACKET *sptr_spx_packet;

	sptr_spx_packet = spx_get_a_send_packet (sizeof (SPX_ACK_PACKET));


	if (sptr_spx_packet != NULL)
		{
    	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated internal send packet %p\n", sptr_spx_packet);
		sptr_send_ecb = (EVENT_CONTROL_BLOCK *) table_malloc (1, sizeof (EVENT_CONTROL_BLOCK));

		if (sptr_send_ecb == NULL)
			{
		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing internal send packet %p\n", sptr_spx_packet);

			spx_free_a_send_packet (sptr_spx_packet);

		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Failed to send internal packet\n");

			return;
			}

	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated internal transmit ECB %p\n", sptr_send_ecb);

		sptr_send_ecb->socket_number = sptr_session->socket;
		sptr_send_ecb->immediate_address = sptr_session->router_or_destination_mac_address;
		sptr_send_ecb->fragment_count = 1;
		sptr_send_ecb->fragment_descriptor[0].type.vptr_buffer = sptr_spx_packet;
		sptr_send_ecb->fragment_descriptor[0].size_of_buffer = sizeof (SPX_ACK_PACKET);
		sptr_send_ecb->fptr_event_service_routine = free_transmit_ecb;
		sptr_send_ecb->fragment_descriptor[0].type.sptr_spx_packet->ipx_header.destination =
			sptr_session->destination_ipx_address;

		add_entry_to_list ((LINK *) &spx.internal_ecb_list, (LINK *) sptr_send_ecb);

		send_spx_packet (sptr_session, sptr_send_ecb, packet_type);
		}
}
/****************************************************************************/
static void free_transmit_ecb (EVENT_CONTROL_BLOCK *sptr_transmit_ecb)
{
 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing internal transmit ECB %p\n", sptr_transmit_ecb);

	table_free (sptr_transmit_ecb);
}
/****************************************************************************/
void spx_transmit_watchdog_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);

	spx_send_internal_packet (sptr_session,SPX_WATCHDOG_PACKET);
}
/****************************************************************************/
void spx_transmit_watchdog_retry_packet (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (sptr_ecb);
	PARAMETER_NOT_USED (end_state);

	spx_send_internal_packet (sptr_session,SPX_WATCHDOG_RETRY_PACKET);
}
/****************************************************************************/
void spx_send_sequenced_packet (ULONG connection_handle,EVENT_CONTROL_BLOCK *sptr_ecb)
{
	SPX_SESSION_CLASS *sptr_session;

	sptr_session = (SPX_SESSION_CLASS *) connection_handle;

	++spx.statistics.number_of_tx_frames;

	sptr_ecb->completion_code = SPX_SUCCESSFUL;

	add_entry_to_list ((LINK *) &sptr_session->unsent_send_ecb_list, (LINK *) &sptr_ecb->links);

	kickstart_transmit_queues (sptr_session);
}
/****************************************************************************/
void spx_resend_data_packet (SPX_SESSION_CLASS *sptr_session, EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_ecb);

	spx.statistics.number_of_tx_resyncs++;

	if (sptr_session->unacked_send_ecb_list.sptr_forward_link != NULL)
		{
		/* Put all unacked transmits on the unsent queue and restart sending */

		sptr_session->unacked_send_ecb_list.sptr_backward_link->links.sptr_forward_link =
			sptr_session->unsent_send_ecb_list.sptr_forward_link;

		if (sptr_session->unsent_send_ecb_list.sptr_forward_link == NULL)
			{
			sptr_session->unsent_send_ecb_list.sptr_backward_link = sptr_session->unacked_send_ecb_list.sptr_backward_link;
			}
		else
			{
			sptr_session->unsent_send_ecb_list.sptr_forward_link->links.sptr_backward_link =
				sptr_session->unacked_send_ecb_list.sptr_backward_link;
			}

		sptr_session->unsent_send_ecb_list.sptr_forward_link = sptr_session->unacked_send_ecb_list.sptr_forward_link;

		sptr_session->sequence_number = sptr_session->ack_number;
		sptr_session->last_ack_number = sptr_session->ack_number;

		sptr_session->unacked_send_ecb_list.sptr_forward_link = NULL;
		sptr_session->unacked_send_ecb_list.sptr_backward_link = NULL;

		kickstart_transmit_queues (sptr_session);
		}
}
/****************************************************************************/
void spx_packet_transmitted (void *vptr_txed_buffer,USHORT number_of_bytes_txed)
{
	PARAMETER_NOT_USED (vptr_txed_buffer);
	PARAMETER_NOT_USED (number_of_bytes_txed);

}
/*************************************************************************/
void spx_internal_transmit_disconnect (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,
	enum SPX_CONNECTION_STATE end_state)
{
	PARAMETER_NOT_USED (end_state);
	PARAMETER_NOT_USED (sptr_ecb);

 	spx_printf (SPX_DATA_PRINTF, "SPX: Sending DISCONNECT packet\r\n");

	spx_send_internal_packet (sptr_session, SPX_INTERNAL_DISCONNECT_PACKET);
}
/*************************************************************************/
void kickstart_transmit_queues (SPX_SESSION_CLASS *sptr_session)
{
	EVENT_CONTROL_BLOCK *sptr_ecb;

	/* while ((sptr_session->remote_allocation_number - sptr_session->sequence_number) < UNREASONABLE_WINDOW_SIZE) */

/* Vidy 11/01/1997 */
	while (sptr_session->remote_allocation_number >= sptr_session->sequence_number)
		{
		sptr_ecb = (EVENT_CONTROL_BLOCK *) get_entry_from_list ((LINK *) &sptr_session->unsent_send_ecb_list);

		if (sptr_ecb == NULL)
			{
			return;
			}

		add_entry_to_list ((LINK *) &sptr_session->unacked_send_ecb_list, (LINK *) &sptr_ecb->links);

		send_spx_packet (sptr_session, sptr_ecb, SPX_DATA_PACKET);
		}
}
