#include "defs.h"
/*	$Modname: spxutil.c$  $version: 1.5$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/19/94 ross
1.1 07/21/94 ross
1.2 08/08/94 ross Initial release
1.3 08/08/94 ross Added copyright
1.4 11/21/94 ross changed to compile under C++.
1.5 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include "spx.h"
/****************************************************************************/
static SPX_PACKET *get_normalized_packet (SPX_PACKET *sptr_txed_packet);
static EVENT_CONTROL_BLOCK *find_ecb_that_corresponds_to_packet (SPX_PACKET *sptr_txed_packet);
/****************************************************************************/
SPX_PACKET *spx_get_a_send_packet (ULONG size_of_packet)
{
	SPX_PACKET *sptr_spx_tx_packet;
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG length;
	ULONG new_offset;

	length = size_of_packet + EXTRA_FRAME_HEADER_BYTES;

	bptr_buffer = (BYTE *) buffer_malloc (length);

	if (bptr_buffer == NULL)
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: buffer_malloc () failed\n");

		return (NULL);
		}

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated buffer at %p of length %ul\n", bptr_buffer, length);

	bptr_offset = bptr_buffer + EXTRA_FRAME_HEADER_BYTES/2;

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

	spx_printf (SPX_MEMORY_PRINTF, "SPX: bptr_offset : %p, new_offset : %x, bptr_new_offset : %p\n",
		bptr_offset, new_offset, bptr_new_offset);

	memcpy ((void *) bptr_new_offset, (const void *) &bptr_buffer, sizeof (ULONG));

	sptr_spx_tx_packet = (SPX_PACKET *) (bptr_new_offset + EXTRA_FRAME_HEADER_BYTES/2);

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Pointer to send packet %p\r\n", sptr_spx_tx_packet);

	return (sptr_spx_tx_packet);
}
/*************************************************************************/
void spx_free_a_send_packet (SPX_PACKET *sptr_txed_packet)
{
	BYTE *bptr_buffer;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG new_offset;

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing packet %p\r\n", sptr_txed_packet);

	bptr_offset = (BYTE *) sptr_txed_packet;

	bptr_offset = (bptr_offset - (EXTRA_FRAME_HEADER_BYTES/4));

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

	spx_printf (SPX_MEMORY_PRINTF, "SPX: bptr_offset : %p, new_offset : %x, bptr_new_offset : %p\n",
		bptr_offset, new_offset, bptr_new_offset);

	memcpy ((void *) &bptr_buffer, (const void *) bptr_new_offset, sizeof (ULONG));

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing buffer at %p\n", bptr_buffer);

	buffer_free ((void *) bptr_buffer);
}
/*************************************************************************/
void spx_send_completion (USHORT port_number, SPX_PACKET *sptr_txed_packet)
{
	EVENT_CONTROL_BLOCK *sptr_ecb;
	SPX_PACKET *sptr_txed_packet_normalized;

	PARAMETER_NOT_USED (port_number);

	if (sptr_txed_packet != NULL)
		{
		sptr_txed_packet_normalized = get_normalized_packet (sptr_txed_packet);

		sptr_ecb = find_ecb_that_corresponds_to_packet (sptr_txed_packet_normalized);

		spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing internal send packet %p\n", sptr_txed_packet);

		spx_free_a_send_packet (sptr_txed_packet);

		if (sptr_ecb != NULL)
			{
			spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing internal transmit ECB %p\n", sptr_ecb);

			table_free (sptr_ecb);
			}
		else
			{
			spx_printf (SPX_ALARM_PRINTF, "SPX: Could not find ECB corresponding to packet %p\n", sptr_txed_packet);
			}
		}
	else
		{
		spx_printf (SPX_ALARM_PRINTF, "SPX: send_completion given invalid packet\n");
		}
}
/*************************************************************************/
static SPX_PACKET *get_normalized_packet (SPX_PACKET *sptr_txed_packet)
{
	SPX_PACKET *sptr_spx_tx_packet;
	BYTE *bptr_offset;
	BYTE *bptr_new_offset;
	ULONG new_offset;

	bptr_offset = (BYTE *) sptr_txed_packet;

	bptr_offset = (bptr_offset - (EXTRA_FRAME_HEADER_BYTES/4));

	new_offset = (ULONG) bptr_offset & EXTRA_FRAME_HEADER_MASK;

	bptr_new_offset = (BYTE *) new_offset;

	sptr_spx_tx_packet = (SPX_PACKET *) (bptr_new_offset + EXTRA_FRAME_HEADER_BYTES/2);

	spx_printf (SPX_MEMORY_PRINTF, "SPX: Pointer to normalized packet is %p\r\n", sptr_spx_tx_packet);

	return (sptr_spx_tx_packet);
}
/*************************************************************************/
static EVENT_CONTROL_BLOCK *find_ecb_that_corresponds_to_packet (SPX_PACKET *sptr_txed_packet)
{
	EVENT_CONTROL_BLOCK *sptr_ecb;

	sptr_ecb = (EVENT_CONTROL_BLOCK *) get_pointer_to_first_entry_in_list ((LINK *) &spx.internal_ecb_list);

	while (sptr_ecb != NULL)
		{
		if (sptr_ecb->fragment_descriptor[0].type.sptr_spx_packet == sptr_txed_packet)
			{
			break;
			}
			
		sptr_ecb = (EVENT_CONTROL_BLOCK *) get_pointer_to_next_entry_in_list ((LINK *) sptr_ecb);
		}

	if (sptr_ecb != NULL)
		{
		delete_entry_from_list ((LINK *) &spx.internal_ecb_list, (LINK *) sptr_ecb);
		}

	return (sptr_ecb);
}
/*************************************************************************/
enum SPX_RETURN_CODE spx_open_socket (USHORT *usptr_socket)
{
	SPX_SOCKET_LIST_ENTRY *sptr_socket_list_entry;
	USHORT dynamic_socket;

	if (*usptr_socket == ALLOCATE_DYNAMIC_SOCKET)
		{
		dynamic_socket = DYNAMIC_SOCKET_START;

		while (find_socket (dynamic_socket) != NULL)
			{
			dynamic_socket = swap ((USHORT) (swap (dynamic_socket) + 1));
			}
		}
	else
		{
		sptr_socket_list_entry = find_socket (*usptr_socket);

		if (sptr_socket_list_entry != NULL)
			{
			return (SPX_IPX_SOCKET_IN_USE);
			}

		dynamic_socket = *usptr_socket;
		}

	sptr_socket_list_entry = (SPX_SOCKET_LIST_ENTRY *) table_malloc (1, sizeof (SPX_SOCKET_LIST_ENTRY));

	if (sptr_socket_list_entry != NULL)
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Allocated SPX socket %p\n", sptr_socket_list_entry);

		sptr_socket_list_entry->socket = dynamic_socket;

		add_entry_to_list ((LINK *) &spx.socket_list, (LINK *) &sptr_socket_list_entry->links);

		*usptr_socket = dynamic_socket;

		++spx.number_of_open_sockets;

		return (SPX_SUCCESSFUL);
		}
	else
		{
	 	spx_printf (SPX_MEMORY_PRINTF, "SPX: table_malloc failed\n");

		return (SPX_SOCKET_TABLE_FULL);
		}
}
/*************************************************************************/
SPX_SOCKET_LIST_ENTRY *find_socket (USHORT socket)
{
	SPX_SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	for (sptr_socket_list_entry = (SPX_SOCKET_LIST_ENTRY *) spx.socket_list.sptr_forward_link; sptr_socket_list_entry != NULL;
		sptr_socket_list_entry = (SPX_SOCKET_LIST_ENTRY *) sptr_socket_list_entry->links.sptr_forward_link)
		{
		if (sptr_socket_list_entry->socket == socket)
			{
			return (sptr_socket_list_entry);
			}
		}

	return (NULL);
}
/*************************************************************************/
enum SPX_RETURN_CODE spx_close_socket (USHORT socket)
{
	SPX_SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	sptr_socket_list_entry = find_socket (socket);

	if (sptr_socket_list_entry != NULL)
		{
		if (sptr_socket_list_entry->socket != 0x0000)
			{
			delete_entry_from_list ((LINK *) &spx.socket_list, (LINK *) &sptr_socket_list_entry->links);

		 	spx_printf (SPX_MEMORY_PRINTF, "SPX: Freeing SPX socket %p\n", sptr_socket_list_entry);

			table_free (sptr_socket_list_entry);

			--spx.number_of_open_sockets;

			return (SPX_SOCKET_CLOSED);
			}
		}

	return (SPX_SOCKET_NOT_FOUND);
}
/*************************************************************************/
void call_ecb_esr (EVENT_CONTROL_BLOCK *sptr_ecb)
{
	if (sptr_ecb->fptr_event_service_routine != NULL)
		{
		(*sptr_ecb->fptr_event_service_routine) (sptr_ecb);
		}
}
/****************************************************************************/
enum SPX_RETURN_CODE spx_ecb_error_check (enum BOOLEAN error_checking_on)
{
	PARAMETER_NOT_USED (error_checking_on);

	return (SPX_SUCCESSFUL);
}
/*************************************************************************/
enum SPX_RETURN_CODE spx_check_socket (USHORT socket)
{
	SPX_SOCKET_LIST_ENTRY *sptr_socket_list_entry;

	sptr_socket_list_entry = find_socket (socket);

	if (sptr_socket_list_entry->socket != 0x0000)
		{
		return (SPX_SUCCESSFUL);
		}
	else
		{
		return (SPX_SOCKET_NOT_FOUND);
		}
}
/*************************************************************************/
void spx_printf (enum SPX_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	BYTE_ENUM (BOOLEAN) print_string;

	va_list argptr;

	va_start (argptr, cptr_format);

	if (spx.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case SPX_PRINTF:
			print_string = spx.printing_enabled;
			break;
		case SPX_MESSAGE_PRINTF:
			print_string = spx.message_printing_enabled;
			break;
		case SPX_STATE_PRINTF:
			print_string = spx.state_printing_enabled;
			break;
		case SPX_SNMP_PRINTF:
			print_string = spx.snmp_printing_enabled;
			break;
		case SPX_ALARM_PRINTF:
			print_string = spx.alarm_printing_enabled;
			break;
		case SPX_MEMORY_PRINTF:
			print_string = spx.memory_printing_enabled;
			break;
		case SPX_DATA_PRINTF:
			print_string = spx.data_printing_enabled;
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format,argptr);
		}

	va_end (argptr);
}
