/*	$Modname: vspxstat.h$  $version: 1.9$      $date: 08/02/95$   */
/*
* 	$lgb$
1.0 07/14/94 ross latest state machine.
1.1 07/14/94 ross next rev.
1.2 07/14/94 ross trying to merge.
1.3 07/19/94 ross
1.4 07/21/94 ross
1.5 07/21/94 ross
1.6 07/23/94 ross watchdog across router timed correctly.
1.7 08/08/94 ross Initial release
1.8 08/08/94 ross Added copyright
1.9 08/02/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/* SPX state machine 
													0				1				2			 3				4		  
Events								  | Disconnected	Listening   Req-Sent Discncting Connected  
--------------------------------+-----------------------------------------------------------
SPX_START_CONNECTION		   	  | 	tx_req/2	  	   -    		 -		 	  	-		    - 	  	  
SPX_LISTEN_FOR_CONNECTION	     |		1			   -         -          -         -
SPX_CONNECTION_REQUEST_RXED	  |		-			tx_ack/4     -     	   -         -         
SPX_CONNECTION_ACK_RXED 		  |		-				-			 4   		   -			 -			  
SPX_WAITING_FOR_ACK_FROM_TARGET |		-				-		  tx_req/2  	-		 	 -	  		  
SPX_NO_ANSWER_FROM_TARGET		  |		-				-		    0	         -			 -			  
SPX_DISCONNECT_RXED		        |		-		 tx_d_ack/0 tx_d_ack/0 tx_d_ack/0  tx_d_ack/0
SPX_DISCONNECT_ACK_RXED 		  |		-				-			 -		   	0		    -			  
SPX_STOP_CONNECTION		   	  | 		-           0         0       tx_disc/3  tx_disc/3          
SPX_WAITING_FOR_DACK_FROM_TARGET|		-				-		  	 -		  	tx_disc/3	 -			  
SPX_NO_ANSWER_FOR_DISC_FRM_TARGT|		-				-		  	 -		  		0	       -			  
SPX_TX_DATA                     |      -           -         -          -        tx_data/4
SPX_TX_DATA_ACK_RXED				  |      -           -         -          -        txa_rx/4
SPX_TX_DATA_NO_ACK              |      -           -         -          -        retx_data/4
SPX_TX_DATA_NO_ACK_TIMEOUT      |      -           -         -          -        abort_sess/0
SPX_RX_DATA                     |      -           -         -          -        rx_data/4 
SPX_RX_WATCHDOG            	  |      -           -         -          -        wtch_rxed/4
SPX_RX_WATCHDOG_RETRY      	  |      -           -         -          -        wtch_rxed/4
SPX_TX_WATCHDOG                 |      -           -         -          -        tx_wdog/4
SPX_TX_WATCHDOG_RETRY_TIMER     |      -           -         -          -        tx_wdog_retry/4
SPX_TX_WATCHDOG_TIMEOUT         |      -           -         -          -        abort_sess/0

waiting		1
starting		2
established	4
terminating 3

*/

void set_spx_state (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state);
void spx_null_state (SPX_SESSION_CLASS *sptr_session,EVENT_CONTROL_BLOCK *sptr_ecb,enum SPX_CONNECTION_STATE end_state);

typedef void (*STATE_FUNCTION) (struct SPX_SESSION_CLASS *sptr_session,struct EVENT_CONTROL_BLOCK *sptr_ecb,
		enum SPX_CONNECTION_STATE end_state);

SPX_STATE_MACHINE_TABLE	spx_state_machine_table[NUMBER_OF_SPX_STATES][NUMBER_OF_SPX_EVENTS] = 
{
/* ------------------------------------------------------------------------ */
/*										     SPX_DISCONNECTED 0                  		 */		 
/* ------------------------------------------------------------------------ */
{
/* START_CONNECTION		   	  */	   {(STATE_FUNCTION) spx_transmit_connection_request,SPX_CONNECT_REQUEST_SENT},
/* SPX_LISTEN_FOR_CONNECTION	  */	 	{set_spx_state,SPX_LISTENING},
/* CONNECTION_REQUEST_RXED	     */	 	{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* WAITING_FOR_ACK_FROM_TARGET  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FROM_TARGET		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* DISCONNECT_RXED		        */		{spx_null_state,ILLEGAL_SPX_STATE},
/* DISCONNECT_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* STOP_CONNECTION		   	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* WAITING_FOR_DACK_FROM_TARGET */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FOR_DISC_FRM_TARGT */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_ACK_RXED			  	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_NO_ACK			  	     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_NO_ACK_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG				  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG_RETRY		  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG     			  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_RETRY_TIMER  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  SPX_LISTENING 1									 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* START_CONNECTION		   	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_LISTEN_FOR_CONNECTION 	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_REQUEST_RXED	     */		{(STATE_FUNCTION) spx_transmit_connection_ack,SPX_CONNECTED},
/* CONNECTION_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* WAITING_FOR_ACK_FROM_TARGET  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FROM_TARGET		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* DISCONNECT_RXED		        */		{(STATE_FUNCTION) spx_transmit_disconnect_ack,SPX_DISCONNECTED,
													spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* DISCONNECT_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* STOP_CONNECTION		   	  */		{set_spx_state,SPX_DISCONNECTED,
													spx_delete_session,NO_CHANGE_TO_SPX_STATE},
/* WAITING_FOR_DACK_FROM_TARGET */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FOR_DISC_FRM_TARGT */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_ACK_RXED			  	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG				  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG_RETRY		  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG     			  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_RETRY_TIMER  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  SPX_CONNECT_REQUEST_SENT 2					 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* START_CONNECTION		   	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_LISTEN_FOR_CONNECTION 	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_REQUEST_RXED	     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_ACK_RXED 		     */		{(STATE_FUNCTION) spx_transmit_connection_established,SPX_CONNECTED},
/* WAITING_FOR_ACK_FROM_TARGET  */		{(STATE_FUNCTION) spx_transmit_connection_request,SPX_CONNECT_REQUEST_SENT},
/* NO_ANSWER_FROM_TARGET		  */		{set_spx_state,SPX_DISCONNECTED,
													spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* DISCONNECT_RXED		        */		{(STATE_FUNCTION) spx_transmit_disconnect_ack,SPX_DISCONNECTED,
													spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* DISCONNECT_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* STOP_CONNECTION		   	  */		{(STATE_FUNCTION) spx_internal_transmit_disconnect,SPX_DISCONNECTING},
/* WAITING_FOR_DACK_FROM_TARGET */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FOR_DISC_FRM_TARGT */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_ACK_RXED			  	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_NO_ACK			  	     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_NO_ACK_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG				  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG_RETRY		  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG     			  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_RETRY_TIMER  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  SPX_DISCONNECTING 3							 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* START_CONNECTION		   	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_LISTEN_FOR_CONNECTION 	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_REQUEST_RXED	     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* WAITING_FOR_ACK_FROM_TARGET  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FROM_TARGET		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* DISCONNECT_RXED		        */		{(STATE_FUNCTION) spx_transmit_disconnect_ack,SPX_DISCONNECTED,
													spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* DISCONNECT_ACK_RXED 		     */		{set_spx_state,SPX_DISCONNECTED,
													spx_delete_session,NO_CHANGE_TO_SPX_STATE},
/* STOP_CONNECTION		   	  */		{(STATE_FUNCTION) spx_internal_transmit_disconnect,SPX_DISCONNECTING},
/* WAITING_FOR_DACK_FROM_TARGET */		{(STATE_FUNCTION) spx_internal_transmit_disconnect,SPX_DISCONNECTING},
/* NO_ANSWER_FOR_DISC_FRM_TARGT */		{set_spx_state,SPX_DISCONNECTED,
													spx_delete_session,NO_CHANGE_TO_SPX_STATE},
/* TX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA_ACK_RXED			  	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_DATA							  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG				  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* RX_WATCHDOG_RETRY		  		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG     			  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_RETRY_TIMER  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_TX_WATCHDOG_TIMEOUT		  */		{spx_null_state,ILLEGAL_SPX_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  SPX_CONNECTED 4								    */			 
/* ------------------------------------------------------------------------ */
{																												 
/* START_CONNECTION		   	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* SPX_LISTEN_FOR_CONNECTION 	  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_REQUEST_RXED	     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* CONNECTION_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* WAITING_FOR_ACK_FROM_TARGET  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FROM_TARGET		  */		{spx_null_state,ILLEGAL_SPX_STATE},
/* DISCONNECT_RXED		        */		{(STATE_FUNCTION) spx_transmit_disconnect_ack,SPX_DISCONNECTED,
													spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* DISCONNECT_ACK_RXED 		     */		{spx_null_state,ILLEGAL_SPX_STATE},
/* STOP_CONNECTION		   	  */		{(STATE_FUNCTION) spx_transmit_disconnect,SPX_DISCONNECTING},
/* WAITING_FOR_DACK_FROM_TARGET */		{spx_null_state,ILLEGAL_SPX_STATE},
/* NO_ANSWER_FOR_DISC_FRM_TARGT */		{spx_null_state,ILLEGAL_SPX_STATE},
/* TX_DATA							  */		{(STATE_FUNCTION) send_spx_packet,NO_CHANGE_TO_SPX_STATE},
/* TX_DATA_ACK_RXED			  	  */		{(STATE_FUNCTION) spx_data_ack_received,NO_CHANGE_TO_SPX_STATE},
/* TX_DATA_NO_ACK			  	     */		{(STATE_FUNCTION) spx_resend_data_packet,NO_CHANGE_TO_SPX_STATE},
/* TX_DATA_NO_ACK_TIMEOUT		  */		{(STATE_FUNCTION) spx_abort_session,NO_CHANGE_TO_SPX_STATE},
/* Allow Data and watchdos to be data acks too... */
/* RX_DATA							*/			{(STATE_FUNCTION) spx_data_ack_received, NO_CHANGE_TO_SPX_STATE,
													(STATE_FUNCTION) spx_pass_rx_packet_to_upper_layer,NO_CHANGE_TO_SPX_STATE},
/* RX_WATCHDOG						*/			{(STATE_FUNCTION) spx_data_ack_received, NO_CHANGE_TO_SPX_STATE,
													spx_watchdog_packet_received,NO_CHANGE_TO_SPX_STATE},
/* RX_WATCHDOG_RETRY			*/				{(STATE_FUNCTION) spx_data_ack_received, NO_CHANGE_TO_SPX_STATE,
													spx_watchdog_retry_packet_received,NO_CHANGE_TO_SPX_STATE},
/* SPX_TX_WATCHDOG     			  */		{(STATE_FUNCTION) spx_transmit_watchdog_packet,NO_CHANGE_TO_SPX_STATE},
/* SPX_TX_WATCHDOG_RETRY_TIMER  */		{(STATE_FUNCTION) spx_transmit_watchdog_retry_packet,NO_CHANGE_TO_SPX_STATE},
/* SPX_TX_WATCHDOG_TIMEOUT		  */		{(STATE_FUNCTION) spx_abort_session,NO_CHANGE_TO_SPX_STATE}
}
};
