/*
** ISN.C -- Code related to generating a initial sequence number for sends
**				on connections
*/

#include "rtrstd.h"
#include "all.h"
#include "tcpextrn.h"

#define ISN_INCR			904		/* from Comer & Stevens, Vol. 2 */


TCPSEQ 
get_current_isn_to_use()
{
	static TCPSEQ isn = 0;					/* At startup time ISN is 0 */

	if (isn == 0)
		isn = tcp.isn_clk_time;
	isn += ISN_INCR;

#if defined(DEBUG)
	tcp_printf(TCP_DEBUG_PRINTF, "TCP: ISN for connection %d\n", isn);
#endif /* DEBUG */
	return isn;
}
