/*
** TCPGLOB.H -- Globals related to TCP handling
*/

#ifndef _TCPGLOB_H_
#define _TCPGLOB_H_

#include <stddef.h>

TCP_CLASS tcp;

/* The state function switch table */
void (*tcp_switch[NUM_TCP_STATES])(TCP_PER_CONN *, TCP_HEADER *) =
	{
		tcp_free,				/* This is a dummy function */
		tcp_closed, 
		tcp_listen, 
		tcp_syn_rcvd, 
		tcp_syn_sent, 
		tcp_estab,
		tcp_fin_wait_1, 
		tcp_fin_wait_2, 
		tcp_closing, 
		tcp_time_wait, 
		tcp_close_wait,
		tcp_last_ack
	};

#if 0
/* ?? SNMP definition until later. The structure format for SNMP_TABLE_ENTRY
** ?? seems to be different.
*/
#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far tcp_snmp_table[] = 
#else
	SNMP_TABLE_ENTRY tcp_snmp_table[] = 
#endif
{
	{
		"tcpRtoAlgorithm", sizeof(INTEGER),snmp_get_or_set_ulong,
		(ULONG) offsetof(
						TCP_MIB, 
						tcpRtoAlgorithm), 
		(ULONG) &tcp.mib, 
		FALSE, TRUE
	},
	{
		"tcpRtoMin", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpRtoMin), (ULONG) &tcp.mib, 
		FALSE, TRUE
	},
	{
		"tcpRtoMax", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpRtoMax), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpMaxConn", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpMaxConn), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpActiveOpens", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpActiveOpens), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpPassiveOpens", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpPassiveOpens), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpAttemptFails", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpAttemptFails), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpEstabResets", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpEstabResets), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpCurrEstab", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpCurrEstab), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpInSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpInSegs), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpOutSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpOutSegs), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpRetransSegs", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpRetransSegs), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpInErrs", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpInErrs), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
	{
		"tcpOutRsts", sizeof(INTEGER), snmp_get_or_set_ulong,
		(ULONG) offsetof(TCP_MIB, tcpOutRsts), (ULONG) &tcp.mib,
		FALSE, TRUE
	},
  	{
		"",0x0000,NULL,(ULONG) NULL,(ULONG) NULL,(ULONG) NULL
	}
};

#endif /* 0 */
#endif /* _TCPGLOB_H_ */
