/*
** VNVTCP.H -- Configuration settings structure for TCP
*/


#ifndef _VNVTCP_
#define _VNVTCP_

#include <vnvrmstr.h>


CONFIGURATION_TABLE tcp_configuration_table = 
{
	{TRUE},
	{
   /*--------------------------------------------------------------------- */
	/* TCP configuration parameters */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP =",
		(ULONG) offsetof(TCP_CLASS, enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
		"TCP Maximum Number Of Connections =",
		(ULONG) offsetof(TCP_CLASS, max_tcp_connection),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Maximum Segment Lifetime =",
		(ULONG) offsetof(TCP_CLASS, two_msl),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_byte_decimal_value,
		NULL,
		"TCP Maximum Retransmit Retries =",
		(ULONG) offsetof(TCP_CLASS, max_transmit_retries),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Maximum Retransmit Timeout =",
		(ULONG) offsetof(TCP_CLASS, max_rtx_timeout),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Minimum Retransmit Timeout =",
		(ULONG) offsetof(TCP_CLASS, min_rtx_timeout),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL, 
		"TCP Connection Idle Timeout =",
		(ULONG) offsetof(TCP_CLASS, conn_idle_time),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP ACK Delay Period =",
		(ULONG) offsetof(TCP_CLASS, max_ack_delay),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Maximum Segment Size =",
		(ULONG) offsetof(TCP_CLASS, max_seg_size),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Send Window Size =",
		(ULONG) offsetof(TCP_CLASS, send_win_size),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"TCP Receive Window Size =",
		(ULONG) offsetof(TCP_CLASS, recv_win_size),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP Printf =",
		(ULONG) offsetof(TCP_CLASS, print_class.tcp_print_switch_on),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP Printf TCP =",
		(ULONG) offsetof(TCP_CLASS, print_class.tcp_printing_enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP Alarm Printf =",
		(ULONG) offsetof(TCP_CLASS, print_class.alarm_printing_enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP Data Printf =",
		(ULONG) offsetof(TCP_CLASS, print_class.data_printing_enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP Diagnostic Printf =",
		(ULONG) offsetof(TCP_CLASS, print_class.debug_printing_enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"TCP States Printf =",
		(ULONG) offsetof(TCP_CLASS, print_class.state_printing_enabled),
		(ULONG) &tcp,
		(ULONG) NULL
	}

	/* End TCP configuration parameters */
   /*--------------------------------------------------------------------- */
	}
};

#endif


