/*.BM*******************************************************************
	Copyright (C) 1990 Intermetrics, Inc.
AUTHOR		:   Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/atoi.c
SCCS ID		:   1.2
LAST DELTA	:   8/29/91  16:10:26
DATE OF GET	:   9/21/92  16:12:54
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.atoi.c
@(#)m/rt/c/ansi/atoi.c	1.2
************************************************************************
.EM*/

#include <ctype.h>

    int
atoi(const char *nptr)
{
    char sign = '+';
    int result = 0;

    /* skip leading white space */
    while (isspace(*nptr)) nptr++;

    /* get the optional sign */
    if ((*nptr == '+') ||  (*nptr == '-')) {
	sign = *nptr++;
    }

    while ((*nptr >= '0') && (*nptr <= '9')) {
	    /* result = result*10 + *nptr++ - '0'; */
	result = (result << 3) + result + result + *nptr++ - '0' ;
    }

    if (sign == '-') result = -result;
    return (result);

} /* atoi */
