/*.BM*******************************************************************
	Copyright (C) 1982 Intermetrics, Inc.
AUTHOR		:   Randy Hudson, modified by David Sotkowitz, Julian Horn,
		    and Tom Sprott
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/itob.c
SCCS ID		:   1.4
LAST DELTA	:   1/6/92  10:52:58
DATE OF GET	:   9/21/92  16:13:13
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.itob.c
@(#)m/rt/c/ansi/itob.c	1.4

    MODULES DEFINED:
	__itob    -- Convert a INT16 integer to a byte string
	__ltob    -- Convert a INT32 integer to a byte string
    RELATION :
	Internal routines used by printf to convert integers to ASCII.
************************************************************************
.EM*/

#include "rt.h"

/* maximum buffer size: 47-bit 77240 long integer rep'd in octal */
#define MAXBUF 16
static char outbuf[MAXBUF];

    INT16
__itob(char *s, INT16 i, INT16 base, char *digits)
/*.SP*********************************************************************
	FUNCTION __itob
	REQUIRES
	    Base must be a non-zero number between -16 and +16.
	    The buffer pointed to by s must be big enough to hold the result.
	    The digits variable must point to "0123456789abcdef" or
	    "0123467890ABCDEF", according as hex printing is to use
	    upper or lower case.
	EFFECTS
	    Converts the integer i to characters in the given
	    arithmetic base.  If base is negative, then i is to be
	    considered signed; otherwise i is to be considered unsigned.
	    The result is put in the buffer supplied by the "s" parameter.
	    Hex printing is in upper or lower case, depending on digits.
	    The characters are put into the buffer from left to right.
	    For example, after __itob(b,12,10), b[0] = '1', b[1] = '2'.
	RETURNS
	    The number of characters put in the buffer.
	METHODS
	    Recursive descent.  The hexadecimal base is expedited.
**************************************************************************
.EP*/
{
    UINT16 ui;
    char *p = &outbuf[0];
    char *q;
    char *s0;

    /* append a '-' if negative */
    s0 = s;
    if (base < 0) {
	base = -base;
	if (i < 0) {
	    *s++ = '-';
	    i = -i;
	}
    }

    /* load chars into outbuf (backwards -- least significant first) */
    ui = (UINT16) i;
    while (ui >= base) {
	if (base == 16) {
	    *p++ = digits[(INT16)(ui & 0xf)];
	    ui >>= 4;
	} else {
	    *p++ = digits[(INT16)(ui % base)];
	    ui /= base;
	}
    }
    *p = digits[(INT16)ui];

    /* reverse the chars */
    q = p;
    while (q >= outbuf) {
	*s++ = *q--;
    }

    /* return the buffer length */
    return (s - s0);

} /* __itob */


    INT16
__ltob(char *s,
#ifdef NOLONGS
    INT16 i,
#else
    INT32 i,
#endif
    INT16 base,
    char *digits)
/*.SP*********************************************************************
	FUNCTION __ltob
	REQUIRES
	    Base must be a non-zero number between -16 and +16.
	    The buffer pointed to by s must be big enough to hold the result.
	    The digits variable must point to "0123456789abcdef" or
	    "0123467890ABCDEF", according as hex printing is to use
	    upper or lower case.
	EFFECTS
	    Converts the long integer i to characters in the given
	    arithmetic base.  If base is negative, then i is to be
	    considered signed; otherwise i is to be considered unsigned.
	    The result is put in the buffer supplied by the "s" parameter.
	    Hex printing is in upper or lower case, depending on digits.
	    The characters are put into the buffer from left to right.
	    For example, after _itob(b,12,10), b[0] = '1', b[1] = '2'.
	RETURNS
	    The number of characters put in the buffer.
	METHODS
	    Recursive descent.  The hexadecimal base is expedited.
**************************************************************************
.EP*/
{
    char *p = &outbuf[0];
    char *q;
    char *s0;
#ifdef NOLONGS
    UINT16 ui;
#else
    UINT32 ui;
#endif

    /* append a '-' if negative */
    s0 = s;
    if (base < 0) {
	base = -base;
	if (i < 0) {
	    *s++ = '-';
	    i = -i;
	}
    }

    /* load chars into outbuf (backwards -- least significant first) */
#ifdef NOLONGS
    ui = (UINT16) i;
#else
    ui = (UINT32) i;
#endif
    while (ui >= base) {
	if (base == 16) {
	    *p++ = digits[(INT16)(ui & 0xf)];
	    ui >>= 4;
	} else {
	    *p++ = digits[(INT16)(ui % base)];
	    ui /= base;
	}
    }
    *p = digits[(INT16)ui];

    /* reverse the chars */
    q = p;
    while (q >= outbuf) {
	*s++ = *q--;
    }

    /* return the buffer length */
    return (s - s0);

} /* __ltob */
