#include <defs.h>
#include "stdlib.h"


char *TheHeap ;
int MAINSIZE;

extern void *	memset(void *, int, size_t);
extern unsigned long mem_avail ;


#if STATUS_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
extern int number_of_blocks_held_by_malloc ;
extern int total_size_alloced;

void memory_debugger (void)
{
   printf ("\nMemory Information.......\n\
      \tInitial Available Memory   : %08X (%d K)\n\
      \tCurrent Memory             : %08X (%d K)\n\
      \tNumber of allocated blocks : %d\n\n",
      MAINSIZE, MAINSIZE / 1024L,
      total_size_alloced, total_size_alloced / 1024,
      number_of_blocks_held_by_malloc) ;
}

#endif

#if MEM_DEBUG
extern	int mem_debug_on;
extern	void	clean_alloc_ptrs(void);
extern	void	print_allocation_table(void);
void	memory_debugger_switch()
{
	if (mem_debug_on)
	{
		printf("\nMemory log on. Turning off\n");
		mem_debug_on = 0;
	}
	else
	{
		printf("\nMemory log off. Turning on. Cleaning table\n");
		clean_alloc_ptrs();
		mem_debug_on = 1;
	}
}
#endif



StdLibInit(int TotalRamSize,void *HeapStart)
{
/*	memset(HeapStart,0,TotalRamSize);	*/
	MAINSIZE = TotalRamSize - (2*1024);   /* 2 k left for SMC buffer */
   mem_avail = MAINSIZE ;
	TheHeap = (char *) HeapStart;
#if STATUS_DEBUG
	register_debugger (memory_debugger, "mem debug") ;
#if MEM_DEBUG
	register_debugger (memory_debugger_switch, "mem dbg") ;
	register_debugger (print_allocation_table, "alloc table");
#endif /* MEM_DEBUG */
#endif
}
