/*.BM*********************************************************************
	Copyright (C) 1989 Intermetrics, Inc.
AUTHOR		:   Mark Hertel
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/stdarg.h
SCCS ID		:   1.8
LAST DELTA	:   9/28/90  13:51:43
DATE OF GET	:   9/21/92  16:13:31
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.stdarg.h
@(#)m/rt/c/ansi/stdarg.h	1.8
**************************************************************************
.EM*/

#ifndef __STDARG_INCLUDED
#define __STDARG_INCLUDED

#ifndef __VA_LIST
#define __VA_LIST
typedef char * va_list; /* pointer to an object of size 1 */
#endif

/*  The include of rtenv.h brings in the appropriate #define    */
/*  for STACK_UP, which determines which way the stack grows.   */
/*  Note that arguments smaller than an int are widened to int. */
/*  For this reason you MUST NOT use types like char in va_arg. */

#include "rtenv.h"

#define va_end(ap)
#ifdef STACK_UP
#define va_start(ap,parmN)	ap=(va_list)(&__va_start+1)
#define va_arg(ap,type)		(((type *)(ap -= sizeof(type)))[0])
#else
#define va_start(ap,parmN)	ap=(va_list)(&__va_start)
#define va_arg(ap,type)		(((type *)(ap += sizeof(type)))[-1])
#endif

#endif
