/*.BM*******************************************************************
	Copyright (C) 1990 Intermetrics, Inc.
AUTHOR		:   Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/68000/dm/stdio.h
SCCS ID		:   1.22
LAST DELTA	:   5/2/91  18:14:21
DATE OF GET	:   9/29/93  09:54:26
UNIX FILE	:   /usr2/millen/m/rt/c/68000/dm/s.stdio.h
@(#)m/rt/c/68000/dm/stdio.h	1.22

	This file defines C input/output macros and functions.

	In a typical embedded application there is no file system
	or disk-oriented I/O.  Therefore several of the functions
	named here, e.g., fopen and lseek, are implemented as stubs.

************************************************************************
.EM*/

#ifndef __STDIO_INCLUDED
#define __STDIO_INCLUDED

/* Standard C Types */

#ifndef __SIZE_T
#define __SIZE_T
typedef unsigned long size_t;
#endif

#ifndef __FILE_H
#define __FILE_H
typedef int FILE;
#endif

typedef long fpos_t;

/* Standard C Macros */

#ifndef NULL
#define NULL ((void *)0)
#endif

#define _IOFBF	0
#define _IOLBF	1
#define _IONBF	2
#define BUFSIZ	256
#define EOF	(-1)
#define FOPEN_MAX 8
#define FILENAME_MAX 25
#define L_tmpnam 25
#define SEEK_CUR 0
#define SEEK_END 1
#define SEEK_SET 2
#define TMP_MAX	25
extern FILE *	stdin;
extern FILE *	stdout;
extern FILE *	stderr;

/* Operations of files */

extern int	remove(const char *);
extern int	rename(const char *, const char *);
extern FILE *	tmpfile(void);
extern char *	tmpnam(char *);

/* File access functions */

extern int	fclose(FILE *);
extern int	fflush(FILE *);
extern FILE *	fopen(const char *, const char *);
extern FILE *	freopen(const char *, const char *, FILE *);
extern void	setbuf(FILE *, char *);
extern int	setvbuf(FILE *, char *, int, size_t);

/* Formatted input/output functions */

extern int	fprintf(FILE *, const char *, ...);
extern int	fscanf(FILE *, const char *, ...);
extern int	printf(const char *, ...);
extern int	scanf(const char *, ...);
extern int	sprintf(char *, const char *, ...);
extern int	sscanf(const char *, const char *, ...);
    /* The last argument to vfprintf, vprintf, and vsprintf is */
    /* really type va_list, but va_list is the same as char *. */
extern int	vfprintf(FILE *, const char *, char *);
extern int	vprintf(const char *, char *);
extern int	vsprintf(char *, const char *, char *);

/* Character input/output functions */

extern int	fgetc(FILE *);
extern char *	fgets(char *, int, FILE *);
extern int	fputc(int, FILE *);
extern int	fputs(const char *, FILE *);
extern int	getc(FILE *);
extern int	getchar(void);
extern char *	gets(char *);
extern int	putc(int, FILE *);
extern int	putchar(int);
extern int	puts(const char *);
extern int	ungetc(int, FILE *);

#define	fgetc	getc
#define	fputc	putc
#define getchar()	getc(stdin)
#define putchar(c)	putc(c, stdout)

/* Direct input/output functions */

extern size_t	fread(void *, size_t, size_t, FILE *);
extern size_t	fwrite(const void *, size_t, size_t, FILE *);

/* File positioning functions */

extern int	fgetpos(FILE *, fpos_t *);
extern int	fseek(FILE *, long int, int);
extern int	fsetpos(FILE *, const fpos_t *);
extern long	ftell(FILE *);
extern void	rewind(FILE *);

/* Error-handling functions */

extern void	clearerr(FILE *);
extern int	feof(FILE *);
extern int	ferror(FILE *);
extern void	perror(const char *);

/* In earlier versions of the Intertools compiler, */
/* many more identifiers were present in stdio.h.  */
/* For backwards compatibility they can be put     */
/* back as they were by defining _OLDIDS.          */

#ifdef OLDIDS
#include "backward.h"
#endif

/* Non-ANSI extensions */

#ifdef _EXTENSIONS
#include "extended.h"
#endif

/* this endif matches the ifndef __STDIO_INCLUDED at the start of this file */
#endif
