/*.BM*********************************************************************
	Copyright (C) 1983 Intermetrics, Inc.
AUTHOR		:   Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/strtok.c
SCCS ID		:   1.1
LAST DELTA	:   9/24/90  14:31:42
DATE OF GET	:   9/21/92  16:13:41
UNIX FILE	:   /usr2/millen/m/rt/c/ansi/s.strtok.c
@(#)m/rt/c/ansi/strtok.c	1.1

    FUNCTIONS DEFINED:
	char * strtok(s1,s2) - tokenize string

    RELATION:
	The strtok function analyzes the string s1 as a sequence of text tokens
	separated by spans of one or more separator characters (given by s2).

	The "first" call, i.e., one with pointer s1 specified, returns a
	pointer to the first character of the first token, and will have
	written a null character into the string starting at s1 immediately
	following the returned token.

	The function keeps track of its position in the string between
	separate calls, so that subsequent calls (which must be made with
	the first argument a NULL pointer) will continue immediately
	following the token last returned.  In this way subsequent calls
	will work through the string s1 until no tokens remain.

	The separator string s2 may be different from call to call.
	When no token remains in s1, a NULL pointer is returned.

**************************************************************************
.EM*/

#include "stdio.h"

char *tmp_save_str = (char *) 0;
static char *save_str = (char *) 0;
    char *
strtok(register char *s1, register const char *s2)
{
    register char c;
    register const char *p;
    register char *result;

    if (!s1) s1 = save_str; /* revert to saved position */
    if (!s1) return (NULL); /* out of data or null input */

	/* pass over leading separator characters */
    while (c = *s1) {
	p = s2;
	while (*p && (c != *p)) p++; /* is c a separator? */
	if (!*p) break; /* no, quit the loop */
	s1++; /* yes, bump s1 */
    }

    if (!c) { /* are there any text characters? */
	save_str = NULL;
	tmp_save_str = NULL;
	return (NULL);
    }

    result = (char *)s1; /* s1 now points at the start of the token */

	/* find the end of the token, i.e., the next separator */
    while (c = *s1) {
	p = s2;
	while (*p && (c != *p)) p++; /* is c a separator? */
	if (*p) break; /* yes, quit the loop */
	s1++; /* no, bump s1 */
    }

    if (c) { /* characters remain at end of token */
	*s1++ = '\0'; /* step on the next separator */
	save_str = s1; /* remember where we left off */
	tmp_save_str = s1; /* remember where we left off */
    } else {
	save_str = NULL;
	tmp_save_str = NULL;
    }

    return (result);
} /* strtok */
