/*.BM*******************************************************************
	Copyright (C) 1982 Intermetrics, Inc.
AUTHOR		:   Don Y. Sakahara, Randy Hudson, David Sotkowitz, Leo Lanzillo
		:   modified for ANSI C by Mark Hertel and Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/xprintf.c
SCCS ID		:   1.32
LAST DELTA	:   3/11/94  16:54:18
DATE OF GET	:   3/11/94  17:05:49
UNIX FILE	:   s.xprintf.c
@(#)m/rt/c/ansi/xprintf.c	1.32

    MODULES DEFINED: _printf
    RELATION :
	Routines that perform low-level I/O for the C library
    EXTERNAL PROCEDURES:
        modf, __itob, __ltob, __btoi

************************************************************************
.EM*/

#include "stdio.h"
#include "rt.h"
#include "stdarg.h"
#include "fpio.h"

#include	"\rtrware\devdrvrs\uim\print.h"

/* Added by Ravi on 02 Nov 1999 ... */
extern char *get_time_in_dhms(char *);
extern enum BOOLEAN FIREWALL_IS_UP;
/* ... Added by Ravi on 02 Nov 1999 */


#ifdef M96002
#define NO_DBL_UNION
#endif
#ifdef NEC77240
#define NO_DBL_UNION
#endif
#ifdef _TARG_RSP
#define NO_DBL_UNION
#endif

#ifdef FP_IO
#include "byteord.h"
#include "fpdef.h"
#ifdef NO_DBL_UNION
#     include "math.h"
#endif
#endif

#ifdef FP_IO
#ifndef NO_DBL_UNION
extern REAL64 modf();
#endif
#endif


extern INT16 __btoi();
extern INT16
__itob(char *s, INT16 i, INT16 base, char *digits);
extern INT16
__ltob(char *s,
#ifdef NOLONGS
    INT16 i,
#else
    INT32 i,
#endif
    INT16 base,
    char *digits);

/****************************************************************/
/*								*/
/*	x_printf.c -- Basic code for the Intermetrics printf,	*/
/* fprintf, and sprintf C routines.  (Basic entry point into	*/
/* this code is _printf).					*/
/*								*/
/*	Created on 01-MAR-82 by DySak.				*/
/*  Modified by Randy Hudson and D. Sotkowitz for CPort, InterC */
/*								*/
/*								*/
/*	The format of the format string as expected by this	*/
/* routine is that described in the ANSI C standard.		*/
/*								*/
/* ! ! ! ! ! ! ! ! ! ! !   B E W A R E   ! ! ! ! ! ! ! ! ! ! !  */
/*								*/
/*	When porting this routine, be mindful of the fact that	*/
/* type casts are used.  Any type casts should be studied	*/
/* closely in light of implementation dependencies of the	*/
/* target machine.						*/
/*								*/
/* ! ! ! ! ! ! ! ! ! ! !   B E W A R E   ! ! ! ! ! ! ! ! ! ! !  */
/*								*/
/****************************************************************/


	/*----------------------------------------------*/
	/*	 G L O B A L   C O N S T A N T S	*/
	/*----------------------------------------------*/

#define FDPRECV 6	/* Floating point Default */
			/* PRECision Value.	  */
#define LEFTOFE 1	/* Number of decimal digits to the left */
			/* of an e format output.		*/
#define LEFTOFF 308	/* Number of decimal digits to the left */
			/* of an f format output.  (This is	*/
			/* presumably a reasonable maximum.	*/


	/*----------------------------------------------*/
	/*	     G L O B A L   T Y P E S		*/
	/*----------------------------------------------*/

struct fmtprm {
    INT16  fldwidth, precision;
    BOOL leftadj, longint, shortint, altformat, printsign, printprefix;
    char padchar;
};

#ifdef FP_IO

#ifdef NO_DBL_UNION
typedef double * FP64PTR;
#else

/*  this union is used so that we can access the fp number by bytes,
 *  words, or as a number
*/

typedef union {
    REAL64	fp64num;
    UINT16	fp64word[4];
    UINT8	fp64byte[8];
} FP64, * FP64PTR;

#endif
#endif

/* Maximum number of digits on a converted float string */
/* Note that this must be big enough to hold all the    */
/* trailing zeros implied by the exponent, e.g., e+308  */
/* plus the maximum number of significant digits (16).  */
#define	NDIG	326

/* forwards references to static routines */
/* we put them second so the code segment */
/* (named after first procedure) will     */
/* have a nicer-looking name.             */

static VOID cppad();
static INT16 dfbic();
static INT16 fcdfv();
static int wrpad();
static int xwrite();
#ifdef FP_IO
static char* cvt();
static INT16 dtoa();
static INT16 dtoe();
static INT16 dtof();
#endif


    int
_printf(bufmode, outbuf, fmt, args)
    BOOL bufmode;		/* TRUE => called from sprintf */
    char *outbuf;		/* if bufmode == TRUE, this is correct */
				/* otherwise, outbuf is interpreted as */
				/* the file pointer to the channel     */
				/* to be written to.     */
    char *fmt;			/* The format string to be used. */
    va_list  args;		/* Pointer to format arguments. */
/*.SP*********************************************************************
	PROCEDURE  _printf
	RETURNS
	    The number of characters transmitted.
	REQUIRES
	    EXTERNAL PROCEDURES:
		dtoe() dtof() dfbic() cppad() xwrite() fcdfv() putc()
	EFFECTS
	    _printf -- Do File or String Print Format
	    This routine is the main code for the printf, sprintf,
	    and fprintf routines (Intermetrics version).
**************************************************************************
.EP*/
{
    INT16  fmtlen;		/* Holds length of individual */
				/* format specification.      */
    struct fmtprm fmtbuf;	/* Format control structure */
    char cchar;			/* current conversion control character. */
    INT16  len1;		/* holds length of conversion result. */
    INT16  chars_out;		/* Number of characters transmitted. */

	/* Added by Ravi on 02 Nov 1999 ... */
    char time_string[20];
	 int index;
	/* ... Added by Ravi on 02 Nov 1999 */


#define BUFFER_SIZE	334

#ifdef MHC11
static char buf1[BUFFER_SIZE];	/* work area to hold an   */
#else				/* individual conversion. */
       char buf1[BUFFER_SIZE];
#endif

    char *bufptr;		/* Points to the character buffer to    */
				/* be copied or output.		        */
    BOOL badcvt;		/* TRUE => bad format convert character */
				/* specified.				*/
    INT16 padcnt;		/* Holds number of Pad characters to be */
				/* generated.				*/
    INT16 precpad;		/* Holds number of left 0 characters    */
				/* to be generated for int precision.	*/
    INT16 templen;		/* Scratch variable.			*/
#ifdef FP_IO
    REAL64 temp_double;		/* Scratch variable.			*/
#endif

   chars_out = 0;

	if (!bufmode)				/* 10/11/95 Sowmya : Dont need a Print Descriptor for sprintf */
	{
		if (get_a_print_descriptor() == FALSE)
			return(EOF);

/* Added by Ravi on 01 Nov 1999 ... */
		if (FIREWALL_IS_UP)
		{
			get_time_in_dhms(&time_string[0]); 

			for(index = 0; index < strlen(time_string); index ++)
			{
		   	 if (EOF == putc(time_string[index], (FILE *)outbuf))
					return (EOF);

			    chars_out ++; 
			}
		}
/* ... Added by Ravi on 01 Nov 1999 */
	}

    while (TRUE) {
	switch (*fmt) {
	    case '%':
		fmtlen = fcdfv(++fmt, &fmtbuf, &args);
		bufptr = buf1;
		badcvt = FALSE;
		switch (cchar = *(fmt + fmtlen)) {
		    case '%':
			buf1[0] = '%';
			fmtbuf.fldwidth = len1 = 1; /* %% prints as % */
			break;
		    case 'i':
		    case 'd':
			bufptr++; /* allow room for leading '+' or ' ' */
			len1 = dfbic(bufptr, fmtbuf.longint, &args, -10, FALSE); 
			if ((fmtbuf.precision == 0) && (len1 == 1) &&
			    *bufptr == '0') {
			    /* Converting a zero value with precision */
			    /* 0 is not supposed to print anything.   */
			    len1 = 0;
			}
			if (buf1[1] != '-') {
			    if (fmtbuf.printsign) {
				buf1[0] = '+';
				len1++;
				bufptr--;
			    } else if (fmtbuf.printprefix) {
				buf1[0] = ' ';
				len1++;
				bufptr--;
			    }
			}
			break;
		    case 'o':
			if (fmtbuf.altformat) {
			    /* start off with a leading '0' */
			    buf1[0] = '0';
			    bufptr= buf1+1;
			    len1 = 1;
			} else {
			    len1 = 0;
			}
			len1 += dfbic(bufptr, fmtbuf.longint, &args, 8, FALSE);
			bufptr = buf1;
			break;
		    case 'p':
			fmtbuf.longint = (sizeof(void *) == sizeof(long));
			/* FALL THROUGH */
		    case 'x':
		    case 'X':
			if (fmtbuf.altformat) {
			    bufptr = buf1+2;
			    buf1[0] = '0';
			    buf1[1] = ((cchar == 'X') ? 'X' : 'x');
			    len1 = 2;
			} else {
			    len1 = 0;
			}
			len1 += dfbic(bufptr, fmtbuf.longint, &args, 16,
			    cchar == 'X');
			/* altformat is to prepend 0x or 0X if non-zero */
			if (fmtbuf.altformat &&
			    ((len1 == 3) && (buf1[2] == '0'))) {
			    len1 = 1;
			    buf1[1] = '\0';
			}
			bufptr = buf1;
			break;
		    case 'u':
			len1 = dfbic(buf1, fmtbuf.longint, &args, 10, FALSE);
			break;
		    case 'c':
				/* treat this as an integer since characters */
				/* are converted to ints before being passed */
			buf1[0] = (char) va_arg(args,int);
			len1	= 1;
			break;
		    case 's':
			len1 = strlen(bufptr = va_arg(args,char *));
			if (fmtbuf.precision >= 1) {
			    if (len1 > fmtbuf.precision)
				len1 = fmtbuf.precision;
			}
			break;
		    case 'n':
			/* store number of characters printed so far */
			/* into a pointer given by next argument.    */
			/* Note: bufptr is used as a scratch variable here */
			bufptr = va_arg(args,void *);
			if (fmtbuf.longint) {
			    *((long*)bufptr) = chars_out;
			} else if (fmtbuf.shortint) {
			    *((short*)bufptr) = chars_out;
			} else {
			    *((int*)bufptr) = chars_out;
			}
			fmtbuf.fldwidth = len1 = 0;
			break;
#ifdef FP_IO
		    case 'E':
		    case 'e':
			len1 = dtoe(buf1, va_arg(args,double), &fmtbuf,cchar);
			break;
		    case 'f':
			len1 = dtof(buf1, va_arg(args,double), &fmtbuf);
			break;
		    case 'G':
		    case 'g':
			if (fmtbuf.precision == 0) {
			    fmtbuf.precision = 1;
			}
			/* In "g" format, the precision indicates the */
			/* number of digits, not the number of digits */
			/* to right of the decimal place.             */
			fmtbuf.precision--;
			temp_double = va_arg(args,REAL64);
			    /* the last argument to dtoe is 'E' or 'e' */
			len1 = dtoe(buf1, temp_double, &fmtbuf, (cchar - 2));
			/* Calculate exponent in a scratch variable */
			templen = (buf1[len1-1] - '0') +
			    (10 * (buf1[len1-2] - '0'));
			if (buf1[len1-4] == (cchar - 2)) {
				/* two digit exponent */
			    if (buf1[len1-3] == '-') {
				templen = -templen;
			    }
			} else { /* three digit exponent */
			    templen += 100 * (buf1[len1-3] - '0');
			    if (buf1[len1-4] == '-') {
				templen = -templen;
			    }
			}
			/* Use "f" format if the exponent is either < -4 or */
			/* >= precision (note: precision was decremented    */
			/* by one above, so the >= test becomes a > test.   */
			if ((templen >= -4) && (templen <= fmtbuf.precision)) {
			    /* Use "f" format after all.  Again, in "g"   */
			    /* format, the precision should mean the      */
			    /* number of digits, not the number of digits */
			    /* to right of the decimal place.  Note that  */
			    /* there will be "templen"+1 digits to the    */
			    /* left of the decimal place, and that the    */
			    /* value in precision has already been        */
			    /* decremented by one earlier.                */
			    fmtbuf.precision -= templen;
			    len1 = dtof(buf1, temp_double, &fmtbuf);
			    /* Strip trailing zeros and decimal point.   */
			    /* We do none of this in "alternate" format. */
			    if (!fmtbuf.altformat) {
				padcnt = len1; /* remember original length */
				/* first get rid of trailing zeros */
				while ((len1 > 0) &&
					(bufptr[len1-1] == '0')) {
				    --len1;
				}
				/* see if we hit a decimal point */
				if ((len1 > 0 ) && (bufptr[len1-1] == '.')) {
				    --len1;
				} else {
				    /* if we didn't hit a ".", make sure  */
				    /* the trailing zeros are not part of */
				    /* the integer part, c.f., ptm 6027.  */
				    precpad = len1;
				    while ((precpad > 0) &&
					(bufptr[precpad-1] != '.')) {
					--precpad;
				    }
				    if ((precpad <= 0) ||
					(bufptr[precpad-1] != '.')) {
					len1 = padcnt; /* bail out */
				    }
				}
				bufptr[len1] = '\0';
			    }
			}
			/* suppress later integer-type precision padding */
			fmtbuf.precision = -1;
			break;
#else
		    case 'f':
		    case 'E':
		    case 'e':
		    case 'G':
		    case 'g':
			fputs(
		"run time routines not compiled with floating point", stderr);
			break;
#endif
		    default:
			badcvt = TRUE;
			break;
		}		/*--- switch (cchar) ---*/

		fmtlen++;

		if (badcvt) {
		    if (cchar == '\0') goto sendthepkt;
		    if (bufmode) {
			for (templen=0;templen<fmtlen;templen++) {
			    *outbuf++ = fmt[templen];
			}
		    } else {
			if (EOF == xwrite((FILE *)outbuf, fmt, fmtlen)) {
			    return (EOF);
			}
		    }
		    chars_out += fmtlen;
		} else {
		    padcnt = fmtbuf.fldwidth - len1;
		    if (cchar == 's') { /* string conversion */
			precpad = 0;
		    } else {
			precpad = fmtbuf.precision - len1;
			if ((*bufptr == '-') ||
			    (*bufptr == '+') ||
			    (*bufptr == ' ')) {
			    precpad++; /* sign character isn't a digit */
			}
			if (precpad > 0) padcnt -= precpad;
		    }

		    if (bufmode) {
			if ((!fmtbuf.leftadj) && (padcnt > 0)) {
			    if (fmtbuf.padchar == '0') {
				/* first spit out the sign, if present */
				if ((*bufptr == '-') || (*bufptr == '+') ||
					(*bufptr == ' ')) {
				    *outbuf++ = *bufptr++;
				    len1--;
				}
			    }
			    cppad(outbuf, fmtbuf.padchar, padcnt);
			    outbuf += padcnt;
			    chars_out += padcnt;
			}
			/* left pad with zeros to satisfy integer precision */
			if (precpad > 0) {
			    /* first spit out the sign, if present */
			    if ((*bufptr == '-') ||
				(*bufptr == '+') ||
				(*bufptr == ' ')) {
				*outbuf++ = *bufptr++;
				len1--;
			    }
			    cppad(outbuf, '0', precpad);
			    outbuf += precpad;
			    chars_out += precpad;
			}
			templen = len1;
			while (templen--) {
			    *outbuf++ = *bufptr++;
			}
			chars_out += len1;
			if ((fmtbuf.leftadj) && (padcnt > 0)) {
			    cppad(outbuf, fmtbuf.padchar, padcnt);
			    outbuf += padcnt;
			    chars_out += padcnt;
			}
		    } else {
			if (!fmtbuf.leftadj) {
			    if ((fmtbuf.padchar == '0') &&
				((*bufptr == '-') || (*bufptr == '+') ||
				(*bufptr == ' '))) {
				if (EOF == xwrite((FILE *)outbuf, bufptr, 1)) {
				    return (EOF);
				}
				len1--;
				bufptr++;
			    }
			    if (padcnt > 0) {
				if (EOF == wrpad((FILE *)outbuf, fmtbuf.padchar,
				    padcnt)) {
				    return (EOF);
				}
				chars_out += padcnt;
			    }
			}
			/* left pad with zeros to satisfy integer precision */
			if (precpad > 0) {
			    /* first spit out the sign, if present */
			    if ((*bufptr == '-') ||
				(*bufptr == '+') ||
				(*bufptr == ' ')) {
				if (EOF == xwrite((FILE *)outbuf, bufptr, 1)) {
				    return (EOF);
				}
				len1--;
				bufptr++;
			    }
			    if (EOF == wrpad((FILE *)outbuf, '0', precpad)) {
				return (EOF);
			    }
			    chars_out += precpad;
			}
			if (EOF == xwrite((FILE *)outbuf, bufptr, len1)) {
			    return (EOF);
			}
			chars_out += len1;
			if (fmtbuf.leftadj && (padcnt > 0)) {
			    if (EOF == wrpad((FILE *)outbuf, fmtbuf.padchar,
				padcnt)) {
				return (EOF);
			    }
			    chars_out += padcnt;
			}
		    }   /* else */
		}		/*--- if (badcvt) ---*/
		fmt += fmtlen;
		break;
	    case '\0':
		if (bufmode) {
		    *outbuf = '\0';
		}
		goto sendthepkt;
	    default:
		if (bufmode) {
		    *outbuf++ = *fmt++;
		} else {
		    if (EOF == putc(*fmt++,(FILE *)outbuf)) {
			return (EOF);
		    }
		}
		chars_out++;
		break;
	}			/*--- switch (*fmt) ---*/
    }				/*--- while (TRUE) ---*/
sendthepkt:
	if (!bufmode)				/* 10/11/95 Sowmya : Dont need a Print Descriptor for sprintf */
		schedule_pkt_on_SMC(PrintDescriptor);
	return(chars_out);

} /* _printf */


    static VOID
cppad(outbuf, padchar, padcount)
    char *outbuf;		/* The buffer into which the pad  */
				/* character is to be replicated. */
    char padchar;		/* The desired pad character. */
    INT16  padcount;		/* The desired replication count. */
{

/*.SP*********************************************************************
	PROCEDURE  cppad
	EFFECTS
	    Writes n copies of a pad character into a buffer.
**************************************************************************
.EP*/

    INT16  count;		/* Temporary to count number of chars */

    for (count = 1; count <= padcount; count++)
	*outbuf++ = padchar;
} /* cppad */


    static INT16
dfbic(buf, longarg, arg, base, upper_case)
    char *buf;			/* buffer in which to place results. */
    BOOL longarg;		/* TRUE => arg is a long. */
    va_list *arg;		/* Ptr to the ptr to the arg to be converted */
    INT16  base;		/* The output base desired. */
    BOOL upper_case;		/* True for X format */
{

/*.SP*********************************************************************
	FUNCTION  dfbic
	REQUIRES
	    EXTERNAL PROCEDURES:
		__itob() __ltob()
	EFFECTS
	    This routine converts a printf, fprintf, or sprintf
	    argument which is an integer or long to ascii.
	    It calls __ltob or __itob, depending on the size
	    of the argument.

	    Both __itob and __ltob require a pointer to a string of hex
	    characters, either in upper or lower case.

**************************************************************************
.EP*/

    register INT16  retval;	/* The return value for this routine. */
    char * digits;

    if (upper_case) {
	digits = "0123456789ABCDEF";
    } else {
	digits = "0123456789abcdef";
    }
#ifndef NOLONGS
    if ((sizeof(int) == sizeof(INT32)) || longarg) {
	retval = __ltob(buf, va_arg(*arg,INT32), base, digits);
	return(retval);
    }
#endif
    retval = __itob(buf, va_arg(*arg,INT16), base, digits);
    return(retval);

} /* dfbic */



    static INT16
fcdfv(fmt, parmbuf, args)
    char *fmt;
    struct fmtprm *parmbuf;
    va_list  *args;		/* Pointer to format arguments. */
{

/*.SP*********************************************************************

	FUNCTION  fcdfv
	REQUIRES
	    fmt[-1] is a percent sign in a format string
	    EXTERNAL PROCEDURES: __btoi()
	EFFECTS
	    This routine is used to eat any of the optional format
	    control specifications which might occur before the actual
	    conversion description character is provided.  It also
	    supplies any default values necessary for an individual
	    conversion.  The length of the format, including the
	    format specifications, is returned.
	    MODIFIED : modifies the callers fmtprm

**************************************************************************
.EP*/

    char *savefmt;		/* saves value of fmt before */
				/* before we muck with it.   */
    INT16  *currfld;		/* Pointer to the current integer field	*/
				/* (fldwidth or precision) which is	*/
				/* being specified.			*/
    char *cptr;			/* Temporary used to collect and      */
				/* convert the integer characters in  */
				/* the format string for field widths */
				/* and precisions.		      */
#ifdef NOLONGS
    INT16  temp32;		/* temp: value of current integer field */
#else
    INT32  temp32;		/* temp: value of current integer field	*/
#endif

    currfld = &parmbuf->fldwidth;
    parmbuf->fldwidth = parmbuf->precision = -1;
    parmbuf->printsign = parmbuf->printprefix = parmbuf->altformat =
    parmbuf->leftadj = parmbuf->longint = parmbuf->shortint = FALSE;
    parmbuf->padchar = ' ';
    savefmt = fmt;
    while (*fmt) {
	switch (*fmt) {
	case '-':
	    parmbuf->leftadj = TRUE;
	    if (currfld == &parmbuf->fldwidth) {
		parmbuf->padchar = ' '; /* undo "0" flag, if also present */
	    }
	    break;
	case '+':
	    parmbuf->printsign = TRUE; /* print '+' or '-' */
	    break;
	case ' ':
	    parmbuf->printprefix = TRUE; /* print ' ' or '-' */
	    break;
	case '#':
	    parmbuf->altformat = TRUE;
	    break;
	case '0':
		/* If on the fldwidth then set padchar to 0 (but do */
		/* nothing if the "-" flag is present).  If on the  */
		/* precision, then ignore it (just a leading zero). */
	    if (!parmbuf->leftadj) {
		if (currfld == &parmbuf->fldwidth) {
		    parmbuf->padchar = '0';
		}
	    }
	    break;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    for (cptr = fmt; ((*cptr <= '9') && ('0' <= *cptr)) ; cptr++);
	    (VOID)__btoi(fmt, (INT16)(cptr - fmt), &temp32, 10);
	    *currfld = (INT16) temp32;
	    fmt = cptr - 1;	/* -1 adjusts for fmt++ */
	    break;		/* at end of loop	*/
	case '*':
	    /* like a number, but get value from next argument */
	    *currfld = va_arg(*args,int);
	    if (*currfld < 0) {
		if (currfld == &parmbuf->precision) {
		    *currfld = -1; /* as if precision omitted */
		} else {
		    parmbuf->leftadj = TRUE;
		    *currfld = -*currfld;
		}
	    }
	    break;
	case '.':
	    currfld = &parmbuf->precision;
	    *currfld = 0;
	    parmbuf->padchar = ' '; /* precision overrides 0 flag */
	    break;
	case 'L':
	    /* indicates long double, but that's a no-op for us */
	    /* parmbuf->longint = TRUE; would be the implementation */
	    break;
	case 'h':
	    parmbuf->shortint = TRUE;
	    break;
	case 'l':
	    parmbuf->longint = TRUE;
	    break;
	/*----------------------------------------------*/
	/*	We really do want the fall through in	*/
	/* the 'E', 'e', 'f', 'G', 'g', 'c', and 's'	*/
	/* cases to the	default case and return.	*/
	/*----------------------------------------------*/
	case 'E':
	case 'e':
	case 'f':
	case 'G':
	case 'g':
	    if (parmbuf->precision < 0) {
		parmbuf->precision = FDPRECV;
	    }
	    /* FALL THROUGH */
	case 's':
	case 'c':
	    parmbuf->longint = FALSE;	/* just in case */
	    /* FALL THROUGH */
	default:
	    return(fmt - savefmt);

	} /*--- switch (*fmt) ---*/
	++fmt;
    } /*--- while (*fmt) ---*/

    return(fmt - savefmt);	/* just in case */

} /* fcdfv */



    static int
wrpad(chan, padchar, padcount)
    FILE * chan;		/* The channel to which the pad  */
				/* character is to be written.   */
    char padchar;		/* The desired pad character. */
    INT16  padcount;		/* The desired replication count. */
/*.SP*********************************************************************
	PROCEDURE  wrpad
	EFFECTS
	    Writes n copies of a pad character into an I/O channel.
**************************************************************************
.EP*/
{
    INT16  count;		/* Temporary to count number of chars */

    for (count = 1; count <= padcount; count++) {
	if (EOF == putc(padchar, chan)) {
	    return (EOF);
	}
    }
    return (0);
} /* wrpad */


    static int
xwrite(chan, pstring, lstring)
    char *pstring;
    INT16   lstring;
    FILE  *chan;
/*.SP*********************************************************************
	PROCEDURE  xwrite
	EFFECTS
	    Write the given string to the ouput device, one character
	    at a time.
**************************************************************************
.EP*/
{
    char *p, *p_end ;

    for (p=pstring,p_end=pstring+lstring; p<p_end; p++) {
        if (EOF == putc(*p,chan)) return (EOF);
    }
    return (0);
} /* xwrite */


#ifdef FP_IO

    static char*
cvt(arg, ndigits, decpt, sign, eflag, buf)
    REAL64	arg;
    INT16	ndigits;
    INT16	*decpt;
    INT8	*sign;
    INT8	eflag;
    char	*buf;
/*.SP*********************************************************************
	FUNCTION  cvt
	REQUIRES
	    EXTERNAL PROCEDURES:  modf
	    buf must point to a buffer at least NDIG characters large.
	EFFECTS
	    cvt converts to ascii string with no leading zeros
	    ON CALL : arg has the fp number.
		      ndigits is the number of significant digits
		      decpt is set to the position of the decimal point
		      sign is set to 0 for positive, 1 for negative
		      eflag tells if conversion is to exponential form
	    RETURNS : a pointer to a string of digits.
		      the string is static.
		      the string is '0' if number is zero
		      the string is '+' if number is infinity
		      the string is '?' if number is not a number
		      that which decpt points to will contain the
			 number of decimal places.
		      that which sign points to will contain the sign
**************************************************************************
.EP*/
{
    register INT16	r2;
    REAL64		intpart;
    REAL64		fracpart;
    REAL64		temp;
    register char	*p;
    register char	*p1;
    INT16		i, tmp;		/*!*/

    if (ndigits < 0) {
	ndigits = 0;
    }
    if (ndigits >= NDIG-1) {
	ndigits = NDIG-2;
    }
    r2 = 0;
    p = &buf[0];
    *sign = (SIGNOF((UINT32*)&arg));
    if (*sign) {
       arg = -arg;
    }
    if (ISZERO((UINT32*)&arg)) {
	buf[0] = '0';
	return(buf);
    }
#ifndef NEC77240
    if (ISINFINITY((UINT32*)&arg)) {
	buf[0] = '+';
	return(buf);
    }
    if (ISNAN((UINT32*)&arg)) {
	buf[0] = '?';
	return(buf);
    }
#endif
    arg = modf(arg, (FP64PTR)(&intpart));

    /*----------------------------------------------------------------*/
    /* arg has decimal part, intpart has integer part.		      */
    /* take the inparts digits one by one and stick them into the end */
    /* of the buffer then move them to the beginning of it.	      */
    /*----------------------------------------------------------------*/

    if (intpart != 0) {
#ifdef TRACE
    printf("IN CVT: intpart != 0\n");
#endif
	p1 = &buf[NDIG];
	while (intpart != 0) {
	    temp = intpart/10;
            /* It's possible that inaccuracy will cause the division  */
            /* by 10 to come out a little bit low.  In C, conversions */
            /* from floating point to integer are done by truncation. */
            /* We add in .03 so that temp will be rounded up when it  */
            /* is converted to the nearest number of tenths, as done  */
            /* by the call to modf and the assignment to i.           */
            temp = temp + 0.03;
            temp = modf(temp, (FP64PTR)(&intpart));
            i = temp * 10.0;

#ifdef TRACE
    printf("IN CVT: intpart evaluation = %d \n", i);
#endif
	    *--p1 = i + '0';
	    r2++;
	}
	while (p1 < &buf[NDIG]) {
	    *p++ = *p1++;
	}

    /*----------------------------------------------------------------*/
    /* if the intpart was zero, then get the decimal part so that it  */
    /* does not have any zero directly to the right of the decimal    */
    /* point.  with each shift left of the decimal number adjust the  */
    /* exponent.						      */
    /*----------------------------------------------------------------*/

    } else {
#ifdef TRACE
    printf("IN CVT: intpart = 0\n");
#endif
#ifdef NEC77240
	if ((float)arg > 0) 
#else
	if (arg > 0) 
#endif
	{
	    while ((fracpart = arg*10) < 1) {
		arg = fracpart;
		r2--;
	    }			/* while */
	}		        /* if arg > 0 */
    }				/* else: intpart was not zero */
    p1 = &buf[ndigits];
    if (eflag == 0) {
	tmp = r2;
	/* Loop around adjusting the pointer up or down in the buffer.     */
	/* We must be careful not to move the pointer out of the range     */
	/* of the buffer.  If the pointer goes outside that range and      */
	/* the buffer is in very low or very high memory, the pointer      */
	/* value could "wrap" and cause later pointer comparisons to fail. */
	if (tmp > 0) {
	    while (tmp && p1 < &buf[NDIG-1]) {
		p1++;
		tmp--;
	    }
	} else {
	    while (tmp && p1 > buf) {
		p1--;
		tmp++;
	    }
	    if (tmp < 0) {		/* pointer would have underflowed buffer */
		buf[0] = '0';		/* This indicates that the number is     */
					/* smaller than the precision they've    */
					/* given us.  The result will be 0.0.... */
		return(buf);
	    }
        }
    }
    *decpt = r2;

    /*----------------------------------------------------------------*/
    /* we now stick the fractional part in digit by digit regardless  */
    /* of whether there was a non-zero integer part		      */
    /*----------------------------------------------------------------*/

#ifdef TRACE
    printf("IN CVT: start fractional part evaluation \n");
#endif
    while (p <= p1) {
	temp = arg*10;
        temp = modf(temp, (FP64PTR)(&intpart));
	arg = temp;
	i = intpart;
#ifdef TRACE
    printf("IN CVT:  fractional part evaluation = %d \n", i);
#endif
	*p++ = i + '0';
    }
    if (!eflag && tmp) {	/* precision is too large.   */
				/* return with what we have. */
	buf[NDIG-1] = '0';
	return(buf);
    }

    /*------------------*/
    /* round the number */
    /*------------------*/

    p = p1;
    *p1 += 5;
    while (*p1 > '9') {
	*p1 = '0';
	if (p1 > buf) {
	    p1--;
	    *p1 += 1;
	} else {
	    *p1 = '1';
	    (*decpt)++;
	    if (eflag == 0) {
		if (p > buf) {
		    *p = '0';
		}
		p++;
	    }			/* if eflag == 0 */
	}			/* else */
    }				/* while *p1 > 9 */
    *p = '\0';
    return(buf);
} /* cvt */




    static INT16
dtoa(number, str_ptr)
    INT16	number;
    char *	str_ptr;
{

/*.SP*********************************************************************
	PROCEDURE  dtoa
	EFFECTS
	    Converts a number into a 2 or 3 digit decimal ascii string.
	    Returns the number of characters put into the buffer.
	    MODIFIED :  puts the character in the buffer passed in.
**************************************************************************
.EP*/

    INT16	frac;
    INT8	i;
    INT16	digits;

    if (number < 0) {
	number = -number;
    }
    if (number > 99) {
	digits = 3;
    } else {
	digits = 2;
    }
    for (i = 1; i <= digits; i++) {
	frac = number%10;
	number = number/10;
	str_ptr[digits-i] = frac + '0';
    }
    return (digits);
} /* dtoa */


    static INT16
dtoe(buf, arg, fmtptr, e_or_E)
    char *	buf;
    REAL64	arg;
    struct fmtprm *fmtptr;
    char	e_or_E;
/*.SP*********************************************************************
	FUNCTION  dtoe
	REQUIRES
	    buf must be large enought to hold the result.
	    EXTERNAL PROCEDURES: cvt() dtoa()
	EFFECTS
	    Takes a fp number and converts it to a string of ascii
	    characters representing that number in exponential form.
	    It returns the length of the string and puts the
	    string in the buffer to which it was passed a pointer.
	    The variable e_or_E points is either 'E' or 'e'.
**************************************************************************
.EP*/
{
    INT8	sign;
    INT16	decpt;
    INT16	precision;
    char *	numstr;
    char *	bp;
    char        fillchar;
    char	cvtbuf[NDIG];

    precision = fmtptr->precision;
    numstr = cvt(arg, precision + 1, &decpt, &sign, 1, cvtbuf);
    bp = buf;
    if ((*numstr == '0') || (*numstr == '+') || (*numstr == '?')) {
	/* conversion gave 0, infinity, or NAN */
	fillchar = *numstr;
	*bp++ = fillchar;
	if ((precision > 0) || fmtptr->altformat) {
	    *bp++ = '.';
	}
	fmtptr->precision = precision = (precision > NDIG) ? NDIG : precision;
	while (--precision >= 0) {
            *bp++ = fillchar;
	}
	*bp++ = e_or_E;
	*bp++ = '+';
	*bp++ = fillchar;
	*bp++ = fillchar;
	*bp++ = fillchar;
    } else {
	if (sign) {
	    *bp++ =  '-';
	} else if (fmtptr->printsign) {
	    *bp++ =  '+';
	} else if (fmtptr->printprefix) {
	    *bp++ =  ' ';
	}
	*bp++ = *numstr++;
	if ((*numstr != '\0') || fmtptr->altformat) {
	    *bp++ = '.';
	}
	while (*numstr != '\0') {
	    *bp++ = *numstr++;
	}
	*bp++ = e_or_E;
	if (decpt -1 >= 0) {
	    *bp++ = '+';
	} else {
	    *bp++ = '-';
	}
	/* update bp after putting in exp */
	bp += dtoa(decpt - 1, bp);
    }	/* else it was a number   */
    *bp = '\0';
    return (INT16)(bp - buf);
} /* dtoe */

    static INT16
dtof(buf, arg, fmtptr)
    char *	buf;
    REAL64	arg;
    struct fmtprm *fmtptr;
/*.SP*********************************************************************
	FUNCTION dtof
	REQUIRES
	    buf must be large enought to hold the result.
	    EXTERNAL PROCEDURES: cvt()
	EFFECTS
	    Converts a fp number to a string of ascii characters
	    representing that number in non-exponential format.
	    It returns the length of the string and puts the
	    string in the buffer to which it was passed a pointer.
**************************************************************************
.EP*/
{
    INT8	sign;
    INT16	decpt;
    INT16	precision;
    char *	numstr;
    char *	bp;
    char	fillchar;
    char	cvtbuf[NDIG];

    bp = buf;
    precision = fmtptr->precision;
    fmtptr->precision = precision = (precision > NDIG) ? NDIG : precision;
    numstr = cvt(arg, precision, &decpt, &sign, 0, cvtbuf);
    if ((*numstr == '0') || (*numstr == '+') || (*numstr == '?')) {
	/* conversion gave 0, infinity, or NAN */
	fillchar = *numstr;
	*bp++ = fillchar;
	if ((precision > 0) || fmtptr->altformat) {
	    *bp++ = '.';
	}
	while (--precision >= 0) {
            *bp++ = fillchar;
	}
        *bp = '\0';
    } else {
        if (sign) {
	    *bp++ =  '-';
	} else if (fmtptr->printsign) {
	    *bp++ =  '+';
	} else if (fmtptr->printprefix) {
	    *bp++ =  ' ';
        }
        if (decpt <= 0) {
	    *bp++ = '0';
	    *bp++ = '.';
            while (decpt++ < 0) {
	        *bp++ = '0';
	    }
	    while (*bp++ = *numstr++) { ; }
	    --bp; /* bump bp back to point to the null */
        } else {
	    while ((*numstr != '\0') && (decpt-- != 0)) {
		*bp++ = *numstr++;
	    }
	    if ((*numstr != '\0') || fmtptr->altformat) {
	        *bp++ = '.';
	    }
	    if (*numstr != '\0') {
		while (*bp++ = *numstr++);
		--bp; /* bump bp back to point to the null */
	    } else {
		*bp = '\0';
	    }
        }			/* else decpt > 0 */
    }				/* else it was a number */
    return (INT16)(bp - buf); /* same as strlen(buf) */
} /* dtof */
    /* end #ifdef FP_IO */
#endif

