/*.BM*******************************************************************
	Copyright (C) 1982,1983 Intermetrics, Inc.
AUTHOR		:   Randy Hudson - modified by David Sotkowitz
		:   Modified for ANSI C by Julian Horn
SECTION		:   C Run Time Library
MODULE		:   m/rt/c/ansi/xscanf.c
SCCS ID		:   1.18
LAST DELTA	:   6/21/93 16:04:04
DATE OF GET	:   6/21/93 16:08:55
UNIX FILE	:   s.xscanf.c
@(#)m/rt/c/ansi/xscanf.c	1.18

    FUNCTIONS DEFINED :
	_scanf		-- common scan routine for {,s,f}scanf
    RELATION :
	Common scan routine for scanf,fscanf,sscanf
    EXTERNAL PROCEDURES: convert
************************************************************************
.EM*/

#include "stdio.h"
#include "rt.h"
#include "stdarg.h"
#include "fpio.h"

#define is_white(c) ((c==' ')||(c=='\t')||(c=='\n')||(c=='\r')||(c=='\f')|| \
	(c=='\v'))

#ifdef FP_IO
#include "fpdef.h"
#include "stdlib.h"
#endif

/* BUFSIZE limits the size of the input field */
#ifdef MHC11
#define BUFSIZE 200
#else
#define BUFSIZE 256
#endif

extern INT16 __btoi();
extern INT16
__itob(char *s, INT16 i, INT16 base, char *digits);
extern INT16
__ltob(char *s,
#ifdef NOLONGS
    INT16 i,
#else
    INT32 i,
#endif
    INT16 base,
    char *digits);

/* These used to be defined in stdarg.h or stdio.h */
#define SCANF_FILE	1
#define SCANF_STRING	2

struct field_spec {
    void *where;	/* file or addr of buffer for nextchar & retchar */
    INT16 *countptr;	/* pointer to increment by chars read */
    char *scanstart;	/* start of set of qualified chars, for '[' format */
    INT16 mode;		/* 1=SCANF_FILE or 2=SCANF_STRING */
    INT16 width;
    INT16 base;		/* kind of scan: values described below */
    char buf[BUFSIZE];	/* buffer to save chars accum'd */
};

/* special values for base field of field_spec structure */

#define ADJUSTABLE_BASE -3
#define SCAN_BASE	-2
#define FLOAT_BASE	-1
#define STRING_BASE	 0
#define OCTAL_BASE	 8
#define DECIMAL_BASE	10
#define HEX_BASE	16

static BOOL char_allowed();
static int sgetc();
static VOID sungetc();
static INT16 rd_field();

/* Following used by rd_field and _scanf to get chars.   */
/* Note the chars_read variable must be declared LOCALLY */
/* by each of the callers of NEXTCHAR and PREVCHAR.      */
/* Note that NEXTCHAR is an expression, since it has a   */
/* value, while PREVCHAR is a statement.  PREVCHAR could */
/* be a void expression, but not all compilers eat that. */

#define NEXTCHAR(mode,where) \
    (chars_read++,(((mode)==SCANF_FILE) ? getc((FILE*)where) : \
    sgetc((char**)where)))

#define PREVCHAR(c,mode,where) \
    chars_read--; \
    if ((mode)==SCANF_FILE) { \
	ungetc(c,(FILE *)where); \
    } else { \
	sungetc(c,(char **)where); \
    }


    INT16
_scanf(mode,where,fmt,args)
    INT16       mode;           /* SCANF_FILE or SCANF_STRING */
    void *	where;		/* file (FILE *) or buffer (char **) */
    char *	fmt;
    va_list	args;
/*.SP*********************************************************************
	FUNCTION  _scanf
	REQUIRES
	     EXTERNAL DATA:
	         args must be pointer to area for arguments
	     EXTERNAL PROCEDURES:
	         must have a function to get and unget characters
		 rd_field() __btoi()
	EFFECTS
	     implements scanf/sscanf/fscanf functions
		MODIFIED : fills the args
**************************************************************************
.EP*/
{
    INT16	cw;
    INT16	fc,c;
    BOOL	do_assign, is_long, is_short,is_char;
    INT16	w;
#ifdef NOLONGS
    INT16	result;
#else
    INT32	result;
#endif
    INT16	count;
    INT16	chars_read;
    INT16	bwidth;	/* with returned by __btoi */
    INT16	fwidth; /* width returned by rd_field */
    char *      tempptr;
    struct field_spec field_def;

#ifdef TRACE
	printf("entering _scanf\n");
	printf("mode = %d, fmt = \"%s\"\n",mode,fmt);
#endif

    field_def.mode = mode;
    field_def.where = where;
    field_def.countptr = &chars_read;

    /* check for immediate EOF */
    if ((c = NEXTCHAR(mode,where)) == EOF) {
	return (EOF);
    }
    PREVCHAR(c,mode,where);
    chars_read = count = 0;

    /*---------------------------------------*/
    /*   loops for all args		     */
    /*---------------------------------------*/

    while (TRUE) {

#ifdef TRACE
	fc = *fmt;
	if (fc) {
	    printf("main loop in  _scanf: fc = '%c'\n",fc);
	} else {
	    printf("main loop in  _scanf: fc = '\\0'\n",fc);
	}
#endif

	switch (fc = *fmt++) {
	case ' ':
	case '\f':
	case '\v':
	case '\r':
	case '\t':
	case '\n':
	    /* skip white space in the input */
	    cw = NEXTCHAR(mode,where);
	    while (is_white(cw)) {
		cw = NEXTCHAR(mode,where);
	    };
	    PREVCHAR(cw,mode,where);
	    break;
	case '\0':

#ifdef TRACE
	        printf("exit1 _scanf, count = %d\n",count);
#endif

	    return (count);
	case '%':
	    /* process a field specification */
	    /* CHANGE: use DySak's thing in printf, */
	    /* or modify so an EOS in the middle of a specification */
	    /* gets caught */

	    /* initial '*' means don't assign result */
	    if (*fmt == '*') {
		do_assign = FALSE;
		fmt++;
	    } else {
		do_assign = TRUE;
	    }

	    /* a optional number specifies the field width */
	    c = *fmt;
	    if ('0' <= c && c <= '9') {
		fmt += __btoi(fmt, (INT16)strlen(fmt), &result, 10);
		field_def.width = (INT16) result;
	    } else {
		field_def.width = -1;
	    }

	    /* Next we can have an optional 'l', 'h', or 'L' that says */
	    /* the field is long, short or long double respectively.   */
	    is_short = is_long = is_char = FALSE ;
	    c = *fmt++;
	    if (c == 'l') {
		is_long = TRUE;
		c = *fmt++;
	    } else if (c == 'h') {
		is_short = TRUE;
		c = *fmt++;
	    } else if (c == 'L') {
		is_long = TRUE;
		c = *fmt++;
	    } else if (c == 'j') {
		is_char = TRUE;
		c = *fmt++;
		}

#ifdef TRACE
		if (c) {
		    printf("conversion switch in  _scanf: c = '%c'\n",c);
		} else {
		    printf("conversion switch in  _scanf: c = '\\0'\n");
		}
#endif

	    /* finally a letter specifies the conversion to perform */
	    switch (c) {
	    case 'i' :
		field_def.base = ADJUSTABLE_BASE;
		goto st_int;
	    case 'd' :
	    case 'u' :
		field_def.base = DECIMAL_BASE;
		goto st_int;
	    case 'o' :
		field_def.base = OCTAL_BASE;
		goto st_int;
	    case 'p' :
		/* %p is like %lx or %x, depending on the size of pointers */
		is_long = (sizeof(long) == sizeof(char*));
		is_short = (sizeof(short) == sizeof(char*));
		/* FALL THROUGH */
	    case 'X' :
	    case 'x' :
		field_def.base = HEX_BASE;
st_int:
		fwidth = rd_field(&field_def);
#ifdef TRACE
		    field_def.buf[fwidth] = '\0';
		    printf("rd_field returned: %d,width = %d,buf = %s\n",
			fwidth,field_def.width,field_def.buf);
#endif
		if ((fwidth == EOF) && (count == 0)) {
		    return (EOF);
		}
		if ((fwidth == 0) || (fwidth == EOF)) {
		    return (count);
		}
		bwidth = __btoi(field_def.buf,fwidth,&result,field_def.base);
		if (do_assign && (bwidth==fwidth) && fwidth) {
		    count++;
		    if (is_char) {
			*va_arg(args,char *) = result;
		    } else if (is_long) {
			*va_arg(args,long *) = result;
		    } else if (is_short) {
			*va_arg(args,short *) = result;
		    } else {
			*va_arg(args,int *) = result;
		    }
		}   /* if do_assign and fwidth etc */
		break;
	    case 'n' :
		if (do_assign) {
		    if (is_char) {
			*va_arg(args,char *) = chars_read;
		    } else if (is_long) {
			*va_arg(args,long *) = chars_read;
		    } else if (is_short) {
			*va_arg(args,short *) = chars_read;
		    } else {
			*va_arg(args,int *) = chars_read;
		    }
		}
		break;
	    case 'c':
		if (field_def.width == -1) {
		    field_def.width = 1;
		}
#ifdef TRACE
		printf("case c in _scanf: width = %d\n",field_def.width);
#endif
		if (do_assign) {
		    tempptr = va_arg(args,char *);
		}
#ifdef TRACE
		printf("chars = \"");
#endif
		while (field_def.width > 0) {
		    cw = NEXTCHAR(mode,where);
		    if (cw == EOF) {
#ifdef TRACE
			printf("<EOF>\"!\n");
#endif
			if (count == 0) {
			    return (EOF);
			}
			return (count);
		    }
#ifdef TRACE
		    printf("%c",cw);
#endif
		    if (do_assign) {
			*tempptr++ = cw;
		    }
		    field_def.width--;
		}
#ifdef TRACE
		printf("\"\n");
#endif
		if (do_assign) {
		    count++;
		}
		break;
	    case 's' :
		field_def.base = STRING_BASE;
		w = rd_field(&field_def);
		field_def.buf[w] = '\0' ;
#ifdef TRACE
		    printf("rd_field returned: %d,width = %d,buf = %s\n",
			w,field_def.width,field_def.buf);
#endif
		if ((w == EOF) && (count == 0)) {
		    return (EOF);
		}
		if ((w == 0) || (w == EOF)) {
		    return (count);
		}
		if (do_assign && w) {
		    count++;
		    strcpy(va_arg(args,char *),field_def.buf);
		}
		break;
	    case '[':
		/* first find the bounds of the scan set */
		field_def.base = SCAN_BASE;
		field_def.scanstart = fmt;
		/* push fmt past the ']' that closes the scan pattern */
		if (*fmt == '^') {
		    fmt++;
		}
		if (*fmt == ']') { /* this left bracket is IN the pattern */
		    fmt++;
		}
		while (*fmt != ']') {
		    fmt++;
		    if (!*fmt) { /* missing right bracket */
			return (count);
		    }
		}
		w = rd_field(&field_def);
		field_def.buf[w] = '\0' ;
#ifdef TRACE
		    printf("rd_field returned: %d,width = %d,buf = %s\n",
			w,field_def.width,field_def.buf);
#endif
		if ((w == EOF) && (count == 0)) {
		    return (EOF);
		}
		if ((w == 0) || (w == EOF)) {
		    return (count);
		}
		if (do_assign && w) {
		    count++;
		    strcpy(va_arg(args,char *),field_def.buf);
		}
		break;
#ifdef FP_IO
	    case 'e':
	    case 'f':
	    case 'E':
	    case 'g':
	    case 'G':
		field_def.base = FLOAT_BASE;
		w = rd_field(&field_def);
		field_def.buf[w] = '\0';
#ifdef TRACE
		printf (
	    "case e/f in scanf, rd_field returned %d, width = %d, buf = %s\n",
		    w,field_def.width,field_def.buf);
#endif

		if ((w == EOF) && (count == 0)) {
		    return (EOF);
		}
		if ((w == 0) || (w == EOF)) {
		    return (count);
		}
		if (do_assign) {
		    count++;
		    if (is_long) {
			*va_arg(args,double *) = strtod(&field_def.buf[2],NULL);
		    } else {
			*va_arg(args, float *) =
				(float)strtod(&field_def.buf[2], NULL);
		    }
		}
		break;
#else
	    case 'f':
	    case 'e':
	    case 'E':
	    case 'g':
	    case 'G':
/*		fprintf(stderr, "floating point not included in this version of run time library");*/
		break;
#endif
	    case '%':
		/* next char should match % */
		c = NEXTCHAR(mode,where);
		if (c != '%') { /* matching failure */
		    if ((c == EOF) && (count == 0)) {
			return (EOF);
		    }
		    return (count);
		}
		break;
	    default:
		/* these cases are all bad formats */
		break;
	    } /* end switch on % character */
	    break;
	default:
	    c = NEXTCHAR(mode,where); /* next char should match */
	    if (c != fc) { /* matching failure */
		if ((c == EOF) && (count == 0)) {
		    return (EOF);
		}
		return (count);
	    }
	    break;
	} /* end switch on format character */
    } /* end while(TRUE) */

} /* _scanf */


    static BOOL
char_allowed(c,p)
    INT16 c;		  /* the character to test */
    struct field_spec *p; /* environment to test it against */
/*.SP*********************************************************************
	FUNCTION  char_allowed
	REQUIRES
	    p points to a valid field definition.
	    If the base is scan_base, then the '[...]' pattern
	    must contain a right square bracket which does not
	    appear in the first position or in the second position
	    following a '^' character.
	EFFECTS
	    Returns TRUE if the character is allowed in the field.
**************************************************************************
.EP*/
{
    BOOL retval;	/* char_allowed return value */
    BOOL want_match;
    char * test;

#ifdef TRACE
	if (c) {
	    printf("char_allowed entered: c = '%c',base = %d\n",c,p->base);
	} else {
	    printf("char_allowed entered: c = '\\0',base = %d\n",p->base);
	}
#endif

    switch (p->base) {
    case STRING_BASE:
        retval = ((is_white(c)) || (c == EOF)) ? FALSE : TRUE;
	break;
    case OCTAL_BASE:
	retval = (('0' <= c) && (c <= '7')) ? TRUE : FALSE;
	break;
    case DECIMAL_BASE:
	retval = (('0' <= c) && (c <= '9')) ? TRUE : FALSE;
	break;
    case HEX_BASE:
	retval = (('0' <= c) && (c <= '9')) ? TRUE : FALSE;
	if(!retval){
	    retval = (('a' <= c) && (c <= 'f')) ? TRUE : FALSE;
	}
	if(!retval){
	    retval = (('A' <= c) && (c <= 'F')) ? TRUE : FALSE;
	}
	break;
#ifdef FP_IO
    case FLOAT_BASE:
	retval = (('0' <= c) && (c <= '9')) ? TRUE : FALSE;
	break;
#endif
    case SCAN_BASE:
	retval = FALSE;
#ifdef TRACE
	    printf("char_allowed scanning against: \"");
	    test = p->scanstart;
	    if (*test == '^') {
		printf("%c",*test++);
	    }
	    if (*test == ']') {
		printf("%c",*test++);
	    }
	    while (*test != ']') {
		printf("%c",*test++);
	    }
	    printf("\"\n");
#endif
	test = p->scanstart;
	if (*test == '^') {
	    want_match = FALSE;
	    test++;
	} else {
	    want_match = TRUE;
	}
	if ((*test == ']') && ((test++,c) == ']')) {
	    retval = want_match;
	} else {
	    /* see if c is in the scan set */
	    while ((*test != c) && (*test != ']')) {
		test++;
	    }
	    /* if c is in the set, and we want a match, return TRUE */
	    retval = (want_match == (*test == c));
	}
	break;
    } /* switch */

#ifdef TRACE
	if (c) {
	    printf("char_allowed exit: c = '%c',base = %d,retval = %d\n",
		c,p->base,retval);
	} else {
	    printf("char_allowed exit: c = '\\0',base = %d,retval = %d\n",
		p->base,retval);
	}
#endif

    return(retval);

} /* char_allowed */


/* Following are used like "getc" and "ungetc" */
/* when scanning a string rather than a file.  */

    static int
sgetc(sptr)
    char**	sptr;
{
    register int c;

    if (c = *(*sptr)) {
        (*sptr)++;
    } else {
	c = EOF;
    }
    return c;
} /* sgetc */


    static VOID
sungetc(c,sptr)
    char	c;
    char**	sptr;
{

    --(*sptr);
} /* sungetc */


    static INT16
rd_field(p)
    struct field_spec *p;
/*.SP*********************************************************************
	FUNCTION  rd_field
	REQUIRES
	     EXTERNAL DATA:
	         buf must be large enough to hold characters
	     EXTERNAL PROCEDURES:
		 char_allowed()
	EFFECTS
             load a field into static buffer
             return count of bytes loaded into field or EOF if found
		MODIFIED :  fills the parameter buf
	METHODS
	    look for special leading characters then just look using a
	    loop.  if fp then look for special chars within loop
**************************************************************************
.EP*/
{
    INT16	c;
    INT16	chars_read;
    char	*bp;
    BOOL	seen_digits;
#ifdef FP_IO
    BOOL        seen_decpt;	/* These are used for fp so that  */
    BOOL	seen_exp;	/* we'll know if these characters */
				/* have been seen so far.         */

    seen_decpt = seen_exp = FALSE;
#endif
    seen_digits = FALSE;

#ifdef TRACE
    printf("rd_field entered: width = %d,base = %d\n",p->width,p->base);
#endif


    chars_read = 0;
    c = NEXTCHAR(p->mode,p->where);
    if (p->base != SCAN_BASE) {
	while (is_white(c)) {   /* ignore white space */
	    c = NEXTCHAR(p->mode,p->where);
	};
    }
    if (c == EOF) {
	return(EOF);
    }
    bp = p->buf;

    /*--------------------------------------------------*/
    /*  The "#f" is necessary for the convert routine.	*/
    /*  The f may be changed in _scanf to d.		*/
    /*--------------------------------------------------*/

#ifdef FP_IO
    if (FLOAT_BASE == p->base) {
        *bp++ = '#';
        *bp++ = 'f';
    }
#endif

    /*-------------------------------------*/
    /* test for special leading characters */
    /*-------------------------------------*/

    if (((c == '-') || (c == '+')) &&
	((DECIMAL_BASE == p->base) || (FLOAT_BASE == p->base) ||
	(OCTAL_BASE == p->base) || (HEX_BASE == p->base) ||
	(ADJUSTABLE_BASE == p->base))) {
	if (--(p->width) == 0) {
	    return (0); /* no good if chopped at [+-] */
	}
	*bp++ = c;
	c = NEXTCHAR(p->mode,p->where);
    } /* if c == - or + and base is arithmetic */

    /* Skip over "0x" or "0X" for hex or adjustable base.        */
    /* Also, if the base is adjustable, then determine the base. */
    if ((ADJUSTABLE_BASE == p->base) || (HEX_BASE == p->base)) {
	if (c == '0') {
	    *bp++ = '0';
	    if (--(p->width) == 0) {
		p->base = HEX_BASE;
		*p->countptr += chars_read;
		return (INT16)(bp - p->buf); /* chopped at 0 is OK */
	    }
	    c = NEXTCHAR(p->mode,p->where);
	    if ((c == 'x') || (c == 'X')) {
		if (--(p->width) == 0) {
		    return (0); /* no good if chopped at 0[Xx] */
		}
		p->base = HEX_BASE;
		*bp++ = c;
		c = NEXTCHAR(p->mode,p->where);
	    } else {
		seen_digits = TRUE; /* fix for ptm 5300 */
		if (ADJUSTABLE_BASE == p->base) {
		    p->base = OCTAL_BASE;
		}
	    }
	} else if (ADJUSTABLE_BASE == p->base) {
	    p->base = DECIMAL_BASE;
	}
    }
    /* if we reach here, p->base is no longer ADJUSTABLE_BASE */

#ifdef FP_IO
    if ((c == '.') && (FLOAT_BASE == p->base)) {
	if (--(p->width) == 0) {
	    return (0); /* no good if chopped at "." */
	}
	seen_decpt = TRUE;
	*bp++ = c;
	c = NEXTCHAR(p->mode,p->where);
    }   /* if c == . and base = FLOAT_BASE */
#endif

    /*----------------*/
    /* start the loop */
    /*----------------*/

    while (p->width-- != 0) {
#ifdef FP_IO
	if (FLOAT_BASE == p->base) {
	    if ((c == '.') && (!seen_decpt)) {
		seen_decpt = TRUE;
		*bp++ = c;
		c = NEXTCHAR(p->mode,p->where);
		continue;
	    }
	    if (((c == 'e') || (c == 'E')) && (!seen_exp)) {
		/* Once you see the exponent, you have an */
		/* invalid number until you get a digit.  */
		/* if the field runs out, we return zero. */
		seen_decpt = TRUE;
		seen_exp = TRUE;
		*bp++ = c;
		c = NEXTCHAR(p->mode,p->where);
		if (p->width-- == 0) {
		    seen_exp = FALSE; /* bad exponent: chops at [Ee] */
		}
		if ((c == '+') || (c == '-')) {
		    *bp++ = c;
		    c = NEXTCHAR(p->mode,p->where);
		    if (p->width-- == 0) {
			seen_exp = FALSE; /* bad exponent: chops at [Ee][+-] */
		    }
		}
		if (!(('0' <= c) && ('9' >= c))) {
		    seen_exp = FALSE; /* bad exponent: no digit after [Ee][+-] */
		}
		if (!seen_exp) {
		    return (0); /* return match failure for bad exponent */
		}
		*bp++ = c;
		c = NEXTCHAR(p->mode,p->where);
		continue;
	    }   /* if c == e/E and float base and have not seen_exp */
	}
#endif
	if (char_allowed(c,p)) {
	    seen_digits = TRUE;
	    *bp++ = c;
	    c = NEXTCHAR(p->mode,p->where);
	} else {
	    break;
	}
    }   /* while-- */

    /* put back the last character (the one that didn't fit) */
    if (c != EOF) {
	PREVCHAR(c,p->mode,p->where);
    }

    if ((!seen_digits) &&
	((p->base == FLOAT_BASE) || (p->base == HEX_BASE) ||
	(p->base == DECIMAL_BASE) || (p->base == OCTAL_BASE))) {
	/* Disallow arithmetic patterns with no digits  */
	/* in them, e.g., 0xx for hex, or .x for float. */
	return (0);
    }
#ifdef TRACE
	*bp = '\0'; /* cap the end so buf will print nicely */
	printf("rd_field main exit: width = %d,base = %d,buf = %s\n",
	    p->width,p->base,p->buf);
#endif

    *p->countptr += chars_read;
    return (INT16)(bp - p->buf);
} /* rd_field */
