#include	"defs.h"
/*	$Modname: brouter.c$  $version: 1.6$      $date: 07/08/94$   */
/*
* 	$lgb$
1.0 10/30/93 ross certification version.
1.1 12/09/93 ross added new lsl.
1.2 03/26/94 ross new startup file.
1.3 04/04/94 ross removed header file, and moved CLOCK_TICKS... into this c file.
1.4 04/04/94 ross got rid of some extraneous include files.
1.5 06/13/94 ross ndis test version.
1.6 07/08/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1990 - 1994 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

/*----------------------------------------------------------------------------
Changes :
	chetan 21st July 1997
	see the comments NEW_BOOT
	Assignment the Boot Mode flag pointer done statically
	rather than dynamically
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include	<softquot.h>

#include "lsl.h"
#define	byte BYTE
#define	word USHORT
#define	dword ULONG
#define	BOOL int
#include "boot.h"
#include	<rcopy.h>		/* This is for idata init */

/* Imran 22.3.99 */
#if USER_EVENT_LOG
#include <usrlog.h>
#endif
/* Imran 22.3.99 */

/* Imran 7.4.99 */
#if EVENT_LOG
#include <logif.h>
#endif
/* Imran 7.4.99 */

extern	char *rompOutSeg;

extern int	FrmRxed;
extern int	FrmTxed;
extern int StdLibInit(int,void *);
extern BYTE init_ethernet_address_for_internet_lan();

#ifdef __BORLANDC__
	#define INT03      {__emit__ (0xcc);}
	#include <conio.h>
#endif
extern enum TEST initialize_test_socket_udp (ULONG clock_ticks_per_second);
extern enum TEST initialize_test_socket_tcp (ULONG clock_ticks_per_second);
extern void	enable_wan_tx_rx(void);
extern void	EnableEthTXAndRxOnSCC1(int);
extern void	EnableEthTXAndRxOnSCC2(int);
extern	void init_ipx_router_network(char *);
extern	int InitMicroCode(void);
extern	int IsBridgingEnabled(void);
extern	void determine_flash_types(void);

extern void calculate_crc_table (void) ;

void	enable_tx_rx(void);
#include "vrtrwstr.h"
#include <rwarebuf.h>
#include <serial.h>
extern void ChatForeground(void);
extern void do_telnet_receives(void);

ULONG code_stack_size ;
ULONG rmon_data_and_vect_table_size ;

/* NEW_BOOT */
#if 1
void *BridgeModeLoc = (void *) 0x1C10 ;
#else
void *BridgeModeLoc;
#endif
/* NEW_BOOT */

#define	SWSR 
/****************************************************************************/
#define CLOCK_TICKS_PER_SECOND 20


extern void initialize_system_timer (void);
extern void restore_timer (void);

extern void disable_dma (USHORT channel);
extern enum TEST initialize_dlsw_tcp_connection (void);

/* version number and date are also inside the program
the c structure for version and date are */

#pragma separate VersionDate
VersionDateType VersionDate =
#if WEB
{"3.00",
#else
{"3.00",
#endif
"February 15, 2000", "ABCD"};

extern void SetErrorVec(void); /* implementation */
void operating_system (void);
/*static enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers);*/
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers);
/****************************************************************************/
#if defined (__FLAT__) && defined (_MEMCHECK_H_)
	static void _MCCALLBACK routerware_error (char *message);
	ERF original_erf;

	extern void cdecl mcinitfp_startcheck (void);
	extern void cdecl mcexitfp_endcheck (void);
	#pragma startup mcinitfp_startcheck     16
	#pragma exit    mcexitfp_endcheck       16
#endif
/****************************************************************************/
int	InitializationDone = 0;
int	SyncRxError;
int	SyncTxError;
char *PtrToIniFile;
char *TmpPtrToIniFile;
ULONG WatchDogServiceRegister = 0xffff102f;
char ethernet_address[6] ;
void Reset();
#if STATUS_DEBUG
void MyReset();
#endif

enum BOOLEAN FIREWALL_IS_UP = FALSE; /* Added by Ravi on 02 Nov 1999 */

void main ()
{
	HeaderType *sptr_cfg_header = (HeaderType *)FL_CFG_HDR ;
	unsigned long tmplong = (unsigned long)sptr_cfg_header->DnLdAddr ;
	ULONG available_dram ;

	char *TmpCharPtr;
	int i;
	BootConfigType  *ptr_boot_config;

/*
	in pmain.68k we are clearing off the idata segment. we need to put the
	proper initialized values for the variables. this is kept in rompOutSeg
	segment. so we copy it into idata using rcopy. see manuals for details.
*/

	rcopy((struct hdr *) &rompOutSeg);		/* This is the idata initialization code  */
	InitializationDone = 0;

	*((BYTE *)WatchDogServiceRegister)= 0x55;
	*((BYTE *)WatchDogServiceRegister)= 0xAA;

	ptr_boot_config = (BootConfigType *)FL_BOOT_HDR;
	/*
	   First parameter  : Ram size,
	   Second parameter : Heap start
	*/
	/* StdLibInit(ptr_boot_config->RamSize - CODE_STACK_SIZE, ptr_boot_config->RamStart + CODE_STACK_SIZE); */
	StdLibInit((ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size),
	           (ptr_boot_config->RamStart + code_stack_size + rmon_data_and_vect_table_size)) ;

/* BridgeModLoc is the variable to tell whether it is warm boot or cold boot */
/* NEW_BOOT */
#if 1
#else
	BridgeModeLoc = (void *) (ptr_boot_config->RamSize + ptr_boot_config->RamStart - (64 * 1024)  - 0xC );
#endif

#ifndef SOFTWARE_QUOTING
/*  initialize the micro code */
	if (InitMicroCode() == 0)
	{
		printf("Fails to initialize microcode. Wrong version.\n");
		while(1);
	}
	printf("Microcode quoting enabled\n");
#else
	printf("Software quoting enabled\n");
#endif /* SOFTWARE_QUOTING */

/* initialize the timer */
	initialize_system_timer ();

	determine_flash_types();

	if (initialize_uim_controller() == -1) 
		while(1);
	SendModemCommand();

/*  on smc there might be a modem also. So send AT and wait for Ok.if Ok 
		is recvd then modem is present else absent although it might be off.*/

	SMCForeground(TRUE);

	printf ("\r\n\r\n\r\n\r\nFirewall Version : %s\r\n", VersionDate.Version);
	printf ("Dated : %s\r\n\r\n\r\n", VersionDate.Date);

	printf ("Copyright (C) 1996 Multi-Tech Systems, Inc.\r\n");
	printf ("Multi-Tech Systems, Inc., 2205 Woodale Drive\r\nMounds View, Minnesota 55112, USA.\r\n");

	SetErrorVec(); /* sets the cpm error vector */

	available_dram = (ptr_boot_config->RamSize - code_stack_size - rmon_data_and_vect_table_size) ;
	printf ("\n\n\rOperating with %d K DRAM for device drivers, applications and stacks\r",
	          (int) (available_dram/1024)) ;

#if 0
	printf ("Ram size : %08X, code stack size : %08X, RMON : %08X\n",
	         ptr_boot_config->RamSize,
				code_stack_size,
				rmon_data_and_vect_table_size) ;
#endif

/* All routers will be pre programmed to have a unique ethernet address. But
	this can be overridden by initalizing it in the config */

	PtrToIniFile = (char * )&lsl.port[0].rfc1213_ifEntry.ifPhysAddress;

#if PROXY_SERVER
#else
	init_ipx_router_network((char *)ptr_boot_config->EthernetAddr);
#endif

	for(i=0;i<6;i++)
		ethernet_address[i] = PtrToIniFile[i] = ptr_boot_config->EthernetAddr[i];

/* Naveen on 20/06/1998 ... */
   /* Added to intialize 'seed ' which will be used to compute the 
      random number */
      srand(lsl.port[0].rfc1213_ifEntry.ifPhysAddress._ushort);
/* ... Naveen on 20/06/1998 */

/* We cannot use the config file although presently uncompressed from the
	flash.this is because strtok() is used to get tokens. this puts a null
	after the token.if it is in flash it cannot write. hence we copy it into
	dram. NOTE:- if any other function uses strtok when processing the 
	configuration string this will create havoc.
*/
	PtrToIniFile = calloc(50 * 1024,1);
	if(PtrToIniFile == (char *) 0)
	{
		printf("\n\r malloc failed for ini file \n\r");
		return;
	}
/* just copy the config file completely to dram */

	TmpCharPtr = (char *)tmplong;
	TmpPtrToIniFile= PtrToIniFile;
	while(*TmpCharPtr)
		(*TmpPtrToIniFile++) = (*TmpCharPtr++);

	if (initialize_nvram ((ULONG) NULL,(ULONG) PtrToIniFile) == FAIL)
	{
		printf ("\n\rNVRAM Failed to initialize properly\r\n");
		return;
	}
	free(PtrToIniFile);
		
	printf ("\n\rNVRAM Initialized\r\n");

	/* in lsl section lsl total buffer size tells about the maximum amount
	of memory that can be allocated to the different device drivers (ethernet 
	& ppp ports ). The mtu specified in the lsl section is used to caluculate
	the number of buffers that be allocated equally to all the different
	ports. lsl maintains these buffers as device driver buffers. freeing these
	and allocating is thro device_driver_free and device_driver_malloc().
	*/

	if (lsl_control (INITIALIZE_BUFFER_CLASS,(ULONG) NULL) == FAIL)
		{
		return;
		}

	printf ("Buffers Initialized\r\n");

/* Sachin 07/12/1996 */

	calculate_crc_table () ;
	init_flash_write_scheduler () ;
	printf ("Flash write scheduler initialized\n") ;

/* Sachin 07/12/1996 */
#if 0
/* Naveen 3/5/1998 ... */
   if (!init_ethernet_address_for_internet_lan())
      return;
/* ... Naveen 3/5/1998 */
#endif

	if (initialize_routerware_software (&routerware_device_drivers[0]) == FAIL)
		{
		return;
		}

	printf ("Device Drivers Initialized\r\n");


	if (initialize_lsl (CLOCK_TICKS_PER_SECOND) == FAIL)
		{
		printf ("LSL Failed To Initialize Properly");

		return;
		}

	printf ("LSL Initialized\r\n");

	if (initialize_routerware_software (&routerware_protocol_software[0]) == FAIL)
		{
		return;
		}

	enable_tx_rx();

#if 0
#if STATUS_DEBUG
   register_debugger(MyReset, "boot");
#endif
#endif   
#if 0
/* Imran 22.3.99 */
#if USER_EVENT_LOG
	init_user_log();
	printf("User Events log inited\n\r");
#endif
/* Imran 22.3.99 */

/* Imran 7.4.99 */
#if EVENT_LOG
	init_log();
	printf("Events log inited\n\r");
	write_log(LOG_EVENT_LOG_INIT, (BYTE) 0);  /* Imran */
#endif
/* Imran 7.4.99 */
#endif

	FIREWALL_IS_UP = TRUE; /* Added by Ravi on 02 Nov 1999 */

	operating_system ();


/*	getch ();*/
}

#ifdef SOFTWARE_QUOTING
	/* Vidy 17/10/96 */
extern		CheckAndRegainInterrupts();	/* somehow we loose ints */
#endif

/****************************************************************************/
extern ULONG old_timer_ulong, lsl_timer_ulong ;
void operating_system (void)
{
	USHORT num_of_calls = 0;
/*sri temp */	ULONG timer_for_user_log = 0,ind=0; /* Imran 22.3.99 */
	InitializationDone = 1;

	*(ULONG *)0xff000010 = 0xFF;	/* Turn off Fail LED */
/* Sachin 20/01/1997 */
	old_timer_ulong = lsl_timer_ulong ;

	do
	{
			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;
/* added By Ravi */
		   poll_for_packet_received_on_ethernet (TRUE);
/* added By Ravi */
			poll_for_packet_received (TRUE);

#if 0		/* sri temp */
						/* Imran 22.3.99 */
			if(++timer_for_user_log == 0x7fff)
			{
			   switch(ind)
				{
					case 0 :
						write_user_log(LOG_USER_EVENT_LOGON,"Naveed");
						ind = 1;
						break;
					case 1 :					
						write_user_log(LOG_USER_EVENT_LOGOFF,"Naveed");
						ind = 2;
						break;
					case 2 :
						write_user_log(LOG_USER_EVENT_DEFAULTER,"Naveed");
						ind = 3;
						break;
					case 3 :
						write_user_log(LOG_USER_EVENT_INVALID_LOGIN_ATTEMPT,"Naveed");
						ind = 0;
						break;
				}
				timer_for_user_log = 0;
			}
		 /* Imran 22.3.99 */
#endif
	
			if(++num_of_calls == 100){

#ifdef SOFTWARE_QUOTING
			CheckAndRegainInterrupts();
#endif

			*( (BYTE *)WatchDogServiceRegister)= 0x55;
			*( (BYTE *)WatchDogServiceRegister)= 0xAA;
				SMCForeground(FALSE);
				ChatForeground();			/* 10/11/95 Sowmya */
				serial_foreground();

				do_telnet_receives();		/* 13, July, 1996, Sanjay */

				polling_timer_interrupt ();
				num_of_calls = 0;

			}

	} while (TRUE);

}
/****************************************************************************/
/*static enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)*/
enum TEST initialize_routerware_software (ROUTERWARE_MODULE_DEFINITION *sptr_routerware_device_drivers)
{
	enum TEST return_code;

	while (sptr_routerware_device_drivers->fptr_initialization_function != NULL)
		{
		return_code = (*sptr_routerware_device_drivers->fptr_initialization_function) (CLOCK_TICKS_PER_SECOND);

		if (return_code == FAIL)
			{
			printf ("No function pointer FAILED\n");
			break;
			}

		++sptr_routerware_device_drivers;
		}

	return (return_code);
}
void enable_tx_rx(void)
{
#if PROXY_SERVER
	EnableEthTXAndRxOnSCC1(FALSE);
	EnableEthTXAndRxOnSCC2(FALSE);
#else
	EnableEthTXAndRxOnSCC1( IsBridgingEnabled() );
	EnableEthTXAndRxOnSCC2( IsBridgingEnabled() );
#endif
}


#if PROXY_SERVER
void frame_relay_inc_ticks()
{
}
#endif


int ag_get_number_of_inbound_users (USHORT port_number)
{
   return 0 ;
}

enum BOOLEAN allot_port_to_inbound_if_required(USHORT port_number)
{
   return FALSE ;
}

#if STATUS_DEBUG  
extern BYTE* DownloadFlag;
void MyReset()
{
	*DownloadFlag = WARM_BOOT_MODE;
   Reset();
}   
#endif

/*--------------------------------------------------------------------------*/
/* Added by Naveen on 9/2/1998: If we don't include telnet in the bin then
   these functions are required otherwise the following 
   functions are not required... */

#if 0
void do_telnet_receives(void)
{
   return;   
}

BYTE configuration_through_SMC_in_progress (void)
{
   return FALSE;
}

void	send_chat_pkt_to_telnet_client(BYTE *buffer_ptr, ULONG length)
{
   PARAMETER_NOT_USED(buffer_ptr);
   PARAMETER_NOT_USED(length);
}

void send_chat_pkt_to_specific_telnet_client(BYTE *buffer_ptr, ULONG length, BYTE *struct_ptr)
{
   PARAMETER_NOT_USED(buffer_ptr);
   PARAMETER_NOT_USED(length);
   PARAMETER_NOT_USED(struct_ptr);
}

/*
void close_dumbtty_connection (TELNET_CLIENT_CLASS *client_info_ptr)
{
   PARAMETER_NOT_USED(client_info_ptr);
}
*/

enum BOOLEAN is_dtty_enabled ()
{
   return FALSE;
}

USHORT call_save_buffer (BYTE *temp_ptr, BYTE *buffer)
{
   PARAMETER_NOT_USED(temp_ptr);
   PARAMETER_NOT_USED(buffer);
   return 0;
}


BYTE *CompressString (BYTE *Buffer)
{
#define YES 1
#define NO  0
	BYTE leading_blank = YES, excess_blank = NO;
	BYTE ch;
	int x=0,y=0;

	do 
	{
		ch = Buffer[x++];
		if (ch == ' ') 
		{
			if (leading_blank == NO) 
			{
				if (excess_blank == NO) 
				{
					Buffer[y++] = ch;
					excess_blank = YES;
				}
			}
		}	
		else 
		{
			leading_blank = NO;
			if (ch == 0 && excess_blank == YES) 
			{
 				Buffer[y-1] = ch;
			}
			else 
			{
				Buffer[y++] = ch;
				excess_blank = NO;
			}
		}			
	} while(ch != 0);
	return(Buffer);
#undef NO
#undef YES
}

BYTE *initialize_client_info_ptr_for_dumbtty()
{
   return NULL;
}

enum BOOLEAN is_term_server_enabled (USHORT port_number)
{
   PARAMETER_NOT_USED(port_number);
   return FALSE;
}

int init_terminal_server (USHORT port_number)
{
   PARAMETER_NOT_USED(port_number);
   return -1;
}

BYTE *net_to_str (BYTE *Addr, ULONG Address)
{
   sprintf(Addr,"%03u.%03u.%03u.%03u",(((int)(Address >> 24)) & 0xff),
		(((int)(Address >> 16)) & 0xff), (((int)(Address >> 8)) & 0xff),
		(((int)(Address)) & 0xff));

   return Addr;
}

ULONG str_to_net(BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%03u.%03u.%03u.%03u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1l);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

BYTE *to_upper_string (BYTE *in_str)
{
	BYTE *ptr = in_str;

	while (*ptr)
	{
		*ptr = (char) toupper ((int) *ptr) ;
		ptr ++ ;
	}
	return in_str ;
}


int get_max_parameter_length (BYTE *start_of_cfg)
{
	char temp[200] ;

	strncpy (temp, start_of_cfg, 160) ;

	if (strstr (temp, "PPP") != NULL)
		return (150) ;

	if (strstr (temp, "CCP") != NULL)
		return (150) ;

	if (strstr (temp, "WAN Port Modem") != NULL)
		return (255) ;

	if (strstr (temp, "ICMP Packet Types") != NULL)
		return (150) ;

	if (strstr (temp, "Frame Relay Port to DLCI") != NULL)
		return (150) ;

	if (strstr (temp, "Filter ") != NULL)
		return (150) ;

	return (100) ;
}

#endif
/* ... Added by Naveen on 9/2/1998 */






