#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#include	"..\..\rel\include\mctypes.h"
#include	"kaddr.h"
#include	"taddr.h"
#include	"faddr.h"

int time_ticks=0;

void (_interrupt far *oldtimer)(void);
void (_interrupt far timer)(void);
int	oldlevel;

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : timer																		 */
/* PURPOSE       : ISR for irq level 0.													 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE.																		 */
/*-----------------------------------------------------------------------------*/
void _interrupt far  timer()
{
   (*oldtimer)();
   time_ticks ++;
	/* Indicate EOI to 8259 */
	outp(0x20, 0x20); 
}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : set_timer																	 */
/* PURPOSE       : To modify the interrupt vector for timer in interrupt vector*/ 
/*                   table.																	 */
/* PARAMETERS    : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void set_timer(void)
{
	 int i;
	 /* enable irq level 1 */
	 oldlevel=inp(0x21);
	 i = oldlevel & ~1;
	 outp(0x21, i);

	 oldtimer=_dos_getvect(8);  /* save old interrupt vector */

	_asm cli

	 _dos_setvect(8, timer);  /* set new interrupt vector */

	_asm sti

}
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/*  FUNCTION NAME : restore_timer 															 */
/*  PURPOSE       : To restore old interrupt vector for timer						 */
/*  PARAMETER     : NONE																		 */
/* RETURN VALUE   : NONE																		 */
/*-----------------------------------------------------------------------------*/
void restore_timer(void)
{
		outp(0x21, oldlevel);

		_asm cli

     _dos_setvect(8, oldtimer);  /* set interrupt vector for timer */

		_asm sti
}
/*-----------------------------------------------------------------------------*/

     
   


		   

