/* LZV.H -- Header for LZW Variable bits compress/decompress code
** From code by Hemanth M.C. (Windows 95 Remote Control Project)
*/

#define BITS				15
#define MAX_CODE 			( ((unsigned)1 << BITS) - 1 )
#define TABLE_SIZE		((unsigned)35023)
#define TABLE_BANKS		( (TABLE_SIZE >> 8) + 1 )
#define END_OF_STREAM	256
#define BUMP_CODE			257
#define FLUSH_CODE		258
#define FIRST_CODE		259
#define UNUSED				((unsigned)-1)

struct dictionary
{
/*	unsigned code_value; */
	unsigned parent_code;
	unsigned char character;
	unsigned char code_value;
};

struct BitBufIndex {
	unsigned char *index;
	unsigned length;
	unsigned bit_offset;
};

#define DICT(i)	dict_array[i>>8][i & 0xFF]


