*********************************************************************
*   module name: rmain.68k                                          *
* modification history
*
* 25/9/95 Vidy enabled BME
* 24/10/95 Vidy added BIT 6 in LocalIO+$14 also set for MMV101 support
* 02/02/96 Vidy turned off DTR (bits 3, 4 and 5) for DTR dialing support
* 08/03/96 Vidy	redused DRAM wait states from Wait1 to Wait0
* 15/05/96 Vidy enabled S/W watchdog timer for production (Ver. 1.4.02)
* Chetan modified code to accomodate Memory Relocation
* and detecting available DRAM
*********************************************************************
*
*	TARGET: 68360 ACE
*		RAM   = $0
*		EPROM = $08000000
*
* FUNCTION: Target initialization
*
* DESCRIPTION: Sets up the hardware environment, initializes the ROM Monitor
*	      and start the ROM Monitor
*
* PSUEDO CODE
*	section S_rst_vecs
*		define initial stack pointer
*		define restart vector (start:)
*
*	section rmuser_code
*
* label= start:
*		set status register to supervisory mode INTS disabled
*
*		set up VBR to value defined in USREQU.68k
*		copy stack pointer to vector 0 in vector table
*		copy restart vector to vector 1 in vector table
*
*		initialize other target hardware
*		add other ISR address to vector table
*
*		call portinit to initialize serial port
*
*		set stack frame pointer A6 to zero
*		clear all registers
*
*		set status register to supervisory mode INTS enabled
*		system call ROMM_go
* 		
********************************************************************
	include	a360boot.inc
*
	xref	_main
	xref _DictStoragePtr
	xref data
	xref ldata

	xdef CheckBank
	xdef MemoryAlarmLEDs

*
*******************************************************************
*			--- restart Vectors ---                   *
*******************************************************************
*
	section	S_rst_vecs,,"code"	;this section is declared in
*				      		;the locate command file and
*				      		;set to the start of ROM
*
	xdef	EXCEPT		
EXCEPT:
	dc.l InitSP		;The first long after on reset should
*				;contain the initial stack pointer  
	dc.l $8	;The second long contains the address
*				;to which the uP will jump to and start
*				;program execution

******************************************************************
*			--- Initialize ---			 *
******************************************************************
*
	section	rmuser_code,,"code"		;this section is defined in 
*					;the locate command file and
*					;is located after S_rst_vecs
	xdef	__main
__main:					
*					; This is the address that the uP
*					; will jump to after a reset
	move.w	#$2700,sr		; Disable Interrupts 
	; set module base adr   
	move.l	#CPU_FC,d0
	movec	d0,DFC
	movec	d0,SFC
	move.l	#ModBaseAdr+1,d0
	moves.l	d0,MBAR

	; set PLL and clocks
	ori.w	#$4000,PLLCR
	move.b	#ClkCtl,CLKOCR
	move.b	#$F7,SYPCR

*removing RAS2DD for config1 - Needed for 16 bit
	move.w	#RAS1DD+WeSel,PEPAR

	; Reason for a 16M Page Size is discussed later
* adding NCS - found from Prasad's Boot
	move.l	#GAMX+PageSz16M+RfshEn+DWQ+RfshCnt25/NumBanks+NCS,GMR

	; program local I/O (CS4)
	move.l	#LocalIOMask+Wait6,OR4
	move.l	#LocalIO+Valid,BR4

	; We are going to change the address space for the FEPROMs
	; First FEPROM is at 128 M
	; Second FEPROM is at 128 M + 512 K
	; This is going to affect the program flow
	; So make way for the proper flow 
	; Write the machine level code into some location in DPRAM
	; Then jump to that location 
	; It would then be easier to change the PC value
	; so that it will point to 128M + locations

	move.l	#DPR_Base+$400,a7 ; Stack ptr while sizing DRAM
	move.l	#DPR_Base+$50,a0

	; If at all the Register Base is changed then
	; the code below has to be changed suitably
	; to make sure that OR0 address is right
;	move.l	#$23FC2FF8,(a0)+
;	move.l	#$00040FFF,(a0)+		;	move.l  #PortWidth8+BootAdrMask1+Wait1,OR0
;	move.w	#$1054,(a0)+			
	move.w	#$23FC,(a0)+        ; Move immediate data to absolute memory
	move.l	#PortWidth16+BootAdrMask1+Wait1,(a0)+  ; Contents that are to go into OR0
	move.l	#OR0,(a0)+   ; Address of OR0

;	move.l	#$23FC0800,(a0)+
;	move.l	#$00010FFF,(a0)+		;	move.l  #Flash1Base+Valid,BR0
;	move.w	#$1050,(a0)+			
	move.w	#$23FC,(a0)+			; Move immediate data to absolute memory
	move.l	#Flash1Base+Valid,(a0)+ ; contents that are to go into BR0
	move.l	#BR0,(a0)+  ; address of BR0

;	move.l	#$06970800,(a0)+
;	move.w	#$0000,(a0)+	 ;  add.l #Flash1Base,(a7)
	move.w	#$0697,(a0)+   ; add immediate data to memory location pointed to by A7
	move.l	#Flash1Base,(a0)+ ; Immediate data that has to be added

	move.w	#$4E75,(a0)+   ;  rts

	; jump to subroutine written at DPR_Base+$50
	move.l	#DPR_Base+$50,a0
	jsr	(a0)

	; program cs1 for 2nd flash
	move.l	#PortWidth16+BootAdrMask2+Wait1,OR1
	move.l	#Flash2Base+Valid,BR1

	; Clear Base and Option registers for the 2 DRAM Banks
	clr.l	BR2
	clr.l	OR2
	clr.l	BR3
	clr.l	OR3

	; After a poweron reset both the Ext Hrdware Reset and POW bits are set 
	; in the RSR
	btst.b	#6,RSR   		 ; check the power on reset bit
	beq	IsItWarmBoot      ; If due to hard reset (our pulling down) check
						       ; whether warm boot
	clr.b	BootModeLocationInDPRAM ; Just remove any stray value
	bra	MemoryChkRequired
IsItWarmBoot:
	cmpi.b	#$A5,BootModeLocationInDPRAM   ; whether warm boot
	bne	MemoryChkRequired

	; D6 and D7 are supposed to have the bank 1 and 2's sizes respectively
	; The only reliable place is the boot header
	; It gives info on Size1 and Size2
	move.l	#20,d0
	clr.l	d6
	move.b	Bank1SizeinBootHdr,d6  ; In terms of MB
	lsl.l	d0,d6						; So multiply by 1Meg
	clr.l	d7
	move.b	Bank2SizeinBootHdr,d7	; In terms of MB
	lsl.l	d0,d7						; So multiply by 1Meg
	bra	MemoryNotChked

MemoryChkRequired:

	; Check the First Bank
	move.l	#OR2,a1
	move.l	#BR2,a2
	bsr	CheckBank
	move.l	d0,d6   ; D6 has bank 1 size

	; Check the Second Bank
	move.l	#OR3,a1
	move.l	#BR3,a2
	bsr	CheckBank
	move.l	d0,d7   ; D7 has bank 2 size

MemoryNotChked:
	move.b	#$40,RSR  ; Clear the POW bit
	; check the memory available
	move.l	d6,d0
	add.l	d7,d0
	cmp.l	#MinDRAMSize,d0  ; Minimum memory required is 2MB
	bge	MemorySizeOK
	bsr	MemoryAlarmLEDs

MemorySizeOK:
	move.l	#$30000000,d3   ; D3 has the refresh counter period (of GMR)
				; The logic wants this to be 24 * 2 = 48 (dec)
	; check for bank 1's registers
	move.l	d6,d4
	beq	Bank1NotPopulated
	asr.l	#1,d3             ; At least 1 Bank => 48/2 = 24
	subq.l	#1,d4
	not.l	d4
	andi.l	#$0FFFF800,d4  ; Just keep Address Mask bits
	ori.l	#PageMode+DramSel+Wait0,d4 ; Set the necessary options
	move.l	d4,OR2
	; While testing memory Bank1 Base was set to 00000000 Hex
	move.l	#$00000001,BR2  ; Make BR2 and OR2 valid and Bank1 Base at 00000000 Hex

	; check for bank 2's registers
Bank1NotPopulated:
	move.l	d7,d4
	beq	Bank2NotPopulated
	asr.l	#1,d3             ; If bank 1 present => 24/2 = 12
								   ; else				  => 48/2 = 24
	add.l	d6,d4
	move.l	d6,d0
	bset.l	#0,d0            ; Valid bit of BR3
	subq.l	#1,d4           
	not.l	d4
	andi.l	#$0FFFF800,d4		; Keep the address mask bits
	ori.l	#PageMode+DramSel+Wait0,d4	 ; Set the necessary options 
	move.l	d4,OR3
	move.l	d0,BR3	

Bank2NotPopulated:
	and.l	#$00FFFFFF,GMR  ; First remove Refresh counter value
	or.l	d3,GMR           ; New refresh counter value depending on banks

	; Hope both banks have matching modules
	; If not either of them must be barren
	cmp.l	d6,d7
	bgt.l	Bank1Poor
	move.l	d6,d0
	bra	SetPageSize
Bank1Poor:
	move.l	d7,d0
SetPageSize:
	andi.l	#$FFE3FFFF,GMR	; Remove old page size value

	; Size          PGS2   PGS1   PGS0
	; 0010 0000	0      0      1			1 MB
	; 0020 0000	0      1      0			2 MB
	; 0040 0000	0      1      1			4 MB
	; 0080 0000	1      0      0			8 MB
	; 0100 0000	1      0      1			16 MB
	; 0200 0000	1      1      0			32 MB
	; 0400 0000	1      1      1			64 MB

	; The position of the set bit has to be found out
	clr.l d1
DidNotFindSetBit:
	btst	#0,d0
	bne	FoundSetBit
	addq.l	#1,d1
	asr.l	#1,d0
	bra	DidNotFindSetBit

FoundSetBit:
	sub.l	#19,d1
	move.l	#18,d2
	lsl.l	d2,d1
	or.l	d1,GMR

***** NEEDS rework
	move.l	#GAMX+PageSz1M+RfshEn+DWQ+RfshCnt25/NumBanks+NCS,GMR

	; Store these sizes in known portions in memory
	move.l	#0,Bank1BasePtr ; Bank1 Base
	move.l	d6,Bank1SizePtr  ; Bank1 Size
	move.l	d6,Bank2BasePtr  ; Bank2 Base
	move.l	d7,Bank2SizePtr  ; Bank2 Size

	; Store the boot mode flag in the DRAM
	; b'cos DPRAM area is being flushed
	move.b	BootModeLocationInDPRAM,BootModeLocationInRAM
	move.l	#DPR_Base,a0  ; Now clear the system RAM (Dual Port RAM)
	move.l	#$3FF,d0   ; For 4K long words i.e from DPR_Base to RBase area
ClearSystemRAM:
	clr.l	(a0)+
	dbf	d0,ClearSystemRAM

	; Reset the Communications Processor
	move.w	#$8001,CR

	movea.l d6,a7			; D6 has Bank 1 Size
	adda.l	d7,a7			; D7 has Bank 2 Size
	suba.l	#$4,a7			; Now stack pointer is pointing
					; to the end of DRAM

*************************************************************
*	HARDWARE INITIALIZATION  
*************************************************************


	move.l	#InitVBR,a0		; get location of VBR
	movec	a0,vbr				; setup the vbr
	lea	EXCEPT(pc),a1		; load reset vectors from PROM to EVT
	move.l	(a1),(a0)+		; load the stack ptr
	lea	__main(pc),a1		; load reset vector
	move.l	a1,(a0)+		; load the reset vector

	move.w	#$740,SDCR		; SDMA 7-64
	move.l	#$C0,PBPAR		; enable SMCTxD1 & SMCRxD1, PB4 = SCC4 EN
	move.w	#$FFFF,PAPAR	; Port A - dedicated on-chip peripheral pins
	move.w	#$0550,PCSO	; Port C - Enable CTS for all SCCs
	move.w	#$0000,PCDIR		
	move.w	#$000F,PCPAR	; Port C - Enable RTS for all SCCs

	move.l	#$E7,LocalIO		; Setup level 1 Ethernet Interface chip
	move.l	#$FE,LocalIO+$10	; Fail LED turned on

	move.l	#$FF,LocalIO+$14	; DTR and CLock Select

**************************************************************
*	CLEAR ALL REGISTERS                                  *
**************************************************************

;	movea.l #DramBootData,a5
	; A7 has DRAM end address - 4
	; We want Global data base in A5
	; Also Data Segment size exceeds 32K
	; Now compiler starts making negative offsets
	; Hence push a5 32K further
	; Hence add 32K to A5
	movea.l	a7,a5
	adda.l	#32768,a5
	suba.l	#DRAMBootDataStartOffsetFromEnd,a5

	move.l	a5,d0
	add.l	#ldata,d0
	; Reserve some 100 bytes
	add.l	#100,d0
	lsr.l	#2,d0    ; These 2 steps : in order to make
	lsl.l	#2,d0    ; the pointer address divisible evenly by 4
	move.l	d0,_DictStoragePtr-data(a5)

	movea.l	#0,a6		; this register is used as the stack frame
							; pointer, set  to zero for XDB
	movea.l	#0,a4		;
	movea.l	#0,a3		;
	movea.l #0,a2		;
	movea.l #0,a1		;
	movea.l #0,a0		;
	clr.l	d7		;
	clr.l	d6		;
	clr.l	d5		;
	clr.l	d4		;
	clr.l	d3		;
	clr.l	d2		;
	clr.l	d1		;
	clr.l	d0		;

	move.w	#$2000,sr		; This is the last thing .

	bsr	_main			   ; now we can go to the main booter code
loop:
	bra.s	loop				; should never reach this code



	; Algorithm : CheckBank
	; Normal access during checking
	; On return D0 will have the bank size
	; D1,D2,D3 and D4 are used
	; Do not use D6 and D7
	; To detect 1 MB, the page size is to be 256K
	; To detect 2 MB, the page size is to be 512K
	; To detect 4 MB, the page size is to be 1M
	; And so on and so forth
	; But we cannot set the page size to the apropriate one
	; This is like :
	; "Which came first ?. The Hen or the Egg" situation
	; So we have set the page size to 16M
	; Column address will be on A13-A2
	; Row address will be on A25-A14
	; The multiplexed address will be on A13-A2
	; Due to hardware problems 2MB, 8MB and 32MB
	; cannot be detected properly
	; For a 1MB module replications occur at 0,2K,4K,6K,8K,10K,12K and 14K
	;													  16K,18K,20K,.................	
	; For a 4MB module replications occur at 0,4K,8K and 12K
	;													  16K,20K,24K and 28K	
	; For a 16MB module replications occur at 0 and 8K
	;													  16K and 24K
	; For a 64MB module there is no such thing
	; Write at 0  --> A
	; Read from 0 --> B
	; If a match occurs .i.e. if A = B there is at least some memory
	; Read from 2K --> C,4K --> D and 8K --> E
	; If B = C, (512KB or 1MB)
	; If B = D, (2MB or 4MB)
	; If B = E, (8MB or 16MB)
	; Else (32MB or 64MB)
	; The Left side ones are not supported at least for the
	; time being But the Right side ones are
	; Do not call this during WARM Boot

CheckBank
	move.l	#DramSel+Wait1+$0C000000,(a1)  ; Options Register
													  ; Assume a max of 64 MB mask
	move.l	#$1,(a2)  ; Base Register (set the valid bit for the bank)
						  ; Set the base at location 0

	; wait for some time after enabling the bank
	move.l	#$FF,d0
WaitPosition:
	dbf	d0,WaitPosition

	move.l	#$ABCD1234,d1		; Pattern to be written to 0
	move.l	d1,$0
	nop
	nop
	nop
	move.l	$0,d2
	cmp.l	d2,d1
	bne	NoMemory
	
	; d1 has contents of location 0
	move.l	$800,d2		; Read from 2KB location
	move.l	$1000,d3	; Read from 4KB location
	move.l	$2000,d4	; Read from 8KB location

	move.l	#$00100000,d0  ; Initial value 1MB
	cmp.l	d1,d2
	beq	GotMemory
	lsl.l	#2,d0				 ; 4MB
	cmp.l	d1,d3
	beq	GotMemory
	lsl.l	#2,d0				 ; 16MB
	cmp.l	d1,d4
	beq	GotMemory
	lsl.l	#2,d0	 			 ; 64MB
	bra	GotMemory		
NoMemory:
	clr.l	d0
GotMemory:
	clr.l	(a2)  ; Make this bank invalid for now
	clr.l	(a1)  : clear all the options
	rts


MemoryAlarmLEDs
	move.l	#LocalIO+$10,a0    ; A0 has Fail LED address

	move.l	#$FFFF,d0
OnOff:
	move.l	#$FF,(a0)     ; Turn Off Fail LED
OffState:
	dbf	d0,OffState

	move.l	#$FE,(a0)     ; Turn On Fail LED
OnState:
	dbf	d0,OnState

	bra	OnOff
	rts


	end
