// addrange.cpp : implementation file
//	Added by Sreelu

#include "stdafx.h"
#include "procon.h"
#include "addrange.h"
#include "usrdata.h"
#include "maskdot.h"
#include "dot.h"
#include "authrnge.h"
#include "userfilt.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL m_DBChanged;
extern int SelectedDefault;
extern BOOL IsStrNumericAndValid(LPCSTR String);
static LPCSTR AddMsgHdr = "IP Address Entry";
static LPCSTR AppMsgHdr = "Application Port Entry";
/////////////////////////////////////////////////////////////////////////////
// addrange dialog


addrange::addrange(CWnd* pParent /*=NULL*/)
	: CDialog(addrange::IDD, pParent)
{
	//{{AFX_DATA_INIT(addrange)
	m_ActionEdit = FALSE;
	m_LowerRangeStr = "";
	m_UpperRangeStr = "";
	m_ProtocolStr = "";
	//}}AFX_DATA_INIT
}

void addrange::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(addrange)
	DDX_Control(pDX, IDC_UP_ADDRESS, m_UpperRangeCtrl);
	DDX_Control(pDX, IDC_LOW_ADDRESS, m_LowerRangeCtrl);
	DDX_Control(pDX, IDC_PROTOCOL, m_ProtoWndCtrl);
	DDX_Control(pDX, IDC_PROTOCOL_COM, m_ProtocolCtrl);
	DDX_Text(pDX, IDC_LOW_ADDRESS, m_LowerRangeStr);
	DDX_Text(pDX, IDC_UP_ADDRESS, m_UpperRangeStr);
	DDX_CBString(pDX, IDC_PROTOCOL_COM, m_ProtocolStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(addrange, CDialog)
	//{{AFX_MSG_MAP(addrange)
	ON_BN_CLICKED(IDCANCEL, OnBtnCancel)
	ON_BN_CLICKED(IDOK, OnBtnOk)
	ON_BN_CLICKED(IDC_HELP, OnBtnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// addrange message handlers

BOOL addrange::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();
	
	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if(SelectedDefault)
		SetDialogForAPP();
	else
		SetDialogForIP();
	
	CenterWindow() ;
	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void addrange::OnBtnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_ADD_RANGE, HELP_CONTEXT);
}

void addrange::OnBtnCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}

void addrange::OnBtnOk()
{
	// TODO: Add your control notification handler code here
	BOOL RetVal;

	if(SelectedDefault)
		RetVal = UpdateAPPStructure();
	else
		RetVal = UpdateIPStructure();

	if(!RetVal)
		return;
	
	m_DBChanged = TRUE;
	CDialog::OnOK();
}

void addrange::SetDialogForIP()
{
	m_ProtoWndCtrl.ShowWindow(FALSE);	
	m_ProtocolCtrl.ShowWindow(FALSE);	

	m_ProtoWndCtrl.EnableWindow(FALSE);	
	m_ProtocolCtrl.EnableWindow(FALSE);	

	if(m_ActionEdit)
	{
		UpdateData (TRUE) ;
		UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	 	Authrnge *pParent = (Authrnge *) GetParent() ;
		IPDEFAULTS *pIPDefault;

		int nIndex = pParent->m_Default->m_IPAddListCtrl.GetCurSel();
		pIPDefault = (IPDEFAULTS *)pParent->m_Default->m_IPAddListCtrl.GetItemDataPtr (nIndex);

		m_LowerRangeStr = pIPDefault->lower_address;
		m_UpperRangeStr = pIPDefault->upper_address;
	}
}

void addrange::SetDialogForAPP()
{
	char szRHS[10];
	UpdateData (TRUE) ;

	m_ProtoWndCtrl.ShowWindow(TRUE);
	m_ProtocolCtrl.ShowWindow(TRUE);	

	m_ProtoWndCtrl.EnableWindow(TRUE);	
	m_ProtocolCtrl.EnableWindow(TRUE);	
	m_ProtocolCtrl.SetCurSel(0);

	if(m_ActionEdit)
	{
		UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	 	Authrnge *pParent = (Authrnge *) GetParent() ;
		APPDEFAULTS *pAppDefault;

		int nIndex = pParent->m_Default->m_AppListCtrl.GetCurSel();
		pAppDefault = (APPDEFAULTS *)pParent->m_Default->m_AppListCtrl.GetItemDataPtr (nIndex);

		sprintf(szRHS, "%d", pAppDefault->lower_port);
		m_LowerRangeStr = szRHS;
		sprintf(szRHS, "%d", pAppDefault->upper_port);
		m_UpperRangeStr = szRHS;

		if(pAppDefault->protocol == TCP_PROTOCOL)
			m_ProtocolCtrl.SetCurSel(0);
		if(pAppDefault->protocol == UDP_PROTOCOL)
			m_ProtocolCtrl.SetCurSel(1);
		if(pAppDefault->protocol == TCP_UDP_PROTOCOL)
			m_ProtocolCtrl.SetCurSel(2);
	}
}
		
BOOL addrange::UpdateIPStructure()
{
	char string[100];
	int add1, add2, add3, add4;
	unsigned long Addrfrom, Addrto;
	CDotDecimal DotValue;
	IPDEFAULTS *pIPDefault;
  	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	Authrnge *pParent = (Authrnge *)	GetParent();

	UpdateData(TRUE);
	int nIndex = pParent->m_Default->m_IPAddListCtrl.GetCurSel();

	if(!m_ActionEdit)
		pIPDefault = (IPDEFAULTS *) malloc (sizeof(IPDEFAULTS));
	else
		pIPDefault = (IPDEFAULTS *)pParent->m_Default->m_IPAddListCtrl.GetItemDataPtr (nIndex);

	strcpy(pIPDefault->lower_address, m_LowerRangeStr);
	strcpy(pIPDefault->upper_address, m_UpperRangeStr);

	DotValue = m_LowerRangeStr;
	if(!strcmp(DotValue,ZeroIPAddress) || DotValue.IsEmpty() || !DotValue.IsValid())
	{				
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
			(LPCSTR) AddMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_LowerRangeCtrl.SetFocus();
		return FALSE;
	}

	DotValue = m_UpperRangeStr;
	if(!strcmp(DotValue,ZeroIPAddress) || DotValue.IsEmpty() || !DotValue.IsValid())
	{				
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
			(LPCSTR) AddMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_UpperRangeCtrl.SetFocus();
		return FALSE;
	}

	get_ip_address(m_LowerRangeStr, &Addrfrom);
	get_ip_address(m_UpperRangeStr, &Addrto);
	if(Addrfrom > Addrto)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Check the Lower & Upper Address Ranges Entered",
			(LPCSTR) AddMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_LowerRangeCtrl.SetFocus();
		return FALSE;
	}

	if(CheckForIPDuplicates(pIPDefault))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Entry Already Exist",
			(LPCSTR) AddMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}
	
	wsprintf(string, "%s\t%s",pIPDefault->lower_address, pIPDefault->upper_address);

	if(!m_ActionEdit)
		nIndex = pParent->m_Default->m_IPAddListCtrl.AddString(string);
	else
	{
		pParent->m_Default->m_IPAddListCtrl.DeleteString(nIndex);
		pParent->m_Default->m_IPAddListCtrl.InsertString(nIndex, string);
	}
	
  	pParent->m_Default->m_IPAddListCtrl.SetItemDataPtr (nIndex, pIPDefault);
	pParent->m_Default->m_IPAddListCtrl.SetCurSel(nIndex);
	return TRUE;
}

BOOL addrange::UpdateAPPStructure()
{
	char string[100], szRHS[20];
	APPDEFAULTS *pAPPDefault;
  	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	Authrnge *pParent = (Authrnge *)	GetParent();

	UpdateData(TRUE);
	int nIndex = pParent->m_Default->m_AppListCtrl.GetCurSel();

	if(!m_ActionEdit)
		pAPPDefault = (APPDEFAULTS *) malloc (sizeof(APPDEFAULTS));
	else
		pAPPDefault = (APPDEFAULTS *)pParent->m_Default->m_AppListCtrl.GetItemDataPtr(nIndex);

	pAPPDefault->lower_port	= atoi((LPCSTR)m_LowerRangeStr);
	pAPPDefault->upper_port = atoi((LPCSTR)m_UpperRangeStr);

	int protocol = m_ProtocolCtrl.GetCurSel();
	if(protocol == 0)	
		pAPPDefault->protocol = TCP_PROTOCOL;
	if(protocol == 1)	
		pAPPDefault->protocol = UDP_PROTOCOL;
	if(protocol == 2)	
		pAPPDefault->protocol = TCP_UDP_PROTOCOL;

	if(!IsStrNumericAndValid(m_LowerRangeStr))
	{

		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) AppMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_LowerRangeCtrl.SetFocus();
		return FALSE;
	}

	if(!IsStrNumericAndValid(m_UpperRangeStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) AppMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_UpperRangeCtrl.SetFocus();
		return FALSE;
	}

	if(pAPPDefault->lower_port > pAPPDefault->upper_port)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Check the Port Ranges Entered",
			(LPCSTR) AppMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_LowerRangeCtrl.SetFocus();
		return FALSE;
	}

	if(CheckForAPPDuplicates(pAPPDefault))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Entry Already Exist",
			(LPCSTR) AppMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return FALSE;
	}
	
	if(pAPPDefault->protocol == TCP_PROTOCOL)
		wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "TCP");
	if(pAPPDefault->protocol == UDP_PROTOCOL)
		wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "UDP");
	if(pAPPDefault->protocol == TCP_UDP_PROTOCOL)
		wsprintf(string, "%d\t%d\t%s",pAPPDefault->lower_port, pAPPDefault->upper_port, "TCP & UDP");
	
	if(!m_ActionEdit)
		nIndex = pParent->m_Default->m_AppListCtrl.AddString(string);
	else
	{
		pParent->m_Default->m_AppListCtrl.DeleteString(nIndex);
		pParent->m_Default->m_AppListCtrl.InsertString(nIndex, string);
	}

  	pParent->m_Default->m_AppListCtrl.SetItemDataPtr (nIndex, pAPPDefault);
	pParent->m_Default->m_AppListCtrl.SetCurSel(nIndex);
	return TRUE;
}

BOOL addrange::CheckForIPDuplicates(IPDEFAULTS *pIPDefault)
{
	IPDEFAULTS *pIPParent;
	unsigned long Addrfrom, Addrto, AddrParentfrom, AddrParentto;
  	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	Authrnge *pParent = (Authrnge *) GetParent() ;
	
	int TotEntry = pParent->m_Default->m_IPAddListCtrl.GetCount();
	int Index = pParent->m_Default->m_IPAddListCtrl.GetCurSel();
	for(int i = 0; i < TotEntry; i++)
	{
		if(m_ActionEdit && i == Index)
			continue;

		pIPParent = (IPDEFAULTS *)	pParent->m_Default->m_IPAddListCtrl.GetItemDataPtr(i);
		get_ip_address(pIPDefault->lower_address, &Addrfrom);
		get_ip_address(pIPDefault->upper_address, &Addrto);
		get_ip_address(pIPParent->lower_address, &AddrParentfrom);
		get_ip_address(pIPParent->upper_address, &AddrParentto);
		
		if((Addrfrom >= AddrParentfrom && Addrfrom <= AddrParentto) || (Addrto >= AddrParentfrom && Addrto <= AddrParentto))
			return TRUE;

		if((AddrParentfrom >= Addrfrom && AddrParentfrom <= Addrto) || (AddrParentto >= Addrfrom && AddrParentto <= Addrto))
			return TRUE;
	}
	return FALSE;		
}

BOOL addrange::CheckForAPPDuplicates(APPDEFAULTS *pAPPDefault)
{
	APPDEFAULTS *pAPPParent;
  	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
//	Authrnge *pParent = (Authrnge *) GetParent() ;
	
	int TotEntry = pParent->m_Default->m_AppListCtrl.GetCount();
	int Index = pParent->m_Default->m_AppListCtrl.GetCurSel();
	for(int i = 0; i < TotEntry; i++)
	{
	  if(m_ActionEdit && i == Index)
	  	continue;

	  pAPPParent = (APPDEFAULTS *)	pParent->m_Default->m_AppListCtrl.GetItemDataPtr(i);

	  if((pAPPDefault->protocol == pAPPParent->protocol) || (pAPPDefault->protocol == TCP_UDP_PROTOCOL))
	  {	
		if(((pAPPDefault->lower_port >= pAPPParent->lower_port) && (pAPPDefault->lower_port <= pAPPParent->upper_port))
			|| ((pAPPDefault->upper_port >= pAPPParent->lower_port) && (pAPPDefault->upper_port <= pAPPParent->upper_port)))
			return TRUE;

		if(((pAPPParent->lower_port >= pAPPDefault->lower_port) && (pAPPParent->lower_port <= pAPPDefault->upper_port))
			|| ((pAPPParent->upper_port >= pAPPDefault->lower_port) && (pAPPParent->upper_port <= pAPPDefault->upper_port)))
			return TRUE;
	  }	
	}
	return FALSE;		
}
