// authrnge.cpp : implementation file
//	Added by Sreelu

#include "stdafx.h"
#include "procon.h"
#include "authrnge.h"
#include "addrange.h"
#include "usrdata.h"
#include "dot.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL m_DBChanged;
int SelectedDefault;
LPCSTR UserDatabaseSectionHeader = "USER Database";
static LPCSTR DeleteIPMsgHdr = "IP Address Delete";
static LPCSTR DeleteAPPMsgHdr = "Application Delete";
/////////////////////////////////////////////////////////////////////////////
// Authrnge dialog


Authrnge::Authrnge(CWnd* pParent /*=NULL*/)
	: CDialog(Authrnge::IDD, pParent)
{
	//{{AFX_DATA_INIT(Authrnge)
	m_AppListStr = "";
	m_IPAddListStr = "";
	//}}AFX_DATA_INIT
	Create (IDD, NULL);
}

void Authrnge::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Authrnge)
	DDX_Control(pDX, IDC_APP_LIST, m_AppListCtrl);
	DDX_Control(pDX, IDC_IPADD_LIST, m_IPAddListCtrl);
	DDX_LBString(pDX, IDC_APP_LIST, m_AppListStr);
	DDX_LBString(pDX, IDC_IPADD_LIST, m_IPAddListStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(Authrnge, CDialog)
	//{{AFX_MSG_MAP(Authrnge)
	ON_BN_CLICKED(IDC_BTNAPP_ADD, OnBtnappAdd)
	ON_BN_CLICKED(IDC_BTNAPP_DELETE, OnBtnappDelete)
	ON_BN_CLICKED(IDC_BTNAPP_EDIT, OnBtnappEdit)
	ON_BN_CLICKED(IDC_BTNIP_ADD, OnBtnipAdd)
	ON_BN_CLICKED(IDC_BTNIP_DELETE, OnBtnipDelete)
	ON_BN_CLICKED(IDC_BTNIP_EDIT, OnBtnipEdit)
	ON_BN_CLICKED(IDCANCEL, OnCancel)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDOK, OnOk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Authrnge message handlers

BOOL Authrnge::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

// ADD, EDIT, DELETE
	if (!AddIPBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (AddIPBitmapBtn.SubclassDlgItem (IDC_BTNIP_ADD, this));
	AddIPBitmapBtn.SizeToContent();

	if (!EditIPBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (EditIPBitmapBtn.SubclassDlgItem (IDC_BTNIP_EDIT, this));
	EditIPBitmapBtn.SizeToContent();

	if (!DeleteIPBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (DeleteIPBitmapBtn.SubclassDlgItem (IDC_BTNIP_DELETE, this));
	DeleteIPBitmapBtn.SizeToContent();

	if (!AddAPPBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (AddAPPBitmapBtn.SubclassDlgItem (IDC_BTNAPP_ADD, this));
	AddAPPBitmapBtn.SizeToContent();

	if (!EditAPPBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (EditAPPBitmapBtn.SubclassDlgItem (IDC_BTNAPP_EDIT, this));
	EditAPPBitmapBtn.SizeToContent();

	if (!DeleteAPPBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (DeleteAPPBitmapBtn.SubclassDlgItem (IDC_BTNAPP_DELETE, this));
	DeleteAPPBitmapBtn.SizeToContent();

	char szRHS[50], string[50];
	int TabStops1[] = {100};
	int TabStops2[] = {70,120};

	m_AppListCtrl.SetTabStops (2, (LPINT) &TabStops2);
	m_IPAddListCtrl.SetTabStops (1, (LPINT) &TabStops1);

	CenterWindow() ;
//	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void Authrnge::OnBtnappAdd()
{
	// TODO: Add your control notification handler code here
	addrange AddRange(this);
	AddRange.m_ActionEdit = FALSE;
	
	SelectedDefault = SELECT_APP;
	AddRange.DoModal();
	return;
}

void Authrnge::OnBtnappDelete()
{
	// TODO: Add your control notification handler code here
	APPDEFAULTS *pAPPDefault;

	if(m_AppListCtrl.GetCount() == 0)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Application List is Empty",
			(LPCSTR) DeleteAPPMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}
	
	int nIndex = m_AppListCtrl.GetCurSel();
	if(nIndex == LB_ERR)		
	{
		MessageBox("Select Application Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	
	pAPPDefault = (APPDEFAULTS *)m_AppListCtrl.GetItemDataPtr (nIndex);

	m_AppListCtrl.DeleteString(nIndex);

	m_IPAddListCtrl.SetCurSel(0);
	m_AppListCtrl.SetCurSel(0);
	free (pAPPDefault);
	m_DBChanged = TRUE;
}

void Authrnge::OnBtnappEdit()
{
	// TODO: Add your control notification handler code here
	addrange AddRange(this);
	AddRange.m_ActionEdit = TRUE;

	if(m_AppListCtrl.GetCount() == 0)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Application List is Empty",
			(LPCSTR) DeleteAPPMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}

/* Added by Ravi on 14/09/1999 ... */	 
	int nIndex = m_AppListCtrl.GetCurSel();
	if(nIndex == LB_ERR)		
	{
		MessageBox("Select Application Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
/* ... Added by Ravi on 14/09/1999 */	 
	
	SelectedDefault = SELECT_APP;
	AddRange.DoModal();
	return;
}

void Authrnge::OnBtnipAdd()
{
	// TODO: Add your control notification handler code here
	addrange AddRange(this);
	AddRange.m_ActionEdit = FALSE;

	SelectedDefault = SELECT_IP;
	AddRange.DoModal();
	return;
}

void Authrnge::OnBtnipDelete()
{
	// TODO: Add your control notification handler code here
	IPDEFAULTS *pIPDefault;

	if(m_IPAddListCtrl.GetCount() == 0)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "IP Address List is Empty",
			(LPCSTR) DeleteIPMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}
	
/* Added by Ravi on 14/09/1999 ... */	 
	int nIndex = m_IPAddListCtrl.GetCurSel();
	if(nIndex == LB_ERR)		
	{
		MessageBox("Select Address Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
/* ... Added by Ravi on 14/09/1999 */	 
	
	pIPDefault = (IPDEFAULTS *)m_IPAddListCtrl.GetItemDataPtr (nIndex);

	m_IPAddListCtrl.DeleteString(nIndex);

	m_IPAddListCtrl.SetCurSel(0);
	m_AppListCtrl.SetCurSel(0);
	free (pIPDefault);
	m_DBChanged = TRUE;
}

void Authrnge::OnBtnipEdit()
{
	// TODO: Add your control notification handler code here
	addrange AddRange(this);
	AddRange.m_ActionEdit = TRUE;

	if (m_IPAddListCtrl.GetCount() == 0)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "IP Address List is Empty",
			(LPCSTR) DeleteIPMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return;
	}

	int nIndex = m_IPAddListCtrl.GetCurSel();
	if(nIndex == LB_ERR)		
	{
		MessageBox("Select Address Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	
	SelectedDefault = SELECT_IP;
	AddRange.DoModal();
	return;
}

void Authrnge::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void Authrnge::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_AUTHENTICATION, HELP_CONTEXT);
}

void Authrnge::OnOk()
{
//	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

