// autodete.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "ipdetect.h"
#include "tftpif.h"
#include "autodete.h"
#include "maskdot.h"

#ifndef ULONG
#define	ULONG	unsigned long
#endif


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// #define 	AUTODETECT_TIMERID 	0xfe10

SERVER_RESPONSE_ENTRIES response_entries[MAX_NUMBER_OF_SERVERS] ;
int number_of_responses = 0 ;
BOOL DetectSuccess = FALSE ;


char obtd_host_ip_address[16] ;
extern ULONG configured_ip_address ;
extern BYTE mac_address[MAX_MAC_ADDRESS_LENGTH] ;

/////////////////////////////////////////////////////////////////////////////
// CAutodetect dialog


CAutodetect::CAutodetect(CWnd* pParent /*=NULL*/)
	: CDialog(CAutodetect::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAutodetect)
	//}}AFX_DATA_INIT

	Create(IDD,pParent);
	CenterWindow();
	ShowWindow(SW_SHOW);
  	m_bDialogCreated = FALSE ;
	m_timeout = FALSE ;
}

void CAutodetect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAutodetect)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAutodetect, CDialog)
	//{{AFX_MSG_MAP(CAutodetect)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAutodetect message handlers

void CAutodetect::OnDestroy()
{
	CDialog::OnDestroy();
	
	ReleaseCapture() ;
}

BOOL CAutodetect::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow();	
	SetCapture() ;
	m_bDialogCreated = TRUE ;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CAutodetect::ResponseReceived(void) 
{
   int ret, error_code ;
   char szBuf[50] ;

   ret = process_response_from_server (response_entries, &error_code, &number_of_responses) ;
   if (ret == -1)
   {		
//   		AfxMessageBox( "DetectSuccess is False");
		return FALSE ;
   }

   DetectSuccess = TRUE ;
   return TRUE ;
}

#if 0 /* Jo */
int CAutodetect::InitialiseSockets()
{
	int ret, flag, error_code, value = 1 ;
	char  szBuf[50]	;
	char  host_ip_address[16] ;
  	
	if ((UDPInitSocket (value, host_ip_address) == -1)) 
 	{
		return FALSE ;
	}
//	sprintf (obtd_host_ip_address, "%c.%c.%c.%c", host_ip_address[0],
//									host_ip_address[1],
//									host_ip_address[2],
//									host_ip_address[3]) ;

	get_dot_decimal_ip_address (SwapDWord(*(ULONG *)host_ip_address), obtd_host_ip_address) ;

	flag = 0 ;
	configured_ip_address = 0 ;
	strcpy ((char *)mac_address, "000000000000\0") ;
	ret = StartAutoDetection (m_hWnd, &error_code, configured_ip_address, mac_address, flag) ;  

	if (ret == -1)
	{
  	    	return FALSE ;
	}

	UINT nTimerID  = this->SetTimer(AUTODETECT_TIMERID, MAX_UDP_RESPONSE_WAIT, NULL) ;
	if(nTimerID == 0)
	{
//  	  	AfxMessageBox("Failure To Create the Timer....");
		return FALSE;
	}
	return TRUE;
}
#endif

BOOL CAutodetect::InitialiseSockets(int retry)
{
	int ret, flag, error_code, value = 1 ;

	if (!retry)
	{	
		ret = UDPInitSocket (value, obtd_host_ip_address) ;
	  	if (ret != 0)
 		{
// char tempbuf[50] ;
// sprintf (tempbuf, "%d", ret) ;
// ::MessageBox (GetSafeHwnd(), tempbuf, "Warning!!!", MB_OK | MB_ICONINFORMATION) ;

	  		 AfxMessageBox("Failed to initialize socket....");
   		 return FALSE ;
		}
	}

	flag = 0 ;
	configured_ip_address = 0 ;
	strcpy ((char *)mac_address, "000000000000\0") ;
	ret = StartAutoDetection (m_hWnd, &error_code, configured_ip_address, mac_address, flag) ;  

	if (ret == -1)
	{
			AfxMessageBox("StartAutoDetection failed") ;
  	    	return FALSE ;
	}

	if (!retry)
	{
		UINT nTimerID  = this->SetTimer(AUTODETECT_TIMERID, MAX_UDP_RESPONSE_WAIT, NULL) ;
		if(nTimerID == 0)
		{
//  		  	AfxMessageBox("Failure To Create the Timer....");
				return FALSE;
		}
	}
	UINT nRetryTimerID  = this->SetTimer(AUTODETECT_RETRY_TIMERID, MAX_UDP_RETRY_RESPONSE_WAIT, NULL) ;
	if(nRetryTimerID == 0)
	{
			return FALSE;
	}
	return TRUE;
}


void CAutodetect::TimerExpired(UINT nIDEvent)
{
	KillTimer(nIDEvent);
	m_timeout == TRUE ;
}
