// bind.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include	<string.h>
#include	"dot.h"
#include	"maskdot.h"
#include "dhcpk.h"
#include "dhcp.h"
#include "bind.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBind dialog


CBind::CBind(CWnd* pParent /*=NULL*/)
	: CDialog(CBind::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBind)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CBind::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBind)
	DDX_Control(pDX, IDC_BUTTON_ADD, m_AddBtn);
	DDX_Control(pDX, IDC_STATIC_FROM4, m_XTo);
	DDX_Control(pDX, IDC_STATIC_FROM3, m_XFrm);
	DDX_Control(pDX, IDC_STATIC_FROM2, m_RTo);
	DDX_Control(pDX, IDC_STATIC_FROM1, m_RFrm);
	DDX_Control(pDX, IDC_LIST_BIND, m_LstWnd);
	DDX_Control(pDX, IDC_BUTTON_DEL, m_DelEnd);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBind, CDialog)
	//{{AFX_MSG_MAP(CBind)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DEL, OnButtonDel)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_LBN_SELCHANGE(IDC_LIST_BIND, OnSelchangeListBind)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static	char *ErrMsgs[] =
{
	/* 0 */	"Internal error",
	/* 1 */	"No Memeory",
	/* 2 */	"No free Address to Bind!",
	/* 3 */	"Invalid IP address",
	/* 4 */	"Invalid MAC Address length (1 to 10)",
	/* 5 */	"Invalid MAC address",
	/* 6 */  "Only hexadecimal digits for MAC address",
	/* 7 */  "IP Address out of range or excluded",
	/* 8 */	"IP address already bound",
	/* 9 */	"MAC address is longer than specified",
};

void CBind::ShowErrMsg(int index)
{
	::MessageBox (GetSafeHwnd(), (LPCSTR)ErrMsgs[index],
			(LPCSTR) "Bindings", MB_OK | MB_ICONEXCLAMATION) ;
}
/////////////////////////////////////////////////////////////////////////////
// CBind message handlers

BOOL CBind::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

        //Set BitMaps

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!AddBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBitmapBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBitmapBtn.SizeToContent();


	if (!DelBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Delete bitmap");

	VERIFY (DelBitmapBtn.SubclassDlgItem (IDC_BUTTON_DEL, this));
	DelBitmapBtn.SizeToContent();


	// TODO: Add extra initialization here
	if (!((DHCP *)GetParent())->pCurGBLTag)
	{
		CDialog::OnCancel();		// Pointer to current AddrRange can't be null
		return TRUE;
	}

	//Set tabstops
	int	TabStops[] = { 70, 150};
	m_LstWnd.SetTabStops (2, (LPINT)&TabStops) ;
	AddrRangeType *pPtr;

	pPtr = ((DHCP *)GetParent())->pCurGBLTag;
	//Set the range texts
	m_RTo.SetWindowText(pPtr->HAddr);
	m_RFrm.SetWindowText(pPtr->LAddr);

	if (pPtr->XAddrList)
	{
		m_XTo.SetWindowText(pPtr->XAddrList->XHAddr);
		m_XFrm .SetWindowText(pPtr->XAddrList->XLAddr);
	}
	else
	{
		m_XTo.SetWindowText("Not defined");
		m_XFrm .SetWindowText("Not defined");
	}

	BindingType *pBind;
	pBind = pPtr->Binds;
	int count = 0;
	while(pBind)
	{
		count++;
		char szBuf[80];
		sprintf(szBuf, "%s\t%s\t%d", pBind->IPAddr,
									pBind->MacAddr, pBind->MacAddrLen);
		m_LstWnd.AddString(szBuf);
		pBind = pBind->NextNode;
	}
	m_LstWnd.SetCurSel(0);
	OnSelchangeListBind();
	if (count >= MAX_BINDINGS)
		m_AddBtn.EnableWindow(FALSE);

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBind::OnButtonAdd()
{
	// TODO: Add your control notification handler code here

	CBindAdd BndAdd(this);

	BndAdd.DoModal();
	
	if (m_LstWnd.GetCount() >= MAX_BINDINGS)
	{
		m_AddBtn.EnableWindow(FALSE);
	}
}

void CBind::OnButtonDel()
{
	// TODO: Add your control notification handler code here
	
	int	CurIndex;

	CurIndex = m_LstWnd.GetCurSel();
	if (CurIndex != LB_ERR)
	{
		//No more deletions
		m_LstWnd.DeleteString(CurIndex);
		m_AddBtn.EnableWindow(TRUE);	// we can add atleast one
	}
	if (CurIndex > 0)
		m_LstWnd.SetCurSel(CurIndex - 1);
	OnSelchangeListBind();
}

void CBind::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_BIND, HELP_CONTEXT) ;
	
}

void CBind::OnSelchangeListBind()
{
	// TODO: Add your control notification handler code here
	int	CurIndex;

	CurIndex = m_LstWnd.GetCurSel();
	if (CurIndex == LB_ERR)
	{
		//No more deletions
		m_DelEnd.EnableWindow(FALSE);
	}
	else
	{
		m_DelEnd.EnableWindow(TRUE);
	}
}

void CBind::OnOK()
{
	// TODO: Add extra validation here
	BindingType *pNewBinds, *ptmp;
	int	index, count, MacLen;
	char szBuf[80];
	char IPAdr[IP_ADDR_LEN], MacAdr[MAC_ADDR_STORE_LEN];
	DHCP *pPtr;

	pPtr = (DHCP *)GetParent();

	//Form a chain of new Bindings
	pNewBinds = NULL;
	count = m_LstWnd.GetCount();
	if (count == LB_ERR)
	{
		ShowErrMsg(0);
		goto ErrorExit;
	}
	for(index = 0; count--; index++)
	{
		if (m_LstWnd.GetText(index, szBuf) == LB_ERR)
		{
			ShowErrMsg(0);
			goto ErrorExit;
		}
		sscanf(szBuf, "%s\t%s\t%d", IPAdr, MacAdr, &MacLen);
		ptmp = (BindingType *) calloc(1, sizeof(BindingType));
		if (!ptmp)
		{
			ShowErrMsg(1);
			goto ErrorExit;
		}
		strcpy(ptmp->IPAddr, IPAdr);
		strcpy(ptmp->MacAddr, MacAdr);
		ptmp->MacAddrLen = MacLen;

		//prepend this node (it is easy)
		ptmp->NextNode = pNewBinds;
		pNewBinds = ptmp;

		continue;		//go to the next list entry

ErrorExit:
		pPtr->FreeBindings(pNewBinds);
		return;
	}

	//release all old bindings
	pPtr->FreeBindings(pPtr->pCurGBLTag->Binds);

	//Attach new bindings
	pPtr->pCurGBLTag->Binds = pNewBinds;
	
	CDialog::OnOK();
}

void	CBind::AddEntry(BindingType *pBind)
{
	char szBuf[80];
	int index;

	sprintf(szBuf, "%s\t%s\t%d", pBind->IPAddr,
									pBind->MacAddr, pBind->MacAddrLen);
	index = m_LstWnd.AddString(szBuf);
	m_LstWnd.SetCurSel(index);
	OnSelchangeListBind();

}

/////////////////////////////////////////////////////////////////////////////
//given a dot decimal IPAddress check if it is in the list of binds
//in the list box
BOOL CBind::CheckIfIPAddressBound(LPCSTR IPAddress, LPSTR retmacadr)
{
	unsigned long in_adr, t_adr;
	int count, index;
	char szBuf[80];
	char IPAdr[IP_ADDR_LEN], MacAdr[MAC_ADDR_STORE_LEN];

	count = m_LstWnd.GetCount();
	*retmacadr = 0;
	if (count == LB_ERR)
	{
		ShowErrMsg(0);
		return 0;
	}
	get_ip_address(IPAddress, &in_adr);	// conver to integer;

	for(index = 0; count--; index++)
	{
		if (m_LstWnd.GetText(index, szBuf) == LB_ERR)
		{
			ShowErrMsg(0);
			return 0;
		}
		sscanf(szBuf, "%s\t%s", IPAdr, MacAdr);	//need only ip address
		get_ip_address(IPAdr, &t_adr);	//conver to integer
		if (in_adr == t_adr) {
			strcpy(retmacadr, MacAdr);
			return index;
		}
	}
	return NO_CLASHING_ENTRY;
}

/////////////////////////////////////////////////////////////////////////////
//given a dot decimal IPAddress check if it is in the list of binds
//in the list box
BOOL CBind::CheckIfMACAddressBound(LPCSTR MacAddress, LPSTR retipadr)
{
	int count, index;
	char szBuf[80];
	char IPAdr[IP_ADDR_LEN], MacAdr[MAC_ADDR_STORE_LEN];

	*retipadr = 0;
	count = m_LstWnd.GetCount();
	if (count == LB_ERR)
	{
		ShowErrMsg(0);
		return 0;
	}

	for(index = 0; count--; index++)
	{
		if (m_LstWnd.GetText(index, szBuf) == LB_ERR)
		{
			ShowErrMsg(0);
			return 0;
		}
		sscanf(szBuf, "%s\t%s", IPAdr, MacAdr);	//need only ip address
		if (!strcmpi(MacAdr, MacAddress)) {
			strcpy(retipadr, IPAdr);
			return index;
		}
	}
	return NO_CLASHING_ENTRY;
}


/////////////////////////////////////////////////////////////////////////////
// CBindAdd dialog


CBindAdd::CBindAdd(CWnd* pParent /*=NULL*/)
	: CDialog(CBindAdd::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBindAdd)
	m_MacAdr = "";
	m_MacLen = 0;
	m_IPAdr = "";
	m_RLAdr = "";
	m_RHAdr = "";
	m_XLAdr = "";
	m_XHAdr = "";
	//}}AFX_DATA_INIT
}

void CBindAdd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBindAdd)
	DDX_Control(pDX, IDC_EDIT_MAC_LEN, m_MacLenWnd);
	DDX_Control(pDX, IDC_EDIT_MAC_ADDR, m_MacAdrWnd);
	DDX_Control(pDX, IDC_IP_ADDRESS, m_IPAdrWnd);
	DDX_Text(pDX, IDC_EDIT_MAC_ADDR, m_MacAdr);
	DDV_MaxChars(pDX, m_MacAdr, 20);
	DDX_Text(pDX, IDC_EDIT_MAC_LEN, m_MacLen);
	DDV_MinMaxInt(pDX, m_MacLen, 1, 10);
	DDX_Text(pDX, IDC_IP_ADDRESS, m_IPAdr);
	DDV_MaxChars(pDX, m_IPAdr, 15);
	DDX_Text(pDX, IDC_STATIC_FROM1, m_RLAdr);
	DDX_Text(pDX, IDC_STATIC_FROM2, m_RHAdr);
	DDX_Text(pDX, IDC_STATIC_FROM3, m_XLAdr);
	DDX_Text(pDX, IDC_STATIC_FROM4, m_XHAdr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBindAdd, CDialog)
	//{{AFX_MSG_MAP(CBindAdd)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CBindAdd::ShowErrMsg(int index)
{
	::MessageBox (GetSafeHwnd(), (LPCSTR)ErrMsgs[index],
			(LPCSTR) "Bindings", MB_OK | MB_ICONEXCLAMATION) ;
}

void CBindAdd::ShowErrMsg(LPCSTR Msg)
{
	::MessageBox (GetSafeHwnd(), (LPCSTR)Msg,
			(LPCSTR) "Bindings", MB_OK | MB_ICONEXCLAMATION) ;
}
/////////////////////////////////////////////////////////////////////////////
// CBindAdd message handlers

/////////////////////////////////////////////////////////////////////////////
//Given an address node, check if 
BOOL	CBindAdd::GetAnUnBoundIPAddress(AddrRangeType *pAdrNode, LPSTR NextAddress)
{
	unsigned long nadr, ladr, uadr, xladr, xuadr;
	char m_IPAdr[IP_ADDR_LEN], tmpbuf[MAC_ADDR_STORE_LEN];

	get_ip_address(pAdrNode->LAddr, &ladr);
	get_ip_address(pAdrNode->HAddr, &uadr);
	if (pAdrNode->XAddrList)
	{
		get_ip_address(pAdrNode->XAddrList->XLAddr, &xladr);
		get_ip_address(pAdrNode->XAddrList->XHAddr, &xuadr);
	}
	for (nadr = ladr; nadr <= uadr; nadr++)
	{
		if (xladr)
		{
			if (nadr == xladr)
			{
				nadr = xuadr;	//exclude upto upper limit
				continue;
			}
		}

		get_dot_decimal_ip_address(nadr, m_IPAdr);
		if (((CBind *)GetParent())->
				CheckIfIPAddressBound((LPCSTR)m_IPAdr, (LPSTR)tmpbuf) ==
					NO_CLASHING_ENTRY)
			break;

	}

	if (nadr > uadr)	//no more free IP address
	{
		*NextAddress = 0;
		return FALSE;
	}
	else
	{
		get_dot_decimal_ip_address(nadr, NextAddress);
		return TRUE;
	}
}

BOOL CBindAdd::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();


	//display the  range and exclusion
	DHCP *ppPtr;

	ppPtr = (DHCP *)	(GetParent()->GetParent());
	if (!ppPtr)
	{
ErrorExit:
		ShowErrMsg(0);
		CDialog::OnCancel();
		return FALSE;
	}
	ppAdrNode = ppPtr->pCurGBLTag;
	if (!ppAdrNode)
		goto ErrorExit;

	m_RLAdr = ppAdrNode->LAddr;
	m_RHAdr = ppAdrNode->HAddr;
	if (ppAdrNode->XAddrList)
	{
		m_XLAdr = ppAdrNode->XAddrList->XLAddr;
		m_XHAdr = ppAdrNode->XAddrList->XHAddr;
	}

	//set Mac addrlen to 6 which is ethernet
	m_MacLen = 6;

	//Set IP address to next unbound IP Address - UF
	char BindAddress[IP_ADDR_LEN];
	if ( !GetAnUnBoundIPAddress(ppAdrNode, BindAddress))
	{
		ShowErrMsg(2);
		CDialog::OnCancel();
		return FALSE;
	}
	m_IPAdr = BindAddress;

	m_IPAdrWnd.LimitText(15);
	m_MacAdrWnd.LimitText( 2 * MAX_MAC_ADDR_LEN);
	m_MacLenWnd.LimitText( 2);
	m_MacAdrWnd.SetFocus();	// let the mac address have the focus

	UpdateData(FALSE);
	
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void CBindAdd::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOG_BIND_ADD, HELP_CONTEXT) ;
	
}

BOOL CBindAdd::ValidEditFields()
{
	//check if IP Address out of range
	if (m_IPAdr.IsEmpty() || !m_IPAdr.IsValid())
	{
		ShowErrMsg(3);
		m_IPAdrWnd.SetFocus();
		return FALSE;
	}
	//check if length > 10
	if (m_MacLen < 1 || m_MacLen > MAX_MAC_ADDR_LEN)
	{
		ShowErrMsg(4);
		m_MacLenWnd.SetFocus();
		return FALSE;
	}
	//check if length < 2 times the macstr
	if ((m_MacLen*2) < (int) strlen(m_MacAdr))
	{
		ShowErrMsg(9);
		m_MacLenWnd.SetFocus();
		return FALSE;
	}


	//check if IP Address excluded
	if (m_MacAdr.IsEmpty())
	{
		ShowErrMsg(5);
		m_MacAdrWnd.SetFocus();
		return FALSE;
	}

	if (!IsValidHexadecimalString((LPCSTR) m_MacAdr))
	{
		ShowErrMsg(6);
		m_MacAdrWnd.SetFocus();
		return FALSE;
	}

	if ( !CheckIPAddressInRange(ppAdrNode, (LPCSTR)m_IPAdr))
	{
		ShowErrMsg(7);
		m_IPAdrWnd.SetFocus();
		return FALSE;
	}

	return TRUE;
}

void CBindAdd::OnOK()
{
	char szBuf[200];
	int	index, len;
	char szMac[MAC_ADDR_STORE_LEN];
	char tmpbuf[40];

	UpdateData(TRUE);

	// TODO: Add extra validation here
	if (!ValidEditFields())
		return;

	//Pad the LHS of MAC address with 0s if needed
	for (index = 0; index < 2*m_MacLen; index++)
		szMac[index] = '0';		//Fill 0s
	szMac[index] = 0;	//NULL terminate
	len = strlen(m_MacAdr);
	strcpy(&szMac[2*m_MacLen - len], m_MacAdr);
	_fstrupr(szMac);

	//check if IP address already bound - check only in this range
	index = ((CBind *)GetParent())->CheckIfIPAddressBound(m_IPAdr, (LPSTR)tmpbuf);
	if (index != NO_CLASHING_ENTRY)
	{
		sprintf(szBuf, "IP address %s already bound to MAC %s. \n \
Binding List entry index is %d", (LPCSTR)m_IPAdr, tmpbuf, index+1);
		ShowErrMsg((LPCSTR)szBuf);
		return;
	}
	index = ((CBind *)GetParent())->CheckIfMACAddressBound(szMac, (LPSTR)tmpbuf);
	if (index != NO_CLASHING_ENTRY)
	{
		sprintf(szBuf, "MAC address %s already bound to IP %s. \n\
Binding List entry index is %d", szMac, tmpbuf, index + 1);
		ShowErrMsg((LPCSTR)szBuf);
		return;
	}

	//Get a Bindnode and fill it up
	BindingType *pBind;

	pBind = (BindingType *)calloc(1, sizeof(BindingType));
	if (!pBind)
	{
		ShowErrMsg(1);
		return;
	}
	//Fillup this struct
	strcpy(pBind->IPAddr, m_IPAdr);
	pBind->MacAddrLen = m_MacLen;
	strcpy(pBind->MacAddr, szMac);

	//check if MAC address is already bound- DHCP Class
	char IPAddress[IP_ADDR_LEN];
	index = ((DHCP *)GetParent()->GetParent())->
							CheckIfMACAddressBound(pBind, IPAddress);
	if (index != NO_CLASHING_ENTRY)
	{

		sprintf(szBuf, "MAC address %s already bound to %s. \n\
Address range List index is %d", (LPCSTR)szMac, IPAddress, index + 1);
		free(pBind);
		ShowErrMsg((LPCSTR)szBuf);
		return;
	}

	//Addstring
	((CBind *)GetParent())->AddEntry(pBind);

	CDialog::OnOK();
}
