// dhcp.cpp : implementation file

// We assume that if any filed is present it is a valid one
// as far as the user uses only roucon to create and delete
// entries it is OK. (i.e. We don't check sanity of the cnf file)
//

#include "stdafx.h"
#include "procon.h"
#include	"dot.h"
#include "maskdot.h"
#include "dhcpk.h"
#include "dhcp.h"
#include "dhcpadt.h"
#include	"bind.h"
#include "dhcpoptn.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

LPCSTR DHCPServerSect = "DHCP";
LPCSTR DHCPErrMsgHdr = "DHCP Server - Error";
BOOL	EditBindings = 0;

/////////////////////////////////////////////////////////////////////////////
// DHCP dialog


DHCP::DHCP(CWnd* pParent /*=NULL*/)
	: CDialog(DHCP::IDD, pParent)
{
	//{{AFX_DATA_INIT(DHCP)
	m_Enable = FALSE;
	//}}AFX_DATA_INIT
	//Vidy added
	m_EditedOptionValueIndex = LB_ERR;
}

void DHCP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DHCP)
	DDX_Control(pDX, IDC_BUTTON3, m_BtnOptnEdt);
	DDX_Control(pDX, IDC_BUTTON1, m_BtnOptnAdd);
	DDX_Control(pDX, IDC_BUTTON2, m_BtnOptnRem);
	DDX_Control(pDX, IDC_STATIC_TYPE, m_OTypeWnd);
	DDX_Control(pDX, IDC_LIST1, m_OptnEdtWnd);
	DDX_Control(pDX, IDC_LIST_OPTN, m_OptnLstWnd);
	DDX_Control(pDX, IDC_STATIC_SEL_IND, m_SelIndWnd);
	DDX_Control(pDX, IDC_BUTTON_EDIT2, m_BndBtn);
	DDX_Control(pDX, IDC_LIST_XADDR, m_XAdrLst);
	DDX_Control(pDX, IDC_STATIC_OPTN_MEANS, m_LineHelp);
	DDX_Control(pDX, IDC_BUTTON_REMOVE, m_RemBtn);
	DDX_Control(pDX, IDC_BUTTON_EDIT, m_EdtBtn);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_AddBtn);
	DDX_Control(pDX, IDC_STATIC_X_LIST, m_XAdrHdrWnd);
	DDX_Control(pDX, IDC_LIST_ADR, m_AdrLstWnd);
	DDX_Control(pDX, IDC_STATIC_ADR_GRP, m_AdrGrpWnd);
	DDX_Check(pDX, IDC_CHECK_ENABLE, m_Enable);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(DHCP, CDialog)
	//{{AFX_MSG_MAP(DHCP)
	ON_LBN_SELCHANGE(IDC_LIST_ADR, OnSelchangeListAdr)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_HELP, OnButtonHelp)
	ON_LBN_SELCHANGE(IDC_LIST_OPTN, OnSelchangeListOptn)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_EDIT, OnButtonEdit)
	ON_BN_CLICKED(IDC_BUTTON_EDIT2, OnButtonBind)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeVal)
	ON_BN_CLICKED(IDC_BUTTON1, OnButtonOptnAdd)
	ON_BN_CLICKED(IDC_BUTTON2, OnButtonOptnRem)
	ON_BN_CLICKED(IDC_BUTTON3, OnButtonOptnEdt)
	ON_LBN_DBLCLK(IDC_LIST_ADR, OnDblclkListAdr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// DHCP message handlers

void DHCP::OnButtonHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_DIALOGDHCP, HELP_CONTEXT) ;
	
}

void	DHCP::DeleteAllDHCPStrings()
{
	int	TagIndex;
	int	PropIndex;
	int	BindIndex;
	char	szLHS[40];
	char	szRHS[80];

//For all Tags
	TagIndex = 0;
	while(1)
	{
//remove tag string
		sprintf(szLHS, "DHCP Tag%d Address Range", TagIndex);
		if( GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
											szRHS, sizeof(szRHS), IniInWinForm))
			WritePrivateProfileString((LPCSTR)DHCPServerSect,
				(LPCSTR)szLHS, (LPCSTR)NULL, (LPCSTR)IniInWinForm);
		else
			break;	// done with all tabs

//remove exclusion
		sprintf(szLHS, "DHCP Tag%d Exclusions", TagIndex);
		if( GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
											szRHS, sizeof(szRHS), IniInWinForm))
			WritePrivateProfileString((LPCSTR)DHCPServerSect,
				(LPCSTR)szLHS, (LPCSTR)NULL, (LPCSTR)IniInWinForm);

//remove properties
		PropIndex = 0;
		while(1)
		{
			//check if get returns a non-null str
			sprintf(szLHS, "$%c DHCP Tag%d Properties",
										(char)('A'+PropIndex++), TagIndex);
			if( GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
											szRHS, sizeof(szRHS), IniInWinForm))
				WritePrivateProfileString((LPCSTR)DHCPServerSect,
					(LPCSTR)szLHS, (LPCSTR)NULL, (LPCSTR)IniInWinForm);
			else
				break;
		}
//remove bindings
		BindIndex = 0;
		while(1)
		{
			//check if get returns a non-null str
			sprintf(szLHS, "$%c DHCP Tag%d Bindings",
										(char)('A'+BindIndex++), TagIndex);
			if( GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
											szRHS, sizeof(szRHS), IniInWinForm))
				WritePrivateProfileString((LPCSTR)DHCPServerSect,
					(LPCSTR)szLHS, (LPCSTR)NULL, (LPCSTR)IniInWinForm);
			else
				break;
		}
		TagIndex++;
	}
//write number of tags = 0
}

/* Sachin, Oct. 4th, 1997 */
extern LPCSTR IPSectionHeader ;
/* Sachin, Oct. 4th, 1997 */
//travers the list and save the parameters one-by-one
void DHCP::SaveParams(void)
{
	
	int	TagIndex;
	AddrRangeType *tmpAddrRange;
	char szLHS[40];
	char szRHS[MAX_INI_OPTN_LEN*3]; //twice max optn strlen + extra for optiontype and code

	LPCSTR ptmp;
	if (m_Enable)
/* Sachin, Oct. 4th, 1997 */
	{
		ptmp = StrEnabled;
		WritePrivateProfileString((LPCSTR)IPSectionHeader,
			(LPCSTR)"IP Port0 BOOTP", (LPCSTR)ptmp, (LPCSTR)IniInWinForm);

	}
/* Sachin, Oct. 4th, 1997 */
	else
		ptmp = StrDisabled;

	WritePrivateProfileString((LPCSTR)DHCPServerSect,
		(LPCSTR)"DHCP Server", (LPCSTR)ptmp, (LPCSTR)IniInWinForm);

	//before anything we need to write count of entries
	TagIndex = m_AdrLstWnd.GetCount();
	sprintf(szRHS,"%d", TagIndex);
	WritePrivateProfileString((LPCSTR)DHCPServerSect,
			(LPCSTR)"DHCP Number of Tags", (LPCSTR)szRHS, (LPCSTR)IniInWinForm);

	TagIndex = 0;
	tmpAddrRange = PtrAddrRange;
	while(tmpAddrRange)
	{
//Write the TagString first
		sprintf(szLHS, "DHCP Tag%d Address Range", TagIndex);
		sprintf(szRHS, "%s,%s,%s", tmpAddrRange->LAddr,
									tmpAddrRange->HAddr, tmpAddrRange->Mask) ;
		WritePrivateProfileString((LPCSTR)DHCPServerSect,
				(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)IniInWinForm);

//write all exclusion address list
		XAddrType *tmpXAddr1, *tmpXAddr2;
		tmpXAddr1 = tmpAddrRange->XAddrList;
		while(tmpXAddr1)
		{
			tmpXAddr2 = tmpXAddr1->NextNode;
			sprintf(szLHS, "DHCP Tag%d Exclusions", TagIndex);
			sprintf(szRHS, "%s,%s", tmpXAddr1->XLAddr, tmpXAddr1->XHAddr);
			WritePrivateProfileString((LPCSTR)DHCPServerSect,
					(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)IniInWinForm);
			tmpXAddr1 = tmpXAddr2;
			break;  //don't write more than 1
		}

//write properties next
		int PropIndex;
		int PropStrIdx;
		OptionType *pCurOptn;

		PropStrIdx = 0;
		for (PropIndex = 0; PropIndex < NUM_OPTIONS ; PropIndex++)
		{
			pCurOptn = &tmpAddrRange->OLPtr[PropIndex];

			if(pCurOptn->OptionList)
			{
				sprintf(szLHS, "$%c DHCP Tag%d Properties",
											(char) ('A' + PropStrIdx++), TagIndex);
				sprintf(szRHS, "%02x,%02x,%s", pCurOptn->OptionType,
							pCurOptn->OptionCount, pCurOptn->OptionList);
				WritePrivateProfileString((LPCSTR)DHCPServerSect,
					(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)IniInWinForm);
			}
		}
//write Binds //for now we write one bind per ini
		BindingType *tmpBind1, *tmpBind2;
		int	BindIndex;

		tmpBind1 = tmpAddrRange->Binds;
		BindIndex = 0;
		while(tmpBind1)
		{
			tmpBind2 = tmpBind1->NextNode;
			sprintf(szLHS, "$%c DHCP Tag%d Bindings",
								(char) ('A'+BindIndex++), TagIndex);
			sprintf(szRHS, "%s,%02x,%s", tmpBind1->IPAddr,
										tmpBind1->MacAddrLen, tmpBind1->MacAddr);
			WritePrivateProfileString((LPCSTR)DHCPServerSect,
					(LPCSTR)szLHS, (LPCSTR)szRHS, (LPCSTR)IniInWinForm);
			tmpBind1 = tmpBind2;	//write next bind
		}

		tmpAddrRange = tmpAddrRange->NextNode; //process next addr range
		TagIndex++;
	}
}

//Walk thru all the big chain sniffing for mallocs and freeing
void DHCP::FreeAllMem(void)
{
	AddrRangeType *tmpAddrRange;

	while(PtrAddrRange)
	{
		tmpAddrRange = PtrAddrRange->NextNode;

		FreeARange(PtrAddrRange);

		PtrAddrRange = tmpAddrRange;	//goto the next node
	}
}

void DHCP::OnOK()
{
	// TODO: Add extra validation here
	//Clear all present strings from ini
	UpdateData(TRUE);

	DeleteAllDHCPStrings();

	//write all strings again
	SaveParams();

	//free all mem
	FreeAllMem();
	CDialog::OnOK();
}

BOOL DHCP::OnInitDialog()
{
	CDialog::OnInitDialog();
	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);
	SetWindowText (WindowHeader) ;

	PtrAddrRange = NULL;	// Pointer to beginning of Address range
	pCurGBLTag = NULL;	// Pointer to current AddrRange
	pCurEditTag = NULL;	// used as a parameter to Edit/Add
	EditBindings = 0;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_BUTTON_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!AddRangeBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load Add bitmap");

	VERIFY (AddRangeBitmapBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddRangeBitmapBtn.SizeToContent();


	if (!DelRangeBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Delete bitmap");

	VERIFY (DelRangeBitmapBtn.SubclassDlgItem (IDC_BUTTON_REMOVE, this));
	DelRangeBitmapBtn.SizeToContent();

	if (!EditRangeBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Edit bitmap");

	VERIFY (EditRangeBitmapBtn.SubclassDlgItem (IDC_BUTTON_EDIT, this));
	EditRangeBitmapBtn.SizeToContent();

	if (!BindRangeBitmapBtn.LoadBitmaps ("BIND1", "BIND2", "BIND3", "BIND4"))
		AfxMessageBox ("Failed to load Bind bitmap");

	VERIFY (BindRangeBitmapBtn.SubclassDlgItem (IDC_BUTTON_EDIT2, this));
	BindRangeBitmapBtn.SizeToContent();


	if (!AddOptionBitmapBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load Add bitmap");

	VERIFY (AddOptionBitmapBtn.SubclassDlgItem (IDC_BUTTON1, this));
	AddOptionBitmapBtn.SizeToContent();                   


	if (!DelOptionBitmapBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load Delete bitmap");

	VERIFY (DelOptionBitmapBtn.SubclassDlgItem (IDC_BUTTON2, this));
	DelOptionBitmapBtn.SizeToContent();

	if (!EditOptionBitmapBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load Edit bitmap");

	VERIFY (EditOptionBitmapBtn.SubclassDlgItem (IDC_BUTTON3, this));
	EditOptionBitmapBtn.SizeToContent();



	int TagIndex;
	char szLHS[40];
	char szRHS[MAX_INI_OPTN_LEN*3];
	char addr1[20], addr2[20], addr3[20];
	int	Type, Count;
	char	Value[80], RestRHS[80];
	char *ErrMsgPtr = NULL;
	int	PropStrIndex;
	int	BindStrIndex;
	char  *OptionsPtr;
	int	TabStop = 60;
	int	ListTabs[] = {70};
	int	Index;

	m_AdrLstWnd.SetTabStops (1, (LPINT)&ListTabs) ;
	m_XAdrLst.SetTabStops(1, (LPINT)&TabStop) ;

	AddrRangeType *pCurTag;		//pointer to current tag
	XAddrType *pXAddr;			//pointer for exclusion node

	GetPrivateProfileString(DHCPServerSect, "DHCP Server", StrNull,
				szRHS, sizeof(szRHS), IniInWinForm);
	if (!strcmp(szRHS, StrEnabled))
		m_Enable = TRUE;
	else
		m_Enable = FALSE;

	TagIndex = 0;
	while(1)
	{
// read the addr range - tag
		sprintf(szLHS, "DHCP Tag%d Address Range", TagIndex);
		GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
				szRHS, sizeof(szRHS), IniInWinForm);
		if (!*szRHS)		// all tags are read by now
			break;

		// CAllocate on node for this tag
		pCurTag = (AddrRangeType *)calloc(1, sizeof(AddrRangeType));

		if (!pCurTag)
		{
			ErrMsgPtr = "No Memory!";
ErrorExit:
			sprintf(szRHS, "%s\nThe entry number is %d.", ErrMsgPtr, TagIndex);
			::MessageBox (GetSafeHwnd(), (LPCSTR) szRHS,
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			FreeAllMem();
			CDialog::OnCancel();
			return TRUE;
		}
		//attach this node into chain ASAP. Better Append
		if (PtrAddrRange)
		{
			AddrRangeType *tmpPtr = PtrAddrRange;

			while (tmpPtr->NextNode)			//Travel till end
				tmpPtr = tmpPtr->NextNode;

			tmpPtr->NextNode = pCurTag;
			pCurTag->PrevNode = tmpPtr;
		}
		else
		{
			PtrAddrRange = pCurTag;
		}

		sscanf(szRHS, "%[^,],%[^,],%[^,]", addr1, addr2, addr3);
		strcpy(pCurTag->LAddr, addr1);
		strcpy(pCurTag->HAddr, addr2);
		strcpy(pCurTag->Mask, addr3);

#if _WINDOWS_
		CDotDecimal	LAddr = addr1;
		CDotDecimal	HAddr = addr2;
		CDotDecimal Mask = addr3;

		if (!LAddr.IsValid() || !HAddr.IsValid() || !Mask.IsValid())
		{
			ErrMsgPtr = "Invalid Address Range Entry!";
			goto ErrorExit;
		}
#endif

// Now read exclusion. if there is going to be
		// more than one, we need to get more from each LHS.
		//LHS will begin with $A and also all LHS
		//But we now permit only one exclusion for a range

		sprintf(szLHS, "DHCP Tag%d Exclusions", TagIndex);
		GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
											szRHS, sizeof(szRHS), IniInWinForm);
		*addr1 = *addr2 = 0;
		sscanf(szRHS, "%[^,],%[^,]", addr1, addr2);

		if (*addr1)
		{
			// CAllocate on node for this exclusion
			pXAddr = (XAddrType *)calloc(1, sizeof(XAddrType));
			if (!pXAddr)
			{
				ErrMsgPtr = "No memory!";
				goto ErrorExit;
			}
			//attach the exclusion list to AddrRange ASAP
			pCurTag->XAddrList = pXAddr;

			strcpy(pXAddr->XLAddr, addr1);
			strcpy(pXAddr->XHAddr, addr2);
		}

#if _WINDOWS_
		CDotDecimal	LAddr = addr1;
		CDotDecimal	HAddr = addr2;

		if (!LAddr.IsValid() || !HAddr.IsValid())
		{
			ErrMsgPtr = "Invalid Exclusion Range Entry!",
			goto ErrorExit;
		}
#endif

//Now read the properties till all properties are read
		PropStrIndex = 0;
		while(1)
		{
			sprintf(szLHS, "$%c DHCP Tag%d Properties",
										(char) ('A' + PropStrIndex), TagIndex);
			GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
					szRHS, sizeof(szRHS), IniInWinForm);

			if (!*szRHS && !PropStrIndex)
			{
				ErrMsgPtr = "A Range with no properties";
				goto ErrorExit;
			}

			if (!*szRHS)	//all properties of this tag is read in
				break;
			while(*szRHS)
			{
				*Value = 0; *RestRHS = 0; Type = Count = 0;	//just reset these

				sscanf(szRHS, "%2x,%2x,%[^,\0],%s", &Type, &Count, Value, RestRHS);
				if (Type < 0 || Type > NUM_OPTIONS)
				{
					ErrMsgPtr = "Invalid Option Type.";
					goto ErrorExit;
				}
#if 0
				if (Count < 0 || Count > MAX_INI_OPTN_LEN)
				{
					ErrMsgPtr = "Invalid Option Length.";
					goto ErrorExit;
				}
#endif
				//Has any previous strings come for the same Type??
				if (pCurTag->OLPtr[Type].OptionList)
				{
					int length;

					//Allocate mem for old + new
					length = strlen(pCurTag->OLPtr[Type].OptionList)+strlen(Value);
					if (length > MAX_OPTN_LEN)
					{
						ErrMsgPtr = "Too much option length";
						goto ErrorExit;
					}
					OptionsPtr = (char *) malloc(length + 2);
					if (!OptionsPtr)
					{
						ErrMsgPtr = "No Memory for options!";
						goto ErrorExit;

					}
					//first put the old optinslist
					strcpy(OptionsPtr, pCurTag->OLPtr[Type].OptionList);
					//cat the new list
					strcat(OptionsPtr, Value);
					//Free mem of old options
					free(pCurTag->OLPtr[Type].OptionList);
				}
				else
				{
					//allocate memory for storing values
					OptionsPtr = (char *) malloc(strlen(Value)+ 2);
					if (!OptionsPtr)
					{
						ErrMsgPtr = "No Memory for options!";
						goto ErrorExit;
					}
					strcpy(OptionsPtr, Value);
				}
				//attach options to the pointer in node
				pCurTag->OLPtr[Type].OptionList = OptionsPtr;
				pCurTag->OLPtr[Type].OptionCount += Count;	//not +
				pCurTag->OLPtr[Type].OptionType = Type;

				strcpy(szRHS, RestRHS);	//go for next tripple
			}
			PropStrIndex++;	//read next property string
		}


// Read static bindings of IP addresses to MAC addresses if any
		BindStrIndex = 0;
		BindingType *BindPtr;
		while (1)
		{
			sprintf(szLHS, "$%c DHCP Tag%d Bindings",
						(char) ('A' + BindStrIndex), TagIndex);
			GetPrivateProfileString(DHCPServerSect, szLHS, StrNull,
						szRHS, sizeof(szRHS), IniInWinForm);
			if (!*szRHS)
				break;		//end of bing for this tag
			while(*szRHS)
			{
				*addr1 = 0; *Value = 0; *RestRHS = 0; Count = 0;	//just reset these
				sscanf(szRHS, "%[^,\0],%2x,%[^,\0],%s", addr1, &Count, Value, RestRHS);
				if (Count < 1 || Count > MAX_MAC_ADDR_LEN)
				{
						ErrMsgPtr = "Invalid MAC addr length";
						goto ErrorExit;
				}
				//Now Callocate a node for this
				BindPtr = (BindingType *) calloc(1, sizeof(BindingType));
				if (!BindPtr)
				{
					ErrMsgPtr = "No Memory";
					goto ErrorExit;
				}
				//Chain this Binding to the end of the binding list
				if (pCurTag->Binds)
				{
					BindingType *tmpBindPtr;

					tmpBindPtr = pCurTag->Binds;
					while(tmpBindPtr->NextNode)
						tmpBindPtr = tmpBindPtr->NextNode;
					tmpBindPtr->NextNode = BindPtr;
				}
				else
				{
					pCurTag->Binds = BindPtr;
				}
				//Fillup this struct
				strcpy(BindPtr->IPAddr, addr1);
				BindPtr->MacAddrLen = Count;
				strcpy(BindPtr->MacAddr, Value);

				strcpy(szRHS, RestRHS);	//go for next tripple
			}
			BindStrIndex++;	//Read next binding
		}
		//Add this tag to the list box
		if (TagIndex == 0)
			sprintf(szRHS, "%s", " Default range");
		else
			sprintf(szRHS, "%s\t%s", pCurTag->LAddr, pCurTag->HAddr);
		Index = m_AdrLstWnd.AddString(szRHS);

		//Set the list box word as the address of the TagStruct
		if (Index == LB_ERR)
			goto ErrorExit;

		m_AdrLstWnd.SetItemDataPtr(Index, pCurTag);

		TagIndex++;		//	goto the next tab

	}

	//Fill the options list with the items
	FillupOptionsList();
	//now set the cursel in options list to 0
	m_OptnLstWnd.SetCurSel(0);


	//if Tag0 is not present, we can't proceed
	if (TagIndex == 0)
	{
			::MessageBox (GetSafeHwnd(), (LPCSTR)"No Default Options Entry!\n\
Please download default setup",
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			CDialog::OnCancel();
			return TRUE;
	}

	Index = m_AdrLstWnd.SetCurSel(0);

	OnSelchangeListAdr();
	UpdateData(FALSE);

	m_AdrLstWnd.SetFocus();		// Sachin likes it here
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void DHCP::OnSelchangeListAdr()
{
	int CurIndex;
	char	szBuf[40];

	// TODO: Add your control notification handler code here
	CurIndex = m_AdrLstWnd.GetCurSel();
	if (CurIndex == LB_ERR)
	{
		pCurGBLTag = 0;	//No Tag for GBL

		//Disable Edit, Delete buttons in range group
		m_EdtBtn.EnableWindow(FALSE);
		m_RemBtn.EnableWindow(FALSE);
		m_SelIndWnd.SetWindowText("None");

		//Reset the contents of Exclude
		m_XAdrLst.ResetContent();

		//Redisplay the OptionsList
		OnSelchangeListOptn();
		return;
	}
	pCurGBLTag = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

	if ( CurIndex )
	{
		sprintf(szBuf, "Entry number %d.", CurIndex + 1);
	}
	else
	{
		sprintf(szBuf, "Default Entry (1)");
	}
	m_SelIndWnd.SetWindowText(szBuf);

//display contents of Exclude
	//Reset the contents of Exclude
	m_XAdrLst.ResetContent();
	szBuf[0] = NULL;
	if (pCurGBLTag->XAddrList)
		sprintf(szBuf, "%s\t%s", pCurGBLTag->XAddrList->XLAddr,
					pCurGBLTag->XAddrList->XHAddr);
	m_XAdrLst.AddString(szBuf);

//if the range selected is default range - No edit, remove or bind
	BOOL Editable;

	Editable = (pCurGBLTag == PtrAddrRange) ? FALSE : TRUE;

	m_EdtBtn.EnableWindow(Editable);
	m_RemBtn.EnableWindow(Editable);
	m_BndBtn.EnableWindow(Editable);

	//Redisplay the OptionsList
	OnSelchangeListOptn();
}

void DHCP::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	pCurEditTag = NULL;

	CDHCPAdt DHCPAdd(this);
	DHCPAdd.DoModal();
	
}

void DHCP::OnDblclkListAdr()
{
	// TODO: Add your control notification handler code here
	int index  = m_AdrLstWnd.GetCurSel();
	OnSelchangeListAdr();

	if (index != 0)
		OnButtonEdit();
}

void DHCP::OnButtonEdit()
{
	// TODO: Add your control notification handler code here
	pCurEditTag = pCurGBLTag;

	CDHCPAdt DHCPEdit(this);
	DHCPEdit.DoModal();
	
	pCurEditTag = NULL;
}

void DHCP::OnButtonRemove()
{
	// TODO: Add your control notification handler code here
	int CurIndex;
	AddrRangeType *pTmp;

	CurIndex = m_AdrLstWnd.GetCurSel();
	if (CurIndex == LB_ERR)
		return;

	pTmp = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

	// Deletestring at index;
	m_AdrLstWnd.DeleteString(CurIndex);
	//Set selection to prev
	m_AdrLstWnd.SetCurSel(CurIndex - 1);
	OnSelchangeListAdr();

	//Diconnect pTMp from the chain
	if (pTmp->PrevNode)
		pTmp->PrevNode->NextNode = pTmp->NextNode;
	if (pTmp->NextNode)
		pTmp->NextNode->PrevNode = pTmp->PrevNode;

	//Free the node
	FreeARange(pTmp);
}

void DHCP::OnCancel()
{
	// TODO: Add extra cleanup here
 
	FreeAllMem();
	CDialog::OnCancel();
}

void DHCP::OnButtonBind()
{
	// TODO: Add your control notification handler code here

	EditBindings = TRUE;
	CBind Bind(this);

	Bind.DoModal();
	EditBindings = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//Callocats memory for a node. Copies the options from the
// node passed as argument. If arg is NULL, copy from default node
//return pointer to new node if OK else NULL
AddrRangeType *DHCP::GetAnAddrNode(AddrRangeType *pOptnsNode)
{
	AddrRangeType *pNewRange, *pCopyFrom;

		// CAllocate on node for this tag
	pNewRange = (AddrRangeType *)calloc(1, sizeof(AddrRangeType));

	if (!pNewRange)
		return NULL;

	if (pOptnsNode)
		pCopyFrom = pOptnsNode;		// copy from passed node
	else
		pCopyFrom = PtrAddrRange;	// copy from defaults node

	//Copy options
	int	OptnIndex;
	OptionType *from, *to;
	
	for (OptnIndex = 0; OptnIndex < NUM_OPTIONS; OptnIndex++)
	{
		if (pCopyFrom->OLPtr[OptnIndex].OptionList)
		{
			to = &pNewRange->OLPtr[OptnIndex];
			from = &pCopyFrom->OLPtr[OptnIndex];

			to->OptionType =from->OptionType;
			to->OptionCount =from->OptionCount;

			// allocate memmory for the options list;
			if (!(to->OptionList =	(char *) malloc(strlen(	from->OptionList)+1)))
			{
				//Free the mem for node
				free(pNewRange);
				//return false;
				return NULL;
			}
			strcpy(to->OptionList, from->OptionList);
		}
	}
	return pNewRange;
}

////////////////////////////////////////////////////////////////////////////
//check if lower bound of first >= pNext bounds
//	assumes integrity of each node by itself
BOOL EntriesClash(AddrRangeType *pFirst, AddrRangeType *pSecond)
{
	unsigned long fl, fu;		//first low and upper bound
	unsigned long fxl, fxu;		//first xclude low and upper bound
	unsigned long sl, su;		//first low and upper bound
	unsigned long sxl, sxu;		//first xclude low and upper bound

//Get all addresses in intger for comparison;
	get_ip_address(pFirst->LAddr, &fl);
	get_ip_address(pFirst->HAddr, &fu);
	get_ip_address(pSecond->LAddr, &sl);
	get_ip_address(pSecond->HAddr, &su);

	//if exclude is present for first
	if (pFirst->XAddrList)
	{
		get_ip_address(pFirst->XAddrList->XLAddr, &fxl);
		get_ip_address(pFirst->XAddrList->XHAddr, &fxu);
	}
	else
	{
		fxl = 0;
		fxu = 0;
	}

	//if exclude is present for second
	if (pSecond->XAddrList)
	{
		get_ip_address(pSecond->XAddrList->XLAddr, &sxl);
		get_ip_address(pSecond->XAddrList->XHAddr, &sxu);
	}
	else
	{
		sxl = 0;
		sxu = 0;
	}

	if (su < fl)		//Second upper is less than first lower, can't clash
		return FALSE;
	if (sl > fu)		//Second lower graer than first upper, can't clash
		return FALSE;
	if ((sl >= fxl) && (su <= fxu))	//Second fully in exclude of first
		return FALSE;
	if ((fl >= sxl) && (fu <= sxu))	//Second fully in exclude of first
		return FALSE;

	return TRUE;	// other wise clash
}

////////////////////////////////////////////////////////////////////////////
//Travel all the list and check for any range clash
//avoid the default range. it covers all ranges
//avoid the pSkip entry (for edit to work properly)
//return No_CLASING_ENTRY if no clash. Else return index of entry clashing
int	DHCP::CheckUnique(AddrRangeType *pRange, AddrRangeType *pSkip)
{
	AddrRangeType	*pTmp, *pTmp2;
	int	CurIndex;

	for (pTmp = PtrAddrRange->NextNode; pTmp; pTmp = pTmp->NextNode)
	{
		if (pTmp == pSkip)		// avoid skip node
			continue;
		if (EntriesClash(pTmp, pRange))
		{
			//find the index of clashing entry and return
			//since we have added the serial number, FindString memeber is useless
			// so we take a different method
			for (CurIndex = 0; ;CurIndex++)
			{
				pTmp2 = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

				if (pTmp == pTmp2)
					return CurIndex;

				if (pTmp2 == (AddrRangeType *) -1)
					return 0;		//this must not happen
			}
		}
	}
	return NO_CLASHING_ENTRY;
}

////////////////////////////////////////////////////////////////////////////
//if pOriginal is non-null,
//				make pRange sit in its place and freeup pOriginal
//else
//				add this entry as the last entry in the list
void	DHCP::AddOrReplaceRange(AddrRangeType *pRange, AddrRangeType *pOriginal)
{
	AddrRangeType *pTmp;
	int	CurIndex;
	char szBuf[60];


	if (pOriginal)
	{
		//Set pointers in pRnage to the pOriginal
		pRange->NextNode = pOriginal->NextNode;
		pRange->PrevNode = pOriginal->PrevNode;
		//Setup Next and Prev nodes of Original if any
		if(pOriginal->NextNode)
			pOriginal->NextNode->PrevNode = pRange;
		if(pOriginal->PrevNode)
			pOriginal->PrevNode->NextNode = pRange;

		//If there are bindings in the Original node we need
		//to retain that
		pRange->Binds = pOriginal->Binds;
		pOriginal->Binds = NULL;


		FreeARange(pOriginal);

//	Set the listbox itemdataptr to point to the pRange address
		//find the index of pOriginal
		for (CurIndex = 0; ;CurIndex++)
		{
			pTmp = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);
			if (pTmp == pOriginal)
				break;

			if (pTmp == (AddrRangeType *) -1)
				return;		//this must not happen
		}

		//The range might have changed, so we need to delete the display
		m_AdrLstWnd.DeleteString(CurIndex);
 		sprintf(szBuf, "%s\t%s", pRange->LAddr, pRange->HAddr);
		CurIndex = m_AdrLstWnd.AddString(szBuf);			//Add this string
		m_AdrLstWnd.SetCurSel(CurIndex);		// make it cur sel
		m_AdrLstWnd.SetItemDataPtr(CurIndex, pRange); // set this as ItmDataPtr

		//need to refresh the exclude range
		OnSelchangeListAdr();
	}
	else
	{
		//Add this to the end of the list
		pTmp = PtrAddrRange;
		while (pTmp->NextNode) {			//Travel till end
			pTmp = pTmp->NextNode;
		}

		pTmp->NextNode = pRange;
		pRange->PrevNode = pTmp;

 		sprintf(szBuf, "%s\t%s", pRange->LAddr, pRange->HAddr);
		CurIndex = m_AdrLstWnd.AddString(szBuf);			//Add this string
		m_AdrLstWnd.SetCurSel(CurIndex);		// make it cur sel
		m_AdrLstWnd.SetItemDataPtr(CurIndex, pRange); // set this as ItmDataPtr
		//do this only after setting ItemDataPtr, it is used in selchange!!
		OnSelchangeListAdr();
	}
}

////////////////////////////////////////////////////////////////////////////
void	DHCP::FreeBindings(BindingType *pNode)
{
	BindingType *tmpBind1, *tmpBind2;
	tmpBind1 = pNode;
	while(tmpBind1)
	{
		tmpBind2 = tmpBind1->NextNode;
		free(tmpBind1);
		tmpBind1 = tmpBind2;
	}
}

////////////////////////////////////////////////////////////////////////////
void	DHCP::FreeARange(AddrRangeType *pNode)
{
	int Index;

//free all the options list mem
	for(Index = 0; Index < NUM_OPTIONS; Index++)
		free(pNode->OLPtr[Index].OptionList);

//free Binds
	FreeBindings(pNode->Binds);
	pNode->Binds = NULL;

//free all exclusion address list
	XAddrType *tmpXAddr1, *tmpXAddr2;
	tmpXAddr1 = pNode->XAddrList;
	while(tmpXAddr1)
	{
		tmpXAddr2 = tmpXAddr1->NextNode;
		free(tmpXAddr1);
		tmpXAddr1 = tmpXAddr2;
	}
//free the tag node itself
	free(pNode);
}

///////////////////////////////////////////////////////////////////
//Given a binding type node, check in the whole list to see
//if the MAC address is bound. If bound, return the index of this
//entry in the list and fillup the matching IP address also.
//If not found return NO_CLASHING_ENTRY
int	DHCP::CheckIfMACAddressBound(BindingType *pBind, LPSTR RetAddress)

{
	int	CurIndex = 1;		//skip default
	int	LstCount;
	AddrRangeType *pAdrRange;
	BindingType *pTmpBnd;

	LstCount = m_AdrLstWnd.GetCount();
	if (LstCount == LB_ERR)
		return NO_CLASHING_ENTRY;

	for (CurIndex = 0; CurIndex < LstCount; CurIndex++)
	{
		pAdrRange = (AddrRangeType *)m_AdrLstWnd.GetItemDataPtr(CurIndex);

		if (EditBindings)
		{
			if (pAdrRange == pCurGBLTag)	//we have selected this entry for
				continue;						//avoid this node
		}

		pTmpBnd = pAdrRange->Binds;
		while(pTmpBnd)
		{
			if (pBind->MacAddrLen == pTmpBnd->MacAddrLen)
			{
				if (!strcmpi(pBind->MacAddr, pTmpBnd->MacAddr))
				{
					strcpy(RetAddress, pTmpBnd->IPAddr);
					return CurIndex;
				}
			}
			pTmpBnd = pTmpBnd->NextNode;
		}
	}
	return NO_CLASHING_ENTRY;
}

/////////////////////////////////////////////////////////////////////////////
// Options related routines


char *OptionTypeString[] =
{
	"Character string",
	"Character string - no null",
	"Dot decimal IP Address",
	"Unsigned 32 bit integer",
	"Unsigned 16 bit integer",
	"Unsigned 8 bit integer",

	"Unknown type"
};

LPCSTR	GetOptionTypeString(int Optn)
{
	if (Optn > OT_UNDEFINED)
		Optn = OT_UNDEFINED;

	return ((LPCSTR) OptionTypeString[Optn]);
}

//the flowwing struct contains all options that are configurable for the
//address range entries.
OptionEditType	EditOptions[] =
{
//********** IMPORTANT :: **************
//If any option is added to this list, It must be sorted on the first filed
//The values in various fields above are based on RFC1533.
//********** IMPORTANT :: **************
	{ 3, 1, 0, -1L, 0L, OT_IP_ADDRESS,"Router Address","Address of default gateway"},
	{ 6, 1, 0, -1L, 0L, OT_IP_ADDRESS, "DNS Server", "Domain Name System Server"},
	{15, 1, 0, -1L, 0L, OT_STRINGZ, "Domain Name", "Domain name for client"},
	{22, 1, 0, 0xFFFFL, 576L, OT_U16,"Reassembly size","Maximum datagram reassembly size"},
	{23, 1, 0, 0xFFL, 1L, OT_U8,"Default IP TTL", "Default IP Time-to-live(max 255)"},
	{26, 1, 0, 0xFFFFL, 68L, OT_U16,"MTU","Interface Maximum Transfer Unit"},	//min 68
	{37, 1, 0, 0xFFL, 1L, OT_U8,"Default TCP TTL","TCP Default Time-to-live"},
	{51, 1, 1, 0xFFFFFFFFL, 600L, OT_U32,"Lease time","IP Address lease time(seconds)"},
//	{-1, OT_STRING, "User Defined", "A stream of bytes. Refer help"}
};

#define NUM_EDIT_OPTIONS  (sizeof(EditOptions) / sizeof(OptionEditType))

void DHCP::FillupOptionsList()
{
	int	index;
	char	szBuf[100];
	int tabstop = 15;

	m_OptnLstWnd.SetTabStops(1, (LPINT)&tabstop) ;

	//for all options in the editoptions
	for (index = 0; index < NUM_EDIT_OPTIONS; index++)
	{
		if (EditOptions[index].OptionCode != -1)
		{
			// form the Options string and add it to the list
			sprintf(szBuf, "%3d\t%s", EditOptions[index].OptionCode,
												EditOptions[index].OptionName);
		}
		else
		{
			sprintf(szBuf, " **\t%s", EditOptions[index].OptionName);
		}
		m_OptnLstWnd.AddString(szBuf);
	}
}

BOOL	DHCP::CheckOptionValuesAndDisplay(AddrRangeType *pAdrRange, int Optn)
{
	//First reset contents
	int	ocode, otype;
	char optnbuf[MAX_INI_OPTN_LEN+1];			//buffer to add to list
	char *srcptr;				//pointer to the options byte array
	int	count, curcount;	//to total options count, current count
	DWORD lvalue;
	WORD	wvalue;
	BYTE bvalue;
	int	index;
	char btmp[15];

	m_OptnEdtWnd.ResetContent();
	//Get the option code of the entry displayed
	ocode = EditOptions[Optn].OptionCode;
	otype = EditOptions[Optn].OptionType;

	if ( !pAdrRange->OLPtr[ocode].OptionList)
		return FALSE;

	srcptr = pAdrRange->OLPtr[ocode].OptionList;
	count = pAdrRange->OLPtr[ocode].OptionCount;

	index = 0;
	curcount = 0;
	//Get the type of the option
	switch (otype)
	{

		case OT_STRINGZ:	// a series of null terminated strings
		case OT_STRING:		//one string no null

			while (curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(BYTE) * 2);
				btmp[sizeof(BYTE) * 2] = 0;
				sscanf(btmp, "%2x", &wvalue);
				srcptr += sizeof(BYTE) * 2;
				if (!wvalue)		// end if this value
					break;
				optnbuf[curcount] = (char)wvalue;
				curcount++;
			}
			optnbuf[curcount] = 0;
			m_OptnEdtWnd.AddString(optnbuf);

			break;

		case OT_IP_ADDRESS:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(DWORD) * 2] = 0;
				sscanf(btmp, "%lx", &lvalue);
				curcount += sizeof(DWORD);		//each IP address is a dword
				srcptr += sizeof(DWORD) * 2;
				get_dot_decimal_ip_address(lvalue, optnbuf);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U32:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(DWORD) * 2] = 0;
				sscanf(btmp, "%lx", &lvalue);
				curcount += sizeof(DWORD);		//each U32 dword
				srcptr += sizeof(DWORD) * 2;
				sprintf(optnbuf,"%lu",lvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U16:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(DWORD) * 2);
				btmp[sizeof(WORD) * 2] = 0;
				sscanf(btmp, "%x", &wvalue);
				curcount += sizeof(WORD);		//each U16 is a word
				srcptr += sizeof(WORD) * 2;
				sprintf(optnbuf,"%u",wvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		case OT_U8:

			while(curcount < count)
			{
				strncpy(btmp,srcptr,sizeof(BYTE) * 2);
				btmp[sizeof(BYTE) * 2] = 0;
				sscanf(btmp, "%x", &bvalue);

				curcount += sizeof(BYTE);		//each U8 is a byte
				srcptr += sizeof(BYTE) * 2;
				sprintf(optnbuf,"%2u",bvalue);
				m_OptnEdtWnd.AddString(optnbuf);
			}
			break;

		default:
			::MessageBox (GetSafeHwnd(), (LPCSTR)"Invalid option type to edit!!",
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return FALSE;
	}
	return TRUE;
}

void DHCP::OnSelchangeListOptn()
{
	// TODO: Add your control notification handler code here
	CurGBLOptn = m_OptnLstWnd.GetCurSel();

	if (CurGBLOptn == LB_ERR)
	{
		// Write type as N.A.
		m_OTypeWnd.SetWindowText("N. A.");

		//Reset the contents of value
		m_OptnEdtWnd.ResetContent();

		//	Disable Edit and Remove Buttons
		m_BtnOptnRem.EnableWindow(FALSE);
		m_BtnOptnAdd.EnableWindow(FALSE);
		m_BtnOptnEdt.EnableWindow(FALSE);

		//Ask user to select an option to edit
		m_LineHelp.SetWindowText("Select an option to edit");
		return;
	}

//Write type 
	m_OTypeWnd.SetWindowText(
			GetOptionTypeString(EditOptions[CurGBLOptn].OptionType));

//check if  a value is present for this option of selected address range
	CheckOptionValuesAndDisplay(pCurGBLTag, CurGBLOptn);

	m_OptnEdtWnd.SetCurSel(0);
	OnSelchangeVal();

	//Update the single line help
	m_LineHelp.SetWindowText(EditOptions[CurGBLOptn].OptionHelp);
}

void DHCP::OnSelchangeVal()
{
	int	curcount;

	// TODO: Add your control notification handler code here
	if (m_OptnEdtWnd.GetCurSel() == LB_ERR)
	{
		m_BtnOptnRem.EnableWindow(FALSE);
		m_BtnOptnEdt.EnableWindow(FALSE);
	}
	else
	{
		m_BtnOptnRem.EnableWindow(TRUE);
		m_BtnOptnEdt.EnableWindow(TRUE);
	}

	//enable if we can add one more option
	curcount = m_OptnEdtWnd.GetCount();
	if (curcount < EditOptions[CurGBLOptn].OptionMaxEntries)
	 	m_BtnOptnAdd.EnableWindow(TRUE);
	else
	 	m_BtnOptnAdd.EnableWindow(FALSE);

	if (curcount <= EditOptions[CurGBLOptn].OptionMinEntries)
		m_BtnOptnRem.EnableWindow(FALSE);
}

void DHCP::OnButtonOptnAdd()
{
	// TODO: Add your control notification handler code here
	m_EditedOptionValueIndex = LB_ERR;

	CDHCPOPTN dhcpoptn(this);

	dhcpoptn.DoModal();

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);
//	OnSelchangeListOptn();	//update status of buttons
	OnSelchangeVal();	//update status of buttons

}

void DHCP::OnButtonOptnEdt()
{

	// TODO: Add your control notification handler code here
	//if we are editing get the cursel value and call addit dialog
	if ((m_EditedOptionValueIndex = m_OptnEdtWnd.GetCurSel()) == LB_ERR)
		return;

	CDHCPOPTN dhcpoptn(this);

	dhcpoptn.DoModal();

	m_EditedOptionValueIndex = LB_ERR;

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);
//	OnSelchangeListOptn();	//update status of buttons
	OnSelchangeVal();	//update status of buttons
}

void DHCP::FormOptionValuesFromList(AddrRangeType *pAdrRange, int Optn)
{

	int	count, curcount;
	int	ocode, otype;
	char	szbuf[MAX_INI_OPTN_LEN * 2];			//buffer to add to list
	char	btmp[MAX_INI_OPTN_LEN];
	DWORD	lvalue;
	WORD	wvalue;
	int	basic_entry_len;
	char	*noptns;

	//form new options
	count = m_OptnEdtWnd.GetCount();
	
	ocode = EditOptions[Optn].OptionCode;
	otype = EditOptions[Optn].OptionType;

	//free old mem even if count 0. ****ALSO MUST RESET THE POINTER****
	if (!count)
	{
		free(pAdrRange->OLPtr[ocode].OptionList);
		pAdrRange->OLPtr[ocode].OptionList = NULL;
		pAdrRange->OLPtr[ocode].OptionCount = 0;
		pAdrRange->OLPtr[ocode].OptionType = ocode;
		return;
	}

	curcount = 0;
	szbuf[0] = 0;

	//Get the type of the option
	switch (otype)
	{
		case OT_STRINGZ:	// a series of null terminated strings

			//can have only one non-null terminated value.
			m_OptnEdtWnd.GetText(curcount, btmp);
			count = strlen(btmp) + 1;
			basic_entry_len = 1;

			int l_index;
			l_index = 0;
			while (btmp[l_index])
			{
				sprintf(&szbuf[l_index*2],"%02x",btmp[l_index]);
				l_index++;
			}
			sprintf(&szbuf[l_index*2],"00");
			break;

		case OT_STRING:		//one string no null
			//can have only one non-null terminated value.
			m_OptnEdtWnd.GetText(curcount, btmp);
			count = strlen(btmp);
			basic_entry_len = 1;

			l_index = 0;
			while (btmp[l_index])
			{
				sprintf(&szbuf[l_index*2],"%02x",btmp[l_index]);
				l_index++;
			}
			break;

		case OT_IP_ADDRESS:
			basic_entry_len = sizeof (DWORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				get_ip_address(btmp, &lvalue);
				sprintf(btmp,"%08lx",lvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U32:
			basic_entry_len = sizeof (DWORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%ld", &lvalue);
				sprintf(btmp,"%08lx",lvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U16:
			basic_entry_len = sizeof (WORD);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%d", &wvalue);
				sprintf(btmp,"%04x",wvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		case OT_U8:
			basic_entry_len = sizeof (BYTE);

			while(curcount < count)
			{
				//get entry from list
				m_OptnEdtWnd.GetText(curcount, btmp);
				sscanf(btmp,"%d", &wvalue);
				sprintf(btmp,"%02x",wvalue);
				strcat(szbuf, btmp);
				curcount++;
			}
			break;

		default:
			::MessageBox (GetSafeHwnd(), (LPCSTR)"Invalid option type!!",
					(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			return;
	}

	//terminate szbuf with NULL ....since one byte is represented as two chars
	szbuf[count * basic_entry_len * 2] = 0;

	//malloc for this much
	if ( !(noptns = (char *)malloc(strlen(szbuf) + 2)))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR)"No memory for options!!",
				(LPCSTR) DHCPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		return ;
	}
	strcpy(noptns, szbuf);

	free(pAdrRange->OLPtr[ocode].OptionList);
	pAdrRange->OLPtr[ocode].OptionList = noptns;
	pAdrRange->OLPtr[ocode].OptionCount = count * basic_entry_len;
	pAdrRange->OLPtr[ocode].OptionType = ocode;

}

void DHCP::OnButtonOptnRem()
{
	// TODO: Add your control notification handler code here
	int value_index;

	//check if there is any selection to remove
	if ((value_index = m_OptnEdtWnd.GetCurSel()) == LB_ERR)
		return;

	//check for a valid option being selected
	if (CurGBLOptn == LB_ERR)
		return;

	//check if a valid selection of range
	if (!pCurGBLTag)
		return;

	//remove the list box item at the index;
	m_OptnEdtWnd.DeleteString(value_index);

	//reform the option list and update
	FormOptionValuesFromList(pCurGBLTag, CurGBLOptn);

	if (value_index > 0)
		m_OptnEdtWnd.SetCurSel(value_index - 1);

	OnSelchangeListOptn();	//update status of Edit and remove buttons
}

BOOL CheckIPAddressInRange(AddrRangeType *pAdrNode, LPCSTR IPAddress)
{
	//Set IP address to next unbound IP Address - UF
	unsigned long nadr, ladr, uadr, xladr, xuadr;

	get_ip_address(IPAddress, &nadr);
	get_ip_address(pAdrNode->LAddr, &ladr);
	get_ip_address(pAdrNode->HAddr, &uadr);
	if (pAdrNode->XAddrList)
	{
		get_ip_address(pAdrNode->XAddrList->XLAddr, &xladr);
		get_ip_address(pAdrNode->XAddrList->XHAddr, &xuadr);
	}
	else
	{
		xladr = xuadr = 0;
	}

	if (nadr < ladr || nadr > uadr)
		return FALSE;
	if (xladr)
	{
		if (nadr >= xladr && nadr <= xuadr)
			return FALSE;
	}
	return TRUE;
}

