#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include "ui.h"
#include "mem.h"
#include "uart.h"
#include "tst.h"

#define	MAGIC_NUM  0xABCD

int DOWN_LOAD=0;  /*--indicates whether to include Bridge Id in the packet or not---*/
int file_hdl=-1;  /*--indicates whether the user has selected a down load file or not--*/ 
int no_of_pkts=0; /*--holds the number of packets sent while down loading----*/
int no_of_dt_pkts=0;	/*---holds the number of data packets sent----*/
byte current_pkt=(byte)0; /*---holds the type of current packet sent---*/
int no_of_errors=0;		  /*---holds the number of errors while down loading---*/
byte ABORT_FLAG=(byte)0;  /*---indicates whether the down loading is aborted or not---*/

word CODE_CRC=0xffff;   /*---accumulates the crc of the compressed code---*/
dword ComprCodeSize;		/*---accumulates the length of the code----*/

extern  void file_buff(byte far *, FILE *);
extern word ltl_endian_word(word);
extern int TOTAL_TIME_TICKS, time_on, time_ticks, SEQ;
extern byte SHOW_CLK_TICKS;
extern int dnld_size;
extern win_data help_win;

extern int LZWcompress(FILE *, dword);
extern int on_dummy_exit(void);

void show_progress(dword, byte);

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : get_file_hndl(i)															 */
/* PURPOSE       : To get the index of the file in the file menu.					 */
/* PARAMETER     : i																				 */
/*                   -integer																	 */
/*                   -holds the index of the file name in the file menu.		 */
/* RETURN VALUE  : returns an integer (-1)												 */
/*-----------------------------------------------------------------------------*/
int get_file_hndl(int i)
  	{
	   file_hdl=i-1;
		return(-1);
	 }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : get_word																	 */
/* PURPOSE       : To read 'wrd_no'th word from the string							 */
/*	PARAMETERS    : str																			 */
/*                   -pointer to an array of bytes										 */
/*                   -holds the string from which the word is to be read		 */
/*                 wrd_no																		 */
/*                   -integer																	 */
/*                   -holds the word number which is to be read					 */
/* RETURN VALUE  : returns a pointer to an array of bytes.							 */
/*-----------------------------------------------------------------------------*/
byte *get_word(byte *str, int wrd_no)
  {
    int i=0;
	 int j=0;
	 byte *buff;
	 buff=(byte *)GetMem(sizeof(byte)*30);

	 while (wrd_no > 0)
	   {
	      while (str[i]==32) i++;      /*----skip blanks----*/
		  j=0;
	     while (str[i] && str[i]!=32)  /*---copy while not blank----*/
	       {
		       buff[j]=str[i];
		       i++;
		       j++;
		    }
		   wrd_no--;
		}
	 buff[j]=0;
	 return(buff);
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : create_filelist(fl_str)												 */
/* PURPOSE       : To create an array of file names & to select a file from it */
/* PARAMETER     : fl_str																		 */
/*                  -pointer to array of chars											 */
/*                  -points to file name													 */
/* RETURN VALUE  : Returns the file name if selected else NULL						 */
/*-----------------------------------------------------------------------------*/
byte *create_filelist(char *fl_str)
  {
	byte *bin_fl;
	menu_data *file_menu;
	win_data *file_win;
	byte **filelist;
	byte **duplist;
	int i=0;
	int j=0;
	struct _find_t *flnames;

	filelist=(byte **)GetMem(sizeof(byte *)*1);
	flnames=(struct _find_t *)GetMem(sizeof(struct _find_t));
	if (!_dos_findfirst((char *)fl_str, _A_NORMAL, flnames))
	  {
			/*-----atlease one .bin file is present-----*/
		   filelist[0]=(byte *)GetMem(sizeof(byte)*15);
	      my_strcpy(filelist[0], (byte *)flnames->name);
		   i++;
		   while (!_dos_findnext(flnames))	 /*---while .bin file is found---*/
		   	 {
		   	  j=0;
		   	  duplist=(byte **)GetMem(sizeof(byte *)*i);
		   	  while (j < i)
		   	    {
		   		   duplist[j]=filelist[j];
		   			j++;
		   		  }
		   		ReleaseMem((byte *)filelist);
	          filelist=(byte **)GetMem(sizeof(byte *)*(i+1));
		   		j=0;
		   		while (j < i)
		   		  {
		            filelist[j]=duplist[j];
		   			  j++;
		   		  }
		   		ReleaseMem((byte *)duplist);
		       filelist[i]=(byte *)GetMem(sizeof(byte)*15);
		       my_strcpy(filelist[i], (byte *)flnames->name); /* append the file name to list */
		   		i++;
		   	 }
	  		 
	   file_win=(win_data *)GetMem(sizeof(win_data));
	   file_menu=init_file_menu(filelist, i);			  /*---initialise the fields of the file menu---*/
		                                               /*---initialise the MENU_TYPE window---*/
	   init_win(file_win, 25,8, 8, 17, (byte *)"Files", MENU_TYPE, 1, (byte)i, on_dummy_exit,
	            (void *)0, (void *)0, bin_fl_help);
		file_hdl=-1;
	   file_win->addnl_info=(void *)file_menu;
	   realise_win(create_win(file_win));
		bin_fl=(byte *)GetMem(sizeof(byte)*15);
		if (file_hdl >= 0)				                 /*---if a file has been selected---*/
	      my_strcpy(bin_fl, filelist[file_hdl]);
	   j=0;
	   while (j < i)	                                /*---Realease all memory allocated---*/
	     {
	        ReleaseMem((byte *)filelist[j]);
			  ReleaseMem((byte *)file_menu[j].attb_string);
	     	  j++;
	     }
	   ReleaseMem((byte *)filelist);
		ReleaseMem((byte *)file_menu);
	   ReleaseMem((byte *)flnames);
	   return(bin_fl);
	  }        
   else
		{
		 /*---- no file is selected----*/
		 error_win((byte *)"Files not found", 15, 10, 21);
	    ReleaseMem((byte *)filelist);
	    ReleaseMem((byte *)flnames);
       return(NULL);
		}
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FILE NAME : file_length(fl)																 */
/* PURPOSE   : To find the file length(number of bytes) of a file					 */
/* PARAMETER : fl																					 */
/*               -file pointer																 */
/*               -points to a file whose file length is to be found				 */
/* RETURN VALUE : returns a double word(number of bytes in the file)				 */
/*-----------------------------------------------------------------------------*/
dword file_length(FILE *fl)
  {
    dword i=0;
	 while (fgetc(fl)!=EOF)    /*---while not end of file---*/
	   i++;
	 if (feof(fl))
	   return(i);
	 else 
	   return 0;
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : snd_abort_pkt																 */
/* PURPOSE       : To send an abort packet to target and to flash a message	 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void snd_abort_pkt()
  {
     DnLdPktHdrType abort_pkt;
	  abort_pkt.PacketType=PT_ABORT;
	  abort_pkt.SeqNum=(byte)SEQ;
	  snd_packet((byte *)&abort_pkt, sizeof(abort_pkt));
	  error_win((byte *)"Down Load Aborted", 20, 10, 23);
	  ABORT_FLAG=(byte)0;
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME  : cnf_dnld(fl, flsz)														 */
/* PURPOSE        : To download the configuration file into the target			 */
/*-----------------------------------------------------------------------------*/
void cnf_dnld(FILE *fl, dword flsz)
  {
     int count=0;
	  char buff[1024];
	  while (!feof(fl))  /*---while not end of file---*/
		 {
			count=0;
	      while (!feof(fl) && count < 1024)  /*---get 1k of data---*/
	        {
			     buff[count]=(char)fgetc(fl);
				  updatecrc(buff[count]);
			     count++;
		     }
		   if (count > 0)
			  {
				 if (count == 1024)
				    no_of_dt_pkts++;
				 dnld_size=count;
			    if (on_dnld_data((byte *)buff, flsz) < 0) /*---down load data--*/
				    break;
			  }
		 }

  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : on_dnld(i)																	 */
/* PURPOSE       : To initiate the down loading into the target					 */
/* PARAMETER     : i																				 */
/*                    -integer																 */
/* RETURN VALUE  : returns an integer														 */
/*-----------------------------------------------------------------------------*/
int  on_dnld(int i)
   {
	  FILE *fl, *ini_fl_ptr;
	  byte *wrd_str;
	  byte ini_buff[80];
	  int key=0;  /*---holds the key pressed---*/
	  str_data *dummy_str_dt;
	  byte *bin_fl_name;	 /*---points to file name---*/
	  win_data *progress_win;
	  int progress_win_id;
	  int help_win_id;
	  byte fllen_str[8];
	  int j=0;
	  int seqnum=0;		 /*---holds the sequence number of the packet----*/
	  dword fsize=0;		 /*---holds the file size of the file------------*/
 	  struct _find_t *flnames;


	  dnld_head_type dnld_header;
	  dnld_eof_type dnld_eof;
	  DnLdPktHdrType hdr_type;
	  TargetCmdType cmd_type;
	  ResultType restype;

	  /*--------------initialise variables-------------------*/
	  time_on=1;
	  no_of_pkts=0;
     no_of_pkts=0;
     no_of_dt_pkts=0;
     current_pkt=(byte)0;
     no_of_errors=0;
     ABORT_FLAG=(byte)0;
	  if (i==1) /*----Down load Code----*/
	     bin_fl_name=create_filelist((char *)"*.bin");
	  else 		/*----Down Load Cnf-----*/
	     bin_fl_name=create_filelist((char *)"*.cnf");  
	  if (file_hdl < 0)	/*---if no file is selected for down load, quit---*/
	    return(OK);

	  progress_win=(win_data *)GetMem(sizeof(win_data));
/*	  dummy_str_dt=(str_data *)GetMem(sizeof(str_data));
	  dummy_str_dt->string=(byte *)GetMem(sizeof(byte)*3);
	  dummy_str_dt->string[0]=0;  */
	  /*-------initialise the progress window-------------*/
	  init_win(progress_win, 12, 4, 17, 50, (byte *)"Down Load Statistics", MSG_TYPE, 1, 0, on_dummy_exit,
	          (void *)0, (void *)0, (void *)0);
/*	  progress_win->addnl_info=(void *)dummy_str_dt;  */
     help_win_id=create_win(&help_win);
 	  realise_win(help_win_id);
	  progress_win_id=create_win(progress_win);
	  realise_win(progress_win_id);
	  fill_window(progress_win_id, 32, 0x11);
	  draw_window(progress_win_id, 0x1f);

	  display_string((byte *)"File Name                     :", 0x050e, 0x1f, (void *)0);
	  display_string((byte *)bin_fl_name, 0x052e, 0x1f, (void *)0);

	  fl=fopen((char *)bin_fl_name, "r");
	  fsize=file_length(fl);
 	  fclose(fl);
	  fl=fopen((char *)bin_fl_name, "r");  

	  display_string((byte *)"File Length                   :", 0x070e, 0x1f, (void *)0);
	  h2str((dword)fsize, fllen_str, 0x0a);
	  display_string((byte *)fllen_str, 0x072e, 0x1f, (void *)0);

	  /*-------initialise the down load packets------------*/

	  cmd_type.Ptype=(byte)0;
	  if (i==1)  /*----Down Load Coad-----*/
	     cmd_type.TargetAction=(byte)DN_LD;
	  else      /*-----Down Load Cnf------*/
	     cmd_type.TargetAction=(byte)DN_LD_CNF;
	  dnld_header.hdr.PacketType=PT_HEADER;
	  dnld_header.hdr.SeqNum=(byte)seqnum;
     CODE_CRC=0xffff;
	  DOWN_LOAD=0;
     ComprCodeSize=0;
	  time_on=1;
	  TOTAL_TIME_TICKS=55;
	  SEQ=1;
	  no_of_dt_pkts=0;
	  show_progress(fsize, 1);
	  SHOW_CLK_TICKS=(byte)0;
	  /*---------------Send the Command Packet----------------*/
	  snd_packet((byte *)&cmd_type, sizeof(cmd_type));
	  rcv_packet((byte *)&restype, sizeof(restype));
     if (_kbhit())
	    {	
		   /*---a key has been pressed---*/
			key=getch();
		   if (!key)
			   key=getch();
			if (key==27)
			  {
				/*----Esc key has been pressed! send an abort packet----*/
			   snd_abort_pkt();
	         destroy_win(progress_win_id);
				destroy_win(help_win_id);
			   return(OK);
			 }
		 }
	  if (time_ticks > TOTAL_TIME_TICKS)
	  	  {
			 /*----no response from the target--------*/
	  	    error_win((byte *)"No Response From Target", 22, 10, 26);
			 fclose(fl);
	       destroy_win(progress_win_id);
			 destroy_win(help_win_id);
	  		 return(OK);
	  	  }

	  /*----open brd.ini file and initialise the header type packet----*/
	  if (i==1)
		  {
	        flnames=(struct _find_t *)GetMem(sizeof(struct _find_t));
	        if (!_dos_findfirst((char *)"brd.ini", _A_NORMAL, flnames))
	           ini_fl_ptr=fopen("brd.ini", "r");
		     else
				  {
				    ReleaseMem((byte *)flnames);
					 error_win((byte *)"brd.ini not found", 25, 10, 28);
					 return(OK);
				  }
		  }
	  else
		  {
	        flnames=(struct _find_t *)GetMem(sizeof(struct _find_t));
	        if (!_dos_findfirst((char *)"test.ini", _A_NORMAL, flnames))
	           ini_fl_ptr=fopen("test.ini", "r");
		     else
				  {
				    ReleaseMem((byte *)flnames);
					 error_win((byte *)"brd.ini not found", 25, 10, 28);
					 return(OK);
				  }
		  }
	  if (fgets((char *)ini_buff, 50, ini_fl_ptr))
		 {
			 wrd_str=get_word(ini_buff, 3);
			 sscanf((char *)wrd_str, "%lx", &dnld_header.headtype.DnLdAddress);
			 ReleaseMem((byte *)wrd_str);
		 }
	  if (fgets((char *)ini_buff, 50, ini_fl_ptr))
		 {
			 wrd_str=get_word(ini_buff, 3);
			 sscanf((char *)wrd_str, "%lx", &dnld_header.headtype.LoadAddr);
			 ReleaseMem((byte *)wrd_str);
		 }
	  if (fgets((char *)ini_buff, 50, ini_fl_ptr))
		 {
			 wrd_str=get_word(ini_buff, 3);
			 sscanf((char *)wrd_str, "%lx", &dnld_header.headtype.StartAddr);
			 ReleaseMem((byte *)wrd_str);
		 }
	  fclose(ini_fl_ptr);


/*	  dnld_header.headtype.LoadAddr=0xffffffff;
	  dnld_header.headtype.StartAddr=0xffffffff;
	  dnld_header.headtype.DnLdAddress=0x001f0000;  */
	  /*---------convert from 86 format to 68k format---------*/
	  dnld_header.headtype.MagicNum=ltl_endian_word((word)MAGIC_NUM);
	  dnld_header.headtype.LoadAddr=little_endian(dnld_header.headtype.LoadAddr);
	  dnld_header.headtype.StartAddr=little_endian(dnld_header.headtype.StartAddr);
	  dnld_header.headtype.DnLdAddress=little_endian(dnld_header.headtype.DnLdAddress);

	  TOTAL_TIME_TICKS=555;
	  DOWN_LOAD=1;
	  hdr_type.PacketType=PT_UNKNOWN;

	  while (hdr_type.PacketType!=PT_ACK)
	    {
			show_progress(fsize, 1);
			no_of_pkts++;
			current_pkt=dnld_header.hdr.PacketType;
//			display_string((byte *)"header", 0x1010, 0x1f, (void *)0);
//			getch();
			/*----send header type packet-------*/
	      snd_packet((byte *)&dnld_header, sizeof(dnld_header));
			time_on=1;
	      if (rcv_dnld_packet((byte *)&hdr_type, sizeof(hdr_type)))
			   continue;
			current_pkt=hdr_type.PacketType;
			show_progress(fsize, 0);
         if (_kbhit())
	       {
				/*----a key has been pressed----*/
				key=getch();
		      if (!key)
				  key=getch();
				if (key==27)
				  {
					/*-----Esc key has been pressed------*/
	            destroy_win(progress_win_id);
					destroy_win(help_win_id);
				   snd_abort_pkt();
	            DOWN_LOAD=0;
			      return(OK);
				  }
		    }
			if (time_ticks > 555)
			  {
				 /*------no response from the target-------*/
	          destroy_win(progress_win_id);
				 destroy_win(help_win_id);
	  	       error_win((byte *)"No Response From Target", 22, 10, 26);
	          DOWN_LOAD=0;
				 return(OK);
			  }
			else
			  {
			     switch(hdr_type.PacketType)
				    {
					   case PT_ABORT : /*---Abort command from the target-----*/
	                               destroy_win(progress_win_id);
					                   destroy_win(help_win_id);
						                error_win((byte *)"Down Load Aborted", 15, 10, 21);
						                fclose(fl);
											 DOWN_LOAD=0;
											 return(OK);
					 }

			   }
		 }
	  SEQ=1;
	  if (i==1)
	     LZWcompress(fl, fsize);  /*---compress the .bin file and down load----*/
	  else
	     cnf_dnld(fl, fsize);     /*---down load .cnf file without compression--*/ 
	  fclose(fl);
	  if (ABORT_FLAG==(byte)0)  
		 {
			  /*----Down loading is not aborted-------*/
			  current_pkt=PT_EOF;
			  no_of_pkts++;
			  show_progress(fsize, 1);
	        dnld_eof.hdr.PacketType=PT_EOF;	/*---init eof packet---*/
	        dnld_eof.hdr.SeqNum=(byte)SEQ;
	        updatecrc((byte)0);
	        updatecrc((byte)0);
	        dnld_eof.eoftype.CRC=ltl_endian_word(CODE_CRC);
	        dnld_eof.eoftype.CodeLength=little_endian((dword)ComprCodeSize);
	        dnld_eof.eoftype.Compression=(byte)1;
	        time_on=1;
//			  display_string((byte *)"eof ", 0x1010, 0x1f, (void *)0);
//			  getch();
	        snd_packet((byte *)&dnld_eof, sizeof(dnld_eof));
			  current_pkt=PT_EOF+1;
	        rcv_dnld_packet((byte *)&hdr_type, sizeof(hdr_type));
			  current_pkt=PT_EOF;
	        DOWN_LOAD=0;
		  }
	  ABORT_FLAG=(byte)0;
	  destroy_win(progress_win_id);
	  destroy_win(help_win_id);
	  DOWN_LOAD=0;
	  return(OK);
	}
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : show_progress(flsz)														 */
/* PURPOSE       : To show the down loading status										 */
/* PARAMETERS    : flsz																			 */
/*                   -double word															 */
/*                   -holds the size of the file that is being down loaded		 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void show_progress(dword flsz, byte snd_or_rcv)
  {
//	 win_data *progress_win;
//	 float factor;
//	 int progress_win_id; 
	 byte *progress_str;
	 byte pkt_no_str[8];
    byte *pkt_types[]={
								(byte *)"Unknown      ",
	                     (byte *)"Header Packet",
								(byte *)"Data Packet  ",
 								(byte *)"Abort Packet ",
								(byte *)"Eof Packet   ",
								(byte *)"Nack Packet  ",
								(byte *)"Ack Packet   "
							 };

/*	 factor=30/(float)((float)flsz/(float)1024);  */
	 progress_str=(byte *)GetMem(sizeof(byte)*33);
	 init_str(progress_str, (byte)176, 30);    /*---initialise the string---*/ 
	 if (flsz/1024)
	    str_nset(progress_str, 32, (int)(no_of_dt_pkts*30/(flsz/1024)));

	 h2str((dword)no_of_pkts, (byte *)pkt_no_str, 0x0a);
	 display_string((byte *)"Number of Packets transferred :", 0x090e, 0x1f, (void *)0);
	 display_string((byte *)pkt_no_str, 0x092e, 0x1f, (void *)0);

	 h2str((dword)no_of_errors, (byte *)pkt_no_str, 0x0a);
     	 display_string((byte *)"Number of Errors              :", 0x0b0e, 0x1f, (void *)0);
	 display_string((byte *)pkt_no_str, 0x0b2e, 0x1f, (void *)0);
 
	 display_string((byte *)"Last Packet Sent              :", 0x0d0e, 0x1f, (void *)0);
    display_string((byte *)"Last Packet Received          :", 0x0f0e, 0x1f, (void *)0);
	 
	 if (snd_or_rcv)
	     display_string((byte *)pkt_types[current_pkt], 0x0d2e, 0x1f, (void *)0);
	 else
	     display_string((byte *)pkt_types[current_pkt], 0x0f2e, 0x1f, (void *)0);

	 display_string((byte *)"Progress :", 0x110e, 0x1f, (void *)0);
	 display_string((byte *)progress_str, 0x1316, 0x1f, (void *)0);

	 ReleaseMem((byte *)progress_str);
  }
/*-----------------------------------------------------------------------------*/






 
