// -------------------------------------------------------------------------
// Project Name         :	MultiRouter Setup for Windows 
// File Name            :	DOT.CPP
// Description          :	Defines the CDotDecimal Class 
//									which contains a Dotted Decimal Address.
// Start Date           :	8th May 1995
// Author               :	Pravin
// Date Last Modified	:       
// Modifications        :       
// -------------------------------------------------------------------------

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "dot.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                       

/* chetan 8/7/97 */
/* #define MaxLength 15 */
/* chetan 8/7/97 */
LPCSTR ZeroIPAddress = "0.0.0.0";

//////////////////////////////////////////////////////////////
//CDotDecimal

CDotDecimal::CDotDecimal()
{
	CString::CString();
}

CDotDecimal::CDotDecimal(const char *psz):CString (psz)
{
//	CString::CString(psz);
}

CDotDecimal::~CDotDecimal()
{
	CString::~CString;
}

//////////////////////////////////////////////////////////////////
//CDotDecimal functions

BOOL CDotDecimal::IsValid()
{
	int zero_count = 0;

	if (IsEmpty())
	{
		// Chida - 26 Apr 1997 
		CDotDecimal aZero(ZeroIPAddress);
		CString::ConcatInPlace(aZero.m_nDataLength, aZero.m_pchData);
		return TRUE ;
	}		
	
	int size = GetLength() ;

/* chetan 8/7/97 */
/*	if(size > MaxLength) */
/* chetan 8/7/97 */
	if(size > MaxLengthOfIPAddr)
		return FALSE ;
	
	int pos ;
	if ((pos = Find ('.')) == -1)
		return FALSE ;					// Doesn't have dot
		
	if((pos < 1) || (pos > 3))
		return FALSE ;					// out of valid range of integer
											//	i.e. out of 8 bit value
		
	char Buf[4] ;
	Buf[3] = '\0' ;
	
	for (int i = 0 ; i < pos ; i ++)
	{
		Buf[i] = GetAt(i) ;
		if ((Buf[i] < '0') || (Buf[i] > '9'))
			return FALSE ;
	}
	
	Buf[pos] = '\0' ;
	
	// First byte being 127 is a special (loopback) address in IP addresses
	// and so cannot be specified.
	if(atoi (Buf) > 255 || atoi (Buf) == 127)       /*Change*/
		return FALSE ;

	if (atoi (Buf) == 0)
		zero_count ++ ;
	
	CString temp ;
	
	temp = Right (size - pos - 1) ;
	
	for (int j = 0 ; j < 3 ; j ++)
	{
		pos = temp.Find ('.') ;		
		if ((pos == -1) && (j != 2 ))
			return FALSE ;

		size = temp.GetLength() ;
		if (j == 2)
		  	pos = size ;
		
		if((pos < 1) || (pos > 3))
			return FALSE ;
		
		for( int i = 0 ; i < pos ; i ++)
		{
			Buf[i] = temp.GetAt(i) ;
			if ((Buf[i] < '0') || (Buf[i] > '9'))
				return FALSE ;
		}
		Buf[pos] = '\0' ;
	
		if (atoi (Buf) > 255)          /*Change*/
			return FALSE ;
		
		if (atoi (Buf) == 0)
			zero_count ++ ;

		//Prepare for next iteration		             
	  if(j != 2)
			temp = temp.Right (size - pos - 1) ;
	}

	if (zero_count == 4)
		return FALSE ; // All 0's is not a valid address

	return TRUE ;
}

// Added by Sreelu
BOOL CDotDecimal::IsValidTime()
{
	int pos,size;
	size = GetLength();
	if ((pos = Find (':')) == -1)
		return FALSE ;					// Doesn't have ':'

	if((pos < 1))
		return FALSE ;					// out of valid range of integer
	
	CString temp;
	pos++;
	temp = Right(size - pos);
	if(!temp.GetLength())
		return FALSE;
	
	return TRUE;
}

const CDotDecimal& CDotDecimal::operator=(const char* psz)
{
	CString::AssignCopy(SafeStrlen(psz), psz);
	return *this;
} 

const CDotDecimal& CDotDecimal::operator +=(const char* psz)
{
	CString::ConcatInPlace(SafeStrlen(psz), psz);
	return *this;
}

const CDotDecimal& CDotDecimal::operator +=(char ch)
{
	CString::ConcatInPlace(1, &ch);
	return *this;
}
/*
const CDotDecimal& CDotDecimal::operator +=(const CString& string)
{
	CString::ConcatInPlace(string.m_nDataLength, string.m_pchData);
	return *this;
} */

const CDotDecimal& CDotDecimal::operator +=(const CDotDecimal& string)
{
	CString::ConcatInPlace(string.m_nDataLength, string.m_pchData);
	return *this;
}

