// Added by Sreelu
// filterin.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "filterin.h"
#include "usrdata.h"
#include "filtradd.h"
#include "userfilt.h"
#include "userdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// FilterIn dialog
extern FILTER_DATA *sptr_filter_data;
TEMP_GROUPDATA *sptr_group_data;	
int NumOfFilter;
int NumOfGroups;
USHORT NumOfDomainName;
extern BOOL m_DBChanged;
extern USHORT number_of_filter_profiles;

static LPCSTR CheckFiltMsgHdr = "Filter Check";

FilterIn::FilterIn(CWnd* pParent /*=NULL*/)
	: CDialog(FilterIn::IDD, pParent)
{
	//{{AFX_DATA_INIT(FilterIn)
	//}}AFX_DATA_INIT
}

void FilterIn::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FilterIn)
	DDX_Control(pDX, IDC_BLOCKED_SITES, m_BlockCtrl);
	DDX_Control(pDX, IDC_ALLOW_SITES, m_AllowCtrl);
	DDX_Control(pDX, IDC_SELECTED_LIST, m_SelectCtrl);
	DDX_Control(pDX, IDC_GROUP_LIST, m_GroupCtrl);
	DDX_Control(pDX, IDC_LIST_TABLE, m_TableCtrl);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(FilterIn, CDialog)
	//{{AFX_MSG_MAP(FilterIn)
	ON_BN_CLICKED(IDCANCEL, OnBtnCancel)
	ON_BN_CLICKED(IDC_BTN_TO_GROUP, OnBtnToGroup)
	ON_BN_CLICKED(IDC_BTN_TO_SELECT, OnBtnToSelect)
	ON_BN_CLICKED(IDOK, OnOk)
	ON_LBN_SELCHANGE(IDC_LIST_TABLE, OnSelchangeListTable)
	ON_BN_CLICKED(IDC_BTN_ALL, OnBtnAll)
	ON_BN_CLICKED(IDC_BLOCKED_SITES, OnBlockedSites)
	ON_BN_CLICKED(IDC_ALLOW_SITES, OnAllowSites)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// FilterIn message handlers

void FilterIn::OnBtnCancel()
{
	// TODO: Add your control notification handler code here
	
	FILTER_DATA *ptr_filter_data = sptr_filter_data;
	for(int i = 0; i < NumOfFilter; i++)
	{
		ptr_filter_data->mask = ptr_filter_data->temp_mask;
		ptr_filter_data = ptr_filter_data->next;	
	}

	free (sptr_group_data);
	CDialog::OnCancel();
}

void FilterIn::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_FILTER, HELP_CONTEXT);
}

void FilterIn::SetDefaults()
{
	char string[50];	
	int gIndex;
	m_GroupCtrl.ResetContent();		
	m_SelectCtrl.ResetContent();		
	FILTER_DATA *pFildata = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(0);
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	
	TEMP_GROUPDATA *temp_group_data = sptr_group_data;
	NumOfFilter = pParent->m_Filter->m_ListCtrl.GetCount();
	NumOfGroups = pParent->m_UserDlg->m_LBoxForGroupName.GetCount();

	for(int Index=0; Index<NumOfGroups; Index++)
	{
		if(NumOfFilter != 0)
		{
			if(IsGroupSet(temp_group_data, pFildata))
			{
				wsprintf(string, "%s", temp_group_data->GroupName);
				int sIndex = m_SelectCtrl.AddString (string);
				m_SelectCtrl.SetItemDataPtr (sIndex, temp_group_data);
			}
			else
			{
				wsprintf(string, "%s", temp_group_data->GroupName);
				gIndex = m_GroupCtrl.AddString (string);
				m_GroupCtrl.SetItemDataPtr(gIndex, temp_group_data);
			}
		}
		else
		{
				wsprintf(string, "%s", temp_group_data->GroupName);
				gIndex = m_GroupCtrl.AddString (string);
				m_GroupCtrl.SetItemDataPtr(gIndex, temp_group_data);
		}
		temp_group_data++;
	}

	UpdateData (FALSE) ;
	m_GroupCtrl.SetCurSel(0);
	m_SelectCtrl.SetCurSel(0);
}

void FilterIn::OnBtnToGroup()
{
	// TODO: Add your control notification handler code here

	int sIndex, fIndex, gIndex;
	char string[50];
	TEMP_GROUPDATA *pGroupProfile;
	TEMP_GROUPDATA *temp_group_data;
	FILTER_DATA *pFilterProfile;		

	if(!m_TableCtrl.GetCount())
	{
		MessageBox("Filter Profile is Empty",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	fIndex = m_TableCtrl.GetCurSel();
	pFilterProfile = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(fIndex);

	if(fIndex == LB_ERR)		
	{
		MessageBox("Select Filter Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	int ItemIndex[30], TotItem;
	m_SelectCtrl.GetSelItems(NumOfGroups, (LPINT) &ItemIndex);
	TotItem = m_SelectCtrl.GetSelCount();

	for(int i=0; i<TotItem; i++)
	{
		pGroupProfile = (TEMP_GROUPDATA *) m_SelectCtrl.GetItemDataPtr(ItemIndex[i]);
		ResetGroupMask(pGroupProfile, pFilterProfile);
		pGroupProfile->Count--;
		if(!pGroupProfile->Count)
			pGroupProfile->FilterAction = DEFAULT;
	}

	m_GroupCtrl.SelItemRange(FALSE, ItemIndex[0], ItemIndex[TotItem-1]);
	m_GroupCtrl.SetSel(ItemIndex[0], TRUE);

	m_GroupCtrl.ResetContent();
	m_SelectCtrl.ResetContent();

	temp_group_data = sptr_group_data;
	for(int Index=0; Index<NumOfGroups; Index++)
	{
		if(IsGroupSet(temp_group_data, pFilterProfile))
		{
			wsprintf(string, "%s", temp_group_data->GroupName);
			sIndex = m_SelectCtrl.AddString (string);
			m_SelectCtrl.SetItemDataPtr (sIndex, temp_group_data);
		}
		else
		{
			if((temp_group_data->FilterAction == pFilterProfile->action) || (temp_group_data->FilterAction == DEFAULT)
						|| (temp_group_data->Count == 0))
			{
				wsprintf(string, "%s", temp_group_data->GroupName);
				gIndex = m_GroupCtrl.AddString (string);
				m_GroupCtrl.SetItemDataPtr(gIndex, temp_group_data);
			}
		}
		temp_group_data++;
	}

	m_GroupCtrl.SetCurSel(0);
	m_SelectCtrl.SetCurSel(0);
}

void FilterIn::OnBtnToSelect()
{
	// TODO: Add your control notification handler code here
	// Select the Groups from the Group List to The Selecte

	char string[50];
	int gIndex, sIndex, fIndex;
	TEMP_GROUPDATA *pGroupProfile;
	TEMP_GROUPDATA *temp_group_data;
	FILTER_DATA *pFilterProfile;		

	if(!m_TableCtrl.GetCount())
	{
		MessageBox("Filter Profile is Empty",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}

	fIndex = m_TableCtrl.GetCurSel();
	pFilterProfile = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(fIndex);

	if(fIndex == LB_ERR)		
	{
		MessageBox("Select Filter Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}

	int ItemIndex[30], TotItem;
	m_GroupCtrl.GetSelItems(NumOfGroups,(LPINT) &ItemIndex);	  	
	TotItem = m_GroupCtrl.GetSelCount();
	for(int i=0; i<TotItem; i++)
	{
		pGroupProfile = (TEMP_GROUPDATA *) m_GroupCtrl.GetItemDataPtr(ItemIndex[i]);
		SetGroupMask(pGroupProfile, pFilterProfile);
		pGroupProfile->Count++;
		pGroupProfile->FilterAction = pFilterProfile->action;

		wsprintf(string, "%s", pGroupProfile->GroupName);
		sIndex = m_SelectCtrl.AddString (string);
		m_SelectCtrl.SetItemDataPtr (sIndex, pGroupProfile);
		m_SelectCtrl.SetCurSel(sIndex);
	}

	m_GroupCtrl.SelItemRange(FALSE, ItemIndex[0], ItemIndex[TotItem-1]);
	m_GroupCtrl.SetSel(ItemIndex[0], TRUE);

	m_GroupCtrl.ResetContent();
	m_SelectCtrl.ResetContent();

	temp_group_data = sptr_group_data;
	for(int Index=0; Index<NumOfGroups; Index++)
	{
		if(IsGroupSet(temp_group_data, pFilterProfile))
		{
			wsprintf(string, "%s", temp_group_data->GroupName);
			sIndex = m_SelectCtrl.AddString (string);
			m_SelectCtrl.SetItemDataPtr (sIndex, temp_group_data);
		}
		else
		{
			if((temp_group_data->FilterAction == pFilterProfile->action) || (temp_group_data->FilterAction == DEFAULT)
						|| (temp_group_data->Count == 0))
			{
				wsprintf(string, "%s", temp_group_data->GroupName);
				gIndex = m_GroupCtrl.AddString (string);
				m_GroupCtrl.SetItemDataPtr(gIndex, temp_group_data);
			}
		}
		temp_group_data++;
	}

	m_GroupCtrl.SetCurSel(0);
  	m_SelectCtrl.SetCurSel(0);
}

void FilterIn::OnOk()
{
	// TODO: Add your control notification handler code here
	// Read the Filter Details add store it in a linked list.
	int Index, bIndex = 0, aIndex = 0;
	FILTER_DATA *pFildata;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();

#if 0
	NumOfDomainName = 0;
	NumOfFilter = pParent->m_Filter->m_ListCtrl.GetCount();
	for(Index = 0; Index < NumOfFilter; Index++)
	{
		pFildata = (FILTER_DATA *) pParent->m_Filter->m_ListCtrl.GetItemDataPtr(Index);
		if(!pFildata->action) 
			bIndex++;
		else
			aIndex++;
			
		if(!pFildata->mask)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Check the Group Enteries",
				(LPCSTR) CheckFiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_TableCtrl.ResetContent();
			if(pFildata->action == FILTER)
			{
				m_BlockCtrl.SetCheck(1);
				m_AllowCtrl.SetCheck(0);
				FilterProfile(FILTER);
				m_TableCtrl.SetCurSel(bIndex - 1);
			}
			else
			{
				m_BlockCtrl.SetCheck(0);
				m_AllowCtrl.SetCheck(1);
				FilterProfile(FORWARD);
				m_TableCtrl.SetCurSel(aIndex - 1);
			}
			OnSelchangeListTable();
			return;
		}			
	}
#endif

	TEMP_GROUPDATA *temp_group_data = sptr_group_data;
	for(Index = 0; Index < NumOfGroups; Index++)
	{
		GROUPDATA *pGdata = (GROUPDATA *) pParent->m_UserDlg->m_LBoxForGroupName.GetItemDataPtr (Index) ;
		pGdata->Allow_Sites = temp_group_data->FilterAction;
#if 0
	char str[50];
	sprintf(str, "%s : %d", pGdata->GroupName, pGdata->Allow_Sites);
	AfxMessageBox(str);
#endif
		temp_group_data++;
	}

	free (sptr_group_data);
	CDialog::OnOK();
}

BOOL FilterIn::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("BARROW1", "BARROW2", "BARROW3", "BARROW4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BTN_TO_GROUP, this));
	DeleteBmpBtn.SizeToContent();

	if (!SelectBmpBtn.LoadBitmaps ("FARROW1", "FARROW2", "FARROW3", "FARROW4"))
		AfxMessageBox ("Failed to load SELECT bitmap");

	VERIFY (SelectBmpBtn.SubclassDlgItem (IDC_BTN_TO_SELECT, this));
	SelectBmpBtn.SizeToContent();							  

	if (!AllBmpBtn.LoadBitmaps ("ALL1", "ALL2", "ALL3", "ALL4"))
		AfxMessageBox ("Failed to load ALL bitmap");

	VERIFY (AllBmpBtn.SubclassDlgItem (IDC_BTN_ALL, this));
	AllBmpBtn.SizeToContent();							  

	int TabStops[] = {22, 150, 190, 230};
	m_TableCtrl.SetTabStops (4, (LPINT) &TabStops);

	m_BlockCtrl.SetCheck(1);
	m_AllowCtrl.SetCheck(0);
	FilterProfile(FILTER);

	m_GroupCtrl.SetCurSel(0);
	m_SelectCtrl.SetCurSel(0);

	FILTER_DATA *ptr_filter_data = sptr_filter_data;
	for(int i = 0; i < NumOfFilter; i++)
	{
		ptr_filter_data->temp_mask = ptr_filter_data->mask;
		ptr_filter_data = ptr_filter_data->next;	
	}

	if(m_TableCtrl.SetCurSel(0) != LB_ERR)
		OnSelchangeListTable();
	CenterWindow() ;
	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void FilterIn::GroupProfile()
{
	USHORT number_of_group_items = 1;

	TEMP_GROUPDATA *temp_group_data = sptr_group_data;
	if (temp_group_data == NULL)
	{
		MessageBox ((LPCSTR) "Insufficient memory",
							(LPCSTR) "Group Profile List", MB_OK | MB_ICONSTOP) ;
		return;
	}
	SetDefaults();
}

void FilterIn::FilterProfile(int ListSelection)
{	
	// Display Filter details from Filter Dialog
	int nIndex;
	FILTER_DATA *pFilterProfile;
	char proto[10], action[10], string[100];
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();

   NumOfFilter = pParent->m_Filter->m_ListCtrl.GetCount();
  for(int i = 0; i < NumOfFilter; i++)	
  {	
	pFilterProfile = (FILTER_DATA *)pParent->m_Filter->m_ListCtrl.GetItemDataPtr(i);
	if(pFilterProfile->action == ListSelection)
	{
		if (pFilterProfile->proto == TCP_PROTOCOL) 
			strcpy(proto, "TCP");
		else
			strcpy(proto, "UDP");

		if (pFilterProfile->action == FILTER)
			strcpy(action, "Block");
		else
			strcpy(action, "Allow");

		if(pFilterProfile->type == APPLICATION)
			wsprintf(string, "%s\t%s\t%d\t%s\t%s","App","None",
				pFilterProfile->port, proto, action);

		if(pFilterProfile->type == IP_ADDRESS)	
				wsprintf(string, "%s\t%s\t%d\t%s\t%s","IP",pFilterProfile->address,
					pFilterProfile->port, "None", action);

		if(pFilterProfile->type == DOMAIN_NAME)
		{
			char dom_name[255];
			strcpy(dom_name, pFilterProfile->address);
			if(strlen(pFilterProfile->address) > 30)
				strncpy((dom_name) + 25, "", 10);

			wsprintf(string, "%s\t%s\t%u\t%s\t%s","Dom",dom_name,
					pFilterProfile->port,"None",action);
		}

		nIndex = m_TableCtrl.AddString(string);
		m_TableCtrl.SetItemDataPtr (nIndex, pFilterProfile) ;
	}
  }
}

void FilterIn::SetGroupMask(TEMP_GROUPDATA *pGroupProfile, FILTER_DATA *pFilterProfile)
{
	// Sets the Group Mask for the filters.
	ULONG GROUP_MASK_ENABLE = 0x00000001;
	ULONG group_mask;
	group_mask = GROUP_MASK_ENABLE << (pGroupProfile->GroupNo - 1);
	pFilterProfile->mask |= group_mask;
}

void FilterIn::ResetGroupMask(TEMP_GROUPDATA *pGroupProfile, FILTER_DATA *pFilterProfile)
{
	// Resets the Group Mask for the filters.
	ULONG GROUP_MASK_ENABLE = 0x00000001;
	ULONG group_mask;
	group_mask = GROUP_MASK_ENABLE << (pGroupProfile->GroupNo - 1);
	pFilterProfile->mask ^= group_mask;
}

void FilterIn::OnSelchangeListTable()
{
	// TODO: Add your control notification handler code here
	FILTER_DATA *pFildata;
	TEMP_GROUPDATA *temp_group_data;
	char string[100];
	char	szRHS[255];
	int  fIndex, sIndex, Index, gIndex;
	
	UpdateData (TRUE) ;
	fIndex = m_TableCtrl.GetCurSel();
	pFildata = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(fIndex);
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	m_SelectCtrl.ResetContent();
	m_GroupCtrl.ResetContent();

	temp_group_data = sptr_group_data;
	NumOfGroups = pParent->m_UserDlg->m_LBoxForGroupName.GetCount();
	for(Index=0; Index<NumOfGroups; Index++)
	{
		if(IsGroupSet(temp_group_data, pFildata))
		{
			wsprintf(string, "%s", temp_group_data->GroupName);
			sIndex = m_SelectCtrl.AddString (string);
			m_SelectCtrl.SetItemDataPtr (sIndex, temp_group_data);
		}
		else
		{
			if((temp_group_data->FilterAction == pFildata->action) || (temp_group_data->FilterAction == DEFAULT) 
						|| (temp_group_data->Count == 0))
			{
				wsprintf(string, "%s", temp_group_data->GroupName);
				gIndex = m_GroupCtrl.AddString (string);
				m_GroupCtrl.SetItemDataPtr(gIndex, temp_group_data);
			}
		}
		temp_group_data++;
	}

	UpdateData (FALSE) ;
	m_GroupCtrl.SetCurSel(0);
	m_SelectCtrl.SetCurSel(0);
}

BOOL FilterIn::IsGroupSet(TEMP_GROUPDATA *pGroupProfile, FILTER_DATA *pFilterProfile)
{	
	ULONG GROUP_MASK_ENABLE = 0x00000001;
	ULONG group_mask, group_result;
	group_mask = GROUP_MASK_ENABLE << (pGroupProfile->GroupNo - 1);
	group_result = pFilterProfile->mask & group_mask;

	if(group_result) 
		return TRUE;
	else
		return FALSE;
}

void FilterIn::OnBtnAll()
{
	// TODO: Add your control notification handler code here
	char string[50];
	TEMP_GROUPDATA *pGroupProfile;
	FILTER_DATA *pFilterProfile;

	if(!m_TableCtrl.GetCount())
	{
		MessageBox("Filter Profile is Empty",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	int fIndex = m_TableCtrl.GetCurSel();
	if(fIndex == LB_ERR)		
	{
		MessageBox("Select Filter Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}

	pFilterProfile = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(fIndex);
	
	int gCount = m_GroupCtrl.GetCount();
	for(int i = 0; i < gCount; i++)			 	
	{
		pGroupProfile = (TEMP_GROUPDATA *) m_GroupCtrl.GetItemDataPtr(i);

		SetGroupMask(pGroupProfile, pFilterProfile);
		pGroupProfile->Count++;
		pGroupProfile->FilterAction = pFilterProfile->action;

		wsprintf(string, "%s", pGroupProfile->GroupName);
		int sIndex = m_SelectCtrl.AddString (string);
		m_SelectCtrl.SetItemDataPtr (sIndex, pGroupProfile);
		m_SelectCtrl.SetCurSel(0);
	}
	m_GroupCtrl.ResetContent();
}

void FilterIn::OnAllowSites()
{
	// TODO: Add your control notification handler code here
// List Out Only the Sites that has to Allowed

	UpdateData (TRUE) ;
	m_BlockCtrl.SetCheck(0);
	m_AllowCtrl.SetCheck(1);
	int count = m_TableCtrl.GetCount();
#if 0
	for(int i = 0; i < count; i++)
		FILTER_DATA *pFildata = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(i);
#endif

	m_TableCtrl.ResetContent();		
	m_GroupCtrl.ResetContent();		
	m_SelectCtrl.ResetContent();		

	FilterProfile(FORWARD);
	if(m_TableCtrl.SetCurSel(0) != LB_ERR)
		OnSelchangeListTable();
}

void FilterIn::OnBlockedSites()
{
	// TODO: Add your control notification handler code here
// List Out Only the Sites that has to Blocked
	
	UpdateData (TRUE) ;
	m_BlockCtrl.SetCheck(1);
	m_AllowCtrl.SetCheck(0);
	int count = m_TableCtrl.GetCount();
#if 0
	for(int i = 0; i < count; i++)
		FILTER_DATA *pFildata = (FILTER_DATA *) m_TableCtrl.GetItemDataPtr(i);
#endif

	m_TableCtrl.ResetContent();		
	m_GroupCtrl.ResetContent();		
	m_SelectCtrl.ResetContent();		

	FilterProfile(FILTER);
	if(m_TableCtrl.SetCurSel(0) != LB_ERR)
		OnSelchangeListTable();
}
/////////////////////////////////////////////////////////////////////////////
// CFilter dialog


CFilter::CFilter(CWnd* pParent /*=NULL*/)
	: CDialog(CFilter::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilter)
	m_UDBCheckStr = FALSE;
	//}}AFX_DATA_INIT
	Create (IDD, NULL);
}

void CFilter::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilter)
	DDX_Control(pDX, IDC_BTN_VIEW, m_ViewWnd);
	DDX_Control(pDX, IDC_CHECK_USERDATABASE, m_UDBEnabled);
	DDX_Control(pDX, IDC_RADIO_BLACKLISTED, m_BlockWnd);
	DDX_Control(pDX, IDC_RADIO_ALLOW, m_AllowWnd);
	DDX_Control(pDX, IDC_LIST1, m_ListCtrl);
	DDX_Check(pDX, IDC_CHECK_USERDATABASE, m_UDBCheckStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFilter, CDialog)
	//{{AFX_MSG_MAP(CFilter)
	ON_BN_CLICKED(IDC_BTN_ADD, OnBtnAdd)
	ON_BN_CLICKED(IDC_BTN_DELETE, OnBtnDelete)
	ON_BN_CLICKED(IDC_BTN_VIEW, OnBtnView)
	ON_BN_CLICKED(IDC_RADIO_ALLOW, OnRadioAllow)
	ON_BN_CLICKED(IDC_RADIO_BLACKLISTED, OnRadioBlacklisted)
	ON_BN_CLICKED(IDC_CHECK_USERDATABASE, OnCheckUserdatabase)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFilter message handlers

void CFilter::OnBtnAdd()
{
	// TODO: Add your control notification handler code here
	FiltrAdd CFilterAdd (this) ;
	CFilterAdd.DoModal() ;

	return ;
}

void CFilter::OnBtnDelete()
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	FILTER_DATA *pFildata;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();

	NumOfFilter = m_ListCtrl.GetCount();
	if(!NumOfFilter)
	{
		AfxMessageBox("Filter Profile Is Empty.");
		pParent->m_UserDlg->m_FilterWnd.EnableWindow (FALSE);
		return;
	}
	
	int nIndex = m_ListCtrl.GetCurSel();
	if (nIndex == LB_ERR)
	{
		MessageBox("Select Filter Profile to Delete",NULL,MB_OK | MB_ICONINFORMATION);
		return ;
	}

	int nRetVal = MessageBox (
			(LPCSTR) "Do you really want to delete selected filter ?",
						(LPCSTR) "Filter - Delete",
								MB_YESNO | MB_ICONQUESTION) ;

// If Deletion cancelled return
	if (nRetVal == IDNO)
		return ;

	pFildata = (FILTER_DATA *) m_ListCtrl.GetItemDataPtr(nIndex);
	DeleteEntryFromList(pFildata);
	m_ListCtrl.DeleteString(nIndex);

	if(!m_ListCtrl.GetCount())
		pParent->m_UserDlg->m_FilterWnd.EnableWindow (FALSE);
	
	m_DBChanged = TRUE;
	m_ListCtrl.SetCurSel(0);
}

void CFilter::OnBtnView()
{
	// TODO: Add your control notification handler code here
	if(!m_ListCtrl.GetCount())
	{
		MessageBox("Filter Profile is Empty",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}
	int Index = m_ListCtrl.GetCurSel();
	if(Index == LB_ERR)
	{
		MessageBox("Select Filter Profile",NULL,MB_OK | MB_ICONINFORMATION);
		return;
	}

	CDomain domain(this);
	domain.DoModal();
	return;
}

void CFilter::OnCancel()
{
	// TODO: Add extra cleanup here
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CFilter::OnOK()
{
	// TODO: Add extra validation here
//	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

BOOL CFilter::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BTN_ADD, this));
	AddBmpBtn.SizeToContent();							  

	if (!DeleteBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBtn.SubclassDlgItem (IDC_BTN_DELETE, this));
	DeleteBtn.SizeToContent();							  

	if (!ViewBtn.LoadBitmaps ("VIEW1", "VIEW2", "VIEW3", "VIEW4"))
		AfxMessageBox ("Failed to load VIEW bitmap");

	VERIFY (ViewBtn.SubclassDlgItem (IDC_BTN_VIEW, this));
	ViewBtn.SizeToContent();			  				  

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBitmapBtn.SizeToContent();

	m_ViewWnd.EnableWindow (FALSE);
	m_ListCtrl.ResetContent() ;

	int TabStops[] = {30, 150, 180, 220};
	m_ListCtrl.SetTabStops (4, (LPINT) &TabStops);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

LRESULT CFilter::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CFilter::PostNcDestroy(void)
{
	if(m_UDBEnabled.GetCheck())
		delete this;
}

void CFilter::OnRadioAllow()
{
	m_AllowWnd.SetCheck(1);
	m_BlockWnd.SetCheck(0);
	DisplayFilterProfile();
}

void CFilter::OnRadioBlacklisted()
{
	m_AllowWnd.SetCheck(0);
	m_BlockWnd.SetCheck(1);
	DisplayFilterProfile();
}

void CFilter::OnCheckUserdatabase()
{
	// TODO: Add your control notification handler code here
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	if (!m_UDBEnabled.GetCheck())
	{
		m_UDBCheckStr = FALSE;
		pParent->enableView (1, FALSE);
		pParent->enableView (2, FALSE);
		m_AllowWnd.EnableWindow(TRUE);
		m_BlockWnd.EnableWindow(TRUE);
	}
	else
	{
		m_UDBCheckStr = TRUE;
		pParent->enableView (1, TRUE);
		pParent->enableView (2, TRUE);
		m_AllowWnd.EnableWindow(FALSE);
		m_BlockWnd.EnableWindow(FALSE);
	}
	m_ListCtrl.ResetContent();
	DisplayFilterProfile();
}

void CFilter::OnSelchangeList1()
{
	// TODO: Add your control notification handler code here
	int Index;
	FILTER_DATA *pFilter;

	Index = m_ListCtrl.GetCurSel();
	pFilter = (FILTER_DATA *) m_ListCtrl.GetItemDataPtr(Index);
	if(pFilter->type != DOMAIN_NAME)
		m_ViewWnd.EnableWindow (FALSE);
	else
		m_ViewWnd.EnableWindow (TRUE);
}

void CFilter::AddEntryToList(FILTER_DATA *pFilter)
{
	FILTER_DATA *pFilterList;

	if(sptr_filter_data == NULL)
	{
		sptr_filter_data = pFilter;
		sptr_filter_data->next = NULL;	
		return;
	}

	pFilterList = sptr_filter_data;
	while(1)
	{
		if(pFilterList->next == NULL)
		{
			pFilterList->next = pFilter;
			pFilterList->next->next = NULL;
			break;
		}
		else
		{
			pFilterList = pFilterList->next;
		}
	}
}

void CFilter::DeleteEntryFromList(FILTER_DATA *pFilter)
{
	FILTER_DATA *pFilterList, *pFilterNext, *temp_ptr;
	
	pFilterList = sptr_filter_data;
	switch(pFilter->type)
	{
		case APPLICATION:
			if((pFilterList->port == pFilter->port) && (pFilterList->proto == pFilter->proto))
			{
				sptr_filter_data = sptr_filter_data->next;
				free (pFilter);
				return;
			}
			break;
		case IP_ADDRESS :
		case DOMAIN_NAME:
			if(!strcmp(pFilterList->address, pFilter->address))
			{
				sptr_filter_data = sptr_filter_data->next;
				free (pFilter);
				return;
			}	
			break;
	}

	pFilterList = sptr_filter_data;
	while(1)
	{
		pFilterNext = pFilterList->next;
		if (pFilterNext == NULL)
			break;

		switch(pFilter->type)
		{
			case APPLICATION:
				if((pFilterNext->port == pFilter->port) && (pFilterNext->proto == pFilter->proto))
				{
				 // Free pFilterNext
					pFilterList->next = pFilterNext->next;
					free (pFilter);
				}
				else
					pFilterList = pFilterList->next;
				break;
			case IP_ADDRESS :
			case DOMAIN_NAME:
				if(!strcmp(pFilterNext->address, pFilter->address))
				{
				 // Free pFilterNext
					pFilterList->next = pFilterNext->next;
					free (pFilter);
				}
				else
					pFilterList = pFilterList->next;
				break;
		}
	}	
}

void CFilter::DisplayFilterProfile()
{
	FILTER_DATA *ptr_filter_data, *pFilterProfile;
	char proto[10], action[10], string[200], dom_name[255];
	int nIndex;

	m_ListCtrl.ResetContent();
	ptr_filter_data = sptr_filter_data;

  while(ptr_filter_data != NULL)
  {
	if(!m_UDBEnabled.GetCheck())
	{
		// Display Filter Datas from either sptr_allow_data or sptr_block_data accordingly
		if(m_AllowWnd.GetCheck())
		{
			// Display Only Sites that has to be Allowed
		  if(ptr_filter_data->action == FORWARD)	
		  {	
			if (ptr_filter_data->proto == TCP_PROTOCOL) 
				strcpy(proto, "TCP");
			else
				strcpy(proto, "UDP");

			if (ptr_filter_data->action == FILTER)
				strcpy(action, "Block");
			else
				strcpy(action, "Allow");

			if(ptr_filter_data->type == APPLICATION)
				wsprintf(string, "%s\t%s\t%d\t%s\t%s","App","None",
					ptr_filter_data->port, proto, action);

			if(ptr_filter_data->type == IP_ADDRESS)	
					wsprintf(string, "%s\t%s\t%d\t%s\t%s","IP",ptr_filter_data->address,
						ptr_filter_data->port, "None", action);

			if(ptr_filter_data->type == DOMAIN_NAME)
			{
				strcpy(dom_name, ptr_filter_data->address);
				if(strlen(ptr_filter_data->address) > 30)
					strncpy((dom_name) + 25, "", 10);

				wsprintf(string, "%s\t%s\t%u\t%s\t%s","Dom",dom_name,
						ptr_filter_data->port,"None",action);
			}

			nIndex = m_ListCtrl.AddString(string);
			m_ListCtrl.SetItemDataPtr (nIndex, ptr_filter_data) ;
			ptr_filter_data = ptr_filter_data->next;
		  }
		  else
			ptr_filter_data = ptr_filter_data->next;
		}
		else
		{
			// Display Only Sites that has to be Blocked
		 if(ptr_filter_data->action == FILTER)
		 {
			if (ptr_filter_data->proto == TCP_PROTOCOL) 
				strcpy(proto, "TCP");
			else
				strcpy(proto, "UDP");

			if (ptr_filter_data->action == FILTER)
				strcpy(action, "Block");
			else
				strcpy(action, "Allow");

			if(ptr_filter_data->type == APPLICATION)
				wsprintf(string, "%s\t%s\t%d\t%s\t%s","App","None",
					ptr_filter_data->port, proto, action);

			if(ptr_filter_data->type == IP_ADDRESS)	
					wsprintf(string, "%s\t%s\t%d\t%s\t%s","IP",ptr_filter_data->address,
						ptr_filter_data->port, "None", action);

			if(ptr_filter_data->type == DOMAIN_NAME)
			{
				strcpy(dom_name, ptr_filter_data->address);
				if(strlen(ptr_filter_data->address) > 30)
					strncpy((dom_name) + 25, "", 10);

				wsprintf(string, "%s\t%s\t%u\t%s\t%s","Dom",dom_name,
						ptr_filter_data->port,"None",action);
			}

			nIndex = m_ListCtrl.AddString(string);
			m_ListCtrl.SetItemDataPtr (nIndex, ptr_filter_data) ;
			ptr_filter_data = ptr_filter_data->next;
		 }
		 else
			ptr_filter_data = ptr_filter_data->next;
		}
	}
	else
	{
		// Display Filter Datas from sptr_filter_data
			if (ptr_filter_data->proto == TCP_PROTOCOL) 
				strcpy(proto, "TCP");
			else
				strcpy(proto, "UDP");

			if (ptr_filter_data->action == FILTER)
				strcpy(action, "Block");
			else
				strcpy(action, "Allow");

			if(ptr_filter_data->type == APPLICATION)
				wsprintf(string, "%s\t%s\t%d\t%s\t%s","App","None",
					ptr_filter_data->port, proto, action);

			if(ptr_filter_data->type == IP_ADDRESS)	
					wsprintf(string, "%s\t%s\t%d\t%s\t%s","IP",ptr_filter_data->address,
						ptr_filter_data->port, "None", action);

			if(ptr_filter_data->type == DOMAIN_NAME)
			{
				strcpy(dom_name, ptr_filter_data->address);
				if(strlen(ptr_filter_data->address) > 30)
					strncpy((dom_name) + 25, "", 10);

				wsprintf(string, "%s\t%s\t%u\t%s\t%s","Dom",dom_name,
						ptr_filter_data->port,"None",action);
			}

			nIndex = m_ListCtrl.AddString(string);
			m_ListCtrl.SetItemDataPtr (nIndex, ptr_filter_data) ;
			ptr_filter_data = ptr_filter_data->next;
	}
	if(ptr_filter_data == NULL)
		break;
  }	
}

void CFilter::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_USER_FILTER_MENU, HELP_CONTEXT);
}

/////////////////////////////////////////////////////////////////////////////
// CDomain dialog


CDomain::CDomain(CWnd* pParent /*=NULL*/)
	: CDialog(CDomain::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDomain)
	m_DomainStr = "";
	//}}AFX_DATA_INIT
}

void CDomain::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDomain)
	DDX_Text(pDX, IDC_EDIT1, m_DomainStr);
	DDV_MaxChars(pDX, m_DomainStr, 255);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDomain, CDialog)
	//{{AFX_MSG_MAP(CDomain)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDomain message handlers

BOOL CDomain::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	char string[300];
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	int Index = pParent->m_Filter->m_ListCtrl.GetCurSel();
	FILTER_DATA *pFilter = (FILTER_DATA *) pParent->m_Filter->m_ListCtrl.GetItemDataPtr(Index);

	strcpy(string, pFilter->address);
	m_DomainStr = string;
	
	UpdateData (FALSE) ;
	return TRUE;  // return TRUE  unless you set the focus to a control
}
