// filterin.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// FilterIn dialog

#include "usrdata.h"

class FilterIn : public CDialog
{
// Construction
public:
	FilterIn(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(FilterIn)
	enum { IDD = IDD_FILTER };
	CButton	m_BlockCtrl;
	CButton	m_AllowCtrl;
	CListBox	m_SelectCtrl;
	CListBox	m_GroupCtrl;
	CListBox	m_TableCtrl;
   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
	CBitmapButton DeleteBmpBtn;
	CBitmapButton SelectBmpBtn;
	CBitmapButton AllBmpBtn;
	//}}AFX_DATA

   void GroupProfile();
	void SetDefaults();
	BOOL IsGroupSet(TEMP_GROUPDATA *, FILTER_DATA *);

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(FilterIn)
	afx_msg void OnBtnCancel();
	afx_msg void OnBtnToGroup();
	afx_msg void OnBtnToSelect();
	afx_msg void OnFilterAdd();
	afx_msg void OnFilterDelete();
	afx_msg void OnHelp();
	afx_msg void OnOk();
	afx_msg void SetGroupMask(TEMP_GROUPDATA *, FILTER_DATA *);
	afx_msg void ResetGroupMask(TEMP_GROUPDATA *, FILTER_DATA *);
	afx_msg void FilterProfile(int);
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeListTable();
	afx_msg void OnBtnAll();
	afx_msg void OnBlockedSites();
	afx_msg void OnAllowSites();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CFilter dialog

class CFilter : public CDialog
{
// Construction
public:
	CFilter(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CFilter)
	enum { IDD = IDD_USER_FILTER_MENU };
	CButton	m_ViewWnd;
	CButton	m_UDBEnabled;
	CButton	m_BlockWnd;
	CButton	m_AllowWnd;
	CListBox	m_ListCtrl;
   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
	CBitmapButton AddBmpBtn;
	CBitmapButton DeleteBtn;
	CBitmapButton ViewBtn;
	BOOL	m_UDBCheckStr;
	//}}AFX_DATA
	void DisplayFilterProfile();
	void AddEntryToList(FILTER_DATA *);
//	int GetMyID ();

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CFilter)
	afx_msg void OnBtnAdd();
	afx_msg void OnBtnDelete();
	afx_msg void OnBtnView();
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg LRESULT OnSwitchFromIden(WPARAM, LPARAM);
	virtual void PostNcDestroy();
	afx_msg void OnRadioAllow();
	afx_msg void OnRadioBlacklisted();
	afx_msg void OnCheckUserdatabase();
	afx_msg void OnSelchangeList1();
	afx_msg void DeleteEntryFromList(FILTER_DATA *);
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CDomain dialog

class CDomain : public CDialog
{
// Construction
public:
	CDomain(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CDomain)
	enum { IDD = IDD_USER_DOMAIN };
	CString	m_DomainStr;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CDomain)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
