// Added by Sreelu
// filtradd.cpp : implementation file
//

#include "stdafx.h"
#include "dot.h"
#include "procon.h"
#include "filtradd.h"
#include "filterin.h"
#include "userfilt.h"
#include "userdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern BOOL m_DBChanged;

/////////////////////////////////////////////////////////////////////////////
// FiltrAdd dialog

//CDotDecimal DotValue;
extern BOOL IsStrNumericAndValid(LPCSTR String);
static LPCSTR FiltMsgHdr = "Filter Entry";
extern int NumOfGroups;

FiltrAdd::FiltrAdd(CWnd* pParent /*=NULL*/)
	: CDialog(FiltrAdd::IDD, pParent)
{
	//{{AFX_DATA_INIT(FiltrAdd)
	m_AddStr = "";
	m_PortStr = "";
	//}}AFX_DATA_INIT
}

void FiltrAdd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(FiltrAdd)
	DDX_Control(pDX, IDC_COMBO_ACTION, m_ActionCtrl);
	DDX_Control(pDX, IDC_STATIC_PROTOCOL, m_StatProtoCtrl);
	DDX_Control(pDX, IDC_STATIC_PORT, m_StatPortCtrl);
	DDX_Control(pDX, IDC_STATIC_DOMAIN, m_DomainCtrl);
	DDX_Control(pDX, IDC_STATIC_FIL_ACTION, m_FilterActionCtrl);
	DDX_Control(pDX, IDC_STATIC_FIL_TYPE, m_FilterTypeCtrl);
	DDX_Control(pDX, IDC_EDIT_PORT, m_PortCtrl);
	DDX_Control(pDX, IDC_EDIT_ADDRESS, m_AddCtrl);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_ProtoCtrl);
	DDX_Control(pDX, IDC_COMBO_FIL_TYPE, m_FiltypeCtrl);
	DDX_Text(pDX, IDC_EDIT_ADDRESS, m_AddStr);
	DDX_Text(pDX, IDC_EDIT_PORT, m_PortStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(FiltrAdd, CDialog)
	//{{AFX_MSG_MAP(FiltrAdd)
	ON_BN_CLICKED(IDCANCEL, OnBtnCancel)
	ON_BN_CLICKED(IDC_BTN_HELP, OnBtnHelp)
	ON_BN_CLICKED(IDOK, OnBtnOk)
	ON_CBN_SELCHANGE(IDC_COMBO_FIL_TYPE, OnSelchangeComboFilType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// FiltrAdd message handlers

void FiltrAdd::OnBtnCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}

void FiltrAdd::OnBtnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_ADD_FILTER, HELP_CONTEXT);
}

void FiltrAdd::OnBtnOk()
{
	// TODO: Add your control notification handler code here

	char type[5], proto[10], action[10], string[200], szRHS[255];
	CDotDecimal DotValue;
	FILTER_DATA *pFildata;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();

	UpdateData(TRUE);

	pFildata = (FILTER_DATA *) calloc(sizeof(FILTER_DATA), 1);

	pFildata->mask = 0;

	if (m_FiltypeCtrl.GetCurSel() == 0)	
		pFildata->type = APPLICATION;
	if (m_FiltypeCtrl.GetCurSel() == 1)	
		pFildata->type = IP_ADDRESS;
	if (m_FiltypeCtrl.GetCurSel() == 2)	
		pFildata->type = DOMAIN_NAME;

	pFildata->port = atoi((LPCSTR)m_PortStr);

	if ( !IsStrNumericAndValid(m_PortStr) && pFildata->type == APPLICATION)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
			(LPCSTR) FiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_PortCtrl.SetFocus();
		return;
	}

	if (m_ProtoCtrl.GetCurSel() == 0)
	{
		strcpy(proto, "TCP");
		pFildata->proto = TCP_PROTOCOL;
	}
	else
	{
		strcpy(proto, "UDP");
		pFildata->proto = UDP_PROTOCOL;
	}

	if(pFildata->type != APPLICATION)
	{
		pFildata->port = 0;
		if(strlen(m_AddStr) > 255)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Please Don't Enter More than 255 Characters",
				(LPCSTR) FiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_AddCtrl.SetFocus();
			return;
		}

		if(m_AddStr == ZeroIPAddress)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Entry",
				(LPCSTR) FiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_AddCtrl.SetFocus();
			return;
		}

		strcpy(pFildata->address, m_AddStr);
		strcpy(proto, "NONE");
		if(pFildata->type == IP_ADDRESS)
		{
			strcpy(pFildata->address, m_AddStr);
			DotValue = m_AddStr;
		 	if(!strcmp(DotValue,ZeroIPAddress) || !DotValue.IsValid())
			{				
				AfxMessageBox("Invalid IP Address");
				m_AddCtrl.SetFocus();
				return;
			}
		}
	}
	else
	{
		if(pFildata->port == 0)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type",
				(LPCSTR) FiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_PortCtrl.SetFocus();
			return;
		}
	}
	
	if (m_ActionCtrl.GetCurSel() == 0)
	{
		strcpy(action, "Block");
		pFildata->action = FILTER;
	}
	else
	{
		strcpy(action, "Allow");
		pFildata->action = FORWARD;
	}

// Checking For Duplicates
	BOOL RetVal = CheckForDuplicates(pFildata);
	if(RetVal)		// TRUE - Already Exist
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Entry Already Exist",
			(LPCSTR) FiltMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		free(pFildata);
		return;
  	}			

	pParent->m_Filter->m_ViewWnd.EnableWindow (FALSE);
	pParent->m_UserDlg->m_FilterWnd.EnableWindow (TRUE);
	
	if(pFildata->type == APPLICATION)
		wsprintf(string, "%s\t%s\t%u\t%s\t%s","App","None",
			pFildata->port, proto, action);

	if(pFildata->type == IP_ADDRESS)	
		wsprintf(string, "%s\t%s\t%u\t%s\t%s","IP",pFildata->address,
			pFildata->port, "None", action);

	if(pFildata->type == DOMAIN_NAME)
	{
		char dom_name[255];
		strcpy(dom_name, pFildata->address);
		if(strlen(pFildata->address) > 30)
			strncpy((dom_name) + 25, "", 10);

		wsprintf(string, "%s\t%s\t%u\t%s\t%s","Dom",dom_name,
				pFildata->port,"None",action);
		pParent->m_Filter->m_ViewWnd.EnableWindow (TRUE);
	}

	int nIndex = pParent->m_Filter->m_ListCtrl.AddString(string);
  	pParent->m_Filter->m_ListCtrl.SetItemDataPtr (nIndex, pFildata) ;
	pParent->m_Filter->m_ListCtrl.SetCurSel(nIndex);
	pParent->m_Filter->AddEntryToList (pFildata);

	UpdateData(FALSE);
	m_DBChanged = TRUE;
	CDialog::OnOK();
}

BOOL FiltrAdd::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();	

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBitmap.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmap.SubclassDlgItem (IDOK, this));
	OKBitmap.SizeToContent();

	if (!CancelBitmap.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmap.SubclassDlgItem (IDCANCEL, this));
	CancelBitmap.SizeToContent();

	if (!HelpBitmap.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmap.SubclassDlgItem (IDC_BTN_HELP, this));
	HelpBitmap.SizeToContent();

	m_AddStr = ZeroIPAddress;
	m_AddCtrl.LimitText (255) ;

//	Default Settings.
	m_FiltypeCtrl.SetCurSel(0);
	m_ActionCtrl.SetCurSel(0);
	m_ProtoCtrl.SetCurSel(0);
	
//	Disable IP Address & Domain Name Parameters
	m_DomainCtrl.EnableWindow(FALSE);
	m_AddCtrl.EnableWindow(FALSE);

// Enable Port & Protocol Parameters
	m_PortCtrl.EnableWindow(TRUE);
	m_ProtoCtrl.EnableWindow(TRUE);
	m_StatPortCtrl.EnableWindow(TRUE);
 	m_StatProtoCtrl.EnableWindow(TRUE);

	UserFilterTab *pParent = (UserFilterTab *) GetParent ();
	if(!pParent->m_Filter->m_UDBEnabled.GetCheck())
	{
		m_FilterActionCtrl.EnableWindow(FALSE);
		m_ActionCtrl.EnableWindow(FALSE);
		if(!pParent->m_Filter->m_AllowWnd.GetCheck())
			m_ActionCtrl.SetCurSel(0);
		else
			m_ActionCtrl.SetCurSel(1);
	}

	CenterWindow() ;
	UpdateData (FALSE) ;
	return FALSE;  // return TRUE  unless you set the focus to a control
}

void FiltrAdd::SelectApplication()
{
	UpdateData(TRUE);
//	Disable IP Address & Domain Name Parameters
	m_DomainCtrl.EnableWindow(FALSE);
	m_AddCtrl.EnableWindow(FALSE);

// Enable Port & Protocol Parameters
	m_PortCtrl.EnableWindow(TRUE);
	m_ProtoCtrl.EnableWindow(TRUE);
	m_StatPortCtrl.EnableWindow(TRUE);
 	m_StatProtoCtrl.EnableWindow(TRUE);
	m_AddStr = ZeroIPAddress;
}

void	FiltrAdd::SelectIPAddr()
{
	UpdateData(TRUE);
//	Disable Port & Protocol Parameters
	m_PortCtrl.EnableWindow(FALSE);
	m_ProtoCtrl.EnableWindow(FALSE);
	m_StatPortCtrl.EnableWindow(FALSE);
 	m_StatProtoCtrl.EnableWindow(FALSE);
	m_AddStr = ZeroIPAddress;

//	Enable IP Address & Domain Name Parameters
	m_DomainCtrl.EnableWindow(TRUE);
	m_AddCtrl.EnableWindow(TRUE);
}

void	FiltrAdd::SelectDomain()
{
	UpdateData(TRUE);
//	Disable Port & Protocol Parameters
	m_PortCtrl.EnableWindow(FALSE);
	m_ProtoCtrl.EnableWindow(FALSE);
	m_StatPortCtrl.EnableWindow(FALSE);
 	m_StatProtoCtrl.EnableWindow(FALSE);

//	Enable IP Address & Domain Name Parameters
	m_DomainCtrl.EnableWindow(TRUE);
	m_AddCtrl.EnableWindow(TRUE);
}

void FiltrAdd::OnSelchangeComboFilType()
{
	// TODO: Add your control notification handler code here
	int index;
	char szRHS[50];

	UpdateData(TRUE);
	index = m_FiltypeCtrl.GetCurSel();
	switch(index)
	{
		case 0:
			SelectApplication();
			break;
		case 1:
			SelectIPAddr();
			m_AddStr = ZeroIPAddress;
			break;
		case 2:
			SelectDomain();
			strcpy (szRHS, " ");
			m_AddStr = szRHS;
			break;
	}

}

BOOL FiltrAdd::CheckForDuplicates(FILTER_DATA *pFilter)
{
	FILTER_DATA *pFilterParent;
	UserFilterTab *pParent = (UserFilterTab *) GetParent ();

	int TotEntry = pParent->m_Filter->m_ListCtrl.GetCount();
	for(int i = 0; i < TotEntry; i++)
	{
		pFilterParent = (FILTER_DATA *) pParent->m_Filter->m_ListCtrl.GetItemDataPtr(i);
		if(pFilter->type == APPLICATION)
		{
			if((pFilterParent->port == pFilter->port) && 
				(pFilterParent->proto == pFilter->proto))
				return TRUE;
		}
		else
		if((pFilter->type == IP_ADDRESS) || (pFilter->type == DOMAIN_NAME))
		{
			if(!strcmpi(pFilterParent->address, pFilter->address))
				return TRUE;
		}
	}
	return FALSE;		
}
