// ftpports.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "proxy.h"
#include "ftpports.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static LPCSTR FTPErrMsgHdr = "Proxy FTP Ports Entry";     // Neelu
extern BOOL IsStrNumericAndValid(LPCSTR String);
extern char f_name[30], f_ctrl[10], f_data[10];

/////////////////////////////////////////////////////////////////////////////
// CFtpPorts dialog


CFtpPorts::CFtpPorts(CWnd* pParent /*=NULL*/)
	: CDialog(CFtpPorts::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFtpPorts)
	m_ctrl_port = "";
	m_data_port = "";
	//}}AFX_DATA_INIT
}

void CFtpPorts::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFtpPorts)
	DDX_Control(pDX, IDC_EDIT_DATA_PORT, m_data_port_ctrl);
	DDX_Control(pDX, IDC_EDIT_CTRL_PORT, m_ctrl_port_ctrl);
	DDX_Text(pDX, IDC_EDIT_CTRL_PORT, m_ctrl_port);
	DDV_MaxChars(pDX, m_ctrl_port, 5);
	DDX_Text(pDX, IDC_EDIT_DATA_PORT, m_data_port);
	DDV_MaxChars(pDX, m_data_port, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFtpPorts, CDialog)
	//{{AFX_MSG_MAP(CFtpPorts)
	ON_BN_CLICKED(IDHELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFtpPorts message handlers

BOOL CFtpPorts::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here
	CenterWindow() ; 
	
	/* Change the title of the dialog as usual */
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	sprintf(WindowHeader, DialogTitleFormat,
		WindowText.GetBuffer(0),SubHeadingPointer);

	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDHELP, this));
	HelpBmpBtn.SizeToContent();

	// TODO: Add extra initialization here

	m_ctrl_port = f_ctrl;
	m_data_port = f_data;

	m_ctrl_port_ctrl.LimitText(5);
	m_data_port_ctrl.LimitText(5);

	// Update dialog data.
	UpdateData (FALSE) ;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFtpPorts::OnOK()
{
	// TODO: Add extra validation here
	unsigned short ctrl_port = 0, data_port = 0, index = 0, sel = 0;
	char c_port[10], d_port[10], strRHS[50];
	char lftp_name[30];
	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	Protocol[PROTOCOL_NAME_SIZE];
	char	Port[PORT_NAME_SIZE];
	
	// Update member variabled
	UpdateData (TRUE) ;

	strcpy(c_port,"21");	 /* default FTP_COMMAND_PORT */
	strcpy(d_port,"20");	 /* default FTP_DATA_PORT */

	if ( ! IsStrNumericAndValid(m_ctrl_port))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type.\nEnter value between 1 & 65535.",
			(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_port_ctrl.SetFocus();
		return ;
	}

	if ( m_ctrl_port == m_data_port)
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Control & Data port are the same.Enter Different values.",
			(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_port_ctrl.SetFocus();
		return ;
	}

	if ((strcmp(m_ctrl_port,"0") == 0) || (strcmp(m_ctrl_port,"") == 0))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type.\nEnter value between 1 & 65535.",
			(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_ctrl_port_ctrl.SetFocus();
		return ;
	}

	if ( ! IsStrNumericAndValid(m_data_port))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type.\nEnter value between 1 & 65535.",
			(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_data_port_ctrl.SetFocus();
		return ;
	}

	if ((strcmp(m_data_port,"0") == 0) || (strcmp(m_data_port,"") == 0))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Unknown Port type.\nEnter value between 1 & 65535.",
			(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
		m_data_port_ctrl.SetFocus();
		return ;
	}

	if(!ValidPortNumbers())
		return;

	sscanf(m_ctrl_port,"%d",&ctrl_port);
	sscanf(m_data_port,"%d",&data_port);

	strcpy(f_ctrl,m_ctrl_port);
	strcpy(f_data,m_data_port);

	sprintf(lftp_name,"FTP(%d,%d)",ctrl_port, data_port);

	while(((Proxy *)GetParent())->m_ProxyListWnd.GetText(index++, ProtocolPort) != LB_ERR)
	{
		sscanf(ProtocolPort,"%s\t%s",Protocol,Port);
		if (strncmp(Port,"FTP",3) == 0)
		{
			if ( !((Proxy *)GetParent())->DeleteEntry((LPCSTR)Protocol, (LPCSTR)Port))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Internal Error.\n\
     	  			Couldn't Delete selection.",	(LPCSTR) FTPErrMsgHdr, 
					MB_OK | MB_ICONEXCLAMATION) ;
				return;
			}

			// Add Entry the new entry to list box

			if ( !((Proxy *)GetParent())->AddEntry((LPCSTR)Protocol, (LPCSTR)lftp_name))
			{
				::MessageBox (GetSafeHwnd(), (LPCSTR) "Maximum limit reached!\n\
		   		Can't add any more.",(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					return;
			}
		}
	}			

	CDialog::OnOK();
}

void CFtpPorts::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

BOOL CFtpPorts::ValidPortNumbers()
{
	int index=0;
	unsigned short ctrl_port, data_port, lower_port, higher_port;
	char c_port[10], d_port[10];

	char	ProtocolPort[PROTOCOL_NAME_SIZE + PORT_NAME_SIZE];
	char	tmpProtocol[PROTOCOL_NAME_SIZE],tmpPort[PORT_NAME_SIZE];
	char PrevDesc[DESC_LEN];
   char  *dmy,dmy1,dmy2,tmpnPort[5];

	UpdateData(TRUE);

	sscanf(m_ctrl_port, "%05d", &ctrl_port);
	sscanf(m_data_port, "%05d", &data_port);

	sprintf(c_port, "%05d", ctrl_port);
	sprintf(d_port, "%05d", data_port);

/* checking the ctrl & data port numbers with reserved port numbers */

	while (TCPPortStrings[index].Name) 
 	{
		if(strncmp(TCPPortStrings[index].Name, "FTP", 3) == 0)
		{
			index++;
			continue;
		}

		if((strcmpi(c_port, TCPPortStrings[index].Number1) == 0)
			|| (strcmpi(c_port, TCPPortStrings[index].Number2) == 0))
		{
			::MessageBox (GetSafeHwnd(), 
				(LPCSTR) "Control port number conflicting with reserved port number.\nEnter different number",
				(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_ctrl_port_ctrl.SetFocus();
			return FALSE;
		}

		if((strcmpi(d_port, TCPPortStrings[index].Number1) == 0)
			|| (strcmpi(d_port, TCPPortStrings[index].Number2) == 0))
		{
			::MessageBox (GetSafeHwnd(), 
				(LPCSTR) "Data port number conflicting with reserved port number.\nEnter different number",
				(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
			m_ctrl_port_ctrl.SetFocus();
			return FALSE;
		}
		index++;
	}

	index = 0;
/* checking the ctrl & data port numbers with user defined entries */
	while(1)
	{
		if (((Proxy *)GetParent())->m_ProxyListWnd.GetText(index++, ProtocolPort) != LB_ERR)
		{
         sscanf(ProtocolPort,"%s\t%s",tmpProtocol,tmpPort);

/* check only for user defined entries */
			sscanf(tmpPort,"%c%[^(]%c%d", &dmy1, PrevDesc, &dmy2, &lower_port);
			if (dmy1 != '$')
				continue;

			if(strchr(ProtocolPort, (int) ',' ))
			{
				sscanf(tmpPort, "%[^(]%c%[^)]%c", dmy, &dmy1, tmpnPort, &dmy2) ;
			 	sscanf(tmpnPort,"%d%c%d", &lower_port, &dmy2,&higher_port);
			 	if((ctrl_port >= lower_port ) && (ctrl_port <= higher_port ))
			 	{
				 	::MessageBox (GetSafeHwnd(), 
						(LPCSTR) "Control port number conflicting with user defined port.\nEnter a different number.",
						(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_port_ctrl.SetFocus();
					return FALSE ;
			 	}

			 	if((data_port >= lower_port ) && (data_port <= higher_port ))
			 	{
				 	::MessageBox (GetSafeHwnd(), 
						(LPCSTR) "Data port number conflicting with user defined port.\nEnter a different number.",
						(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					m_data_port_ctrl.SetFocus();
					return FALSE ;
			 	}
			}

			else 
			{
				if(ctrl_port == lower_port)
				{
					::MessageBox (GetSafeHwnd(), 
						(LPCSTR) "Control port number conflicting with user defined port.\nEnter different number.",
						(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					m_ctrl_port_ctrl.SetFocus();
					return FALSE;
				}

				if(data_port == lower_port)
				{
					::MessageBox (GetSafeHwnd(), 
						(LPCSTR) "Data port number conflicting with user defined port.\nEnter different number.",
						(LPCSTR) FTPErrMsgHdr, MB_OK | MB_ICONEXCLAMATION) ;
					m_data_port_ctrl.SetFocus();
					return FALSE;
				}
			}
		}
		else
			break;
	}

	return TRUE;
}

void CFtpPorts::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_DIALOG_FTP_PORTS, HELP_CONTEXT);
}
