// history.cpp : implementation file
// Neelu for user events history

#include "stdafx.h"
#include "procon.h"
#include "history.h"
#include "time.h"
#include "dos.h"

#define MaxINIString 150   // Maximum length of string in the CNF File.


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHistory dialog


CHistory::CHistory(CWnd* pParent /*=NULL*/)
	: CDialog(CHistory::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHistory)
	m_log_event = "";
	m_combo_date = "";
	m_combo_month = "";
	m_combo_year = "";
	m_year  = "";
	//}}AFX_DATA_INIT
}

void CHistory::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHistory)
	DDX_Control(pDX, IDC_LIST1, m_ctrl_log_event);
	DDX_Control(pDX, IDC_COMBO1, m_ctrl_date);
	DDX_Control(pDX, IDC_COMBO2, m_ctrl_month);
	DDX_Control(pDX, IDC_COMBO3, m_ctrl_year);
	DDX_LBString(pDX, IDC_LIST1, m_log_event);
	DDX_CBString(pDX, IDC_COMBO1, m_combo_date);
	DDX_CBString(pDX, IDC_COMBO2, m_combo_month);
	DDX_CBString(pDX, IDC_COMBO3, m_combo_year);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHistory, CDialog)
	//{{AFX_MSG_MAP(CHistory)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_CBN_SELCHANGE(IDC_COMBO2, OnSelchangeMonth)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CHistory message handlers

int YearComboBox[3];
int InitDlg;

BOOL CHistory::OnInitDialog()
{
	char date_buf[128];
	int dd,mm,yy;
	CDialog::OnInitDialog();

	
	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();
	
	if (!RefreshBmpBtn.LoadBitmaps ("REFRESH1", "REFRESH2", "REFRESH3"))
		AfxMessageBox ("Failed to load REFRESH bitmap");

	VERIFY (RefreshBmpBtn.SubclassDlgItem (IDC_BUTTON_REFRESH, this));
	RefreshBmpBtn.SizeToContent();
	
	_strdate(date_buf);
	sscanf(date_buf,"%02d/%02d/%02d",&mm,&dd,&yy);
	
	FillOutComboBoxs(dd,mm,yy);
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHistory::OnButtonRefresh()
{
       //	char Filename[128];
	// TODO: Add your control notification handler code here
	int dd = m_ctrl_date.GetCurSel();
	int mm = m_ctrl_month.GetCurSel()+1;
	int yy = m_ctrl_year.GetCurSel();
	char Buf[400];	
	char *ch;
	char day[10],tmpmonth[10],year[10];
	char Time[25],Date[25],Msg[40],date[25],uname[40],Msg1[40];
	
	m_ctrl_date.GetLBText(dd,day);
     //	AfxMessageBox(day);
	
	sprintf(tmpmonth,"%02d",mm);
     //AfxMessageBox(tmpmonth);
	
	m_ctrl_year.GetLBText(yy,year);
//    	AfxMessageBox(year);

	sprintf(date, "%s/%s/%s", day, tmpmonth, year);
  //	AfxMessageBox(date);
		
	  
	  
	  
	  m_ctrl_log_event.ResetContent();

	
	
	CStdioFile input;
	char *FileName = UserEventBdcastFile ;
	if (!input.Open(FileName, CFile::modeRead | CFile::typeText))
		return ;
	////Read the strings and if there is a newline character, don't display it
	////Also if the buffer is empty, don't add the empty string to the listbox.
	while((input.ReadString(Buf , MaxINIString)) != NULL)
	{
		
		sscanf(Buf,"%s  %s  %s  %s",Time,Date,uname,Msg);
//		AfxMessageBox(Buf);
//		AfxMessageBox(Date);
//		AfxMessageBox(Msg);
//		AfxMessageBox(Msg1);

		char Buffer[400];
		if ((ch = strchr (Buf, (int)'\n')) != NULL)
		       	*ch= '\0';
		if ((ch = strchr (Buf, (int)'#')) != NULL)  
			*ch = '\0';
		if (Buf[0])
		{ 	
		     	sprintf(Buffer,"%s %s %s",Time,uname,Msg);
		     //	AfxMessageBox(Buffer);
			if(strcmp(date,Date) == 0)
			m_ctrl_log_event.InsertString (m_ctrl_log_event.GetCount(), Buffer);
	
		}		
	}
	input.Close();

	CenterWindow();
// 	UpdateData (FALSE);
	
	
#if 0
//	sprintf(Filename,"%02d%02d%04d.log",dd+1,mm+1,YearComboBox[yy]);
	sprintf(Filename,"01011900.log");
	
//	AfxMessageBox(Filename);

 	m_ctrl_log_event.ResetContent();

	CStdioFile output;
	char Buf[128],*ch;
	const int MaxINIString = 128;
	if(!output.Open(Filename, CFile::modeRead | CFile::typeText))
	{
		if(!InitDlg)
			AfxMessageBox("History not Available");
		return;
	}
	
// 	m_ctrl_log_event.ResetContent();
	while((output.ReadString(Buf , MaxINIString)) != NULL)
	{
		if ((ch = strchr (Buf, (int)'\n')) != NULL)
			*ch = '\0';
		m_ctrl_log_event.InsertString (m_ctrl_log_event.GetCount(), Buf);
	}
	output.Close();

	CenterWindow();

#endif
	
	return;
}

void CHistory::FillOutComboBoxs(int day, int month, int year)
{
	int index = 0, ZeroIndex = 0;
	char *Months[] = {"Jan","Feb","Mar","Apr","May","Jun","July","Aug","Sep","Oct","Nov","Dec"};
	char StringtoInsert[20];
	int DaysInMonth[] = { 31,28,31,30,31,30,31,31,30,31,30,31};
	
	m_ctrl_month.ResetContent();
	m_ctrl_date.ResetContent();
	m_ctrl_year.ResetContent();
	
	year = (year == 99) ? 1900 + year : 2000 + year;
	YearComboBox[0] = year - 1;
	YearComboBox[1] = year ;
	YearComboBox[2] = year + 1;
	YearComboBox[3] = year - 99;//new
	index = DaysInMonth[month-1];
	if(!year%4) index++;
	while(index--)
	{
		sprintf(StringtoInsert, "%02d", ZeroIndex + 1);
		m_ctrl_date.InsertString(ZeroIndex++,StringtoInsert);
	}
	index = 12 ;
	ZeroIndex = 0;
	while(index--)
	{
		m_ctrl_month.InsertString(ZeroIndex, Months[ZeroIndex]);
		ZeroIndex++;
	}

  	ZeroIndex = 0;
  	sprintf(StringtoInsert, "%d", year - 1);
  	m_ctrl_year.InsertString(ZeroIndex++, StringtoInsert);
  	sprintf(StringtoInsert, "%d", year );
  	m_ctrl_year.InsertString(ZeroIndex++, StringtoInsert);
  	sprintf(StringtoInsert, "%d", year - 99); //new
  	m_ctrl_year.InsertString(ZeroIndex++, StringtoInsert);//new

	m_ctrl_date.SetCurSel(day - 1);
	m_ctrl_month.SetCurSel(month - 1);
	m_ctrl_year.SetCurSel(1);
	return;
}

void CHistory::OnSelchangeMonth()
{
	// TODO: Add your control notification handler code here
	char date_buf[128];
	int dd,mm,yy;

	int index = m_ctrl_month.GetCurSel();
	_strdate(date_buf);
    	sscanf(date_buf,"%02d/%02d/%02d",&mm,&dd,&yy);
    // 	sscanf(date_buf,"%02d/%02d/%s",&mm,&dd,yy);

	FillOutComboBoxs(dd,index + 1,yy);
	return;
}

void CHistory::OnOK()
{
	// TODO: Add extra validation here
	CDialog::OnOK();

}

void CHistory::OnButtonClear()
{
	// TODO: Add your control notification handler code here
	char HistFiles[FILE_NAME_SIZE];
	struct _find_t *filename;
	
	filename = (struct _find_t *) malloc (sizeof(struct _find_t));
	if(filename == NULL)
		return;
	strcpy(HistFiles,LoadPath);
	strcat(HistFiles,"*.log");
	_dos_findfirst(HistFiles,_A_NORMAL,filename);
//	_dos_findfirst("*.log",_A_NORMAL,filename);

//	AfxMessageBox(filename->name);
	remove(filename->name);
	while(!_dos_findnext(filename))
	{
//		AfxMessageBox(filename->name);
		remove(filename->name);
	} 
	return;
}

#if 0
void CHistory::OnDropdownCombo3()
{
	// TODO: Add your control notification handler code here
	char year[10];
	AfxMessageBox("Edit Combo Box");
	int index = 0;
	m_ctrl_year.InsertString(index++,m_combo_year);
     //	AfxMessageBox("Edit Combo Box");

	m_ctrl_year.SetCurSel(index);
	UpdateData(FALSE);
		
}
#endif
