/*----------------------------------------------------------------------------
  Filename   : ddehdlr.c
  Purpose    : This file contains the functions which handle the DDE
			   messages with the program manager to create the groups.
----------------------------------------------------------------------------*/

#include "windows.h"
#include "string.h"
#include "dde.h"
#include "install.h"
#include "ddehdlr.h"
#include "utils.h"
#include "init.h"

char ApplnName[8] = "PROGMAN" ;
char TopicName[8] = "Progman" ;
		
static BOOL	bInInitiate = FALSE ;
static BOOL	ConvInitiated = FALSE ;

PRODUCTSTRUCT ProductStringStruct ;

int DeleteOldIconIndex = 0 ;
int DeleteIconIndex = 0 ;
int AddIconIndex = 0 ;


/*----------------------------------------------------------------------------
  Function   : InitConnection (hWndClient)
  Purpose    : Initialises the conversation.
----------------------------------------------------------------------------*/
BOOL InitConnection (HWND hWndClient)
{
    ATOM  atomTopic ;
    ATOM  atomApplication ;

    atomTopic = GlobalAddAtom ((LPCSTR) TopicName) ;
    atomApplication = GlobalAddAtom ((LPCSTR) ApplnName) ;

    /* flag bInInitiate is queried when client processes the server's ACK */
    bInInitiate = TRUE ;
	ConvInitiated = FALSE ;				 
    SendMessage (
		HWND_BROADCAST,           // = -1 i.e. broadcast to all
   		WM_DDE_INITIATE, 
		hWndClient,
   		MAKELONG (atomApplication, atomTopic)
	) ;
    bInInitiate = FALSE ;

    GlobalDeleteAtom (atomApplication) ;
    GlobalDeleteAtom (atomTopic) ;
    return ConvInitiated ;
}


/*----------------------------------------------------------------------------
 Function   : ClientAcknowledge (HWND, HWND, long, BOOL)
 Purpose    : Called when client application receives WM_DDE_ACK message
				  or WM_TIMER message (time out on wait for ACK).
----------------------------------------------------------------------------*/
void ClientAcknowledge (HWND hWndClient, HWND hWndServer,
												LONG lParam, BOOL bTimeOut)
{
   char szTopic[12] ;
   char szApplication[12] ;
	BOOL fBusy = FALSE ;
	BOOL fNACK = FALSE ;

	if (bInInitiate)
	{
    	GlobalGetAtomName (LOWORD (lParam), (LPSTR) szApplication, 10) ;
      GlobalGetAtomName (HIWORD (lParam), (LPSTR) szTopic, 10) ;
		if (!lstrcmpi ((LPCSTR) szApplication, (LPCSTR) ApplnName) &&
					  		 !lstrcmpi ((LPCSTR) szTopic, (LPCSTR) TopicName))
		{
			bInInitiate = FALSE ;
			ConvInitiated = TRUE ;
			hgWndPM = hWndServer ;
			return ;
	   }
   }

	KillTimer (hgWnd, DDE_TIMER_ID) ;

	if (!bTimeOut)
	{
		if (! (LOWORD (lParam) & 0x8000))
		{
			fNACK = TRUE ;
			if (LOWORD (lParam) & 0x4000)
				fBusy = TRUE ;
		}

		switch (CreateState) 
		{
			case CREATE_GROUP :
			case SHOW_GROUP :
				if (fNACK)
				{		
					if (!fBusy)
					{
						ShowWindow (hgWnd, SW_NORMAL) ;
						if (CreateState == CREATE_GROUP)
						{
							MessageBox (hgWnd,
    							(LPCSTR) "Program Manager Could Not Create Group",
						    		InstallTitle, MB_OK | MB_ICONINFORMATION) ;
						}
						else
						{
							if (CreateState == SHOW_GROUP)
							{
								MessageBox (hgWnd,
  									(LPCSTR) "Program Manager Could Not Show Group",
									    InstallTitle, MB_OK | MB_ICONINFORMATION) ;
							}
						}
						CreateState = END_CONV ;
						break ;
				   }
				   else
						break ;
				}
				else
				{
					CreateState ++ ;		/* advance to next state */
					break ;
				}
				break ;

			case DELETE_OLD_ITEM :
				if (fNACK)
				{
					if (!fBusy)
					{
			 			DeleteOldIconIndex ++ ;
						if (DeleteOldIconIndex > NoOfOldIcons)
						{
							CreateState ++ ;
							DeleteIconIndex = 1 ;
						}
			    		break ;
					}			
					else
						break ;
				}
				else
				{
			 		DeleteOldIconIndex ++ ;
					if (DeleteOldIconIndex > NoOfOldIcons)
					{
						CreateState ++ ;
						DeleteIconIndex = 1 ;
					}
			    	break ;
				}
				break ;

			case DELETE_ITEM :
				if (fNACK)
				{
					if (!fBusy)
					{
				 		DeleteIconIndex ++ ;
						if (DeleteIconIndex > NoOfNewIcons)
						{
							CreateState ++ ;
							AddIconIndex = 1 ;
						}		
					 	break ;
					}
					else
						break ;
				}
				else
				{
				 	 DeleteIconIndex ++ ;
					 if (DeleteIconIndex > NoOfNewIcons)
					 {
					 	CreateState ++ ;
					 	AddIconIndex = 1 ;
					 }
					 break ;
				}
				break ;

			case ADD_ITEM :
				if (fNACK)
				{
					if (!fBusy)
					{
						ShowWindow (hgWnd, SW_NORMAL) ;
						MessageBox (hgWnd,
								"Program Manager Cold Not Add Item",
								     InstallTitle, MB_OK | MB_ICONINFORMATION) ;
						CreateState = END_CONV ;
						break ;
					}
					else
						break ;
				}
				else
				{
					AddIconIndex ++ ;
					if (AddIconIndex > NoOfNewIcons)
						CreateState ++ ;
					break ;
				}
				break ;
		}
	}				
	CreateMTRGroupStateMC() ;	/* call the state machine */
}

/*----------------------------------------------------------------------------
  Function   : SendExecCommand (HWND, HWND, LPSTR)
  Purpose    : Sends the execute command with the data to the server.
----------------------------------------------------------------------------*/
void SendExecCommand (HWND hWndClient, HWND hWndServer, LPSTR lpszCmdString)
{
	HANDLE hCommand ;
	LPSTR lpCommand ;

	if (! (hCommand = GlobalAlloc (GMEM_MOVEABLE | GMEM_DDESHARE,
		  									lstrlen (lpszCmdString) + 1)))
		return ;
	if (! (lpCommand = GlobalLock (hCommand)))
	{
		GlobalFree (hCommand) ;
		return ;
	}
	lstrcpy (lpCommand, lpszCmdString) ;
	GlobalUnlock (hCommand) ;
    SetTimer (hgWnd, DDE_TIMER_ID, (WORD) DDE_PERIOD, NULL) ;
	if (! PostMessage (hWndServer, WM_DDE_EXECUTE,
								hWndClient,	MAKELONG (0, hCommand)))
		GlobalFree (hCommand) ;
    return ;
}

/*----------------------------------------------------------------------------
  Function   : SendTerminate (HWND, HWND)
  Purpose    : Send terminate message to program manager to end conversation.
----------------------------------------------------------------------------*/
void SendTerminate (HWND hWndClient, HWND hWndServer)
{
    PostMessage (hWndServer, WM_DDE_TERMINATE, (WPARAM) hWndClient, 0L) ;
}
