/*----------------------------------------------------------------------------
 Filename   : display.c
 Purpose    : This file contains the functions to display bitmaps and
 				  dialog boxes on the main screen.
----------------------------------------------------------------------------*/
#include 	<windows.h>
#include		<string.h>
#include		<fcntl.h>
#include		<io.h>
#include		"sys\types.h"
#include		"sys\stat.h"
#include    "stdio.h"

#include	"install.h"
#include	"display.h"
#include	"dlgbox.h"
#include	"ourdlgbx.h"
#include	"mirtns.h"
#include	"animate.h"
#include	"utils.h"
#include "init.h"

HDC		hCmpDC ;		/* compatible DC holding the main screen bitmap */
HBITMAP	hCmpBmp ;	/* bitmap created which is displayed on main screen */
FARPROC	LogoTimerFn ;

PRODUCTSTRUCT ProductStringStruct ;

int PromptForDestDirAgain = 0 ;
int PromptForSrcDirAgain = 0 ;


/*----------------------------------------------------------------------------
  Function   : DisplayROUCONLogo ()
  Synopsis   : displays the ROUCON logo on the main screen.
----------------------------------------------------------------------------*/
void DisplayROUCONLogo (void)
{
	HDC hDc ;

	/* save the old cursor and set hourglass cursor */
	hCurCursor = hHourGlass ;
	hSaveCursor = SetCursor (hHourGlass) ;

	hDc = GetDC (hgWnd) ;
	DisplayLogo (hDc) ;
	ReleaseDC (hgWnd, hDc) ;

	/* remove the hourglass and restore old cursor */
	SetCursor(hSaveCursor) ;
	hCurCursor = hSaveCursor ;
	return ;
}

/*----------------------------------------------------------------------------
  FUNCTION	: DisplayLogo (HDC)
  PURPOSE	: displays the 'ROUCON' logo on the main screen.
----------------------------------------------------------------------------*/
void DisplayLogo (HDC hDc)
{
	int x, y ;
	BITMAP bmp ;
  	HDC hMemDc1 ;
	HBITMAP hOldBmp1 ;

  	hCmpDC = CreateCompatibleDC (hDc) ;
	hCmpBmp = CreateCompatibleBitmap (hDc, MainWndRect.right,
															MainWndRect.bottom) ;
	SelectObject (hCmpDC, hCmpBmp) ;

	FillRgn (hCmpDC, 
					CreateRectRgn (0, 0, MainWndRect.right, MainWndRect.bottom), 
								GetStockObject (LTGRAY_BRUSH)) ;

	/* prepare the bitmap to be displayed in the main window */

  	hMemDc1 = CreateCompatibleDC (hDc) ;
  	hOldBmp1 = SelectObject (hMemDc1, hBmpRoucon) ;
	GetObject (hBmpRoucon, sizeof (BITMAP), (LPSTR) &bmp) ;
	x = (MainWndRect.right - bmp.bmWidth) >> 1 ; 
	y = (MainWndRect.bottom - bmp.bmHeight - 100) >> 1 ;
	BitBlt (hCmpDC, x, y, bmp.bmWidth, bmp.bmHeight, hMemDc1, 0, 0, SRCCOPY) ;
  	SelectObject (hMemDc1, hOldBmp1) ;

	y += (bmp.bmHeight + 20) ; 
  	hOldBmp1 = SelectObject (hMemDc1, hBmpAddr) ;
	GetObject (hBmpAddr, sizeof (BITMAP), (LPSTR) &bmp) ;
	x = (MainWndRect.right - bmp.bmWidth) >> 1 ;  
	BitBlt (hCmpDC, x, y, bmp.bmWidth, bmp.bmHeight, hMemDc1, 0, 0, SRCCOPY) ;
  	SelectObject (hMemDc1, hOldBmp1) ;
  	DeleteDC (hMemDc1) ;
  	BitBlt (hDc, 0, 0, MainWndRect.right, MainWndRect.bottom, hCmpDC,
																			0, 0, SRCCOPY) ;
}

void DisplayErasedPortion (HDC hDc, RECT rct)
{
  	BitBlt (hDc, rct.left, rct.top, rct.right, rct.bottom,
				hCmpDC, rct.left, rct.top, SRCCOPY) ;
}

void	AppendSlash (PSTR ptr)
{
	int indx = strlen(ptr);

	if (!indx)
	{
		ptr[0] = '\\' ;
		ptr[1] = 0 ; 
		return ;
	}
	if (ptr[indx - 1] != '\\') 
	{
		ptr[indx] = '\\' ;
		ptr[indx+1] = 0 ;
	}
}


BOOL CheckMTR (LPSTR DestDir)
{
	BYTE	name[256] ;
	int fd ;

	lstrcpy((LPSTR) name, (LPCSTR) DestDir) ;
	if (DestDir[lstrlen((LPCSTR) DestDir) - 1] != '\\')
		lstrcat ((LPSTR) name, (LPCSTR) "\\") ;
	lstrcat((LPSTR) name, (LPCSTR) "install.ini") ;
	if ((fd = _open(name, 0)) < 0)
		return FALSE ;

	_close (fd) ;
	return TRUE ;
}

int Port ;


int FAR PASCAL PortToUseDlgFn(HWND hDlg, unsigned message,
													WORD wParam, LONG lParam)
{
//	char Buf[80] ;

	switch (message)
	{
        case WM_INITDIALOG :
		  	  DLGCenterDialog(hDlg) ;
//			  strcpy (Buf, ProductStringStruct.ProductName) ;
//			  strcat (Buf, " Installation") ;
			  SetWindowText (hDlg, InstallTitle) ;
		      Port = 0 ;
			  CheckRadioButton (hDlg, 100, 103, 100) ;
			  /* set the current values */
			  return TRUE ;

        case WM_COMMAND :
           switch (wParam) 
		   {
				  case 100 :
				  case 101 :
				  case 102 :
				  case 103 :
				  Port = wParam - 100 ;
				  break;

				  case IDOK :
					  PortToUse = Port ;
                 EndDialog (hDlg, TRUE) ;
	              return TRUE ;

              case IDCANCEL :
					  EndDialog (hDlg, FALSE) ;
					  return TRUE ;
            }
            break;
    }
    return FALSE ;
}

/****************************************************************************
 * FUNCTION	: SetDirsDlgFn (HWND, unsigned, WORD, LONG)
 * PURPOSE	: shows the dialog box for setting the directories.
 ****************************************************************************/
int FAR PASCAL SetDirsDlgFn (HWND hDlg, unsigned message,
												WORD wParam, LONG lParam)
{
	char TmpStr[256];
	static HWND hSrcDir ;
	static HWND hDestDir ;
	static HWND hPrevFocus ;

	switch (message)
	{
        case WM_INITDIALOG:
    	  		DLGCenterDialog (hDlg);
   		   /* set the current values */
				lstrcpy ((LPSTR) TmpStr,
									(LPCSTR) ProductStringStruct.ProductName) ;
				lstrcat ((LPSTR) TmpStr,
									(LPCSTR) " - Select Directories") ;
				SetWindowText (hDlg, (LPCSTR) TmpStr) ;
				SetDlgItemText (hDlg, IDC_SETDIR_SRC, (LPSTR) SourceDir);
				SetDlgItemText (hDlg, IDC_SETDIR_DEST, (LPSTR) DestDir);
				SendDlgItemMessage (hDlg, IDC_SETDIR_SRC,
						EM_LIMITTEXT, (WPARAM) 63, 0L) ;
				SendDlgItemMessage (hDlg, IDC_SETDIR_DEST,
						EM_LIMITTEXT, (WPARAM) 63, 0L) ;
				return TRUE ;

        case WM_COMMAND:
            switch (wParam)
				{
                case IDOK:
					 	 GetDlgItemText (hDlg, IDC_SETDIR_SRC,
						 								(LPSTR) SourceDir, 63);
		    			 GetDlgItemText (hDlg, IDC_SETDIR_DEST,
						 								(LPSTR) DestDir, 63);

						 if (!CheckMTR (SourceDir))
						 {	
							lstrcpy ((LPSTR) TmpStr,
												(LPCSTR) "Could not locate files in ") ;
							lstrcat ((LPSTR) TmpStr, (LPCSTR) SourceDir) ;
							lstrcat ((LPSTR) TmpStr,
									  (LPCSTR) ".\nPlease enter correct directory.") ;
							MessageBox(hDlg, TmpStr, InstallTitle, MB_OK);
							PromptForSrcDirAgain = 1 ;
							hSrcDir = GetDlgItem (hDlg, IDC_SETDIR_SRC) ;
							hPrevFocus = SetFocus (hSrcDir) ;
							return FALSE ;
						}
				  	   if (PromptForSrcDirAgain)
						{
						  	SetFocus (hPrevFocus) ;
							PromptForSrcDirAgain = 0 ;
			 			}
 						_strupr (SourceDir);
					    _strupr (DestDir);
					    AppendSlash (SourceDir);
					    AppendSlash (DestDir);

					 	AnsiUpper ((LPSTR) DestDir);
				     	if (CreateDir (DestDir) == -1) 
					 	{
		               MessageBox (hDlg, "Unable to create destination	directory",
									  	  InstallTitle, MB_OK | MB_ICONEXCLAMATION);
						   PromptForDestDirAgain = 1 ;
	   					hDestDir = GetDlgItem (hDlg, IDC_SETDIR_DEST) ;
  		   				hPrevFocus = SetFocus (hDestDir) ;
			      		return FALSE;
	      			}
				 	   if (PromptForDestDirAgain)
					   {
						 	 SetFocus (hPrevFocus) ;  
							 PromptForDestDirAgain = 0 ;
					   }
                  EndDialog (hDlg, TRUE);
                  return TRUE ;

           		 case IDCANCEL:
				    case OURIDCANCEL:
            	 	 EndDialog (hDlg, FALSE);
               	 return TRUE ;

            }
            break;
    }
    return FALSE ;
}


/****************************************************************************
 * Function   : InvokeDialog (HWND, PSTR, FARPROC);
 * Purpose    : invokes the dialog with the passed paramters and returns the
 *					 value returned by EndDialog.
 ****************************************************************************/
int InvokeDialog (HWND hWnd, LPSTR DlgName, FARPROC DlgFn)
{
	int RetVal ;
	FARPROC lpDlgFn ;

	lpDlgFn = MakeProcInstance (DlgFn, hInst) ;
	RetVal = DialogBox (hInst, DlgName, hWnd, lpDlgFn) ;
	FreeProcInstance (lpDlgFn) ;
	return RetVal ;
}
//int close (int);
//int open (char *, int, ...);

//HBRUSH hBr, hOBr ;

/* -------------------------------------------------------------------------
	Function	:	InstallDlgFn()
	Synopsis	:	Displays the installation progress.
 ------------------------------------------------------------------------ */
int FAR PASCAL InstallDlgFn (HWND hDlg, UINT message,
											WPARAM wParam, LPARAM lParam)
{
	int i, Drive, ret_val ;
	char Buf1[80] ;
//	char Buf2[40] ;
//	HDC hDC ;
//	HBRUSH hBr, hOBr ;
//	RECT rect ;
//	HWND hCtl ;

	switch (message) 
	{
		case WM_INITDIALOG:
			DLGCenterDialog (hDlg) ;
//			GetClientRect (hDlg, &rect) ;
//			hBr = CreateSolidBrush (RGB (0x80, 0x80, 0x80)) ;
//			hDC = GetDC (hDlg) ;  
//			hOBr = SelectObject (hDC, hBr) ;
//			UpdateColors (hDC) ;
//			hCtl = GetDlgItem (hDlg, 2000) ;
//			SetBkColor (hCtl, RGB (0xFF, 0x00, 0x00)) ;
			lstrcpy ((LPSTR) Buf1, (LPCSTR) "Installing ") ;
			lstrcat ((LPSTR) Buf1, 
								(LPCSTR) ProductStringStruct.ProductName) ;
			SetWindowText (hDlg, (LPCSTR) Buf1) ;
			hInstallDlg = hDlg ;
			LogoTimerFn = MakeProcInstance (LogoTimer, hInst) ;
			if (! SetTimer (hgWnd, 0x1, 2000, (TIMERPROC) LogoTimerFn))
				FreeProcInstance (LogoTimerFn);

			AnsiUpper((LPSTR) SourceDir);
			AnsiUpper((LPSTR) DestDir);
			SetDlgItemText (hDlg, IDC_INST_SRC, (LPSTR)SourceDir);
			SetDlgItemText (hDlg, IDC_INST_DEST, (LPSTR)DestDir);

			// Hide the guages.
			ShowWindow(GetDlgItem(hDlg, 106), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, 107), SW_HIDE);
			for (i=501; i<= 510; i++)
				ShowWindow(GetDlgItem(hDlg, i), SW_HIDE);

			SetFocus (GetDlgItem(hDlg, IDOK));

//			SelectObject (hDC, hOBr) ;
//			DeleteObject (hBr) ;
//			ReleaseDC (hDlg, hDC) ;
			return (TRUE);

		case WM_CTLCOLOR:
			return (HandleDlgColors (hDlg, (HWND) LOWORD (lParam),
								    (HDC) wParam, (int) HIWORD (lParam)));
		
		case WM_DRAWITEM :
			Animate (TRUE);
			if (CurInstallState == COPY_FILE)
			{
				UpdateFileProgress (1) ;
				UpdateTotalProgress (1) ;
			}
			break;

		case WM_TIMER :  // 9-2-96
			if (InInstallFiles)
			{
				ret_val = InstallFilesStateMC () ;
				if (! ret_val)
				{
					if (TimerCreated)
					{
						DestroyInstallTimer();
						TimerCreated = 0 ; // 9-2-96
					}
					GetOutOfInstallDlg (hDlg) ; // 9-2-96
					return TRUE ;           // 9-2-96
//					goto Aborting ;
				}
				return TRUE ;
			}
			break ;

		case WM_COMMAND :
			switch (wParam)
			{
				case IDOK :
					if (IsCharUpper(DestDir[0]))
						Drive = DestDir[0] - 'A' + 1 ;
					else
						Drive = DestDir[0] - 'a' + 1 ;

					// Hide install  buttons.
					ShowWindow(GetDlgItem (hDlg, IDOK), SW_HIDE) ;

					// Display the guages
					ShowWindow(GetDlgItem(hDlg, 106), SW_SHOW);
					ShowWindow(GetDlgItem(hDlg, 107), SW_SHOW);
					for (i=501; i<= 510; i++)
						ShowWindow(GetDlgItem(hDlg, i), SW_SHOW);

					UpdateFileProgress(0) ;
					UpdateTotalProgress(0) ;

					SetFocus(GetDlgItem(hDlg, IDCANCEL));
						
					CurInstallState = START_XFER;
					/* If Out of Disk Space Abort - Changed now */
					if (!(InstallFilesStateMC())) // 9-2-96
					{
						if (TimerCreated == 1)
						{
							DestroyInstallTimer () ;
							TimerCreated = 0 ;
						}
//		 9-2-96				KillTimer(hgWnd, 0x1);
 //	 9-2-96					FreeProcInstance(LogoTimerFn);
	//	 9-2-96				hInstallDlg = NULL;
     // 9-2-96            EndDialog(hDlg, FALSE);
	  					GetOutOfInstallDlg (hDlg) ;
						return TRUE ;
					}
					EnableWindow (GetDlgItem(hDlg, wParam), 0);
					SetFocus(GetDlgItem(hDlg, IDCANCEL));
					break;

				case IDCANCEL:				// Abort
					if (TimerCreated)		 // 9-2-96
					{
						DestroyInstallTimer();
						TimerCreated = 0 ; 
					}
					lstrcpy ((LPSTR) Buf1, (LPCSTR) "Want to Abort ") ;
					lstrcat ((LPSTR) Buf1,
								(LPCSTR) ProductStringStruct.ProductName) ;
					lstrcat ((LPSTR) Buf1, (LPCSTR) " Installation ?") ;
//					strcpy (Buf2, ProductStringStruct.ProductName) ;
//					strcat (Buf2, " Installation") ;
					if (MessageBox (hDlg, (LPCSTR) Buf1, InstallTitle,
									MB_YESNO | MB_ICONQUESTION) == IDYES)
					{

//Aborting :			KillTimer(hgWnd, 0x1); 9-2-96
// 9-2-96						FreeProcInstance(LogoTimerFn);
// 9-2-96						hInstallDlg = NULL;
// 9-2-96                    	EndDialog(hDlg, FALSE);
						GetOutOfInstallDlg (hDlg) ;
                    	return (TRUE);
					}
					else
					{
						if (!TimerCreated)  	 // 9-2-96
						{
							TimerCreated = 1 ;	  
							CreateInstallTimer ();
						}
					}
					break;

				default:
					break;
			}
			break;

		default:
			break;
	}
	return (FALSE);								// Not processed
}


/*----------------------------------------------------------------------------
Module : GetOutOfInstallDlg
 			9-2-96
----------------------------------------------------------------------------*/
void GetOutOfInstallDlg (HWND hDlg)
{
//	HDC hDC ;

//	hDC = GetDC (hDlg) ;
//	SelectObject (hDC, hOBr) ;
//	DeleteObject (hBr) ;
//	ReleaseDC (hDlg, hDC) ;
	KillTimer(hgWnd, 0x1);
	FreeProcInstance(LogoTimerFn);
	hInstallDlg = NULL;
    EndDialog(hDlg, FALSE);
	return ;
}


HBRUSH HandleDlgColors(HWND hDlg, HWND hDlgItem, HDC hDC, int nCtlType)
	// Handle to the current dialog
	// Handle of the dialog item for
	// which the message is intended
	// DC of the dialog item
	// Type of the WM_CTLCOLOR message
{
	static HBRUSH hBr = NULL ;

	if (hBr != NULL)
		DeleteObject (hBr) ;
	hBr = CreateSolidBrush (GetSysColor (COLOR_BTNFACE)) ;


	switch (nCtlType)
	{
		case CTLCOLOR_DLG:
			return hBr;

		case CTLCOLOR_BTN :
			SetBkMode (hDC, TRANSPARENT) ;
			return hBr ;

		case CTLCOLOR_STATIC :
			SetBkMode (hDC, TRANSPARENT) ;
			return hBr ;
	}
	return ((LRESULT) NULL) ;
}



