/*----------------------------------------------------------------------------
	Module  :  Install for Roucon
	Purpose :  Accesses the Install.Ini file while installing Roucon
	Author  :  Chetan (cfp)
----------------------------------------------------------------------------*/

#include "windows.h"
#include "init.h"
#include "string.h"
#include "stdlib.h"
#include "dos.h"

/* This is a pointer to the location in global heap
	that holds the full path for the INSTALL.INI file */
LPSTR lpszInstIniFilename ;


/*----------------------------------------------------------------------------
Module 	: GetProductName
Input  	: Address of the structure into which the Product Name and it's
			  Description are stored
Output 	: Nothing
----------------------------------------------------------------------------*/
void FAR PASCAL GetProductName (PRODUCTSTRUCT FAR *PS)
{
	LPCSTR lpcszSection = "Product" ;		
 	LPCSTR lpcszEntry = "Name" ;
	LPCSTR lpcszDefault = "" ;
	char szRetBuf[PRODUCT_NAME_LEN + PROD_DESCRIP_LEN + 1 + SEP_SPACE] ;
	LPSTR lpszTemp ;
	char szSeparators[] = "\n\t," ;		/* Various allowable separators */
	LPSTR lpszRetBuf = szRetBuf ;

	/* Get the name and description of the product into
		the buffer pointed by lpszRetBuf from the entry 
		"Name" under the section "Product" in the file
		"INSTALL.INI"  */

	GetPrivateProfileString (
			lpcszSection,
			lpcszEntry,
			lpcszDefault,
			lpszRetBuf,
			sizeof (szRetBuf),
			(LPCSTR) lpszInstIniFilename
	) ;

	/* Get the name of the product */
	lpszTemp = _fstrtok (lpszRetBuf, (LPSTR) szSeparators) ;

	/* Check if product name exceeds the max. length allowed 
		and if it exceeds truncate the name */
	if (lstrlen ((LPCSTR) lpszTemp) > PRODUCT_NAME_LEN - 1)
		*(lpszTemp + PRODUCT_NAME_LEN - 1) = NULL_TERM ;
	
	/* Copy the product name into the structure */
	lstrcpy (PS->ProductName, (LPCSTR) lpszTemp) ;

	/* Get the product description */
	lpszTemp = _fstrtok (NULL, (LPSTR) szSeparators) ;

	/* Check whether the description exceeds the max. 
		allowable length and if it exceeds make the 
		corrections  */
	if (lstrlen ((LPCSTR) lpszTemp) > PROD_DESCRIP_LEN - 1)
		*(lpszTemp + PROD_DESCRIP_LEN - 1) = NULL_TERM ;

	/* copy the description into the structure */
	lstrcpy (PS->ProductDescription, (LPCSTR) lpszTemp) ;

	return ;
}


/*----------------------------------------------------------------------------
Module 	: GetSectionList
Input  	: The starting address of the 2-D array into which
			  the various section strings are to be loaded.
Output 	: The No. of sections in the "INSTALL.INI" file.
----------------------------------------------------------------------------*/
int FAR PASCAL GetSectionList (SECTIONSTRUCT FAR *SS)
{
	LPCSTR lpcszSection = "Sections" ;
	LPCSTR lpcszEntry = NULL ;
	LPCSTR lpcszDefault = "" ;
	char szRetBufLHS[(NO_OF_SECTIONS * (SECTION_NAME_LEN_LHS + 1)) + 1] ;
	LPSTR lpszTemp ;
	char szRetBufRHS[SECTION_NAME_LEN_RHS] ;
	int cbNoOfSections = 0 ;
	LPSTR lpszRetBufLHS = szRetBufLHS ;
	LPSTR lpszRetBufRHS = szRetBufRHS ;

	/* Get all the  section headings from the LHS of the "Sections"
		section in the "INSTALL.INI" into the pointed to by
		lpszRetBufLHS */

	GetPrivateProfileString (
		lpcszSection,
		lpcszEntry,
		lpcszDefault,
		lpszRetBufLHS,
		sizeof (szRetBufLHS),
		(LPCSTR) lpszInstIniFilename
	) ;

	lpszTemp = lpszRetBufLHS ;

	/* Get the RHS of the entries of the "Sections" section
		one by one and copy them into the structure whose
		address has been passed as an input argument */

	while (*lpszTemp)
	{
		GetPrivateProfileString (
			lpcszSection,
			lpszTemp,
			lpcszDefault,
			lpszRetBufRHS,
			sizeof (szRetBufRHS),
			(LPCSTR) lpszInstIniFilename
		) ;

		lstrcpy (SS->SectionNames[cbNoOfSections], (LPCSTR) lpszRetBufRHS) ;
		cbNoOfSections ++ ;
		lpszTemp += lstrlen ((LPCSTR) lpszTemp) + 1 ;
	}
	return cbNoOfSections ;
}


/*----------------------------------------------------------------------------
Module 	: GetFilesInSection
Input  	: Section name and address of the array of structures
			  where all the file information would be stored.
Output 	: No. of files in the section
----------------------------------------------------------------------------*/
int FAR PASCAL GetFilesInSection (LPSTR lpszSection, FILESTRUCT FAR *FS)
{
	int cbNoOfFiles ;

	cbNoOfFiles = GetFilesInSpecifiedSections (lpszSection, FS) ;
	return cbNoOfFiles ;
}


/*----------------------------------------------------------------------------
Module : GetCommonFiles
Input  : Address of the array of structures where all the file
		   information would be stored.
Output : No. of Files in the "Common" section
----------------------------------------------------------------------------*/
int FAR PASCAL GetCommonFiles (FILESTRUCT FAR *FS)
{
	int cbNoOfFiles ;
	LPSTR lpszSection = "Common" ;

	cbNoOfFiles = GetFilesInSpecifiedSections (lpszSection, FS) ;
	return cbNoOfFiles ;
}



/*----------------------------------------------------------------------------
Module :	GetOldIconList
Input  :	Address of the array of structures where all
 			the old icons information would be stored.
Output :	No of Old Icons
----------------------------------------------------------------------------*/
int FAR PASCAL GetOldIconList (ICONSTRUCT FAR *IS)
{
	int cbNoOfIcons ;
	LPCSTR lpcszSection = "Old Icons" ;

	cbNoOfIcons = GetIconList (lpcszSection, IS) ;
	return cbNoOfIcons ;
}



/*----------------------------------------------------------------------------
Module :	GetNewIconList
Input  :	Address of the array of structures where all
 			the new icons information would be stored.
Output :	No of New Icons
----------------------------------------------------------------------------*/
int FAR PASCAL GetNewIconList (ICONSTRUCT FAR *IS)
{
	int cbNoOfIcons ;
	LPCSTR lpcszSection = "Icons" ;

	cbNoOfIcons = GetIconList (lpcszSection, IS) ;
	return cbNoOfIcons ;
}



/*----------------------------------------------------------------------------
Module :	GetIconList
Input  :	Address of the array of structures where all
 			the icon information would be stored and the
			section name
Output :	No of Icons
----------------------------------------------------------------------------*/
int FAR PASCAL GetIconList (LPCSTR lpcszSection, ICONSTRUCT FAR *IS)
{
	LPCSTR lpcszEntry = NULL ;
	LPCSTR lpcszDefault = "" ;
	char szRetBufLHS[(NO_OF_ICONS * (ICON_NAME_HEAD + 1)) + 1] ;
	LPSTR lpszTemp ;
	char szRetBufRHS[MAX_ICON_FILENAME_LEN + 1 + 1 + ICON_DESCRIP_LEN
									+ SEP_SPACE + 1] ;
	char szSeparators[] = "\n\t," ;	/* Various allowable separators */
	LPSTR lpszStr ;
	int cbNoOfIcons = 0 ;
	LPSTR lpszRetBufLHS ;
	LPSTR lpszRetBufRHS ;
	ICONSTRUCT FAR *lpszStoreAddress = IS ;  /* Store the address of */
														  /* array of structures */

	lpszRetBufLHS = szRetBufLHS ;
	lpszRetBufRHS = szRetBufRHS ;
	GetPrivateProfileString (
		lpcszSection,
		lpcszEntry,
		lpcszDefault,
		lpszRetBufLHS,
		sizeof (szRetBufLHS),
		(LPCSTR) lpszInstIniFilename
	) ;

	lpszTemp = lpszRetBufLHS ;

	while (*lpszTemp)
	{
		GetPrivateProfileString (
			lpcszSection,
			lpszTemp,
			lpcszDefault,
			lpszRetBufRHS,
			sizeof (szRetBufRHS),
			(LPCSTR) lpszInstIniFilename
		) ;

		lpszStr = _fstrtok (lpszRetBufRHS, (LPSTR) szSeparators) ;
		if (lstrlen ((LPCSTR) lpszStr) > MAX_ICON_FILENAME_LEN - 1)
			*(lpszStr + MAX_ICON_FILENAME_LEN - 1) = NULL_TERM ;
		lstrcpy (IS->Filename, (LPCSTR) lpszStr) ;

		lpszStr = _fstrtok (NULL, (LPSTR) szSeparators) ;
		IS->IconNo = _fstrtod (lpszStr) ;

		lpszStr = _fstrtok (NULL, (LPSTR) szSeparators) ;
		if (lstrlen ((LPCSTR) lpszStr) > ICON_DESCRIP_LEN - 1)
			*(lpszStr + ICON_DESCRIP_LEN - 1) = NULL_TERM ;
		lstrcpy (IS->IconDescription, (LPCSTR) lpszStr) ;

		lpszTemp += lstrlen ((LPCSTR) lpszTemp) + 1 ;
		IS ++ ;
		cbNoOfIcons ++ ;
	}
	IS = lpszStoreAddress ;
	return cbNoOfIcons ;
}



/*----------------------------------------------------------------------------
Module 	: GetFilesInSpecifiedSections
Input  	: Section name and address of the array of structures
			  where all the file information would be stored.
Output 	: No. of Files in Section
Synopsis : This function is called by GetFilesInSection
			  and GetCommonFiles
----------------------------------------------------------------------------*/
int FAR PASCAL GetFilesInSpecifiedSections (LPSTR lpszSection,
																FILESTRUCT FAR *FS)
{
	LPCSTR lpcszEntry = NULL ;
	LPCSTR lpcszDefault = "" ;
   char szRetBufLHS[(MAX_NO_OF_FILES * (FILE_NAME_HEAD + 1)) + 1] ;
	LPSTR lpszTemp ;
	char szRetBufRHS[MAX_FILENAME_LEN + 1 + 1 + 4 + 1 + 
									 FILE_DESCRIP_LEN + SEP_SPACE + 1] ;
	char szSeparators[] = "\n\t," ;	/* Various allowable separators */
	LPSTR lpszStr ;
	int cbNoOfFiles = 0 ;
	LPSTR lpszRetBufLHS ;
	LPSTR lpszRetBufRHS ;
	FILESTRUCT FAR *lpszStoreAddress = FS ;  /* Store the address of */
														  /* array of structures */

	lpszRetBufLHS = szRetBufLHS ;
	lpszRetBufRHS = szRetBufRHS	;

	GetPrivateProfileString (
		lpszSection,
		lpcszEntry,
		lpcszDefault,
		lpszRetBufLHS,
		sizeof (szRetBufLHS),
		(LPCSTR) lpszInstIniFilename
	) ;

	lpszTemp = lpszRetBufLHS ;

	while (*lpszTemp)
	{
		GetPrivateProfileString (
			lpszSection,
			lpszTemp,
			lpcszDefault,
			lpszRetBufRHS,
			sizeof (szRetBufRHS),
			(LPCSTR) lpszInstIniFilename
		) ;

		lpszStr = _fstrtok (lpszRetBufRHS, (LPSTR) szSeparators) ;
		if (lstrlen ((LPCSTR) lpszStr) > MAX_FILENAME_LEN - 1)
			*(lpszStr + MAX_FILENAME_LEN - 1) = NULL_TERM ;
		lstrcpy (FS->Filename, (LPCSTR) lpszStr) ;
		AnsiUpper (FS->Filename) ;

		lpszStr = _fstrtok (NULL, (LPSTR) szSeparators) ;
		FS->DisketteNo = _fstrtod (lpszStr) ;

		lpszStr = _fstrtok (NULL, (LPSTR) szSeparators) ;
		FS->FileSize = _fstrtoul(lpszStr) ;

		lpszStr = _fstrtok (NULL, (LPSTR) szSeparators) ;
		if (lstrlen ((LPCSTR) lpszStr) > FILE_DESCRIP_LEN - 1)
			*(lpszStr + FILE_DESCRIP_LEN - 1) = NULL_TERM ;
		lstrcpy (FS->FileDescription, (LPCSTR) lpszStr) ;

		lpszTemp += lstrlen ((LPCSTR) lpszTemp) + 1 ;
		FS ++ ;
		cbNoOfFiles ++ ;
	}
	FS = lpszStoreAddress ;
	return cbNoOfFiles ;
}


/*----------------------------------------------------------------------------
Module : _fstrtoul
Input  : Far pointer to string which is to be converted into
			an unsigned long integer
Output : Unsigned long integer
----------------------------------------------------------------------------*/
DWORD _fstrtoul (LPSTR lpszStr)
{
	static char local_string[256];

	lstrcpy (local_string, lpszStr);
	return (strtoul (local_string, NULL, BASE_TEN)) ;
}


/*----------------------------------------------------------------------------
Module : _fstrtod
Input  : Far pointer to string which is to be converted into
			an integer
Output : Integer
----------------------------------------------------------------------------*/
int _fstrtod (LPSTR lpszStr)
{
	static char	local_string[256] ;

	lstrcpy (local_string, lpszStr) ;
	return (atoi (local_string)) ;
}

/*----------------------------------------------------------------------------
Module : FindInstIniPath
Input  : Pointer to Buffer containing the full path of the
			associated EXE file
Output : The passed pointer is modified to specify the path 
			for the INSTALL.INI file
----------------------------------------------------------------------------*/
void FAR PASCAL FindInstIniPath (LPSTR lpszPath)
{
	LPSTR lpszBackSlash ;
	lpszInstIniFilename = lpszPath ;
	lpszBackSlash = _fstrrchr (lpszInstIniFilename, BACK_SLASH) ;
	*lpszBackSlash = NULL_TERM ;
	_fstrcat (lpszInstIniFilename, (LPCSTR) "\\INSTALL.INI") ;
	return ;
}


/*----------------------------------------------------------------------------
Module : GetFreeSpaceInCurDrive
Input  : Drive number
Output : Free Space available on the current drive
----------------------------------------------------------------------------*/
DWORD FAR PASCAL GetFreeSpaceInCurDrive (unsigned int DriveNo)
{
	struct diskfree_t DiskInfo ;
	DWORD dwFreeSpace ;
	unsigned int drive ;

	drive = DriveNo ;
	_dos_getdiskfree (drive, &DiskInfo) ;

	dwFreeSpace = (DWORD) (DiskInfo.avail_clusters) *
						  (DWORD) (DiskInfo.sectors_per_cluster) *
							  (DWORD) (DiskInfo.bytes_per_sector) ;
	return dwFreeSpace ;
}



/*----------------------------------------------------------------------------
Module : ConvertNumToStrWithCommas
Input  : Number to be converted and the address of buffer for storage
Output : Nothing
----------------------------------------------------------------------------*/
void ConvertNumToStrWithCommas (DWORD Number, NPSTR npszStrBuf)
{
	int i = 0 ;
	int comma = 0 ;
	int length ;
	DWORD NumWithK ;
   char temp ;
	
	NumWithK = Number / (DWORD) (ONE_KILO) ;
	do
	{
		*(npszStrBuf + i) = (char) ((NumWithK % (DWORD) (BASE_TEN)) + ZERO) ;
		NumWithK /= (DWORD) (BASE_TEN) ;
		i ++ ;
		comma ++ ;
		if (comma == 3 && NumWithK > 0)
		{
			*(npszStrBuf + i) = COMMA_CHAR ;
			i ++ ;
			comma = 0 ;
		}
	}
	while (NumWithK >= 1) ;

	length = i ;
	for (i = 0 ; i < length / 2 ; i ++)
	{
		temp = *(npszStrBuf + i) ;
		*(npszStrBuf + i) = *(npszStrBuf + length - 1 - i) ;
		*(npszStrBuf + length - 1 - i) = temp ;
	}
	*(npszStrBuf + length) = NULL_TERM ;
	return ;
}

/*----------------------------------------------------------------------------
	Module : GetDestInstallPath
	Input  : Pointer to Destination Path Buffer
	Output : Boolean ; TRUE if found else FALSE
----------------------------------------------------------------------------*/
BOOL GetDestInstallPath (LPSTR DestPath)
{
	LPCSTR lpcszSection = "Product" ;		
 	LPCSTR lpcszEntry = "Directory" ;
	LPCSTR lpcszDefault = "" ;
	char szRetBuf[DIRECTORY_NAME_LEN] ;
	LPSTR lpszRetBuf = szRetBuf ;

	/* Get the name of destination directory from
		the entry "Directory" under the section
		"Product" in the INSTALL.INI file */  
	GetPrivateProfileString (
			lpcszSection,
			lpcszEntry,
			lpcszDefault,
			lpszRetBuf,
			sizeof (szRetBuf),
			(LPCSTR) lpszInstIniFilename
	) ;

	if (!szRetBuf[0])
		return FALSE ;

	// In case it exceeds
	*(lpszRetBuf + DIRECTORY_NAME_LEN - 1) = NULL_TERM ;
	lstrcpy (DestPath, lpszRetBuf) ;
	return TRUE ;
}

/*----------------------------------------------------------------------------
	Module : GetInstallGroupName
	Input  : Pointer to Group Path Buffer
	Output : Boolean ; TRUE if found else FALSE
----------------------------------------------------------------------------*/
BOOL GetInstallGroupName (LPSTR GrpName)
{
	LPCSTR lpcszSection = "Product" ;		
 	LPCSTR lpcszEntry = "GroupName" ;
	LPCSTR lpcszDefault = "" ;
	char szRetBuf[GRP_PATH_LEN] ;
	LPSTR lpszRetBuf = szRetBuf ;

	/* Get the name of destination directory from
		the entry "GroupName" under the section
		"Product" in the INSTALL.INI file */  
	GetPrivateProfileString (
			lpcszSection,
			lpcszEntry,
			lpcszDefault,
			lpszRetBuf,
			sizeof (szRetBuf),
			(LPCSTR) lpszInstIniFilename
	) ;

	if (!szRetBuf[0])
		return FALSE ;

	// In case it exceeds
	*(lpszRetBuf + GRP_PATH_LEN - 1) = NULL_TERM ;
	lstrcpy (GrpName, lpszRetBuf) ;
	return TRUE ;
}
	
