/****************************************************************************
 * Filename   : install.h
 * Purpose    : header file for install.c
 ****************************************************************************/

#define	WM_COMPLETE 	(WM_USER + 0x100)
#define	WM_USERABORT	(WM_USER + 0x101)
#define	WM_ERROR			(WM_USER + 0x102)	

#define	TIMER_ID			100
#define	PERIOD			1000
#define	DDE_TIMER_ID	200
#define	DDE_PERIOD		10000

#define  INSTALL_TIMER_ID  500   // 9-2-96
#define  INSTALL_TIME_OUT  100  	// 9-2-96

/* control IDs for setdirs dialog */
#define	IDC_SETDIR_SRC		1400
#define	IDC_SETDIR_DEST	1401

/* control IDs for install dialog */
#define	IDC_INST_SRC		1701
#define	IDC_INST_DEST		1703
#define	IDC_INST_SRCFILE	1705
#define	IDC_INST_DESTFILE	1706

#define	IDC_INST_PROGRESS			107
#define	IDC_INST_TOT_PROGRESS	106
#define	IDC_INST_ABORT				1001

/* various states in creating the mrack group */
#define	DELETE_GROUP	1
#define	CREATE_GROUP	2
#define	SHOW_GROUP		3

#define DELETE_OLD_ITEM  4   // correspondig to Beta version
#define DELETE_ITEM      5   // correspondig to this version
#define ADD_ITEM         6	  // correspondig to this version
#define END_CONV         7 


/* various states in creating the mrack group */
#define	ROOT_DIR			0
#define	WIN_DIR			2

#define	START_XFER		1
#define	COPY_FILE		2
#define	NEXT_FILE		3
#define	END_XFER			4
#define	NAME_LEN			8
#define	NAME_EXT_LEN	12

typedef struct tagFileList {
	BYTE name[NAME_LEN + 1];
} FileListType;

typedef struct tagNameFileList {
	BYTE name[NAME_EXT_LEN + 1];
} FileNameListType;

extern	int		hInstallTimer;
extern	HANDLE	hInst;			/* main window instance handle */
extern	FileNameListType	*InstallFiles;
extern	int		NumFiles;
extern	BYTE		SourceDir[];		/* source directory for files */
extern	BOOL		GotROUCONDir;
extern	DWORD		FileSize, BytesDone, TotalSize, CumSize;
extern	HANDLE	hMainInsWnd;
extern	BYTE	RouconDir[] ;
extern	BYTE	DestDir[] ;		/* destination dir to store files */
extern char	InstallTitle[] ;
extern	HWND	hInstallDlg;

extern	BOOL	InInstallFiles ;
extern	int	CurInstallState ;
extern   int   TimerCreated ;
extern	HWND	hgWnd;			/* main window handle */
extern	HWND	hgWndPM;		/* program manager window handle */
extern	int	CurFileIndex;
extern	char	SysFilesDir[];		/* system files dir */
extern	BYTE	PortToUse;
extern	char	RouconSysFilesDir[];
extern int NoOfOldIcons ; // 9-2-96	make global
extern int NoOfSections ; // 9-2-96 make global
extern int NoOfNewIcons ; // 9-2-96	make global
extern int DeleteOldIconIndex ;
extern int DeleteIconIndex ;
extern int AddIconIndex ;
extern int Ctl3dv2Index ;

extern	BOOL	AbortInstall;
/* function prototypes */
int 	PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);
BOOL 	NEAR PASCAL InstallInit (HANDLE hInstance);
long 	FAR PASCAL InstallWndProc (HWND hWnd, unsigned message, WORD wParam, LONG lParam);
void	InitiateInstall(void);
BOOL	InstallAllFiles (HWND hDlg);
BOOL	InstallFile (PSTR FileName, PSTR DirName, HDC hDc, int Width, int Height);
int	CreateDir (char *Dir);

void	CreateMTRGroup(void);
void	CreateMTRGroupStateMC(void);
void	AddItemToGroup(PSTR ExecStr, PSTR NameStr, int IconIndex);

BOOL	SaveSystemInfo (void);
void	MakeIniStr (int index, char *Val);

BOOL	InstallFilesStateMC (void) ;
BOOL	OpenSrcDestFiles (BOOL ShowStatus) ;
void	CloseSrcDestFiles (void) ;
BOOL	CopyOneBlock (BOOL ShowStatus) ;
void	UpdateFileProgress (int Flag) ;
void	UpdateTotalProgress (int Flag) ;
void	CreateInstallTimer(void) ;
void	DestroyInstallTimer(void) ;
WORD 	FAR PASCAL InstallTimerFn (HWND hWnd, WORD wMsg, int nIDEvent,
																				DWORD dwTime) ;
BOOL	UpdateSystemInfo(void);
int CheckForExactDiskette (void) ;
int FAR PASCAL DiskDlgFn (HWND hDlg, unsigned message,
													WORD wParam, LONG lParam) ;
void GetOut (void) ;

extern	void	FAR PASCAL DOS3Call(void);

/* small model related string routines used */
int  atoi(char *);
char *itoa(int, char *, int);

#include	"memory.h"

