// ipconfig.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include	"dot.h"
#include "maskdot.h"
#include "ipconfig.h"
#include "iproutes.h"
//#include "igwaycon.h"
#define MIN_DEFAULT_TTL			0
#define MAX_DEFAULT_TTL			255
#define MIN_REASSM_TMOUT		1
#define MAX_REASSM_TMOUT		100

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char	*IPMsgHeader="IP Setup";
LPCSTR IPSectionHeader ="IP Routing" ;
LPCSTR DHCPSectionHeader = "DHCP" ;
LPCSTR DHCPAssigned = "DHCP Assigned";

extern LPCSTR TNETSectionHeader;
extern BOOL IsWANPort(int PortNumber);
extern BOOL IsSecuredLANPort(int PortNumber);
extern int GetInternetLANPortNumber();
extern int GetWANPortNumber();
extern BOOL RmtLocalIpAddressesOfSameNet (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask);

/////////////////////////////////////////////////////////////////////////////
// CIPConfig dialog


CIPConfig::CIPConfig(CWnd* pParent /*=NULL*/)
	: CDialog(CIPConfig::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPConfig)
	m_SecuredLANIPAddrStr = "";
        m_SecuredLANMskStr = "";
        m_SecuredLANGwayStr = "";
        m_InternetLANIPAddrStr = "";
        m_InternetLANMskStr = "";
        m_DHCPClientEnabled = FALSE;
        m_DHCPRelayAgentEnabled = FALSE;
        m_DHCPServerAddress = "";
        m_ISPCheck = FALSE;
        m_WANIPAddrStr = "";
        m_WANMskStr = "";        
        m_IGwayAddressStr = "";
        m_nIGwayPort = 0;
	m_DHCPHostName = "";
	m_DnsServerValue = "";
	//}}AFX_DATA_INIT
}

BEGIN_MESSAGE_MAP(CIPConfig, CDialog)
	//{{AFX_MSG_MAP(CIPConfig)
	ON_BN_CLICKED(IDC_ISP_ASSIGNED, ISPAssignedStatusChanged)
	ON_BN_CLICKED(IDC_IPHELP, OnHelp)
	ON_BN_CLICKED(IDC_STATIC_ROUTE_BUTTON, OnButtonStatHost)

        ON_BN_CLICKED(IDC_WAN_IS_GWAY, OnSelectionWAN)
        ON_BN_CLICKED(IDC_LAN_IS_GWAY, OnSelectionLAN)

        ON_BN_CLICKED(IDC_DHCP_CLIENT, OnDHCPClient)
        ON_BN_CLICKED(IDC_DHCP_RELAY_AGENT, OnDHCPRelayAgent)

//        ON_BN_CLICKED(IDC_ADVANCED_BUTTON, OnAdvancedIPConfig)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CIPConfig::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPConfig)
	DDX_Control(pDX, IDC_DNS_SERVER_HDR, m_DnsServerHdr);
	DDX_Control(pDX, IDC_DNS_SERVER, m_DnsServer);
	DDX_Control(pDX, IDC_HOST_NAME, m_EditDHCPHostName);
	DDX_Text(pDX, IDC_SECUREDLAN_IP_ADDR, m_SecuredLANIPAddrStr);
	DDX_Control(pDX, IDC_SECUREDLAN_IP_ADDR, m_SecuredLANIPAddrWnd);
	DDX_Text(pDX, IDC_SECUREDLAN_NETMASK, m_SecuredLANMskStr);
	DDX_Control(pDX, IDC_SECUREDLAN_NETMASK, m_SecuredLANMskWnd);
	DDX_Text(pDX, IDC_SECUREDLAN_GWAY_ADDR, m_SecuredLANGwayStr);
	DDX_Control(pDX, IDC_SECUREDLAN_GWAY_ADDR, m_SecuredLANGwayWnd);
	DDX_Text(pDX, IDC_INTERNETLAN_IP_ADDR, m_InternetLANIPAddrStr);
	DDX_Control(pDX, IDC_ILAN_ADDRESS_HDR, m_InternetLANIPAddrHdrWnd);
	DDX_Control(pDX, IDC_INTERNETLAN_IP_ADDR, m_InternetLANIPAddrWnd);
	DDX_Text(pDX, IDC_INTERNETLAN_NETMASK, m_InternetLANMskStr);
	DDX_Control(pDX, IDC_INTERNETLAN_NETMASK, m_InternetLANMskWnd);
	DDX_Control(pDX, IDC_ILAN_MASK_HDR, m_InternetLANMskHdrWnd);
        DDX_Control(pDX, IDC_DHCP_CLIENT, m_DHCPClientWnd);
        DDX_Check(pDX, IDC_DHCP_CLIENT, m_DHCPClientEnabled);
        DDX_Check(pDX, IDC_DHCP_RELAY_AGENT, m_DHCPRelayAgentEnabled);
        DDX_Control(pDX, IDC_DHCP_RELAY_AGENT, m_DHCPRelayAgentWnd);
        DDX_Control(pDX, IDC_DHCP_SERVER_ADDRESS_HDR, m_DHCPServerAddressHdrWnd);
        DDX_Text(pDX, IDC_DHCP_SERVER_IP_ADDRESS, m_DHCPServerAddress);
        DDX_Control(pDX, IDC_DHCP_SERVER_IP_ADDRESS, m_DHCPServerAddressWnd);
	DDX_Control(pDX, IDC_ISP_ASSIGNED, m_ISPWnd);
	DDX_Check(pDX, IDC_ISP_ASSIGNED, m_ISPCheck);
	DDX_Text(pDX, IDC_WAN_IP_ADDR, m_WANIPAddrStr);
	DDX_Control(pDX, IDC_WAN_IP_ADDR, m_IPAddrWnd);
        DDX_Control(pDX, IDC_ADDRESS_STATIC_TEXT, m_IPHdrWnd);
	DDX_Text(pDX, IDC_WAN_NET_MASK, m_WANMskStr);
	DDX_Control(pDX, IDC_WAN_NET_MASK, m_WANMskWnd);
        DDX_Control(pDX, IDC_WAN_IS_GWAY, m_RWANIsGway);
        DDX_Control(pDX, IDC_LAN_IS_GWAY, m_RLANIsGway);
        DDX_Control(pDX, IDC_IGWAY_ADDRESS_HDR ,m_IGwayAddressHdr);
        DDX_Text(pDX, IDC_IGWAY_IP_ADDRESS, m_IGwayAddressStr);
        DDX_Control(pDX, IDC_IGWAY_IP_ADDRESS, m_IGwayAddressWnd);
	DDX_Text(pDX, IDC_HOST_NAME, m_DHCPHostName);
	DDX_Text(pDX, IDC_DNS_SERVER, m_DnsServerValue);
	//}}AFX_DATA_MAP
}



/*
#if 0
	DDX_Text(pDX, IDC_IP_TTL, m_nTimeToLive);
	DDX_Control(pDX, IDC_IP_TTL, m_TimeToLiveWnd);
	DDX_Text(pDX, IDC_REASSEMBLY_TIMEOUT, m_nReassemblyTimeOut);
	DDX_Control(pDX, IDC_REASSEMBLY_TIMEOUT, m_ReassemblyTimeOutWnd);
#endif
*/

/////////////////////////////////////////////////////////////////////////////
// CIPConfig message handlers

BOOL CIPConfig::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
////////////////////////////////////////////////////////////////////////////
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////

	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

	if (!HelpBitmapBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load Help bitmap");

	VERIFY (HelpBitmapBtn.SubclassDlgItem (IDC_IPHELP, this));
	HelpBitmapBtn.SizeToContent();

	if (!StaticRouteBitmapBtn.LoadBitmaps ("SROUT1", "SROUT2", "SROUT3", "SROUT4"))
		AfxMessageBox ("Failed to load Static Route bitmap");

	VERIFY (StaticRouteBitmapBtn.SubclassDlgItem (IDC_STATIC_ROUTE_BUTTON, this));
	StaticRouteBitmapBtn.SizeToContent();

#if 0
	if (!AdvBitmapBtn.LoadBitmaps ("MORE1", "MORE2", "MORE3", "MORE4"))
		AfxMessageBox ("Failed to load Advanced bitmap");

	VERIFY (AdvBitmapBtn.SubclassDlgItem (IDC_ADVANCED_BUTTON, this));
	AdvBitmapBtn.SizeToContent();

#endif


	// Read the configuration file and init the variables
	char	szRHS[40];
	char	szRHS1[60];
//	char	szLHSAddr[40];
//	char	szLHSMask[40];
	CDotDecimal DotValue;

   strcpy(FileName, IniInWinForm);

	m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",3,
				(LPCSTR) FileName);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;
        
        m_ISPCheck = FALSE;
        ReadIPPortParameters(0, m_SecuredLANIPAddrStr, m_SecuredLANMskStr); //Get Address and Net Mask for Secured LAN Port
        ReadIPPortParameters(1, m_InternetLANIPAddrStr, m_InternetLANMskStr); //Get Address and Net Mask for Internet LAN Port
        ReadIPPortParameters(2, m_WANIPAddrStr, m_WANMskStr); //Get Address and Net Mask for WAN Port

/* Added By Ravi on 11 Jan 1999 ... */        
	GetPrivateProfileString ((LPCSTR) IPSectionHeader,(LPCSTR) "IP DNS Server Address1",
		 ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
	m_DnsServerValue = szRHS ;
/* ... Added By Ravi on 11 Jan 1999 */        

        if (m_ISPCheck)
        {
                m_ISPWnd.EnableWindow(TRUE);
                m_IPAddrWnd.EnableWindow(FALSE);
                m_IPHdrWnd.EnableWindow(FALSE);
		m_WANIPAddrStr = "ISP Assigned";
        }
        else
        {
                m_IPAddrWnd.EnableWindow(TRUE);
                m_IPHdrWnd.EnableWindow(TRUE);
        }
#if 0
        /* Get TTL */
	//Readin the other information
	m_nTimeToLive = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
				(LPCSTR) "IP Default TTL", 255, (LPCSTR) FileName) ;

        /* Get Reassembly timeout */
	m_nReassemblyTimeOut = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
				(LPCSTR) "IP Reassembly Timeout", 30, (LPCSTR) FileName) ;
#endif

        /* Added By Ravi for DHCP Host Name */
	GetPrivateProfileString((LPCSTR) DHCPSectionHeader, (LPCSTR) "DHCP Host Name", StrNull,
				(LPSTR)szRHS1, sizeof(szRHS1), (LPCSTR)FileName);
	m_DHCPHostName = szRHS1;

	m_EditDHCPHostName.LimitText (50) ;

        /* Is DHCP Client Enabled on Internet LAN */
	GetPrivateProfileString((LPCSTR) IPSectionHeader, (LPCSTR) "IP Port1 DHCP Client", StrNull,
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR)FileName);

        if (!strcmp(szRHS, StrEnabled))
        {
                m_DHCPClientEnabled = TRUE;
                m_InternetLANIPAddrStr = DHCPAssigned;
                m_InternetLANMskStr = DHCPAssigned;
//				m_DnsServerValue = DHCPAssigned; 
                m_DHCPClientWnd.EnableWindow(TRUE);
                m_InternetLANIPAddrHdrWnd.EnableWindow(FALSE);
                m_InternetLANMskHdrWnd.EnableWindow(FALSE);
                m_InternetLANIPAddrWnd.EnableWindow(FALSE);
                m_InternetLANMskWnd.EnableWindow(FALSE);
//				m_DnsServerHdr.EnableWindow(FALSE);
//				m_DnsServer.EnableWindow(FALSE);
        }
        else
        {
                m_DHCPClientEnabled = FALSE;
        }

        /* Is DHCP Relay Agent Enabled on Internet LAN */
	GetPrivateProfileString((LPCSTR) DHCPSectionHeader, "DHCP Relay Agent", StrNull,
				(LPSTR) szRHS, sizeof(szRHS), FileName);

        if (!strcmp(szRHS, StrEnabled))
        {
                m_DHCPRelayAgentEnabled = TRUE;
        	GetPrivateProfileString((LPCSTR) DHCPSectionHeader, "DHCP Server IP Address", StrNull,
				szRHS, sizeof(szRHS), FileName);
                m_DHCPServerAddress = szRHS;
                m_DHCPServerAddressWnd.EnableWindow(TRUE);
                m_DHCPRelayAgentWnd.EnableWindow(TRUE);
                m_DHCPServerAddressHdrWnd.EnableWindow(TRUE);
        }
        else
        {
                m_DHCPRelayAgentEnabled = FALSE;
                m_DHCPServerAddress = "0.0.0.0";
                m_DHCPServerAddressWnd.EnableWindow(FALSE);
                m_DHCPServerAddressHdrWnd.EnableWindow(FALSE);
        }

	char *comma; // To break the string at ',' .
	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) StrNull,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
	
	if ((comma = strchr (szRHS, (int) ',')) != NULL)
  	{
	   	*comma = '\0' ;
   		DotValue = m_SecuredLANGwayStr = szRHS;
   		m_nDefaultMetric = (UINT) atoi(++ comma) ;
  	}
	else
	{
		m_nDefaultMetric = 1 ; // If not provided, default to 1
	}

	if (!DotValue.IsEmpty() && !DotValue.IsValid())
		m_SecuredLANGwayStr = "" ;

	UINT NumberOfIPPorts;

	NumberOfIPPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",3,
				(LPCSTR) FileName);

        m_nIGwayPort = GetPrivateProfileInt(IPSectionHeader,
		    	(LPCSTR) "IP Internet Gateway Port",2,
		    	(LPCSTR) FileName);

        if (m_nIGwayPort > NumberOfIPPorts || IsSecuredLANPort(m_nIGwayPort))
                m_nIGwayPort = NumberOfIPPorts-1;

        if (!IsWANPort(m_nIGwayPort))
        {       // Get the InternetGateWay IP Address
	        GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		        (LPCSTR) "IP Internet Gateway Address", ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
                DotValue = m_IGwayAddressStr = szRHS;
	        if ( ! DotValue.IsValid())
                {
	        	m_IGwayAddressStr = ZeroIPAddress;
                }

                //Handle UI now
//                UpdateData(TRUE);
                LANIsSelectedAsInternetGateay();
        }
        else
        {
                //Handle UI now
//                UpdateData(TRUE);
                WANIsSelectedAsInternetGateay();
        }

	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CIPConfig::OnOK()
{
	// TODO: Add extra validation here
	char	szRHS[40], szRHS1[60] ; // szDHCPServerAddress;
	char    *szPPPLHS = "PPP Port%d Option%%IPCP%%IP Address";
	CDotDecimal DotValue;
        BOOL ValueWritten = FALSE;

	UpdateData(TRUE);
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidEditFields())
		return;
	
        WriteIPPortParameters(0, m_SecuredLANIPAddrStr, m_SecuredLANMskStr); //Write Address and Net Mask for Secured LAN Port

/* Added By Ravi on 11 Jan 1999 ... */
//	if (!m_DHCPClientWnd.GetCheck())
//        {
            DotValue = m_DnsServerValue;

			if (DotValue.IsEmpty())
			{
				m_DnsServerValue=ZeroIPAddress;
				exit;
			}

        	if (!DotValue.IsValid())
            {
				if (DotValue != ZeroIPAddress)
				{
	        	        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DNS Server Address",
			                (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		                m_DnsServer.SetFocus() ;
		                return ;
				}
            }

//        }
//	else
//		m_DnsServerValue = "0.0.0.0";

	WritePrivateProfileString ((LPCSTR) IPSectionHeader, (LPCSTR) "IP DNS Server Address1",
		 m_DnsServerValue, (LPCSTR) FileName) ;

// Setting DNS Server Address1 & DNS Server Address2 as same
	WritePrivateProfileString ((LPCSTR) IPSectionHeader, (LPCSTR) "IP DNS Server Address2",
		 m_DnsServerValue, (LPCSTR) FileName) ;

/* ... Added By Ravi on 11 Jan 1999 */

        if (m_DHCPClientWnd.GetCheck())
        {
                m_InternetLANIPAddrStr = "0.0.0.0";
                m_InternetLANMskStr = "0.0.0.0";
		m_DnsServerValue = "0.0.0.0";
                strcpy(szRHS, "enabled");
        }
        else
                strcpy(szRHS, "disabled");
                
        WritePrivateProfileString(IPSectionHeader ,
      	        (LPCSTR) "IP Port1 DHCP Client",(LPSTR)szRHS, (LPCSTR) FileName);
                
        WriteIPPortParameters(1, m_InternetLANIPAddrStr, m_InternetLANMskStr); //Write Address and Net Mask for Internet LAN Port

        if (m_ISPCheck)
                m_WANIPAddrStr = ZeroIPAddress;
        WriteIPPortParameters(2, m_WANIPAddrStr, m_WANMskStr); //Write Address and Net Mask for WAN Port

#if 0
	wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nTimeToLive);
	WritePrivateProfileString(IPSectionHeader ,
			(LPCSTR) "IP Default TTL",(LPSTR)szRHS, (LPCSTR) FileName);

	wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nReassemblyTimeOut);
	WritePrivateProfileString(IPSectionHeader ,
				(LPCSTR) "IP Reassembly Timeout", szRHS, (LPCSTR) FileName) ;

#endif
	wsprintf(szRHS, "%s,%d", (LPCSTR)m_SecuredLANGwayStr, m_nDefaultMetric);
	WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) szRHS, (LPCSTR) FileName) ;

        if (m_DHCPRelayAgentWnd.GetCheck())
        {
                DotValue = m_DHCPServerAddress;
        	if (DotValue.IsEmpty() || !DotValue.IsValid())
                {
	                ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DHCP Server Address",
			                (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
	                m_DHCPServerAddressWnd.SetFocus() ;
	                return ;
                }
                strcpy(szRHS, "enabled");
        }
        else
        {
                strcpy(szRHS, "disabled");
                m_DHCPServerAddress = "0.0.0.0";
        }

       	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Relay Agent", (LPCSTR) szRHS, (LPCSTR) FileName) ;

	/* For DHCP Host Name*/
        strcpy(szRHS1, m_DHCPHostName) ;
       	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Host Name", (LPCSTR) szRHS1, (LPCSTR) FileName) ;

       	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Server IP Address", (LPCSTR)m_DHCPServerAddress , (LPCSTR) FileName) ;


        if (m_RLANIsGway.GetCheck())
        {
                DotValue = m_IGwayAddressStr;
        	if (m_DHCPClientWnd.GetCheck() || IsValidInternetGatewayAddress(m_IGwayAddressStr))
                {
                        wsprintf((LPSTR) szRHS, (LPSTR) "%u", GetInternetLANPortNumber());
                        WritePrivateProfileString(IPSectionHeader ,
			        (LPCSTR) "IP Internet Gateway Port",(LPSTR)szRHS, (LPCSTR) FileName);
                        if (m_DHCPClientWnd.GetCheck())
                                m_IGwayAddressStr = ZeroIPAddress;
                        WritePrivateProfileString(IPSectionHeader, (LPCSTR) "IP Internet Gateway Address",
			        m_IGwayAddressStr, (LPCSTR) FileName);
                        ValueWritten = TRUE;
                }
                else
                {
		        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Internet gateway address",
			        (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		        m_IGwayAddressWnd.SetFocus() ;
                        return;
                }
        }
        else
        {
                m_IGwayAddressStr = ZeroIPAddress;
                wsprintf((LPSTR) szRHS, (LPSTR) "%u", GetWANPortNumber());
                WritePrivateProfileString(IPSectionHeader ,
	       	        (LPCSTR) "IP Internet Gateway Port",(LPSTR)szRHS, (LPCSTR) FileName);

 	        WritePrivateProfileString(IPSectionHeader, (LPCSTR) "IP Internet Gateway Address",
				        m_IGwayAddressStr, (LPCSTR) FileName);
        }

	CDialog::OnOK();
}

void CIPConfig::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_IP_CONFIG_DIALOG, HELP_CONTEXT);
}

void CIPConfig::ReadIPPortParameters(int PortNumber, CString& Address, CString& NetMask)
{
	char	szRHS[40];
	char	szLHSAddr[40];
	char	szLHSMask[40];
	CDotDecimal DotValue;
        
	sprintf(szLHSAddr, "IP Port%d Address", PortNumber);
	sprintf(szLHSMask, "IP Port%d Address Mask", PortNumber);

	//Get IP address 
	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHSAddr, ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;

	DotValue = Address = szRHS;
        if (IsWANPort(PortNumber))
        {
	        if ( ! DotValue.IsValid())
                {
	        	Address = ZeroIPAddress;
                        m_ISPCheck = TRUE;
                }
                else
                        m_ISPCheck = FALSE;
        }

        //Get subnet mask 
	GetPrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
 				ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   				(LPCSTR) FileName);
   	NetMask = szRHS;
	if ( ! verify_ip_subnet_mask((LPCSTR)m_SecuredLANMskStr))
		NetMask = ZeroIPAddress;
}


void CIPConfig::WriteIPPortParameters(int PortNumber, CString Address, CString NetMask)
{
	char	szRHS[40];
	char	szLHSAddr[40];
	char	szLHSMask[40];
	char    *szPPPLHS = "PPP Port%d Option%%IPCP%%IP Address";
	CDotDecimal DotValue;
        
	sprintf(szLHSAddr, "IP Port%d Address", PortNumber);
	sprintf(szLHSMask, "IP Port%d Address Mask", PortNumber);

	//Get IP address 
	WritePrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHSAddr, Address, (LPCSTR) FileName) ;

        if (IsWANPort(PortNumber))
        {
		wsprintf(szRHS, szPPPLHS, PortNumber - GetNumberOfLanPorts());
                if (m_ISPCheck == TRUE)
                {
			// PPP local address is 0.0.0.0 and negotiable
                	ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
			ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
                }
                else
                {
			ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
			ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szRHS, 5, (LPCSTR) Address) ;
                }
        }
        else
        {
                if (IsSecuredLANPort(PortNumber))
        		WritePrivateProfileString ((LPCSTR) SNMPSectionHeader,
	        		(LPCSTR) "SNMP Local Internet Address",
		        		(LPCSTR) Address, (LPCSTR) FileName) ;
        }
 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
				NetMask, (LPCSTR) FileName);
}


int CIPConfig::GetNumberOfLanPorts()
{
	return (GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "LSL Number of LAN Ports",2,
				(LPCSTR) FileName));
}
BOOL CIPConfig::ValidatePortParameter(int PortNumber, CString Address, CString NetMask,  CEdit& AddressWnd, CEdit& NetMaskWnd)
{
	CDotDecimal DotValue;

	DotValue = Address;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

        if (IsWANPort(PortNumber))
        {
                if (m_ISPCheck)
        		DotValue = ZeroIPAddress;
                else
	        if (!DotValue.IsValid())
	        {
	                ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
			                (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
	                AddressWnd.SetFocus() ;
	                return FALSE ;
	        }
        }
	else
	if (!DotValue.IsValid())
	{
	        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
			        (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
	        AddressWnd.SetFocus() ;
	        return FALSE ;
	}

	DotValue = NetMask;

	if ( !DotValue.IsValid() || !verify_ip_subnet_mask((LPCSTR)NetMask))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		NetMaskWnd.SetFocus() ;
		return FALSE ;
	}
	return TRUE ;
        
}

BOOL CIPConfig::ValidEditFields()
{
        if (!ValidatePortParameter(0, m_SecuredLANIPAddrStr, m_SecuredLANMskStr, m_SecuredLANIPAddrWnd, m_SecuredLANMskWnd))
        {
	        return FALSE;
        }

        if (!m_DHCPClientWnd.GetCheck())
        {
                if (!ValidatePortParameter(1, m_InternetLANIPAddrStr, m_InternetLANMskStr, m_InternetLANIPAddrWnd, m_InternetLANMskWnd))
                {
	                return FALSE;
                }
        }
        if (!ValidatePortParameter(2, m_WANIPAddrStr, m_WANMskStr, m_IPAddrWnd, m_WANMskWnd))
        {
	        return FALSE;
        }

	CDotDecimal DotValue;
	DotValue = m_SecuredLANGwayStr;
	if ( ! DotValue.IsValid())
	{
		if (DotValue != ZeroIPAddress)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Default Route",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_SecuredLANGwayWnd.SetFocus() ;
			return FALSE ;
		}
	}
	//Check to see that the gateway address, if entered
	//is in the same network as the LAN
	if (DotValue != ZeroIPAddress)
	{
		DWORD LANIPAddress, GWAYIPAddress, NETMask;
		get_ip_address((LPCSTR) m_SecuredLANIPAddrStr, &LANIPAddress);
		get_ip_address((LPCSTR) m_SecuredLANMskStr, &NETMask);
		get_ip_address((LPCSTR) m_SecuredLANGwayStr, &GWAYIPAddress);
		if ((LANIPAddress & NETMask) != (GWAYIPAddress & NETMask))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN port IP address and Gateway \
IP address\nmust be in the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_SecuredLANGwayWnd.SetFocus() ;
			return FALSE ;
		}
		if (LANIPAddress == GWAYIPAddress)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Default Route must \
point to another\nhost or router on the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_SecuredLANGwayWnd.SetFocus() ;
			return FALSE ;
		}
	}
#if 0
	if ( (m_nTimeToLive < MIN_DEFAULT_TTL) ||
						(m_nTimeToLive > MAX_DEFAULT_TTL))
	{
		char Msg[80];
		wsprintf(Msg, "Invalid TTL. Must be between %d and %d",
			MIN_DEFAULT_TTL, MAX_DEFAULT_TTL);
		::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_TimeToLiveWnd.SetFocus() ;
		return FALSE ;
	}

	if ( (m_nReassemblyTimeOut < MIN_REASSM_TMOUT) ||
						(m_nReassemblyTimeOut > MAX_REASSM_TMOUT))
	{
		char Msg[80];
		wsprintf(Msg, "Invalid Reassembly Timeout.\n\
Must be between %d and %d", MIN_DEFAULT_TTL, MAX_DEFAULT_TTL);
		::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_ReassemblyTimeOutWnd.SetFocus() ;
		return FALSE ;
	}
#endif
	if (m_SecuredLANGwayStr.IsEmpty())
		m_SecuredLANGwayStr = ZeroIPAddress;

	return TRUE;
}

void CIPConfig::ISPAssignedStatusChanged()
{
        UpdateData(TRUE);			//Get the dialog updates
        if (m_ISPWnd.GetCheck())
        {
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
//		m_WANIPAddrStr = ZeroIPAddress; //reset address
		m_WANIPAddrStr = "ISP Assigned";
        }
        else
        {
		m_WANIPAddrStr = ZeroIPAddress; 
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
        }
	UpdateData(FALSE);		//display data in dialog
}

void CIPConfig::OnButtonStatHost()
{
	CIPHRoute IIPHRoute (this) ;
	IIPHRoute.DoModal() ;
}

/* #if 0
void CIPConfig::OnAdvancedIPConfig()
{
        CIGwayConfig IIGwayConfig (this);
        IIGwayConfig .DoModal();
}
#endif
*/


void CIPConfig::OnSelectionWAN()
{
	UpdateData(TRUE);		//display data in dialog
        WANIsSelectedAsInternetGateay();
}

void CIPConfig::WANIsSelectedAsInternetGateay()
{
        m_RWANIsGway.SetCheck(1);
        m_RLANIsGway.SetCheck(0);
        m_IGwayAddressHdr.EnableWindow(FALSE);
        m_IGwayAddressWnd.EnableWindow(FALSE);
        m_IGwayAddressStr = ZeroIPAddress;
	UpdateData(FALSE);		//display data in dialog
}

void CIPConfig::OnSelectionLAN()
{
	UpdateData(TRUE);
        LANIsSelectedAsInternetGateay();
}
void CIPConfig::LANIsSelectedAsInternetGateay()
{
        m_RWANIsGway.SetCheck(0);
        m_RLANIsGway.SetCheck(1);
        if(m_DHCPClientEnabled)
        {
                m_IGwayAddressStr = DHCPAssigned;
                m_IGwayAddressHdr.EnableWindow(FALSE);
                m_IGwayAddressWnd.EnableWindow(FALSE);
//					m_DnsServerHdr.EnableWindow(FALSE);
        }
        else
        {
                m_IGwayAddressHdr.EnableWindow(TRUE);
                m_IGwayAddressWnd.EnableWindow(TRUE);
//			 	    m_DnsServerHdr.EnableWindow(TRUE);
        }
	UpdateData(FALSE);		//display data in dialog
}

BOOL CIPConfig::IsValidInternetGatewayAddress(CString Address)
{
//        CIPConfig *pFather = (CIPConfig*)GetParent();
	CDotDecimal AddressDotValue, SubNetDotValue, GatewayDotValue = Address;

        if (!GatewayDotValue.IsValid())
                return FALSE;

        AddressDotValue = m_InternetLANIPAddrStr;
        if (!AddressDotValue.IsValid())
                return FALSE;

        SubNetDotValue = m_InternetLANMskStr;
        if (!SubNetDotValue.IsValid())
                return FALSE;
        if (RmtLocalIpAddressesOfSameNet((LPCSTR)AddressDotValue, (LPCSTR)GatewayDotValue, (LPCSTR)SubNetDotValue))
                return TRUE;
        return FALSE;
}

void CIPConfig::OnDHCPClient()
{
	UpdateData(TRUE);		
        if (m_DHCPClientWnd.GetCheck())
        {
                m_InternetLANIPAddrStr = DHCPAssigned;
                m_InternetLANMskStr = DHCPAssigned;
//				m_DnsServerValue = DHCPAssigned;
				m_InternetLANIPAddrHdrWnd.EnableWindow(FALSE);
				m_InternetLANIPAddrWnd.EnableWindow(FALSE);
				m_InternetLANMskHdrWnd.EnableWindow(FALSE);
				m_InternetLANMskWnd.EnableWindow(FALSE);
//				m_DnsServerHdr.EnableWindow(FALSE);
//				m_DnsServer.EnableWindow(FALSE);
                
                if (m_RLANIsGway.GetCheck())
                        m_IGwayAddressStr = DHCPAssigned;
                m_IGwayAddressHdr.EnableWindow(FALSE);
                m_IGwayAddressWnd.EnableWindow(FALSE);

        }
        else
        {
				m_InternetLANIPAddrHdrWnd.EnableWindow(TRUE);
				m_InternetLANIPAddrWnd.EnableWindow(TRUE);
				m_InternetLANMskHdrWnd.EnableWindow(TRUE);
				m_InternetLANMskWnd.EnableWindow(TRUE);
				m_DnsServerHdr.EnableWindow(TRUE);
				m_DnsServer.EnableWindow(TRUE);


                if (m_RLANIsGway.GetCheck())
                {
                        m_IGwayAddressHdr.EnableWindow(TRUE);
                        m_IGwayAddressWnd.EnableWindow(TRUE);
                }
                m_InternetLANIPAddrStr = ZeroIPAddress;
                m_InternetLANMskStr = ZeroIPAddress;
                m_IGwayAddressStr = ZeroIPAddress;
//				m_DnsServerValue = ZeroIPAddress;
        }
	UpdateData(FALSE);
}

void CIPConfig::OnDHCPRelayAgent()
{
	UpdateData(TRUE);		
        if (m_DHCPRelayAgentWnd.GetCheck())
        {
                m_DHCPRelayAgentEnabled = TRUE;
                m_DHCPServerAddress = "0.0.0.0";
                m_DHCPServerAddressWnd.EnableWindow(TRUE);
                m_DHCPRelayAgentWnd.EnableWindow(TRUE);
                m_DHCPServerAddressHdrWnd.EnableWindow(TRUE);
        }
        else
        {
                m_DHCPRelayAgentEnabled = FALSE;
                m_DHCPServerAddress = "0.0.0.0";
                m_DHCPServerAddressWnd.EnableWindow(FALSE);
                m_DHCPServerAddressHdrWnd.EnableWindow(FALSE);
        }
	UpdateData(FALSE);		//display data in dialog
}
