// ipconfig.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CIPConfig dialog

class CIPConfig : public CDialog
{
// Construction
public:
	CIPConfig(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CIPConfig)
	enum { IDD = IDD_IP_CONFIG_DIALOG };
	CStatic	m_DnsServerHdr;
	CEdit	m_DnsServer;
	CEdit	m_EditDHCPHostName;
	CString	m_SecuredLANIPAddrStr; // Secured LAN IP Address
   CEdit    m_SecuredLANIPAddrWnd; // Secured LAN IP Address Handler
	CString  m_SecuredLANMskStr;    // Secured LAN Net Mask
	CEdit    m_SecuredLANMskWnd;    // Secured LAN Net Mask Handler
	CString  m_SecuredLANGwayStr;   // Default Gateway for Secured LAN
	CEdit    m_SecuredLANGwayWnd;   // Default Gateway Control for Secured LAN
	CString	m_InternetLANIPAddrStr; // Internet LAN IP Address
	CStatic 	m_InternetLANIPAddrHdrWnd; // Internet LAN IP Address Handler
	CEdit 	m_InternetLANIPAddrWnd; // Internet LAN IP Address Handler
	CString  m_InternetLANMskStr;    // Internet LAN Net Mask
	CEdit    m_InternetLANMskWnd;    // Internet LAN Net Mask Handler
	CStatic  m_InternetLANMskHdrWnd;    // Internet LAN Net Mask Handler
   CButton  m_DHCPClientWnd;    // DHCP Client Handler
   BOOL     m_DHCPClientEnabled;    // Is DHCP Client on this port enabled
   BOOL     m_DHCPRelayAgentEnabled; // Is DHCP Relay Agent Enabled on this port
   CButton  m_DHCPRelayAgentWnd; // DHCP Relay Agent Handler
   CStatic  m_DHCPServerAddressHdrWnd; // DHCP Server IP Address Header Handler
   CString  m_DHCPServerAddress; // DHCP Server Address
   CEdit    m_DHCPServerAddressWnd; // DHCP Server IP Address Handler
	CButton	m_ISPWnd;               // To Handle 'ISP' checkbox
	BOOL	   m_ISPCheck;             // Status of 'ISP'checkbox
	CString	m_WANIPAddrStr;         // IP Address for WAN Port if not 'ISP Assigned'
	CEdit	   m_IPAddrWnd;            // To Handle IP Address BOX
   CStatic  m_IPHdrWnd;             // To Handle IP Address Static Text
	CString  m_WANMskStr;            // Net Mask for WAN Port if not 'ISP Assigned'
	CEdit    m_WANMskWnd;            // Net Mask for WAN Port if not 'ISP Assigned'
   CButton  m_RWANIsGway;
   CButton  m_RLANIsGway;
   CStatic  m_IGwayAddressHdr;
   CString  m_IGwayAddressStr;
   CEdit    m_IGwayAddressWnd;
   UINT     m_nIGwayPort;
	UINT	   m_nDefaultMetric;
	int	m_nPorts;		// number of IP ports
   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   CBitmapButton StaticRouteBitmapBtn;
	CString	m_DHCPHostName;
	CString	m_DnsServerValue;
	//}}AFX_DATA


// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CIPConfig)
	virtual BOOL   OnInitDialog();
	virtual void   OnOK();
   afx_msg void   ReadIPPortParameters(int PortNumber, CString& Address, CString& NetMask);
   afx_msg void   WriteIPPortParameters(int PortNumber, CString Address, CString NetMask);
//   afx_msg BOOL   IsWANPort(int PortNumber);
//   afx_msg BOOL   IsSecuredLANPort(int PortNumber);
   afx_msg BOOL   ValidatePortParameter(int PortNumber, CString Address, CString NetMask,  CEdit& AddressWnd, CEdit& NetMaskWnd);
   afx_msg BOOL   ValidEditFields();
   afx_msg int    GetNumberOfLanPorts();
   afx_msg void   ISPAssignedStatusChanged();      
   afx_msg void   OnHelp();
   afx_msg void   OnButtonStatHost();
   afx_msg void   OnSelectionWAN();
   afx_msg void   OnSelectionLAN();
   afx_msg BOOL   IsValidInternetGatewayAddress(CString Address);
   afx_msg void   OnDHCPClient();
   afx_msg void   OnDHCPRelayAgent();
   afx_msg void   WANIsSelectedAsInternetGateay();
   afx_msg void   LANIsSelectedAsInternetGateay();
//   afx_msg void   OnAdvancedIPConfig();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
