/// -------------------------------------------------------------------------
// Project Name                 :       Wizard Setup 
// File Name                    :       IPDNLD.CPP
// Start Date                   :       22nd JAN 1999
// Author                   	  :       Sreelakshmi
// Modifications                : 
/// -------------------------------------------------------------------------

// ipdnld.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "dot.h"
#include "maskdot.h"
#include "ipdnld.h"
#include "dhcpk.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char	*IPDnldMsgHeader="IP Setup";
char  *DhcpAssigned = "DHCP Assigned";
char  *ISPAssigned = "ISP Assigned";
CDotDecimal DotValue;

extern char	*IPMsgHeader;

extern int GetWANPortNumber();
extern BOOL IsSecuredLANPort(int PortNumber);
extern int GetInternetLANPortNumber();
extern BOOL IsSecuredLANPort(int PortNumber);
extern BOOL IsWANPort(int PortNumber);
extern BOOL RmtLocalIpAddressesOfSameNet (LPCSTR LocalAddr, LPCSTR RmtAddr, LPCSTR AddrMask);
extern BOOL ModifyIPAddress ; /* Neelu on 04/02/99 */
extern CDotDecimal dotdecimal_configured_ip_address ;/* Neelu on 04-02-99*/

/////////////////////////////////////////////////////////////////////////////
// CIPDNLD dialog


CIPDNLD::CIPDNLD(CWnd* pParent /*=NULL*/)
	: CDialog(CIPDNLD::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIPDNLD)
	m_IPAddrStr = "";
	m_MskStr = "";
	m_ISPcheck = FALSE;
	m_DNSAddrStr = "";
	m_DRAddrStr = "";
	m_RAcheck = FALSE;
	m_RAAddrStr = "";
	m_GTAddrStr = "";
	m_HostNameStr = "";
	m_Dhcpcheck = FALSE;
	m_port_string2 = "";
	m_port_string1 = "";
	//}}AFX_DATA_INIT
}

void CIPDNLD::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIPDNLD)
	DDX_Control(pDX, IDC_RADIO_LAN, m_LANEnabled);
	DDX_Control(pDX, IDC_RADIO_WAN, m_WanEnabled);
	DDX_Control(pDX, IDC_STATIC_DNS_SERVER, m_DNSHdrWnd);
	DDX_Control(pDX, IDC_CHECK_DHCP_CLIENT, m_DhcpWnd);
	DDX_Control(pDX, IDC_STATIC_HOST_NAME, m_HostNameWnd);
	DDX_Control(pDX, IDC_STATIC_GT_IP_ADDRESS, m_GTHdrWnd);
	DDX_Control(pDX, IDC_STATIC_ADDR_RA, m_RAHdrWnd);
	DDX_Control(pDX, IDC_STATIC_DEFAULT_ROUTE, m_DRHdrWnd);
	DDX_Control(pDX, IDC_STATIC_MASK, m_MaskHdrWnd);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_EDIT_HOST_NAME, m_HostWnd);
	DDX_Control(pDX, IDC_EDIT_GT_IP_ADDRESS, m_GTAddrWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR_RA, m_RAAddrWnd);
	DDX_Control(pDX, IDC_CHECK_RELAY_AGENT, m_RAWnd);
	DDX_Control(pDX, IDC_EDIT_DEFAULT_ROUTE, m_DRAddrWnd);
	DDX_Control(pDX, IDC_EDIT_DNS_SERVER, m_DNSAddrWnd);
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPcheck);
	DDX_Text(pDX, IDC_EDIT_DNS_SERVER, m_DNSAddrStr);
	DDX_Text(pDX, IDC_EDIT_DEFAULT_ROUTE, m_DRAddrStr);
	DDX_Check(pDX, IDC_CHECK_RELAY_AGENT, m_RAcheck);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR_RA, m_RAAddrStr);
	DDX_Text(pDX, IDC_EDIT_GT_IP_ADDRESS, m_GTAddrStr);
	DDX_Text(pDX, IDC_EDIT_HOST_NAME, m_HostNameStr);
	DDX_Check(pDX, IDC_CHECK_DHCP_CLIENT, m_Dhcpcheck);
	DDX_Text(pDX, IDC_STATIC2, m_port_string2);
	DDX_Text(pDX, IDC_STATIC1, m_port_string1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CIPDNLD, CDialog)
	//{{AFX_MSG_MAP(CIPDNLD)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_CHECK_RELAY_AGENT, OnCheckRelayAgent)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	ON_BN_CLICKED(IDC_RADIO_LAN, OnRadioLan)
	ON_BN_CLICKED(IDC_RADIO_WAN, OnRadioWan)
	ON_BN_CLICKED(IDC_CHECK_DHCP_CLIENT, OnCheckDhcpClient)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CIPDNLD message handlers

void CIPDNLD::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here
		UpdateData(TRUE);			//Get the dialog updates

	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		m_ISPcheck = TRUE;
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
		m_IPAddrStr = ISPAssigned; //reset address
	}
	else
	{
		m_ISPcheck = FALSE;
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
		m_MaskHdrWnd.EnableWindow(TRUE);
		m_MskWnd.EnableWindow(TRUE);
		m_IPAddrStr = ZeroIPAddress; //reset address
	}
		UpdateData(FALSE);		//display data in dialog
}

void CIPDNLD::OnCheckRelayAgent()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);		//Get the dialog updates
        if (m_RAWnd.GetCheck())
        {
                m_RAcheck = TRUE;
                m_RAAddrWnd.EnableWindow(TRUE);
                m_RAWnd.EnableWindow(TRUE);
                m_RAHdrWnd.EnableWindow(TRUE);
        }
        else
        {
                m_RAcheck = FALSE;
			       m_RAAddrStr = ZeroIPAddress;
                m_RAAddrWnd.EnableWindow(FALSE);
                m_RAHdrWnd.EnableWindow(FALSE);
        }

	UpdateData(FALSE);		//display data in dialog
}

void CIPDNLD::OnSelchangeListPorts()
{
// TODO: Add your control notification handler code here
	int PortIndex;

	UpdateData(TRUE);		//Get the dialog updates

// Validate the Values entered for the previous selection

	if (!ValidatePortSettings(m_nOldPort))
	{
		SelectPort(m_nOldPort);
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}

// Store the Old Values in a temp array
 	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr; 

	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
	{
		AfxMessageBox("PortIndex Fails");
		return;
	}		

// Get the Values for the selected port
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];

	if (PortIndex == 0)		//Secured LAN index
	{
// Disable Controls Regarding Internet Lan & Wan
		SelectSecuredLan();
	}
	else if(PortIndex == 1)		//InSecured LAN index
	{
// Disable Controls Regarding Secured Lan & Wan
		SelectInternetLan();
	}
	else if(PortIndex == 2)	  //Wan index
	{
// Disable Controls Regarding Secured Lan & Wan
		SelectWan();
	}

	UpdateData(FALSE);	//display data in dialog
	m_nOldPort = PortIndex;

}

void CIPDNLD::OnCancel()
{
	// TODO: Add extra cleanup here
	CDialog::OnCancel();
}

void CIPDNLD::OnOK()
{
	// TODO: Add extra validation here
	char	szRHS[40], szRHS1[80] ; 
   BOOL ValueWritten = FALSE;

	UpdateData(TRUE);		//Get the dialog updates

// Store the Old Values in a temp array
 	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr; 

//Write Secured Lan Parameters
	for(int i = 0; i < m_nPorts; i++)
	{
		DotValue = m_IPAddr[i];

		if(!ValidatePortSettings(i))
			return;

		if(i == 1)		// InSecured Lan
		{
			if (m_Dhcpcheck)
			{
            m_IPAddr[i] = ZeroIPAddress;
            m_IPMask[i] = ZeroIPAddress;
	 			m_DNSAddrStr = ZeroIPAddress;
            strcpy(szRHS, "enabled");
			}
			else
				strcpy(szRHS, "disabled");

			WritePrivateProfileString(IPSectionHeader ,
     	 	     (LPCSTR) "IP Port1 DHCP Client",(LPSTR)szRHS, (LPCSTR) FileName);

			DotValue = m_DNSAddrStr;

#if 0
	wsprintf (szRHS1, "DNS Server Address is %s.", m_DNSAddrStr);
	::MessageBox (GetSafeHwnd(),(LPCSTR) szRHS1,
	      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
#endif

	if(!m_Dhcpcheck)
	{
	   if (m_DNSAddrStr.IsEmpty())
		{
			DotValue = ZeroIPAddress;
			m_DNSAddrStr=ZeroIPAddress;
		}	
	
	 	if(strcmp(DotValue,ZeroIPAddress) && !DotValue.IsValid())
	 	{
	 	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DNS Server Address",
	 		      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
	 		m_PortListWnd.SetCurSel(1);
	 		SelectInternetLan();
	 		m_DNSAddrWnd.SetFocus();
	 		return;
	 	}
	}

	      WritePrivateProfileString(IPSectionHeader ,
     	        (LPCSTR) "IP DNS Server Address1", (LPCSTR) m_DNSAddrStr, (LPCSTR) FileName);

   	   WritePrivateProfileString(IPSectionHeader ,
     	        (LPCSTR) "IP DNS Server Address2", (LPCSTR) m_DNSAddrStr, (LPCSTR) FileName);
                
		}
		
		if( i == 2 )
		{
		  if (m_ISPcheck)
   	     m_IPAddr[i] = ZeroIPAddress;
		}

		WriteIPPortParameters(i,m_IPAddr[i],m_IPMask[i]);
	}

//Write Default Route Address
	DotValue = m_DRAddrStr;
	if(!DotValue.IsValid() && strcmp(DotValue, ZeroIPAddress))
	{
	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Default Route Address",
		      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_PortListWnd.SetCurSel(0);
		SelectSecuredLan();
		m_DRAddrWnd.SetFocus();
		return;
	}

	wsprintf(szRHS, "%s,%d", (LPCSTR)m_DRAddrStr, m_nDefaultMetric);
	WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) szRHS, (LPCSTR) FileName) ;

//Write Relay Agent DHCP Server Address
   if (m_RAWnd.GetCheck())
   {
       DotValue = m_RAAddrStr;
     	 if (DotValue.IsEmpty() || !DotValue.IsValid())
       {
	        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Relay Agent IP Address",
		        (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
 			  m_PortListWnd.SetCurSel(1);
			  SelectInternetLan();
	        m_RAAddrWnd.SetFocus() ;
	        return ;
        }
        strcpy(szRHS, "enabled");
   }
   else
   {
		strcpy(szRHS, "disabled");
      m_RAAddrStr = ZeroIPAddress;
   }

	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Relay Agent", (LPCSTR) szRHS, (LPCSTR) FileName) ;

 	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Server IP Address", (LPCSTR) m_RAAddrStr , (LPCSTR) FileName) ;

//Write DHCP Host Name
         strcpy(szRHS1, m_HostNameStr) ;
       	WritePrivateProfileString ((LPCSTR) DHCPSectionHeader, 
               	(LPCSTR) "DHCP Host Name", (LPCSTR) szRHS1, (LPCSTR) FileName) ;

//Write Internet Gateway Parameter
        if (m_LANEnabled.GetCheck())
        {
					if (!strcmp(m_GTAddrStr,DhcpAssigned))
							DotValue = ZeroIPAddress;
					else
			            DotValue = m_GTAddrStr;

//   	     		if (!strcmp(DotValue, ZeroIPAddress) || IsValidInternetGatewayAddress(m_GTAddrStr))
   	     		if (m_Dhcpcheck || (IsValidInternetGatewayAddress(m_GTAddrStr) && !m_Dhcpcheck))
            	{
                 wsprintf((LPSTR) szRHS, (LPSTR) "%u", GetInternetLANPortNumber());
                 WritePrivateProfileString(IPSectionHeader ,
				        (LPCSTR) "IP Internet Gateway Port",(LPSTR)szRHS, (LPCSTR) FileName);
                 if (m_DhcpWnd.GetCheck())
                    m_GTAddrStr = ZeroIPAddress;
                 WritePrivateProfileString(IPSectionHeader, (LPCSTR) "IP Internet Gateway Address",
  				        m_GTAddrStr, (LPCSTR) FileName);
         	     ValueWritten = TRUE;
           		}
            	else
            	{
			        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Internet gateway address",
				        (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			        m_GTAddrWnd.SetFocus() ;
         	     return;
            	}
        }
        else
        {
                m_GTAddrStr = ZeroIPAddress;
                wsprintf((LPSTR) szRHS, (LPSTR) "%u", GetWANPortNumber());
                WritePrivateProfileString(IPSectionHeader ,
	       	        (LPCSTR) "IP Internet Gateway Port",(LPSTR)szRHS, (LPCSTR) FileName);

		 	       WritePrivateProfileString(IPSectionHeader, (LPCSTR) "IP Internet Gateway Address",
				        m_GTAddrStr, (LPCSTR) FileName);
        }

	CDialog::OnOK();
}

BOOL CIPDNLD::OnInitDialog()
{
	char *comma; // To break the string at ',' .

	CDialog::OnInitDialog();
	
// TODO: Add extra initialization here
	
	if (!OKBitmapBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBitmapBtn.SubclassDlgItem (IDOK, this));
	OKBitmapBtn.SizeToContent();

	if (!CancelBitmapBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load Cancel bitmap");

	VERIFY (CancelBitmapBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBitmapBtn.SizeToContent();

// Load the Strings from the String Table
//		m_gateway_string.LoadString(IDS_STRING_WAN);

//Add items into the port list
 	m_PortListWnd.InsertString(0,"Secured LAN");
 	m_PortListWnd.InsertString(1,"Internet LAN");
 	m_PortListWnd.InsertString(2,"WAN");
	
//Set current selection as Secured LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

// Read the configuration file and init the variables
	char	szRHS[40];

	strcpy(FileName, IniInWinForm);

	UINT NumberOfIPPorts;

/* Is DHCP Client Enabled on Internet LAN - Added by Ravi */
	GetPrivateProfileString((LPCSTR) IPSectionHeader, (LPCSTR) "IP Port1 DHCP Client", StrNull,
				(LPSTR)szRHS, sizeof(szRHS), (LPCSTR)FileName);

	if(!strcmp(szRHS,"enabled"))
	{
	 	m_Dhcpcheck = TRUE;
		m_DhcpWnd.SetCheck(TRUE);
//      m_GTAddrStr = DhcpAssigned;
 	}
	else
	{
	 	m_Dhcpcheck = FALSE;
		m_DhcpWnd.SetCheck(FALSE);
	}

	NumberOfIPPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",3,
				(LPCSTR) FileName);

	m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",3,
				(LPCSTR) FileName);

	for(int i=0; i < m_nPorts; i++)
	{
   	ReadIPPortParameters(i, m_IPAddrStr, m_MskStr); //Get Address and Net Mask for Secured LAN Port
/* set LAN address for that configured during autodetection */
		if (ModifyIPAddress == TRUE)
		{
			if ( ! dotdecimal_configured_ip_address.IsValid())
				m_IPAddr[0] = ZeroIPAddress ;
			else
				m_IPAddr[0] = dotdecimal_configured_ip_address ;
		}
/* Neelu For AutoDetection 20/1/99 */


	if(i == 1 && m_Dhcpcheck)
		{
			m_IPAddr[i] = DhcpAssigned;
			m_IPMask[i] = DhcpAssigned;
		}
		else if(i == 2 && !strcmp(m_IPAddr[i],ZeroIPAddress))
		{
			m_IPAddr[i] = ISPAssigned;
		}
	   else
		{
			m_IPAddr[i] = m_IPAddrStr;
			m_IPMask[i] = m_MskStr;
		}
	}

/* Getting The Default Route IP Address - Added by Ravi */
	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) StrNull,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;

	if ((comma = strchr (szRHS, (int) ',')) != NULL)
  	{
	   	*comma = '\0' ;
   		DotValue = m_DRAddrStr = szRHS;
   		m_nDefaultMetric = (UINT) atoi(++ comma) ;
  	}
	else
	{
		m_nDefaultMetric = 1 ; // If not provided, default to 1
	}

	m_DRAddrStr = szRHS;


	GetPrivateProfileString ((LPCSTR) DHCPSectionHeader, 
			(LPCSTR) "DHCP Host Name", StrNull,
				(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
	m_HostNameStr = szRHS;
	
// GateWay Parameters

	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Internet Gateway Address", ZeroIPAddress,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
	m_GTAddrStr = szRHS;
	
	m_nGateWayPort = GetPrivateProfileInt((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Internet Gateway Port", 2, (LPCSTR) FileName) ;

   if (m_nGateWayPort > NumberOfIPPorts || IsSecuredLANPort(m_nGateWayPort))
        m_nGateWayPort = NumberOfIPPorts-1;

	if(IsWANPort(m_nGateWayPort))		
	{
		WANIsSelectedAsInternetGateay();
//		m_GTAddrStr = ZeroIPAddress;
	}
	else
	{
	   GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		   (LPCSTR) "IP Internet Gateway Address", ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;
		if(m_Dhcpcheck) 
			m_GTAddrStr = DhcpAssigned;
		else
			m_GTAddrStr = szRHS;

	   LANIsSelectedAsInternetGateay();
	}

/* To Get the DNS Server Address - Added by Ravi */
	GetPrivateProfileString ((LPCSTR) IPSectionHeader,(LPCSTR) "IP DNS Server Address1",
		 ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;

	m_DNSAddrWnd.SetWindowText(szRHS);

/* To Get the Relay Agent Parameters - Added by Ravi */
	GetPrivateProfileString((LPCSTR) DHCPSectionHeader, "DHCP Relay Agent", StrNull,
				(LPSTR) szRHS, sizeof(szRHS), FileName);
	if(!strcmp(szRHS,"enabled"))
	{
     	m_RAcheck = TRUE;
      m_RAWnd.SetCheck(TRUE);
	
		GetPrivateProfileString((LPCSTR) DHCPSectionHeader, "DHCP Server IP Address", StrNull,
				(LPSTR) szRHS, sizeof(szRHS), FileName);
		
		m_RAAddrWnd.SetWindowText(szRHS);

	}
	else
	{
      m_RAcheck = FALSE;
      m_RAWnd.SetCheck(FALSE);
      m_RAAddrStr = ZeroIPAddress;
	}


/* Get the WAN Parameters - Added by Ravi */
 	if(strcmp(m_IPAddr[2],ZeroIPAddress) == 0)
	{
	//Set ISP Assigned
		m_ISPWnd.SetCheck(TRUE);
		m_ISPcheck = TRUE;
  	}
	else
	{
		//Not ISP Assigned
		m_ISPWnd.SetCheck(FALSE);
		m_ISPcheck = FALSE;
	}


//Select Secured LAN as the Default Port.
	SelectSecuredLan();

	CenterWindow() ;
	UpdateData(FALSE);	//display data in dialog

	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CIPDNLD::SelectSecuredLan()
{
	CDotDecimal DotValue;

	UpdateData(TRUE);		//Get the dialog updates

// Load the Strings from the String Table
		m_port_string1.LoadString(IDS_SECURED_LAN_SETUP1);
		m_port_string2.LoadString(IDS_SECURED_LAN_SETUP2);

//Select Secured LAN as the Default Port.
// Disable Parameters Regarding Internet LAN & WAN
	m_ISPWnd.ShowWindow(FALSE);	
	m_DhcpWnd.ShowWindow(FALSE);

	m_ISPWnd.EnableWindow(FALSE);	
	m_DhcpWnd.EnableWindow(FALSE);

// Disable DNS Controls
	m_DNSAddrWnd.ShowWindow(FALSE);
	m_DNSHdrWnd.ShowWindow(FALSE);

	m_DNSAddrWnd.EnableWindow(FALSE);
	m_DNSHdrWnd.EnableWindow(FALSE);

// Disable Relay Agent Controls
	m_RAWnd.ShowWindow(FALSE);
	m_RAHdrWnd.ShowWindow(FALSE);
	m_RAAddrWnd.ShowWindow(FALSE);

	m_RAWnd.EnableWindow(FALSE);
	m_RAHdrWnd.EnableWindow(FALSE);
	m_RAAddrWnd.EnableWindow(FALSE);

// Enable Default Route Controls
 	m_DRHdrWnd.ShowWindow(TRUE);
 	m_DRAddrWnd.ShowWindow(TRUE);

 	m_DRHdrWnd.EnableWindow(TRUE);
 	m_DRAddrWnd.EnableWindow(TRUE);

//Enable IP Parameters
	m_IPHdrWnd.ShowWindow(TRUE);
	m_IPAddrWnd.ShowWindow(TRUE);

	m_IPHdrWnd.EnableWindow(TRUE);
	m_IPAddrWnd.EnableWindow(TRUE);

	m_MaskHdrWnd.ShowWindow(TRUE);
	m_MskWnd.ShowWindow(TRUE);

	m_MaskHdrWnd.EnableWindow(TRUE);
	m_MskWnd.EnableWindow(TRUE);

// Display Secured LAN Parameters.

	m_IPAddrStr = m_IPAddr[0];
	m_MskStr = m_IPMask[0];

	UpdateData(FALSE);	//display data in dialog

	m_nOldPort = 0;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CIPDNLD::SelectInternetLan()
{
	UpdateData(TRUE);		//Get the dialog updates

// Load the Strings from the String Table
		m_port_string1.LoadString(IDS_INTERNET_LAN_SETUP1);
		m_port_string2.LoadString(IDS_INTERNET_LAN_SETUP2);

// Disable Parameters Regarding Secured LAN & WAN
// Disable Default Route Controls
 	m_DRHdrWnd.ShowWindow(FALSE);
 	m_DRAddrWnd.ShowWindow(FALSE);

 	m_DRHdrWnd.EnableWindow(FALSE);
 	m_DRAddrWnd.EnableWindow(FALSE);

//Disable ISP Assigned Controls
	m_ISPWnd.ShowWindow(FALSE);	

	m_ISPWnd.EnableWindow(FALSE);	

//Enable DHCP Controls & Relay Agent
	m_DhcpWnd.ShowWindow(TRUE);

	m_DhcpWnd.EnableWindow(TRUE);

	m_RAWnd.ShowWindow(TRUE);
	m_RAHdrWnd.ShowWindow(TRUE);
	m_RAAddrWnd.ShowWindow(TRUE);

	m_RAWnd.EnableWindow(TRUE);
	m_RAHdrWnd.EnableWindow(TRUE);
	m_RAAddrWnd.EnableWindow(TRUE);

// Enable DNS Controls
	m_DNSAddrWnd.ShowWindow(TRUE);
	m_DNSHdrWnd.ShowWindow(TRUE);

	m_DNSAddrWnd.EnableWindow(TRUE);
	m_DNSHdrWnd.EnableWindow(TRUE);

//Enable IP Parameters
	m_IPHdrWnd.ShowWindow(TRUE);
	m_IPAddrWnd.ShowWindow(TRUE);

	m_IPHdrWnd.EnableWindow(TRUE);
	m_IPAddrWnd.EnableWindow(TRUE);

	m_MaskHdrWnd.ShowWindow(TRUE);
	m_MskWnd.ShowWindow(TRUE);

	m_MaskHdrWnd.EnableWindow(TRUE);
	m_MskWnd.EnableWindow(TRUE);

//	m_IPAddrStr = m_IPAddr[1];
//	m_MskStr = m_IPMask[1];

	if (m_Dhcpcheck)
	{
      m_DhcpWnd.SetCheck(TRUE);
		DhcpEnableCheck();
	}
	else
	{
      m_DhcpWnd.SetCheck(FALSE);
		DhcpDisableCheck();
	}

	if (m_RAcheck)
	{
	   m_RAcheck = TRUE;
      m_RAAddrWnd.EnableWindow(TRUE);
      m_RAWnd.EnableWindow(TRUE);
      m_RAHdrWnd.EnableWindow(TRUE);
	}
	else
	{
      m_RAcheck = FALSE;
		m_RAAddrStr = ZeroIPAddress;
      m_RAAddrWnd.EnableWindow(FALSE);
      m_RAHdrWnd.EnableWindow(FALSE);
	}


	m_IPAddrStr = m_IPAddr[1];
	m_MskStr = m_IPMask[1];

	UpdateData(FALSE);	//display data in dialog

	m_nOldPort = 1;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CIPDNLD::SelectWan()
{
	UpdateData(TRUE);		//Get the dialog updates

// Load the Strings from the String Table
		m_port_string1.LoadString(IDS_WAN_SETUP1);
		m_port_string2.LoadString(IDS_WAN_SETUP2);

// Disable Parameters Regarding InSecured LAN & Secured LAN 
// Disable Default Route Controls
 	m_DRHdrWnd.ShowWindow(FALSE);
 	m_DRAddrWnd.ShowWindow(FALSE);

 	m_DRHdrWnd.EnableWindow(FALSE);
 	m_DRAddrWnd.EnableWindow(FALSE);

//Disable DHCP Controls & Relay Agent
	m_DhcpWnd.ShowWindow(FALSE);

	m_DhcpWnd.EnableWindow(FALSE);

	m_RAWnd.ShowWindow(FALSE);
	m_RAHdrWnd.ShowWindow(FALSE);
	m_RAAddrWnd.ShowWindow(FALSE);

	m_RAWnd.EnableWindow(FALSE);
	m_RAHdrWnd.EnableWindow(FALSE);
	m_RAAddrWnd.EnableWindow(FALSE);

// Disable DNS Controls
	m_DNSAddrWnd.ShowWindow(FALSE);
	m_DNSHdrWnd.ShowWindow(FALSE);

	m_DNSAddrWnd.EnableWindow(FALSE);
	m_DNSHdrWnd.EnableWindow(FALSE);

//Enable IP Parameters
	m_IPHdrWnd.ShowWindow(TRUE);
	m_IPAddrWnd.ShowWindow(TRUE);

	m_IPHdrWnd.EnableWindow(TRUE);
	m_IPAddrWnd.EnableWindow(TRUE);

	m_MaskHdrWnd.ShowWindow(TRUE);
	m_MskWnd.ShowWindow(TRUE);

	m_MaskHdrWnd.EnableWindow(TRUE);
	m_MskWnd.EnableWindow(TRUE);

//Enable ISP Assigned Controls
	m_ISPWnd.ShowWindow(TRUE);	

	m_ISPWnd.EnableWindow(TRUE);	

	m_MaskHdrWnd.EnableWindow(TRUE);
	m_MskWnd.EnableWindow(TRUE);


 	if(!strcmp(m_IPAddr[2],ZeroIPAddress) || !strcmp(m_IPAddr[2],ISPAssigned))
	{
		//Set ISP Assigned
		m_ISPWnd.SetCheck(TRUE);
		m_ISPcheck = TRUE;
		m_IPHdrWnd.EnableWindow(FALSE);
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPAddrStr = ISPAssigned;
  	}
	else
	{
		//Not ISP Assigned
		m_ISPWnd.SetCheck(FALSE);
		m_ISPcheck = FALSE;
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
	}

	m_IPAddrStr = m_IPAddr[2];
	m_MskStr = m_IPMask[2];

	UpdateData(FALSE);	//display data in dialog

	m_nOldPort = 2;
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CIPDNLD::ValidatePortSettings(int PortNumber)
{
	CDotDecimal DotValue;

// Store the Old Values in a temp array
 	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr; 

	DotValue = m_IPAddr[PortNumber];

#if 0	
	if(PortNumber == 0)
		goto CheckAddr;

	if(PortNumber == 1 && !m_Dhcpcheck)
		goto CheckAddr;
	else
		goto NoAddrCheck;

	if(PortNumber == 2 && m_ISPcheck)
		goto CheckAddr;
	else
		goto ISPAddrCheck;
#endif

	if(PortNumber == 1 && m_Dhcpcheck)
		goto NoAddrCheck;
	if(PortNumber == 2 && m_ISPcheck)
		goto ISPAddrCheck;

//CheckAddr:
	if(!DotValue.IsValid()) 
	{
	   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
		      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_IPAddrWnd.SetFocus();
		return FALSE;
	}

ISPAddrCheck:	
	DotValue = m_IPMask[PortNumber];

	if (!DotValue.IsValid() || !verify_ip_subnet_mask((LPCSTR)m_IPMask[PortNumber]))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.",
			(LPCSTR) IPDnldMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE;
	}

NoAddrCheck:
// Validate Other parameters for each Port
	if(!ValidateOtherParameters(PortNumber))	
		return FALSE;

 	return TRUE;
}

void CIPDNLD::OnCheckDhcpClient()
{
// TODO: Add your control notification handler code here
	UpdateData(TRUE);		//Get the dialog updates
        if (m_DhcpWnd.GetCheck())
        {
				 	 m_Dhcpcheck = TRUE;
                m_IPAddrStr = DhcpAssigned;
                m_MskStr = DhcpAssigned;
					 m_DNSAddrStr = DhcpAssigned;	
			m_IPHdrWnd.EnableWindow(FALSE);
			m_IPAddrWnd.EnableWindow(FALSE);
			m_MaskHdrWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
			m_DNSHdrWnd.EnableWindow(FALSE);
			m_DNSAddrWnd.EnableWindow(FALSE);
                
                if (!m_WanEnabled.GetCheck())
                        m_GTAddrStr = DhcpAssigned;
                m_GTHdrWnd.EnableWindow(FALSE);
                m_GTAddrWnd.EnableWindow(FALSE);
        }
        else
        {
		   m_Dhcpcheck = FALSE;
			m_IPHdrWnd.EnableWindow(TRUE);
			m_IPAddrWnd.EnableWindow(TRUE);
			m_MaskHdrWnd.EnableWindow(TRUE);
			m_MskWnd.EnableWindow(TRUE);
			m_DNSHdrWnd.EnableWindow(TRUE);
			m_DNSAddrWnd.EnableWindow(TRUE);

                if (!m_WanEnabled.GetCheck())
                {
                        m_GTHdrWnd.EnableWindow(TRUE);
                        m_GTAddrWnd.EnableWindow(TRUE);
                }
                m_IPAddrStr = ZeroIPAddress;
                m_MskStr = ZeroIPAddress;
                m_GTAddrStr = ZeroIPAddress;
			m_DNSAddrStr = ZeroIPAddress;
        }
	UpdateData(FALSE);	//display data in dialog
}

void CIPDNLD::DhcpEnableCheck()
{
			m_Dhcpcheck = TRUE;
                m_IPAddrStr = DhcpAssigned;
                m_MskStr = DhcpAssigned;
					 m_DNSAddrStr = DhcpAssigned;	
                m_GTAddrStr =	DhcpAssigned;	
			m_IPHdrWnd.EnableWindow(FALSE);
			m_IPAddrWnd.EnableWindow(FALSE);
			m_MaskHdrWnd.EnableWindow(FALSE);
			m_MskWnd.EnableWindow(FALSE);
			m_DNSHdrWnd.EnableWindow(FALSE);
			m_DNSAddrWnd.EnableWindow(FALSE);
                
                if (!m_WanEnabled.GetCheck())
                        m_GTAddrStr = DhcpAssigned;
                m_GTHdrWnd.EnableWindow(FALSE);
                m_GTAddrWnd.EnableWindow(FALSE);

}

void CIPDNLD::DhcpDisableCheck()
{
			m_Dhcpcheck = FALSE;
			m_IPHdrWnd.EnableWindow(TRUE);
			m_IPAddrWnd.EnableWindow(TRUE);
			m_MaskHdrWnd.EnableWindow(TRUE);
			m_MskWnd.EnableWindow(TRUE);
			m_DNSHdrWnd.EnableWindow(TRUE);
			m_DNSAddrWnd.EnableWindow(TRUE);

                if (!m_WanEnabled.GetCheck())
                {
                        m_GTHdrWnd.EnableWindow(TRUE);
                        m_GTAddrWnd.EnableWindow(TRUE);
                }
                m_IPAddrStr = m_IPAddr[1];
                m_MskStr = m_IPMask[1];
//                m_GTAddrStr = ZeroIPAddress;
//			m_DNSAddrStr = ZeroIPAddress;
} 

void CIPDNLD::ReadIPPortParameters(int PortNumber, CString& Address, CString& NetMask)
{
	char	szRHS[40];
	char	szLHSAddr[40];
	char	szLHSMask[40];
	CDotDecimal DotValue;
        
	sprintf(szLHSAddr, "IP Port%d Address", PortNumber);
	sprintf(szLHSMask, "IP Port%d Address Mask", PortNumber);

//Get IP address 
	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHSAddr, ZeroIPAddress, (LPSTR) szRHS, sizeof (szRHS), (LPCSTR) FileName) ;

	Address = szRHS;

	DotValue = Address = szRHS;
        if (IsWANPort(PortNumber))
        {
	        if ( ! DotValue.IsValid())
                {
	        	Address = ZeroIPAddress;
                        m_ISPcheck = TRUE;
                }
                else
                        m_ISPcheck = FALSE;
        }

//Get subnet mask 
	GetPrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
 				ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   				(LPCSTR) FileName);
   	NetMask = szRHS;

	if ( ! verify_ip_subnet_mask((LPCSTR)NetMask))
		NetMask = ZeroIPAddress;

}

void CIPDNLD::WriteIPPortParameters(int PortNumber, CString Address, CString NetMask)
{
	char	szLHSAddr[40];
	char	szLHSMask[40];
	char    *szPPPLHS = "PPP Port%d Option%%IPCP%%IP Address";
	CDotDecimal DotValue;
        
	sprintf(szLHSAddr, "IP Port%d Address", PortNumber);
	sprintf(szLHSMask, "IP Port%d Address Mask", PortNumber);

//Get IP address 
	WritePrivateProfileString ((LPCSTR) IPSectionHeader,
		(LPCSTR) szLHSAddr, Address, (LPCSTR) FileName) ;

	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
		 NetMask, (LPCSTR) FileName);
}

BOOL CIPDNLD::IsValidInternetGatewayAddress(CString Address)
{
		  CDotDecimal AddressDotValue, SubNetDotValue, GatewayDotValue = Address;

        if (!GatewayDotValue.IsValid())
                return FALSE;

        AddressDotValue = m_IPAddr[1];
        if (!AddressDotValue.IsValid())
                return FALSE;

        SubNetDotValue = m_IPMask[1];
        if (!SubNetDotValue.IsValid())
                return FALSE;
        if (!RmtLocalIpAddressesOfSameNet((LPCSTR)AddressDotValue, (LPCSTR)GatewayDotValue, (LPCSTR)SubNetDotValue))
          return FALSE;

	     return TRUE;
}

void CIPDNLD::LANIsSelectedAsInternetGateay()
{
        m_WanEnabled.SetCheck(0);
        m_LANEnabled.SetCheck(1);
        if (m_Dhcpcheck)
        {
                m_GTAddrStr = DhcpAssigned;			// Make a check for dhcp client enabled - sri 28/1/99
                m_GTHdrWnd.EnableWindow(FALSE);
                m_GTAddrWnd.EnableWindow(FALSE);
			   	 m_DNSHdrWnd.EnableWindow(FALSE);
        }
        else
        {
                m_GTHdrWnd.EnableWindow(TRUE);
                m_GTAddrWnd.EnableWindow(TRUE);
					 m_DNSHdrWnd.EnableWindow(TRUE);
        }
	UpdateData(FALSE);		//display data in dialog
}

void CIPDNLD::WANIsSelectedAsInternetGateay()
{
        m_WanEnabled.SetCheck(1);
        m_LANEnabled.SetCheck(0);
        m_GTHdrWnd.EnableWindow(FALSE);
        m_GTAddrWnd.EnableWindow(FALSE);
		  if(!m_Dhcpcheck)
   	     m_GTAddrStr = ZeroIPAddress;

#if 0
		  else
		  {
			  m_Dhcpcheck = FALSE;
	        m_GTAddrStr = DhcpAssigned;
		  }
#endif

	UpdateData(FALSE);		//display data in dialog
}

void CIPDNLD::OnRadioWan()
{
// TODO: Add your control notification handler code here
	UpdateData(TRUE);		//Get the dialog updates

	m_WanEnabled.SetCheck(1);
	m_LANEnabled.SetCheck(0);

	m_GTAddrWnd.EnableWindow(FALSE);
	m_GTHdrWnd.EnableWindow(FALSE);

//        WANIsSelectedAsInternetGateay();
}

void CIPDNLD::OnRadioLan()
{
// TODO: Add your control notification handler code here
	UpdateData(TRUE);		//Get the dialog updates

	m_WanEnabled.SetCheck(0);
   m_LANEnabled.SetCheck(1);
	if(m_Dhcpcheck)
	{
		m_GTAddrStr = DhcpAssigned;
		m_GTAddrWnd.EnableWindow(FALSE);
		m_GTHdrWnd.EnableWindow(FALSE);
	}
	else
	{
		m_GTAddrWnd.EnableWindow(TRUE);
		m_GTHdrWnd.EnableWindow(TRUE);
	}

	UpdateData(FALSE);		//display data in dialog

//        LANIsSelectedAsInternetGateay();
	
}

void CIPDNLD::SelectPort(int PortNumber)
{
		if(PortNumber == 0)
			SelectSecuredLan();
		if(PortNumber == 1)
			SelectInternetLan();
		if(PortNumber == 2)
			SelectWan();
}

BOOL CIPDNLD::ValidateOtherParameters(int PortNumber)
{
	switch(PortNumber)
	{
		case 0:
			if(!ValidateSecuredLanParameters())
				return FALSE;
		case 1:
			if(!ValidateInternetLanParameters())
				return FALSE;
/*		case 2:
			if(!ValidateWanParameters())
				return FALSE; */
	}
	return TRUE;
}

BOOL CIPDNLD::ValidateSecuredLanParameters()
{
	CDotDecimal DotValue;

// Check For Default Route Address

 	DotValue = m_DRAddrStr;

	if(!DotValue.IsEmpty() && strcmp(DotValue,ZeroIPAddress))
	{
		if(!DotValue.IsValid())
		{
		   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Default Route Address",
			      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_PortListWnd.SetCurSel(1);
			SelectSecuredLan();
			m_DRAddrWnd.SetFocus();
			return FALSE;
		}

		if (!RmtLocalIpAddressesOfSameNet((LPCSTR)m_IPAddr[0], (LPCSTR)m_DRAddrStr, (LPCSTR)m_IPMask[0]))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN port IP address and Gateway \
IP address\nmust be in the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_DRAddrWnd.SetFocus();
	   	return FALSE;
		}

		if(!strcmp(m_IPAddr[0],m_DRAddrStr))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Default Route must point to another\n\
host or router on the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_DRAddrWnd.SetFocus();
	   	return FALSE;
		}
	}

	return TRUE;
}		

BOOL CIPDNLD::ValidateInternetLanParameters()
{
	CDotDecimal DotValue;
//	char	szRHS1[80] ; 

// Check For DNS Server Address
	DotValue = m_DNSAddrStr;

#if 0
	wsprintf (szRHS1, "DNS Server Address is %s.", m_DNSAddrStr);
	::MessageBox (GetSafeHwnd(),(LPCSTR) szRHS1,
	      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
#endif


	if(!m_Dhcpcheck)
	{
		if (m_DNSAddrStr.IsEmpty())
		{
			DotValue = ZeroIPAddress ;
			m_DNSAddrStr = ZeroIPAddress ;
		}

		if(strcmp(DotValue,ZeroIPAddress) && !DotValue.IsValid())
		{
		   ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid DNS Server Address",
			      (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_PortListWnd.SetCurSel(2);
			SelectInternetLan();
			m_DNSAddrWnd.SetFocus();
			return FALSE;
		}
	}

// Check For DHCP Relay Agent
   if (m_RAWnd.GetCheck())
   {
       DotValue = m_RAAddrStr;
     	 if (DotValue.IsEmpty() || !DotValue.IsValid())
       {
	        ::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid Relay Agent IP Address",
		        (LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			  m_PortListWnd.SetCurSel(2);
			  SelectInternetLan();
	        m_RAAddrWnd.SetFocus() ;
	        return FALSE;
        }
   }
	return TRUE;
}


