// ipdnld.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CIPDNLD dialog

class CIPDNLD : public CDialog
{
// Construction
public:
	CIPDNLD(CWnd* pParent = NULL);	// standard constructor
	BOOL SelectSecuredLan();
	BOOL SelectInternetLan();
	BOOL SelectWan();


// Dialog Data
	//{{AFX_DATA(CIPDNLD)
	enum { IDD = IDD_DIALOG_FIREWALL_IP_DNLD };
	CButton	m_LANEnabled;
	CButton	m_LanEnabled;
	CButton	m_WanEnabled;
	CStatic	m_DNSHdrWnd;
	CButton	m_DhcpWnd;
	CStatic	m_HostNameWnd;
	CStatic	m_GTHdrWnd;
	CStatic	m_RAHdrWnd;
	CStatic	m_DRHdrWnd;
	CStatic	m_MaskHdrWnd;
	CStatic	m_IPHdrWnd;
	CEdit	m_HostWnd;
	CEdit	m_GTAddrWnd;
	CEdit	m_RAAddrWnd;
	CButton	m_RAWnd;
	CEdit	m_DRAddrWnd;
	CEdit	m_DNSAddrWnd;
	CListBox	m_PortListWnd;
	CButton	m_ISPWnd;
	CEdit	m_MskWnd;
	CEdit	m_IPAddrWnd;
	CString	m_IPAddrStr;
	CString	m_MskStr;
	BOOL	m_ISPcheck;
	CString	m_DNSAddrStr;
	CString	m_DRAddrStr;
	BOOL	m_RAcheck;
	CString	m_RAAddrStr;
	CString	m_GTAddrStr;
	CString	m_HostNameStr;
	BOOL	m_Dhcpcheck;
   UINT     m_nGateWayPort;
	CString	m_port_string2;
	CString	m_port_string1;
	//}}AFX_DATA
	int	m_nOldPort;
	BOOL	m_ISP[MAX_NUM_PORTS];
	CString m_IPAddr[MAX_NUM_PORTS];
	CString m_IPMask[MAX_NUM_PORTS];
	UINT	m_nDefaultMetric;
	int 	m_nPorts;
	
	CBitmapButton OKBitmapBtn;
	CBitmapButton CancelBitmapBtn;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
  	afx_msg void SelectPort(int PortNumber);
	// Generated message map functions
	//{{AFX_MSG(CIPDNLD)
	afx_msg BOOL ValidateOtherParameters(int PortNumber);
	afx_msg BOOL ValidatePortSettings(int PortNumber);
	afx_msg BOOL ValidateSecuredLanParameters();
	afx_msg BOOL ValidateInternetLanParameters();
	afx_msg void WANIsSelectedAsInternetGateay();
	afx_msg void LANIsSelectedAsInternetGateay();
	afx_msg BOOL IsValidInternetGatewayAddress(CString Address);
   afx_msg void ReadIPPortParameters(int PortNumber, CString& Address, CString& NetMask);
   afx_msg void WriteIPPortParameters(int PortNumber, CString Address, CString NetMask);
	afx_msg void DhcpEnableCheck(); 
	afx_msg void DhcpDisableCheck(); 
	afx_msg void OnCheckIpAddr();
	afx_msg void OnCheckRelayAgent();
	afx_msg void OnSelchangeListPorts();
	afx_msg void OnRadioLan();
	afx_msg void OnRadioWan();
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckDhcpClient();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
