// ipfilter.h : header file

#include "tabdlg.h"
#include "dot.h"



/////////////////////////////////////////////////////////////////////////////
// ICMPFilter dialog

class ICMPFilter : public CDialog
{
// Construction
public:
	ICMPFilter(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(ICMPFilter)
	enum { IDD = IDD_DIALOG_ICMP_FILTERING };
	BOOL	m_AddressMaskRequest;
	BOOL	m_DestinationUnreachable;
	BOOL	m_EchoReply;
	BOOL	m_EchoRequest;
	BOOL	m_ParameterProblem;
	BOOL	m_Redirect;
	BOOL	m_SourceQuench;
	BOOL	m_TimeExceed;
	BOOL	m_TimeStampResponse;
	BOOL	m_TimeStampRequest;
	BOOL	m_AddressMaskResponse;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   
	virtual void OnOK();

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(ICMPFilter)
	virtual void PostNcDestroy () ;
	afx_msg LRESULT OnSwitchToIden (WPARAM, LPARAM) ;
	afx_msg LRESULT OnSwitchFromIden (WPARAM, LPARAM) ;
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
//	virtual void OnOK();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// ICMPFilterTab dialog

class ICMPFilterTab : public CTabDialog
{
// Construction
public:
	ICMPFilterTab(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(ICMPFilterTab)
	enum { IDD = IDD_DIALOG_ICMP_FILTER_TAB };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA
public:
	ICMPFilter *ICMPFilterDialog[4] ;
	virtual void OnOK();

private:
	int tabcount ;

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(ICMPFilterTab)
		// NOTE: the ClassWizard will add member functions here
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
//	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// IPFilterType dialog

class IPFilterType : public CDialog
{
// Construction
public:
	IPFilterType(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(IPFilterType)
	enum { IDD = IDD_DIALOG_IP_FILTERING_TYPE };
	CComboBox	m_IPFilterDefaultActionControl;
	CStatic	m_IPFilterListHeaderControl;
	CListBox	m_IPFilterListControl;
	CString	m_IPFilterListHeader;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;
   CBitmapButton AddBitmapBtn;
   CBitmapButton DelBitmapBtn;
   CBitmapButton EditBitmapBtn;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	BOOL DuplicateString (CString) ;
	virtual void OnOK();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(IPFilterType)
	virtual void OnCancel();
//	virtual void OnOK();
   afx_msg LRESULT OnSwitchFromIden (WPARAM, LPARAM) ;
	afx_msg LRESULT OnSwitchToIden (WPARAM, LPARAM) ;
   virtual void PostNcDestroy () ;
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonIpFilterAdd();
	afx_msg void OnButtonIpFilterRemove();
	afx_msg void OnHelp();
	afx_msg void OnButtonIpFilterEdit();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////////////
// IPFiltering dialog

class IPFiltering : public CTabDialog
{
// Construction
public:
	IPFiltering(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(IPFiltering)
	enum { IDD = IDD_DIALOG_IP_FILTERING };
	//}}AFX_DATA

public:
   IPFilterType *m_pdlgIPFilterTypes[2] ;
	ICMPFilterTab *ICMPFilterTabDialog ;
private:
   int tabcount ;
   void GetConfig(void) ;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
	virtual void OnOK();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(IPFiltering)
   virtual BOOL OnInitDialog();
	virtual void OnCancel();
//	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// NewIPAddressFilter dialog

class NewIPAddressFilter : public CDialog
{
// Construction
public:
	NewIPAddressFilter(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(NewIPAddressFilter)
	enum { IDD = IDD_DIALOG_NEW_IP_ADDRESS_FILTER };
	CEdit	m_NewIPAddrWnd;
	CComboBox	m_TypeControl;
	CComboBox	m_PortControl;
	CDotDecimal m_IPAddress;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(NewIPAddressFilter)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// NewIPPortFilter dialog

class NewIPPortFilter : public CDialog
{
// Construction
public:
	NewIPPortFilter(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(NewIPPortFilter)
	enum { IDD = IDD_DIALOG_NEW_IP_PORT_FILTER };
	CComboBox	m_ProtocolControl;
	CComboBox	m_TypeControl;
	CComboBox	m_ProtocolPortControl;
	CComboBox	m_PortControl;
	CString	m_ProtocolPort;
	//}}AFX_DATA

   CBitmapButton OKBitmapBtn;
   CBitmapButton CancelBitmapBtn;
   CBitmapButton HelpBitmapBtn;

// Implementation
public :
	int	RouMsgBox(int, LPCSTR, int);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(NewIPPortFilter)
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeComboNewIpProtocol();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
