// ipprx.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include	"dot.h"
#include "maskdot.h"
#include "ipprx.h"

#if 0
char	*IPMsgHeader="IP Setup";
LPCSTR IPSectionHeader ="IP Routing" ;
LPCSTR DHCPSectionHeader = "DHCP" ;
extern LPCSTR TNETSectionHeader;
#endif

extern char	*IPMsgHeader;
extern LPCSTR   IPSectionHeader;
extern LPCSTR   DHCPSectionHeader;
extern LPCSTR   TNETSectionHeader;

#define MIN_DEFAULT_TTL			0
#define MAX_DEFAULT_TTL			255
#define MIN_REASSM_TMOUT		1
#define MAX_REASSM_TMOUT		100

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ipprx dialog


ipprx::ipprx(CWnd* pParent /*=NULL*/)
	: CDialog(ipprx::IDD, pParent)
{
	//{{AFX_DATA_INIT(ipprx)
	m_ISPCheck = FALSE;
	m_MskStr = "";
	m_GwayStr = "";
	m_nDefaultTTL = 0;
	m_nReassemTimeout = 0;
	m_IPAddrStr = "";
	//}}AFX_DATA_INIT
}

void ipprx::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ipprx)
	DDX_Control(pDX, IDC_LIST_PORTS, m_PortListWnd);
	DDX_Control(pDX, IDC_STATIC_SEL_PORT, m_SelPortGrp);
	DDX_Control(pDX, IDC_STATIC_ADDR, m_IPHdrWnd);
	DDX_Control(pDX, IDC_EDIT_REASSM, m_RTOWnd);
	DDX_Control(pDX, IDC_EDIT_TTL, m_TTLWnd);
	DDX_Control(pDX, IDC_EDIT_GATEWAY, m_GwayWnd);
	DDX_Control(pDX, IDC_EDIT_MSK, m_MskWnd);
	DDX_Control(pDX, IDC_EDIT_IP_ADDR, m_IPAddrWnd);
	DDX_Control(pDX, IDC_CHECK_IP_ADDR, m_ISPWnd);
	DDX_Check(pDX, IDC_CHECK_IP_ADDR, m_ISPCheck);
	DDX_Text(pDX, IDC_EDIT_MSK, m_MskStr);
	DDX_Text(pDX, IDC_EDIT_GATEWAY, m_GwayStr);
	DDX_Text(pDX, IDC_EDIT_TTL, m_nDefaultTTL);
	DDX_Text(pDX, IDC_EDIT_REASSM, m_nReassemTimeout);
	DDX_Text(pDX, IDC_EDIT_IP_ADDR, m_IPAddrStr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(ipprx, CDialog)
	//{{AFX_MSG_MAP(ipprx)
	ON_BN_CLICKED(IDC_CHECK_IP_ADDR, OnCheckIpAddr)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_LBN_SELCHANGE(IDC_LIST_PORTS, OnSelchangeListPorts)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// ipprx message handlers

void ipprx::OnCheckIpAddr()
{
	// TODO: Add your control notification handler code here

	if (m_ISPWnd.GetCheck())	// Get the status of check button
	{
		UpdateData(TRUE);			//Get the dialog updates
		m_IPAddrWnd.EnableWindow(FALSE);
		m_IPHdrWnd.EnableWindow(FALSE);
		m_IPAddrStr = ZeroIPAddress; //reset address
		UpdateData(FALSE);		//display data in dialog
	}
	else
	{
		m_IPHdrWnd.EnableWindow(TRUE);
		m_IPAddrWnd.EnableWindow(TRUE);
	}
}

BOOL ipprx::OnInitDialog()
{
	CDialog::OnInitDialog();
////////////////////////////////////////////////////////////////////////////
	CenterWindow();
	/* Change the title of the dialog as usual */
	{
		char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

		GetWindowText (CurrentHeading, 80) ;
		SubHeadingPointer = strchr (CurrentHeading, '-') ;
		if (SubHeadingPointer == NULL)
			SubHeadingPointer = CurrentHeading ;
		else
			SubHeadingPointer += 2 ;

		sprintf(WindowHeader, DialogTitleFormat,
			WindowText.GetBuffer(0),SubHeadingPointer);

		SetWindowText (WindowHeader) ;
	}
////////////////////////////////////////////////////////////////////////////

	// Read the configuration file and init the variables
	int	index;
	char	szRHS[40];
	char	szLHSAddr[40];
	char	szLHSMask[40];
	CDotDecimal DotValue;
					
	m_nPorts = GetPrivateProfileInt(IPSectionHeader,
				(LPCSTR) "IP Number of Ports",4,
				(LPCSTR) IniInWinForm);
	if (m_nPorts > MAX_NUM_PORTS)
		m_nPorts = MAX_NUM_PORTS;

	strcpy(szLHSAddr, "IP Port0 Address");
	strcpy(szLHSMask, "IP Port0 Address Mask");
	for (index = 0; index < m_nPorts; index++)
	{
		//Get IP address of the port
	  	GetPrivateProfileString ((LPCSTR) IPSectionHeader,
			(LPCSTR) szLHSAddr, ZeroIPAddress, (LPSTR) szRHS,
									sizeof (szRHS), (LPCSTR) IniInWinForm) ;
		DotValue = 	m_IPAddr[index] = szRHS;
		if ( ! DotValue.IsValid())
			m_IPAddr[index] = ZeroIPAddress;

		//If IP address == 0.0.0.0 then it is ISP assigned
		m_ISP[index] = FALSE;
		if (index > 0)		//not for LAN port
			if ( ! strcmp((LPCSTR)m_IPAddr[index], ZeroIPAddress))
				m_ISP[index] = TRUE;

		//Get subnet mask for the port
	 	GetPrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
 					ZeroIPAddress,(LPSTR) szRHS ,sizeof(szRHS),
   				(LPCSTR) IniInWinForm);
   	m_IPMask[index] = szRHS;
		if ( ! verify_ip_subnet_mask((LPCSTR)m_IPMask[index]))
			m_IPMask[index] = ZeroIPAddress;

		szLHSAddr[7]++;		//next Port
		szLHSMask[7]++;		//next Port
	}
	//Readin the other information
	m_nDefaultTTL = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
				(LPCSTR) "IP Default TTL", 255, (LPCSTR) IniInWinForm) ;

	m_nReassemTimeout = GetPrivateProfileInt ((LPCSTR) IPSectionHeader,
				(LPCSTR) "IP Reassembly Timeout", 30, (LPCSTR) IniInWinForm) ;

	char *comma; // To break the string at ',' .
	GetPrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) StrNull,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	
	if ((comma = strchr (szRHS, (int) ',')) != NULL)
  	{
	   	*comma = '\0' ;
   		DotValue = m_GwayStr = szRHS;
   		m_nDefaultMetric = (UINT) atoi(++ comma) ;
  	}
	else
	{
		m_nDefaultMetric = 1 ; // If not provided, default to 1
	}

	if (!DotValue.IsEmpty() && !DotValue.IsValid())
		m_GwayStr= "" ;

	//Add items into the port list
 	m_PortListWnd.AddString("LAN");
	if (m_nPorts > 2)
	{
		strcpy(szRHS, "WAN 1");
		for (index = 0; index < NUM_WAN_PORTS; index++)
		{
			m_PortListWnd.AddString(szRHS);
			szRHS[4]++;	//next port name
		}
	}
	else
	{
	 	m_PortListWnd.AddString("WAN");
	}
	//Set current selection as LAN
	m_nOldPort = 0;
	m_PortListWnd.SetCurSel(m_nOldPort);

	//Set the other port dependent parameters to be of LAN
	m_IPAddrStr = m_IPAddr[m_nOldPort];
 	m_MskStr = m_IPMask[m_nOldPort];
	m_ISPCheck = m_ISP[m_nOldPort];
	m_ISPWnd.EnableWindow(FALSE);
	m_SelPortGrp.SetWindowText("LAN");

	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void ipprx::OnHelp()
{
	// TODO: Add your control notification handler code here
		AfxGetApp()->WinHelp(0x20000 + IDD_IP_CONFIG, HELP_CONTEXT);
	
}

BOOL ipprx::ValidPortSettings()
{
	CDotDecimal DotValue;

	DotValue = m_IPAddrStr;

	if (DotValue.IsEmpty())
		DotValue = ZeroIPAddress;

	if(m_ISPCheck)			// If ISP assigns we make it 0.0.0.0
		DotValue = ZeroIPAddress;
	else
	{
		if (!DotValue.IsValid())
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP Address",
					(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_IPAddrWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( ! verify_ip_subnet_mask((LPCSTR)m_MskStr))
	{
		::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid IP subnet mask.\n\
Refer to help for more details",
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_MskWnd.SetFocus() ;
		return FALSE ;
	}
	return TRUE ;
}

BOOL ipprx::ValidEditFields()
{

	//makesure that the current edit controls have valid entries
	if (!ValidPortSettings())
		return FALSE;

	//Since the data is validated we need to put into the
	//local structs before we start writing out
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

	CDotDecimal DotValue;
	DotValue = m_GwayStr;

	if ( ! DotValue.IsValid())
	{
		if (DotValue != ZeroIPAddress)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Invalid gateway address",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_GwayWnd.SetFocus() ;
			return FALSE ;
		}
	}
	//Check to see that the gateway address, if entered
	//is in the same network as the LAN
	if (DotValue != ZeroIPAddress)
	{
		DWORD LANIPAddress, GWAYIPAddress, NETMask;
		get_ip_address((LPCSTR) m_IPAddr[0], &LANIPAddress);
		get_ip_address((LPCSTR) m_IPMask[0], &NETMask);
		get_ip_address((LPCSTR) m_GwayStr, &GWAYIPAddress);
		if ((LANIPAddress & NETMask) != (GWAYIPAddress & NETMask))
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "LAN port IP address and Gateway \
IP address\nmust be in the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_GwayWnd.SetFocus() ;
			return FALSE ;
		}
		if (LANIPAddress == GWAYIPAddress)
		{
			::MessageBox (GetSafeHwnd(), (LPCSTR) "Gateway IP address must \
point to another\nhost or router on the same IP network",
				(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
			m_GwayWnd.SetFocus() ;
			return FALSE ;
		}
	}

	if ( (m_nDefaultTTL < MIN_DEFAULT_TTL) ||
						(m_nDefaultTTL > MAX_DEFAULT_TTL))
	{
		char Msg[80];
		wsprintf(Msg, "Invalid TTL. Must be between %d and %d",
			MIN_DEFAULT_TTL, MAX_DEFAULT_TTL);
		::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_TTLWnd.SetFocus() ;
		return FALSE ;
	}

	if ( (m_nReassemTimeout < MIN_REASSM_TMOUT) ||
						(m_nReassemTimeout > MAX_REASSM_TMOUT))
	{
		char Msg[80];
		wsprintf(Msg, "Invalid Reassembly Timeout.\n\
Must be between %d and %d", MIN_DEFAULT_TTL, MAX_DEFAULT_TTL);
		::MessageBox (GetSafeHwnd(), (LPCSTR) Msg,
			(LPCSTR) IPMsgHeader, MB_OK | MB_ICONEXCLAMATION) ;
		m_RTOWnd.SetFocus() ;
		return FALSE ;
	}

	if (m_GwayStr.IsEmpty())
		m_GwayStr = ZeroIPAddress;

	return TRUE;
}

void ipprx::OnOK()
{
	// TODO: Add extra validation here
	int index;
	char	szRHS[40];
	char	szLHSAddr[40];
	char	szLHSMask[40];
	char *szPPPLHS = "PPP Port%d Option%%IPCP%%IP Address";

	UpdateData(TRUE);
	//Validate the current port's setup and copy them to internal variables
	//if error return

	if (!ValidEditFields())
		return;

	//write the new values out into the ini file

	strcpy(szLHSAddr, "IP Port0 Address");
	strcpy(szLHSMask, "IP Port0 Address Mask");
	for (index = 0; index < m_nPorts; index++)
	{
		//Write IP Address
	  	WritePrivateProfileString ((LPCSTR) IPSectionHeader,
			(LPCSTR) szLHSAddr, m_IPAddr[index], (LPCSTR) IniInWinForm) ;

		//If ISP assigned WAN address write 0.0.0.0 and
		// In PPP make local option negotiable
		if (index > 0)		//not for LAN port
		{
			wsprintf(szRHS, szPPPLHS, index - 1);
		 	if (m_ISP[index] == TRUE)
			{
			// PPP local address is 0.0.0.0 and negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) ZeroIPAddress) ;
			}
			else
			{
			// PPP local address is user assinged (non-0.0.0.0) and NOT negotiable
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 3, (LPCSTR) "Not Negotiable") ;
				ModifyEndOfRouconIniString ((LPCSTR) PPPSectionHeader,
					(LPCSTR) szRHS, 5, (LPCSTR) m_IPAddr[index]) ;
			}
		}
		else		// the LAN IP address is to be copied into SNMP section also
		{
			WritePrivateProfileString ((LPCSTR) SNMPSectionHeader,
				(LPCSTR) "SNMP Local Internet Address",
					(LPCSTR) m_IPAddr[index], (LPCSTR) IniInWinForm) ;
		}
		//write subnet mask for the port
	 	WritePrivateProfileString(IPSectionHeader, (LPCSTR) szLHSMask,
					m_IPMask[index], (LPCSTR) IniInWinForm);
		szLHSAddr[7]++;		//next Port
		szLHSMask[7]++;		//next Port
	}
	wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nDefaultTTL);
	WritePrivateProfileString(IPSectionHeader ,
			(LPCSTR) "IP Default TTL",(LPSTR)szRHS, (LPCSTR) IniInWinForm);

	wsprintf((LPSTR) szRHS, (LPSTR) "%u", m_nReassemTimeout);
	WritePrivateProfileString(IPSectionHeader ,
				(LPCSTR) "IP Reassembly Timeout", szRHS, (LPCSTR) IniInWinForm) ;

	wsprintf(szRHS, "%s,%d", (LPCSTR)m_GwayStr, m_nDefaultMetric);
	WritePrivateProfileString ((LPCSTR) IPSectionHeader, 
		(LPCSTR) "IP Default Route", (LPCSTR) szRHS, (LPCSTR) IniInWinForm) ;

	CDialog::OnOK();
	return;
}

void ipprx::OnSelchangeListPorts()
{
	// TODO: Add your control notification handler code here
	
	int PortIndex;
	UpdateData(TRUE);

	// TODO: Add your control notification handler code here
	PortIndex = m_PortListWnd.GetCurSel();
	if (PortIndex == LB_ERR)
		return;

	if (m_nOldPort == PortIndex)	// Prevent any loops
		return;

	if (!ValidPortSettings())
	{
		m_PortListWnd.SetCurSel(m_nOldPort);
		return;
	}
	//Store values for Old Port
	m_ISP[m_nOldPort] = m_ISPCheck;
	m_IPAddr[m_nOldPort] = m_IPAddrStr;
	m_IPMask[m_nOldPort] = m_MskStr;

	m_ISPCheck = m_ISP[PortIndex];
	m_IPAddrStr = m_IPAddr[PortIndex];
	m_MskStr = m_IPMask[PortIndex];

	if (PortIndex == 0)		//LAN index
	{
		//If the selected port is LAN disable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(FALSE);
		//Change the group heading to that of the selected port
		m_SelPortGrp.SetWindowText("LAN");
	}
	else
	{
		//If the selected port is NOT LAN enable ISP_Assigned_Address
		m_ISPWnd.EnableWindow(TRUE);
		//Change the group heading to that of the selected port
		if (m_nPorts <= 2)
		{
			m_SelPortGrp.SetWindowText("WAN");
		}
		else
		{
			char Buf[10];

			sprintf(Buf, "WAN %d", PortIndex);
			m_SelPortGrp.SetWindowText(Buf);
		}
	}

	m_IPHdrWnd.EnableWindow(!m_ISPCheck);
	m_IPAddrWnd.EnableWindow(!m_ISPCheck);


	UpdateData(FALSE);
	m_nOldPort = PortIndex;
}
